/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.CommonDef;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.HandleValueTable;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

public class QueryHandleJPanel
extends JPanel
implements ActionListener {
    protected HandleValue[] handleValues;
    protected HandleTool tool;
    protected JTextField nameField;
    protected JTextField indexField;
    protected JList typeChoice;
    protected JTextField customTypeField;
    protected JCheckBox certifyCheckbox;
    protected JCheckBox cacheCertifyCheckbox;
    protected JCheckBox authoritativeCheckbox;
    protected JCheckBox ignoreRestrictedCheckbox;
    protected HandleValueTable dataPanel;
    protected JPanel workPanel;
    protected MyButton submitButton;

    public QueryHandleJPanel() {
        this(new HandleTool());
    }

    public QueryHandleJPanel(HandleTool tool) {
        this.tool = tool;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        EtchedBorder etchBorder = new EtchedBorder();
        int x = 0;
        int y = 0;
        this.workPanel = new JPanel(gridbag);
        this.nameField = new JTextField("", 20);
        this.nameField.setScrollOffset(0);
        this.nameField.addActionListener(this);
        this.nameField.setToolTipText("Input the new handle name");
        this.indexField = new JTextField("", 20);
        this.indexField.addActionListener(this);
        this.indexField.setToolTipText("Input the index value");
        String[] typeStrs = new String[CommonDef.DATA_TYPE_STR.length];
        for (int i = 0; i < CommonDef.DATA_TYPE_STR.length - 1; ++i) {
            typeStrs[i] = CommonDef.DATA_TYPE_STR[i];
        }
        typeStrs[CommonDef.DATA_TYPE_STR.length - 1] = "All_DATA_TYPE";
        this.customTypeField = new JTextField("", 20);
        this.customTypeField.addActionListener(this);
        this.customTypeField.setToolTipText("Enter a comma-separated list of types, or choose from the list below");
        this.typeChoice = new JList<String>(typeStrs);
        this.typeChoice.setToolTipText("choose query type");
        DefaultListSelectionModel m = new DefaultListSelectionModel();
        m.setSelectionMode(2);
        m.setLeadAnchorNotificationEnabled(true);
        this.typeChoice.setSelectionModel(m);
        this.submitButton = new MyButton(" Submit ", "click to retrieve the handle", "Submit");
        this.submitButton.addActionListener(this);
        x = 0;
        y = 0;
        JPanel p1 = new JPanel(gridbag);
        p1.add((Component)new JLabel(" Handle Name: ", 4), AwtUtil.getConstraints(x, y, 1.0, 0.0, 1, 1, new Insets(5, 2, 5, 1), true, false));
        p1.add((Component)this.nameField, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, new Insets(1, 2, 5, 5), true, false));
        p1.add((Component)new JLabel(" Query Indexes: ", 4), AwtUtil.getConstraints(x, y, 1.0, 0.0, 1, 1, new Insets(5, 2, 5, 1), true, false));
        p1.add((Component)this.indexField, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 1, 1, new Insets(1, 2, 5, 5), true, false));
        p1.add((Component)new JLabel(" Query Types: ", 4), AwtUtil.getConstraints(x, y, 1.0, 0.0, 1, 1, new Insets(5, 2, 5, 1), true, false));
        p1.add((Component)this.customTypeField, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 9, new Insets(1, 2, 5, 5), true, false));
        p1.add((Component)new JScrollPane(this.typeChoice), AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 2, 9, new Insets(1, 2, 5, 5), true, true));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.submitButton);
        p1.add((Component)buttonPanel, AwtUtil.getConstraints(x + 1, y + 9, 1.0, 1.0, 1, 1, new Insets(5, 2, 10, 2), false, true));
        this.certifyCheckbox = new JCheckBox("Certify", false);
        this.cacheCertifyCheckbox = new JCheckBox("Certify Cache", true);
        this.authoritativeCheckbox = new JCheckBox("Authoritative", false);
        this.ignoreRestrictedCheckbox = new JCheckBox("Ignore Restricted Values", true);
        x = 0;
        y = 0;
        JPanel p2 = new JPanel(gridbag);
        p2.setBorder(new TitledBorder(etchBorder, "Query Properties"));
        p2.add((Component)this.certifyCheckbox, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, false));
        p2.add((Component)this.cacheCertifyCheckbox, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, false));
        p2.add((Component)this.authoritativeCheckbox, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, false));
        p2.add((Component)this.ignoreRestrictedCheckbox, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, false));
        JPanel p3 = new JPanel(gridbag);
        p3.add((Component)p1, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 3, new Insets(10, 10, 10, 10), true, true));
        p3.add((Component)p2, AwtUtil.getConstraints(1, 1, 1.0, 1.0, 1, 1, new Insets(10, 10, 10, 10), true, false));
        this.dataPanel = new HandleValueTable();
        this.dataPanel.setBorder(new TitledBorder(etchBorder, "Handle Data"));
        x = 0;
        y = 0;
        this.workPanel.add((Component)p3, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 2, 1, new Insets(5, 5, 5, 5), true, true));
        this.workPanel.add((Component)this.dataPanel, AwtUtil.getConstraints(x, y, 1.0, 1.0, 2, 10, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)this.workPanel, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, new Insets(2, 5, 10, 5), 10, true, true));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.submitButton || src == this.nameField || src == this.indexField || src == this.customTypeField) {
            this.submit();
        }
    }

    public void reset() {
        this.indexField.setText("");
        this.nameField.setText("");
        this.customTypeField.setText("");
        this.typeChoice.clearSelection();
        this.certifyCheckbox.setSelected(false);
        this.cacheCertifyCheckbox.setSelected(true);
        this.authoritativeCheckbox.setSelected(false);
        this.ignoreRestrictedCheckbox.setSelected(true);
        this.dataPanel.setHandleValues(new HandleValue[0]);
    }

    protected void submit() {
        int i;
        Vector<byte[]> queryTypes = new Vector<byte[]>();
        StringTokenizer token = new StringTokenizer(this.customTypeField.getText().trim(), ", ");
        while (token.hasMoreTokens()) {
            String str = token.nextToken().trim();
            if (str.length() <= 0) continue;
            queryTypes.addElement(Util.encodeString(str));
        }
        if (!this.typeChoice.isSelectedIndex(CommonDef.DATA_TYPE_STR.length - 1)) {
            List items = this.typeChoice.getSelectedValuesList();
            for (i = 0; i < items.size(); ++i) {
                queryTypes.addElement(Util.encodeString((String)items.get(i)));
            }
        }
        byte[][] types = null;
        if (queryTypes.size() > 0) {
            types = new byte[queryTypes.size()][];
            for (i = 0; i < types.length; ++i) {
                types[i] = (byte[])queryTypes.elementAt(i);
            }
        }
        token = new StringTokenizer(this.indexField.getText().trim(), ",");
        Vector<Integer> it = new Vector<Integer>();
        while (token.hasMoreTokens()) {
            String str = token.nextToken();
            try {
                it.addElement(Integer.valueOf(str));
            }
            catch (Exception e) {
                System.err.println("Error: Invalid index: " + e);
            }
        }
        int[] indexes = new int[it.size()];
        for (int i2 = 0; i2 < it.size(); ++i2) {
            indexes[i2] = (Integer)it.elementAt(i2);
        }
        ResolutionRequest req = new ResolutionRequest(Util.encodeString(this.nameField.getText().trim()), types, indexes, this.tool.getCurrentAuthentication());
        req.certify = this.certifyCheckbox.isSelected();
        req.cacheCertify = this.cacheCertifyCheckbox.isSelected();
        req.authoritative = this.authoritativeCheckbox.isSelected();
        req.ignoreRestrictedValues = this.ignoreRestrictedCheckbox.isSelected();
        try {
            AbstractResponse resp = this.tool.processRequest(this, req, "Resolving handle ...");
            if (resp == null) {
                return;
            }
            if (resp.responseCode == 1) {
                HandleValue[] vals = ((ResolutionResponse)resp).getHandleValues();
                this.dataPanel.setHandleValues(vals);
            } else {
                this.warn("Can not process this request: \n  " + resp);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.warn(String.valueOf(e));
        }
    }

    void warn(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning", 2);
    }

    void info(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Container c = f.getContentPane();
        c.add(new QueryHandleJPanel());
        f.setSize(500, 500);
        f.pack();
        f.setVisible(true);
    }
}

