/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.handle.apps.gui.jutil.InfoPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.Util;

public class IPRedirectPanel
extends JPanel
implements ActionListener {
    private final Configuration config;
    private final RedirectTableModel redirectModel;
    private final JTable redirectTable;
    private final JButton addButton;
    private final JButton delButton;

    public IPRedirectPanel(Configuration config) {
        this.config = config;
        this.redirectModel = new RedirectTableModel();
        this.redirectTable = new JTable(this.redirectModel);
        this.redirectTable.setSelectionMode(0);
        this.redirectTable.setRowSelectionAllowed(true);
        this.addButton = new JButton("Add");
        this.delButton = new JButton("Remove");
        this.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        InfoPanel infoPanel = new InfoPanel();
        infoPanel.setTitle("Redirect IP Addresses");
        infoPanel.setText("If you are behind the same NAT firewall as a \nhandle server, you may have problems accessing \nthat handle server using the external IP address \nfor that server.  Setting an IP address redirect \nallows you to tell this handle resolver to use a \ndifferent internal IP address instead of the specified \nexternal addresses.");
        this.add((Component)infoPanel, AwtUtil.getConstraints(x, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)new JScrollPane(this.redirectTable), AwtUtil.getConstraints(x, y, 1.0, 1.0, 1, 3, true, true));
        this.add((Component)this.addButton, AwtUtil.getConstraints(x + 1, y++, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        this.add((Component)this.delButton, AwtUtil.getConstraints(x + 1, y++, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(x + 1, y++, 0.0, 1.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
        this.loadRecords();
    }

    private void loadRecords() {
        Map<String, String> m = this.config.getLocalAddressMap();
        if (m != null) {
            for (String key : m.keySet()) {
                String val = m.get(key);
                if (key instanceof InetAddress) {
                    key = Util.rfcIpRepr((InetAddress)((Object)key));
                }
                if (val instanceof InetAddress) {
                    val = Util.rfcIpRepr((InetAddress)((Object)val));
                }
                this.redirectModel.addRedirect(String.valueOf(key), String.valueOf(val));
            }
        }
    }

    public void saveRecords() {
        try {
            this.config.setLocalAddressMap(this.redirectModel.getRedirects());
            this.config.saveLocalAddressMap();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "<html>An error occured while saving the address mapping:<br>&nbsp;&nbsp; " + e + "</html>");
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int selectedRow;
        Object src = evt.getSource();
        if (src == this.addButton) {
            int idx = this.redirectModel.addRedirect("", "");
            this.redirectTable.setRowSelectionInterval(idx, idx);
        } else if (src == this.delButton && (selectedRow = this.redirectTable.getSelectedRow()) >= 0) {
            this.redirectModel.deleteRedirect(selectedRow);
        }
    }

    private class Redirect {
        String fromAddress = "";
        String toAddress = "";

        Redirect(String from, String to) {
            this.fromAddress = from;
            this.toAddress = to;
        }
    }

    private class RedirectTableModel
    extends AbstractTableModel {
        private final Vector redirects = new Vector();

        private RedirectTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "External Address";
                }
                case 1: {
                    return "Connection Address";
                }
            }
            return "";
        }

        public Map getRedirects() {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < this.redirects.size(); ++i) {
                Redirect r = (Redirect)this.redirects.elementAt(i);
                if (r.fromAddress == null || r.fromAddress.trim().length() <= 0 || r.toAddress == null || r.toAddress.trim().length() <= 0) continue;
                m.put(r.fromAddress, r.toAddress);
            }
            return m;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public int addRedirect(String key, String value) {
            if (key == null) {
                key = "";
            }
            if (value == null) {
                value = "";
            }
            this.redirects.addElement(new Redirect(key, value));
            int idx = this.redirects.size() - 1;
            this.fireTableRowsInserted(idx, idx);
            return idx;
        }

        public void deleteRedirect(int row) {
            if (row < 0) {
                return;
            }
            this.redirects.removeElementAt(row);
            this.fireTableRowsDeleted(row, row);
        }

        @Override
        public int getRowCount() {
            return this.redirects.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Redirect r = (Redirect)this.redirects.elementAt(row);
            return column == 0 ? r.fromAddress : r.toAddress;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            Redirect r = (Redirect)this.redirects.elementAt(row);
            if (col == 0) {
                r.fromAddress = String.valueOf(obj);
            } else {
                r.toAddress = String.valueOf(obj);
            }
        }
    }
}

