/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Choice;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import net.handle.hdllib.Interface;

public class InterfacePanel
extends Panel {
    private final Choice typeChoice = new Choice();
    private final Choice protocolChoice;
    private final TextField portField;

    public InterfacePanel() {
        this.typeChoice.addItem("OUT_OF_SERVICE");
        this.typeChoice.addItem("ADMIN");
        this.typeChoice.addItem("QUERY");
        this.typeChoice.addItem("ADMIN_AND_QUERY");
        this.protocolChoice = new Choice();
        this.protocolChoice.addItem("HDL_UDP");
        this.protocolChoice.addItem("HDL_TCP");
        this.protocolChoice.addItem("HDL_HTTP");
        this.protocolChoice.addItem("HDL_HTTPS");
        this.portField = new TextField("2641", 6);
        this.add(new Label("Type: "));
        this.add(this.typeChoice);
        this.add(new Label("  Protocol: "));
        this.add(this.protocolChoice);
        this.add(new Label("  Port: "));
        this.add(this.portField);
    }

    public void getInterface(Interface intfc) {
        switch (this.protocolChoice.getSelectedIndex()) {
            case 0: {
                intfc.protocol = 0;
                break;
            }
            case 1: {
                intfc.protocol = 1;
                break;
            }
            case 2: {
                intfc.protocol = (byte)2;
                break;
            }
            case 3: {
                intfc.protocol = (byte)3;
                break;
            }
            default: {
                intfc.protocol = 0;
            }
        }
        switch (this.typeChoice.getSelectedIndex()) {
            case 0: {
                intfc.type = 0;
                break;
            }
            case 1: {
                intfc.type = 1;
                break;
            }
            case 2: {
                intfc.type = (byte)2;
                break;
            }
            case 3: {
                intfc.type = (byte)3;
                break;
            }
            default: {
                intfc.type = 0;
            }
        }
        try {
            intfc.port = Integer.parseInt(this.portField.getText().trim());
        }
        catch (Exception e) {
            this.getToolkit().beep();
            intfc.port = 2641;
            this.portField.setText("2641");
        }
    }

    public void setInterface(Interface intfc) {
        switch (intfc.protocol) {
            case 0: {
                this.protocolChoice.select(0);
                break;
            }
            case 1: {
                this.protocolChoice.select(1);
                break;
            }
            case 2: {
                this.protocolChoice.select(2);
                break;
            }
            case 3: {
                this.protocolChoice.select(3);
                break;
            }
            default: {
                this.protocolChoice.select(0);
            }
        }
        switch (intfc.type) {
            case 0: {
                this.typeChoice.select(0);
                break;
            }
            case 1: {
                this.typeChoice.select(1);
                break;
            }
            case 2: {
                this.typeChoice.select(2);
                break;
            }
            case 3: {
                this.typeChoice.select(3);
                break;
            }
            default: {
                this.typeChoice.select(0);
            }
        }
        this.portField.setText(String.valueOf(intfc.port));
    }
}

