/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.handle.apps.db_tool.DefaultDataPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValuePanel
extends JPanel
implements ActionListener,
DocumentListener {
    private final CopyOnWriteArrayList<ChangeListener> changeListeners = new CopyOnWriteArrayList();
    private boolean isTriggerChanges = false;
    private final JTextField indexField;
    private final JTextField typeField;
    private final JTextField dataField;
    private byte[] data;
    private final JButton editDataButton;
    private final JComboBox<String> ttlTypeChoice;
    private final JTextField ttlField;
    private final JTextField timestampField;
    private final JCheckBox adminReadCheckbox;
    private final JCheckBox adminWriteCheckbox;
    private final JCheckBox publicReadCheckbox;
    private final JCheckBox publicWriteCheckbox;
    private final JPanel refsPanel;
    private final JList<String> referenceList;
    private final DefaultListModel<String> referenceListModel;
    private final Vector<ValueReference> references = new Vector();
    private final JButton addReferenceButton;
    private final JButton remReferenceButton;
    private final JButton editReferenceButton;

    public HandleValuePanel() {
        super(new GridBagLayout());
        this.indexField = new JTextField("", 10);
        this.indexField.getDocument().addDocumentListener(this);
        this.indexField.addActionListener(this);
        this.typeField = new JTextField("", 10);
        this.typeField.getDocument().addDocumentListener(this);
        this.typeField.addActionListener(this);
        this.dataField = new JTextField("", 20);
        this.dataField.setEditable(false);
        this.editDataButton = new JButton("Edit");
        this.ttlTypeChoice = new JComboBox();
        this.ttlTypeChoice.addItem("Relative");
        this.ttlTypeChoice.addItem("Absolute");
        this.ttlTypeChoice.addActionListener(this);
        this.ttlField = new JTextField("", 6);
        this.ttlField.getDocument().addDocumentListener(this);
        this.ttlField.addActionListener(this);
        this.timestampField = new JTextField("", 10);
        this.timestampField.setEditable(false);
        this.adminReadCheckbox = new JCheckBox("AR", true);
        this.adminReadCheckbox.addActionListener(this);
        this.adminWriteCheckbox = new JCheckBox("AW", true);
        this.adminWriteCheckbox.addActionListener(this);
        this.publicReadCheckbox = new JCheckBox("PR", true);
        this.publicReadCheckbox.addActionListener(this);
        this.publicWriteCheckbox = new JCheckBox("PW", false);
        this.publicWriteCheckbox.addActionListener(this);
        this.referenceListModel = new DefaultListModel();
        this.referenceList = new JList<String>(this.referenceListModel);
        this.addReferenceButton = new JButton("Add");
        this.remReferenceButton = new JButton("Remove");
        this.editReferenceButton = new JButton("Modify");
        JPanel panel1 = new JPanel(new GridBagLayout());
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel panel3 = new JPanel(new GridBagLayout());
        int x = 0;
        int y = 0;
        panel1.add((Component)new JLabel("Index:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.indexField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel1.add((Component)new JLabel(" Type:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.typeField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel1.add((Component)new JLabel(" Data:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.dataField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel1.add((Component)this.editDataButton, AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        x = 0;
        y = 0;
        panel2.add((Component)new JLabel(" TTL:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel2.add(this.ttlTypeChoice, AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel2.add((Component)this.ttlField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        panel2.add((Component)new JLabel(" Timestamp:", 4), AwtUtil.getConstraints(x++, y, 0.0, 0.0, 1, 1, true, true));
        panel2.add((Component)this.timestampField, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        x = 0;
        y = 0;
        JPanel tmpPanel = new JPanel(new GridBagLayout());
        tmpPanel.add((Component)new JLabel(" Permissions:", 2), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 2, 1, true, true));
        tmpPanel.add((Component)this.adminReadCheckbox, AwtUtil.getConstraints(0, 1, 0.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.adminWriteCheckbox, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.publicReadCheckbox, AwtUtil.getConstraints(0, 2, 0.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.publicWriteCheckbox, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, true, true));
        panel3.add((Component)tmpPanel, AwtUtil.getConstraints(x++, y, 1.0, 0.0, 1, 1, true, true));
        this.refsPanel = new JPanel(new GridBagLayout());
        this.refsPanel.add((Component)new JLabel(" Refs:", 2), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 2, 1, true, true));
        this.refsPanel.add((Component)new JScrollPane(this.referenceList), AwtUtil.getConstraints(0, 1, 1.0, 0.0, 1, 5, true, true));
        int n = ++x;
        ++x;
        panel3.add((Component)this.refsPanel, AwtUtil.getConstraints(n, y, 1.0, 0.0, 1, 1, true, true));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HandleValuePanel.this.refsPanel.setVisible(false);
            }
        });
        this.add((Component)panel1, AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)panel2, AwtUtil.getConstraints(0, 1, 0.0, 1.0, 1, 1, true, true));
        this.add((Component)panel3, AwtUtil.getConstraints(0, 2, 0.0, 0.0, 1, 1, true, true));
        this.addReferenceButton.addActionListener(this);
        this.remReferenceButton.addActionListener(this);
        this.editReferenceButton.addActionListener(this);
        this.editDataButton.addActionListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.indexField.setEditable(enabled);
        this.typeField.setEditable(enabled);
        this.editDataButton.setEnabled(enabled);
        this.ttlTypeChoice.setEnabled(enabled);
        this.ttlField.setEditable(enabled);
        this.adminReadCheckbox.setEnabled(enabled);
        this.adminWriteCheckbox.setEnabled(enabled);
        this.publicReadCheckbox.setEnabled(enabled);
        this.publicWriteCheckbox.setEnabled(enabled);
    }

    private void updateDataLabel() {
        if (this.data == null) {
            this.dataField.setText("<null>");
        } else if (Util.looksLikeBinary(this.data)) {
            this.dataField.setText(Util.decodeHexString(this.data, false));
        } else {
            this.dataField.setText(Util.decodeString(this.data));
        }
    }

    private void rebuildReferenceList() {
        this.referenceListModel.clear();
        for (int i = 0; i < this.references.size(); ++i) {
            this.referenceListModel.addElement(String.valueOf(this.references.elementAt(i)));
        }
        this.refsPanel.setVisible(!this.references.isEmpty());
    }

    public void setHandleValue(HandleValue value) {
        this.setTriggerChanges(false);
        this.data = value.getData();
        this.updateDataLabel();
        this.indexField.setText(String.valueOf(value.getIndex()));
        this.typeField.setText(Util.decodeString(value.getType()));
        switch (value.getTTLType()) {
            case 1: {
                this.ttlTypeChoice.setSelectedIndex(1);
                break;
            }
            default: {
                this.ttlTypeChoice.setSelectedIndex(0);
            }
        }
        this.ttlField.setText(String.valueOf(value.getTTL()));
        this.timestampField.setText(String.valueOf(new Date(value.getTimestamp() * 1000)));
        this.adminReadCheckbox.setSelected(value.getAdminCanRead());
        this.adminWriteCheckbox.setSelected(value.getAdminCanWrite());
        this.publicReadCheckbox.setSelected(value.getAnyoneCanRead());
        this.publicWriteCheckbox.setSelected(value.getAnyoneCanWrite());
        this.references.removeAllElements();
        ValueReference[] refs = value.getReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                this.references.addElement(refs[i]);
            }
        }
        this.rebuildReferenceList();
        this.setTriggerChanges(true);
    }

    public void getHandleValue(HandleValue value) {
        block8: {
            String val;
            block7: {
                try {
                    value.setIndex(Integer.parseInt(this.indexField.getText().trim()));
                }
                catch (Exception e) {
                    val = this.indexField.getText().trim();
                    if (val.equals("-") || val.isEmpty()) break block7;
                    System.err.println("Error: invalid index value: " + this.indexField.getText());
                }
            }
            try {
                value.setTTL(Integer.parseInt(this.ttlField.getText().trim()));
                if (this.ttlTypeChoice.getSelectedIndex() == 0) {
                    value.setTTLType((byte)0);
                } else {
                    value.setTTLType((byte)1);
                }
            }
            catch (Exception e) {
                val = this.ttlField.getText().trim();
                if (val.equals("-") || val.isEmpty()) break block8;
                System.err.println("Error: invalid ttl: " + this.ttlField.getText());
            }
        }
        value.setData(this.data);
        value.setType(Util.encodeString(this.typeField.getText()));
        value.setAdminCanRead(this.adminReadCheckbox.isSelected());
        value.setAdminCanWrite(this.adminWriteCheckbox.isSelected());
        value.setAnyoneCanRead(this.publicReadCheckbox.isSelected());
        value.setAnyoneCanWrite(this.publicWriteCheckbox.isSelected());
        ValueReference[] refs = new ValueReference[this.references.size()];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = this.references.elementAt(i);
        }
        value.setReferences(refs);
    }

    private void editData() {
        DefaultDataPanel dataPanel = new DefaultDataPanel();
        dataPanel.setValue(this.data);
        if (2 == GenericDialog.showDialog("Edit Data", dataPanel, 3, this)) {
            return;
        }
        this.data = dataPanel.getValue();
        this.updateDataLabel();
        this.triggerChange();
    }

    private void evtAddReference() {
    }

    private void evtRemoveReference() {
    }

    private void evtEditReference() {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.editDataButton) {
            this.editData();
        } else if (src == this.addReferenceButton) {
            this.evtAddReference();
        } else if (src == this.remReferenceButton) {
            this.evtRemoveReference();
        } else if (src == this.editReferenceButton) {
            this.evtEditReference();
        } else {
            this.triggerChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.triggerChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.triggerChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.triggerChange();
    }

    private void setTriggerChanges(boolean isTriggerChanges) {
        this.isTriggerChanges = isTriggerChanges;
    }

    private void triggerChange() {
        if (this.isTriggerChanges) {
            for (ChangeListener listener : this.changeListeners) {
                listener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }
}

