/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.handle.apps.db_tool.AdminInfoPanel;
import net.handle.apps.db_tool.SiteInfoPanel;
import net.handle.apps.db_tool.ValueListInfoPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class DefaultDataPanel
extends Panel
implements ItemListener {
    private final TextArea textArea;
    private final Choice formatChoice;
    private int lastFormat;

    public DefaultDataPanel() {
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea(5, 50);
        this.formatChoice = new Choice();
        this.formatChoice.addItem("Hex");
        this.formatChoice.addItem("Text");
        this.formatChoice.addItem("Site Info");
        this.formatChoice.addItem("Admin Info");
        this.formatChoice.addItem("Reference List");
        Button loadButton = new Button("Load");
        Button saveButton = new Button("Save");
        Panel northPanel = new Panel();
        northPanel.add(this.formatChoice);
        northPanel.add(new Label("   "));
        northPanel.add(loadButton);
        northPanel.add(saveButton);
        this.add((Component)northPanel, "North");
        this.add((Component)this.textArea, "Center");
        this.lastFormat = 0;
        this.formatChoice.addItemListener(this);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDataPanel.this.loadFromFile();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultDataPanel.this.saveToFile();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Select File to Load", 0);
        fwin.setVisible(true);
        String dir = fwin.getDirectory();
        String file = fwin.getFile();
        if (dir == null || file == null || file.trim().length() <= 0) {
            return;
        }
        InputStream in = null;
        try {
            File dataFile = new File(dir, file);
            byte[] data = new byte[(int)dataFile.length()];
            in = new FileInputStream(dataFile);
            int r = 0;
            for (int n = 0; n < data.length && (r = in.read(data, n, data.length - n)) > 0; n += r) {
            }
            this.selectFormat(0);
            this.lastFormat = 0;
            this.setHexValue(data);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            GenericDialog.askQuestion("Error", "Error unable to load data: " + e, 0, this);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception dataFile) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        System.err.println("Saving to a file....");
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Select File to Save", 1);
        fwin.setVisible(true);
        String dir = fwin.getDirectory();
        String file = fwin.getFile();
        if (dir == null || file == null || file.trim().length() <= 0) {
            return;
        }
        OutputStream out = null;
        try {
            File dataFile = new File(dir, file);
            out = new FileOutputStream(dataFile);
            out.write(this.getValue());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            GenericDialog.askQuestion("Error", "Error unable to save data: " + e, 0, this);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception dataFile) {}
            }
        }
    }

    public void setValue(byte[] value) {
        if (this.lastFormat == 0) {
            this.setHexValue(value);
        } else {
            this.setTextValue(value);
        }
    }

    public byte[] getValue() {
        if (this.lastFormat == 0) {
            return this.getHexValue();
        }
        return this.getTextValue();
    }

    private void getSiteValue() {
        byte[] currentVal = this.getValue();
        SiteInfo site = new SiteInfo();
        if (currentVal.length > 0) {
            try {
                Encoder.decodeSiteInfoRecord(currentVal, 0, site);
            }
            catch (Throwable e) {
                System.err.println("Exception parsing current value: " + e);
                e.printStackTrace(System.err);
            }
        }
        SiteInfoPanel sitePanel = new SiteInfoPanel();
        sitePanel.setSiteInfo(site);
        if (2 != GenericDialog.showDialog("Edit Data", sitePanel, 3, this)) {
            sitePanel.getSiteInfo(site);
            byte[] record = Encoder.encodeSiteInfoRecord(site);
            this.selectFormat(0);
            this.setValue(record);
        } else {
            this.selectFormat(this.lastFormat);
        }
    }

    private void getAdminValue() {
        byte[] currentVal = this.getValue();
        AdminRecord admin = new AdminRecord();
        if (currentVal.length > 0) {
            try {
                Encoder.decodeAdminRecord(currentVal, 0, admin);
            }
            catch (Throwable e) {
                System.err.println("Exception parsing current value: " + e);
                e.printStackTrace(System.err);
            }
        }
        AdminInfoPanel adminPanel = new AdminInfoPanel();
        adminPanel.setAdminInfo(admin);
        if (2 != GenericDialog.showDialog("Edit Admin Record", adminPanel, 3, this)) {
            adminPanel.getAdminInfo(admin);
            byte[] record = Encoder.encodeAdminRecord(admin);
            this.selectFormat(0);
            this.setValue(record);
        } else {
            this.selectFormat(this.lastFormat);
        }
    }

    private void getVListValue() {
        byte[] currentVal = this.getValue();
        ValueReference[] valuesInGroup = new ValueReference[]{};
        if (currentVal.length > 0) {
            try {
                valuesInGroup = Encoder.decodeValueReferenceList(currentVal, 0);
            }
            catch (Throwable e) {
                System.err.println("Exception parsing current value: " + e);
                e.printStackTrace(System.err);
            }
        }
        ValueListInfoPanel valuesPanel = new ValueListInfoPanel();
        valuesPanel.setValueListInfo(valuesInGroup);
        if (2 != GenericDialog.showDialog("Edit Value List Record", valuesPanel, 3, this)) {
            valuesInGroup = valuesPanel.getValueListInfo();
            byte[] record = Encoder.encodeValueReferenceList(valuesInGroup);
            this.selectFormat(0);
            this.setValue(record);
        } else {
            this.selectFormat(this.lastFormat);
        }
    }

    private void convertTextToHex() {
        this.setHexValue(this.getTextValue());
    }

    private void convertHexToText() {
        this.setTextValue(this.getHexValue());
    }

    private byte[] getTextValue() {
        return Util.encodeString(this.textArea.getText());
    }

    private void setTextValue(byte[] b) {
        this.textArea.setText(Util.decodeString(b));
    }

    private byte[] getHexValue() {
        return Util.encodeHexString(this.textArea.getText());
    }

    private void setHexValue(byte[] b) {
        this.textArea.setText(Util.decodeHexString(b, true));
    }

    private void selectFormat(int newFormat) {
        this.formatChoice.select(newFormat);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.formatChoice) {
            int format = this.formatChoice.getSelectedIndex();
            if (format == this.lastFormat) {
                return;
            }
            if (format == 0) {
                this.convertTextToHex();
                this.lastFormat = format;
            } else if (format == 1) {
                this.convertHexToText();
                this.lastFormat = format;
            } else if (format == 2) {
                this.getSiteValue();
            } else if (format == 3) {
                this.getAdminValue();
            } else if (format == 4) {
                this.getVListValue();
            }
        }
    }
}

