/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.cnri.util.StreamTable;
import net.handle.apps.db_tool.HandleInfoPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.server.HandleStorageFactory;

public class DBTool
extends JFrame
implements ActionListener {
    private final HandleStorage storage;
    private final JButton deleteHandleButton;
    private final JButton addHandleButton;
    private final JButton modifyHandleButton;
    private final JButton listHandlesButton;
    private final JButton addNAButton;
    private final JButton deleteNAButton;
    private final JButton listNAsButton;
    private final JButton exitButton;

    public DBTool(HandleStorage storage) {
        super("Handle Database Tool");
        this.storage = storage;
        JPanel p = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)p, "Center");
        this.deleteHandleButton = new JButton("Delete Handle");
        this.addHandleButton = new JButton("Create Handle");
        this.modifyHandleButton = new JButton("Modify Handle");
        this.listHandlesButton = new JButton("List Handles");
        this.addNAButton = new JButton("Add Homed Prefix");
        this.deleteNAButton = new JButton("Delete Homed Prefix");
        this.listNAsButton = new JButton("List Homed Prefixes");
        this.exitButton = new JButton("Exit");
        int y = 0;
        int x = 0;
        p.add((Component)this.addHandleButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.deleteHandleButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.modifyHandleButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.listHandlesButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)new Label(" "), AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.addNAButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.deleteNAButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.listNAsButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)new Label(" "), AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        p.add((Component)this.exitButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
        this.deleteHandleButton.addActionListener(this);
        this.addHandleButton.addActionListener(this);
        this.modifyHandleButton.addActionListener(this);
        this.listHandlesButton.addActionListener(this);
        this.addNAButton.addActionListener(this);
        this.deleteNAButton.addActionListener(this);
        this.listNAsButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void listHandles() throws Exception {
        System.out.println("\nListing handles: ");
        this.storage.scanHandles(new ScanCallback(){

            @Override
            public void scanHandle(byte[] handle) {
                System.out.println(Util.decodeString(handle));
            }
        });
    }

    private void createHandle() throws Exception {
        JTextField handleField = new JTextField("", 25);
        if (2 == GenericDialog.showDialog("Enter New Handle", handleField, 3, this)) {
            return;
        }
        String handle = handleField.getText();
        HandleInfoPanel handlePanel = new HandleInfoPanel();
        if (2 == GenericDialog.showDialog("Enter Values for \"" + handle + "\"", handlePanel, 3, this)) {
            return;
        }
        HandleValue[] values = handlePanel.getHandleValues();
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null) continue;
            values[i].setTimestamp((int)(System.currentTimeMillis() / 1000L));
        }
        this.storage.createHandle(Util.encodeString(handle), values);
    }

    private void addNA() throws Exception {
        JTextField naHandleField = new JTextField("", 25);
        if (2 == GenericDialog.showDialog("Enter Prefix Handle [NEW]", naHandleField, 3, this)) {
            return;
        }
        this.storage.setHaveNA(Util.upperCaseInPlace(Util.encodeString(naHandleField.getText())), true);
    }

    private void deleteNA() throws Exception {
        JTextField naHandleField = new JTextField("", 25);
        if (2 == GenericDialog.showDialog("Enter Prefix Handle [DELETE]", naHandleField, 3, this)) {
            return;
        }
        this.storage.setHaveNA(Util.upperCaseInPlace(Util.encodeString(naHandleField.getText())), false);
    }

    private void listNAs() throws Exception {
        System.out.println("\nListing Prefixes: ");
        this.storage.scanNAs(new ScanCallback(){

            @Override
            public void scanHandle(byte[] handle) {
                System.out.println(Util.decodeString(handle));
            }
        });
    }

    private void modifyHandle() throws Exception {
        JTextField handleField = new JTextField("", 25);
        if (2 == GenericDialog.showDialog("Enter Handle To Modify", handleField, 3, this)) {
            return;
        }
        byte[] handle = Util.encodeString(handleField.getText());
        byte[][] rawValues = this.storage.getRawHandleValues(handle, null, null);
        if (rawValues == null) {
            GenericDialog.askQuestion("Error", "The handle \"" + Util.decodeString(handle) + "\" does not exist in this database", 0, this);
            return;
        }
        HandleValue[] values = new HandleValue[rawValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new HandleValue();
            Encoder.decodeHandleValue(rawValues[i], 0, values[i]);
        }
        HandleInfoPanel handlePanel = new HandleInfoPanel();
        handlePanel.setHandleValues(values);
        if (2 == GenericDialog.showDialog("Edit Values for \"" + Util.decodeString(handle) + "\"", handlePanel, 3, this)) {
            return;
        }
        values = handlePanel.getHandleValues();
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null) continue;
            values[i].setTimestamp((int)(System.currentTimeMillis() / 1000L));
        }
        this.storage.updateValue(handle, values);
    }

    private void deleteHandle() throws Exception {
        JTextField handleField = new JTextField("", 25);
        if (2 == GenericDialog.showDialog("Enter Handle to Delete", handleField, 3, this)) {
            return;
        }
        byte[] handle = Util.encodeString(handleField.getText());
        this.storage.deleteHandle(handle);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        try {
            if (src == this.listHandlesButton) {
                this.listHandles();
            } else if (src == this.addHandleButton) {
                this.createHandle();
            } else if (src == this.modifyHandleButton) {
                this.modifyHandle();
            } else if (src == this.deleteHandleButton) {
                this.deleteHandle();
            } else if (src == this.addNAButton) {
                this.addNA();
            } else if (src == this.deleteNAButton) {
                this.deleteNA();
            } else if (src == this.listNAsButton) {
                this.listNAs();
            } else if (src == this.exitButton) {
                this.storage.shutdown();
                System.exit(0);
            }
        }
        catch (Exception e) {
            this.getToolkit().beep();
            e.printStackTrace(System.err);
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv == null || argv.length < 1) {
            System.err.println("usage: java net.handle.apps.db_tool.DBTool <server-directory>");
            return;
        }
        File serverDir = new File(argv[0]);
        StreamTable serverInfo = new StreamTable();
        serverInfo.readFromFile(new File(serverDir, "config.dct"));
        serverInfo = (StreamTable)serverInfo.get("server_config");
        HandleStorage storage = HandleStorageFactory.getStorage(serverDir, serverInfo, true);
        DBTool dbTool = new DBTool(storage);
        dbTool.setVisible(true);
    }
}

