/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view.resources;

import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.cnri.util.StreamTable;

public class Resources
extends ResourceBundle {
    private static final String DEFAULT_DICT = "/net/handle/apps/admintool/view/resources/english.dict";
    private final StreamTable resourceTable = new StreamTable();
    private StreamTable backupResourceTable;

    public Resources() {
        this(DEFAULT_DICT);
    }

    public Resources(String resourceName) {
        InputStreamReader rdr;
        try {
            rdr = new InputStreamReader(this.getClass().getResourceAsStream(resourceName), "UTF8");
            this.resourceTable.readFrom(rdr);
        }
        catch (Exception e) {
            System.err.println("Error reading resources: " + e);
            e.printStackTrace(System.err);
        }
        if (DEFAULT_DICT.equals(resourceName)) {
            this.backupResourceTable = this.resourceTable;
        } else {
            this.backupResourceTable = new StreamTable();
            try {
                rdr = new InputStreamReader(this.getClass().getResourceAsStream(DEFAULT_DICT), "UTF8");
                this.backupResourceTable.readFrom(rdr);
            }
            catch (Exception e) {
                System.err.println("Error reading backup (english) resources: " + e);
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.resourceTable.keys();
    }

    @Override
    protected Object handleGetObject(String key) throws MissingResourceException {
        Object o = this.resourceTable.get(key);
        if (o == null) {
            o = this.backupResourceTable.get(key);
        }
        if (o == null) {
            return "??" + key + "??";
        }
        return o;
    }
}

