/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.apps.admintool.view.ValueReferenceEditor;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ValueReference;

public class ValueReferenceListEditor
extends JPanel
implements ActionListener,
HandleValueEditor {
    private final AdminToolUI ui;
    private final DefaultListModel<ValueReference> valueListModel;
    private final JList<ValueReference> valueList;
    private final JButton addButton;
    private final JButton editButton;
    private final JButton delButton;

    public ValueReferenceListEditor(AdminToolUI ui) {
        super(new GridBagLayout());
        this.ui = ui;
        this.valueListModel = new DefaultListModel();
        this.valueList = new JList<ValueReference>(this.valueListModel);
        this.valueList.setSelectionMode(0);
        this.addButton = new JButton(ui.getStr("add"));
        this.editButton = new JButton(ui.getStr("modify"));
        this.delButton = new JButton(ui.getStr("remove"));
        this.add((Component)new JScrollPane(this.valueList), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 4, new Insets(4, 4, 4, 4), true, true));
        this.add((Component)this.addButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        this.add((Component)this.editButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        this.add((Component)this.delButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        this.addButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.delButton.addActionListener(this);
        this.valueList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ValueReferenceListEditor.this.editButton.isEnabled()) {
                    ValueReferenceListEditor.this.editValue();
                }
            }
        });
    }

    @Override
    public boolean saveValueData(HandleValue value) {
        Object[] values = new ValueReference[this.valueListModel.getSize()];
        this.valueListModel.copyInto(values);
        value.setData(Encoder.encodeValueReferenceList((ValueReference[])values));
        return true;
    }

    @Override
    public void loadValueData(HandleValue value) {
        ValueReference[] values = null;
        try {
            values = Encoder.decodeValueReferenceList(value.getData(), 0);
        }
        catch (Exception e) {
            System.err.println("Unable to extract value reference list from " + value);
            values = new ValueReference[]{};
        }
        this.valueListModel.removeAllElements();
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null) continue;
            this.valueListModel.addElement(values[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.addButton) {
            this.addValue();
        } else if (src == this.editButton) {
            this.editValue();
        } else if (src == this.delButton) {
            this.removeValue();
        } else if (src == this.valueList) {
            this.editValue();
        }
    }

    private void addValue() {
        ValueReference valRef;
        ValueReferenceEditor valRefPanel = new ValueReferenceEditor();
        do {
            if (2 != JOptionPane.showConfirmDialog(this, valRefPanel, this.ui.getStr("enter_value") + ": ", 2, -1)) continue;
            return;
        } while ((valRef = valRefPanel.getValue()) == null);
        this.valueListModel.addElement(valRef);
    }

    private void editValue() {
        int selIdx = this.valueList.getSelectedIndex();
        if (selIdx < 0) {
            return;
        }
        ValueReference valRef = this.valueListModel.get(selIdx);
        ValueReferenceEditor valRefPanel = new ValueReferenceEditor(valRef);
        do {
            if (2 != JOptionPane.showConfirmDialog(this, valRefPanel, this.ui.getStr("enter_value") + ": ", 2, -1)) continue;
            return;
        } while ((valRef = valRefPanel.getValue()) == null);
        this.valueListModel.set(selIdx, valRef);
    }

    private void removeValue() {
        List<ValueReference> obj = this.valueList.getSelectedValuesList();
        for (int i = 0; obj != null && i < obj.size(); ++i) {
            if (obj.get(i) == null) continue;
            this.valueListModel.removeElement(obj.get(i));
        }
    }
}

