/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class ValueReferenceEditor
extends JPanel {
    private JTextField hdlField;
    private JTextField idxField;

    public ValueReferenceEditor() {
        this((ValueReference)null);
    }

    public ValueReferenceEditor(ValueReference valRef) {
        super(new GridBagLayout());
        this.add((Component)new JLabel("Handle: ", 4), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, true, false));
        this.hdlField = new JTextField("", 20);
        this.add((Component)this.hdlField, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, true, false));
        this.add((Component)new JLabel("Value Index: ", 4), AwtUtil.getConstraints(0, 1, 0.0, 0.0, 1, 1, true, false));
        this.idxField = new JTextField("", 20);
        this.add((Component)this.idxField, AwtUtil.getConstraints(1, 1, 1.0, 0.0, 1, 1, true, false));
        this.setValue(valRef);
    }

    public void setValue(ValueReference valRef) {
        if (valRef == null) {
            this.hdlField.setText("");
            this.idxField.setText("1");
        } else {
            byte[] bytes = valRef.handle;
            if (bytes == null) {
                this.hdlField.setText("");
            } else {
                try {
                    this.hdlField.setText(Util.decodeString(bytes));
                }
                catch (Exception e) {
                    this.hdlField.setText("");
                }
            }
            this.idxField.setText(String.valueOf(valRef.index));
        }
    }

    public ValueReference getValue() {
        String hdl = this.hdlField.getText().trim();
        if (hdl.length() <= 0) {
            JOptionPane.showMessageDialog(this, "Warning: empty handle invalid.\n");
            return null;
        }
        String idxStr = this.idxField.getText().trim();
        int idx = -1;
        try {
            idx = Integer.parseInt(idxStr);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Warning: invalid index value: '" + idxStr + "'.\n  Indexes must be a positive integer.");
            return null;
        }
        if (idx < 0) {
            JOptionPane.showMessageDialog(this, "Warning: invalid index value: '" + idxStr + "'.\n  Indexes must be a positive integer.");
            return null;
        }
        return new ValueReference(Util.encodeString(hdl), idx);
    }
}

