/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.cnri.guiutil.GridC;
import net.cnri.util.StreamTable;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.EditValueWindow;
import net.handle.apps.admintool.view.GetSiteInfoPanel;
import net.handle.apps.admintool.view.HandleValueRenderer;
import net.handle.apps.admintool.view.SignerInfo;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleSignature;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.SecureResolver;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionCallback;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

@Deprecated
public class TxnReviewWindow
extends JFrame
implements ActionListener {
    private static final String MARKER_MSG = "-stop receiving transactions marker-";
    private AdminToolUI appUI;
    private TxnReviewWindow thisObj;
    private DefaultListModel pendingListModel;
    private DefaultListModel valuesListModel;
    private JList pendingList;
    private JList valuesList;
    private String handle;
    private JButton signerButton;
    private JButton authButton;
    private JButton updateButton;
    private JCheckBox removeOldSignaturesBox;
    private JLabel sourceSiteLabel;
    private JLabel statusField;
    private JProgressBar progressBar;
    private Action[] updateActions;
    private Action signAction;
    private Action signAllAction;
    private int numTxnsToRetrieve = 50;
    private StreamTable replicationInfo;
    private String txnPrefsKey;
    private SiteInfo replicationSite;
    private SecureResolver resolver;
    private SignerInfo signerInfo;
    private AuthenticationInfo authInfo;

    public static final String prefKeyForSite(SiteInfo site) {
        if (site == null) {
            return "none";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("site:");
        for (int i = 0; i < site.servers.length; ++i) {
            if (i != 0) {
                sb.append('|');
            }
            try {
                sb.append(Util.rfcIpRepr(site.servers[i].getInetAddress()));
                sb.append(':');
                sb.append(site.servers[i].interfaces[0].port);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error: " + e);
            }
        }
        return sb.toString();
    }

    public TxnReviewWindow(AdminToolUI ui, SiteInfo replSite) {
        super(ui.getStr("signer_win_title") + " " + ui.getMain().getVersion());
        if (replSite == null) {
            throw new NullPointerException();
        }
        this.appUI = ui;
        this.thisObj = this;
        this.replicationSite = replSite;
        this.txnPrefsKey = TxnReviewWindow.prefKeyForSite(replSite);
        this.resolver = new SecureResolver(this.appUI.getMain().getResolver());
        this.resolver.ignoreUnsignedValues = false;
        this.resolver.ignoreInvalidSignatures = false;
        this.resolver.reportMissingValues = true;
        this.resolver.printState();
        Object txnPrefObj = this.appUI.getMain().prefs().get(this.txnPrefsKey);
        if (txnPrefObj instanceof StreamTable) {
            this.replicationInfo = (StreamTable)txnPrefObj;
        } else {
            this.replicationInfo = new StreamTable();
            this.appUI.getMain().prefs().put(this.txnPrefsKey, this.replicationInfo);
        }
        this.removeOldSignaturesBox = new JCheckBox(ui.getStr("remove_old_sigs"));
        this.removeOldSignaturesBox.setSelected(true);
        this.updateButton = new JButton(new AbstractAction(ui.getStr("update_txns_list")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                for (Action action : TxnReviewWindow.this.updateActions) {
                    menu.add(action);
                }
                menu.show(TxnReviewWindow.this.updateButton, 0, TxnReviewWindow.this.updateButton.getHeight());
            }
        });
        this.signAction = new AbstractAction(ui.getStr("sign_selected_handle")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.signSelectedHandle();
            }
        };
        this.signAllAction = new AbstractAction(ui.getStr("sign_all_handles")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.signAllHandles();
            }
        };
        this.signAction.putValue("Default", Boolean.TRUE);
        this.updateActions = new Action[]{new AbstractAction(ui.getStr("get_next_5")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 5;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_20")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 20;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_50")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 50;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_100")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 100;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_500")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 500;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_1000")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 1000;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_5000")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 5000;
                TxnReviewWindow.this.getTransactions();
            }
        }, new AbstractAction(ui.getStr("get_next_100000")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TxnReviewWindow.this.numTxnsToRetrieve = 100000;
                TxnReviewWindow.this.getTransactions();
            }
        }};
        this.pendingListModel = new DefaultListModel();
        this.valuesListModel = new DefaultListModel();
        this.pendingList = new JList(this.pendingListModel);
        this.valuesList = new JList(this.valuesListModel);
        this.signerButton = new JButton(ui.getStr("signer"));
        this.authButton = new JButton(ui.getStr("authenticate"));
        this.statusField = new JLabel(" ");
        this.statusField.setForeground(Color.gray);
        this.progressBar = new JProgressBar();
        this.sourceSiteLabel = new JLabel(ui.getStr("no_source_site"));
        this.valuesList.setSelectionMode(2);
        this.valuesList.setCellRenderer(new HandleValueRenderer());
        this.valuesList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    Object val = TxnReviewWindow.this.valuesList.getSelectedValue();
                    if (val == null || !(val instanceof HandleValue)) {
                        return;
                    }
                    EditValueWindow editWin = new EditValueWindow(TxnReviewWindow.this.appUI, TxnReviewWindow.this.thisObj, TxnReviewWindow.this.handle, TxnReviewWindow.this.getValues());
                    editWin.loadValueData(((HandleValue)val).duplicate(), false);
                    editWin.setMode(2);
                    editWin.setVisible(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.add((Component)this.sourceSiteLabel, GridC.getc(0, 0).fillx().wx(1.0f));
        p2.add((Component)this.updateButton, GridC.getc(1, 0).insets(0, 12, 0, 0));
        p.add((Component)p2, GridC.getc(0, 0).fillx().wx(1.0f));
        p.add((Component)new JScrollPane(this.pendingList), GridC.getc(0, 1).wxy(1.0f, 0.0f).fillboth());
        p.add(Box.createVerticalStrut(200), GridC.getc(0, 1));
        p2 = new JPanel(new GridBagLayout());
        p2.add((Component)this.signerButton, GridC.getc(0, 0));
        p2.add((Component)this.authButton, GridC.getc(1, 0));
        p2.add((Component)this.statusField, GridC.getc(2, 0).wx(1.0f).fillboth());
        p2.add(Box.createHorizontalStrut(200), GridC.getc(2, 0).wx(1.0f));
        p2.add((Component)this.progressBar, GridC.getc(3, 0).wx(1.0f).fillboth());
        p2.add((Component)new JButton(this.signAllAction), GridC.getc(4, 0));
        p2.add((Component)new JButton(this.signAction), GridC.getc(5, 0));
        p.add((Component)p2, GridC.getc(0, 2).fillx().wx(1.0f));
        p.add((Component)new JScrollPane(this.valuesList), GridC.getc(0, 4).wxy(1.0f, 1.0f).fillboth());
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(p);
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, 4);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
            }
        });
        this.authButton.addActionListener(this);
        this.signerButton.addActionListener(this);
        this.pendingList.setSelectionMode(0);
        this.pendingList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TxnReviewWindow.this.selectionUpdated();
            }
        });
        this.updateSiteLabel();
        this.updateEnabledItems();
        this.enableEvents(202L);
    }

    public HandleValue[] getValues() {
        HandleValue[] values = new HandleValue[this.valuesListModel.size()];
        for (int i = 0; i < this.valuesListModel.size(); ++i) {
            values[i] = (HandleValue)this.valuesListModel.get(i);
        }
        return values;
    }

    @Override
    public final void processEvent(AWTEvent evt) {
        evt.getID();
        switch (evt.getID()) {
            case 202: {
                this.appUI.txnReviewWindowClosed(this);
                return;
            }
        }
        super.processEvent(evt);
    }

    private void selectionUpdated() {
        ToBeSigned tbs = (ToBeSigned)this.pendingList.getSelectedValue();
        this.signAction.setEnabled(tbs != null);
        this.signAllAction.setEnabled(this.pendingListModel.getSize() > 0);
        if (tbs == null) {
            this.handle = null;
            this.valuesListModel.removeAllElements();
        } else {
            this.handle = Util.decodeString(tbs.txn.handle);
            this.valuesList.setListData(tbs.txn.values);
        }
    }

    private void updateSiteLabel() {
        if (this.replicationSite == null) {
            this.sourceSiteLabel.setText(this.appUI.getStr("no_source_site"));
        } else {
            this.sourceSiteLabel.setText(this.appUI.getStr("source_site_label") + ": " + this.replicationSite.toString());
        }
    }

    public static TxnReviewWindow showReviewWindow(AdminToolUI appUI) {
        GetSiteInfoPanel siteInfoPanel = new GetSiteInfoPanel(appUI, appUI.getStr("select_source_site"));
        SiteInfo sourceSite = null;
        block3: while (sourceSite == null) {
            int result = JOptionPane.showConfirmDialog(null, siteInfoPanel, appUI.getStr("select_source_site"), 2);
            switch (result) {
                case 0: {
                    sourceSite = siteInfoPanel.getSiteInfo();
                    continue block3;
                }
            }
            return null;
        }
        TxnReviewWindow win = new TxnReviewWindow(appUI, sourceSite);
        win.setVisible(true);
        return win;
    }

    private void updateEnabledItems() {
    }

    private void removeFromQueue(final ToBeSigned tbs) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pendingListModel.removeElement(tbs);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TxnReviewWindow.this.pendingListModel.removeElement(tbs);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean receiveTxn(Transaction txn, GetTxnCallback callback) {
        ToBeSigned toBeSigned = new ToBeSigned(txn, callback);
        int prevIdx = this.pendingListModel.indexOf(toBeSigned);
        switch (txn.action) {
            case 2: {
                if (prevIdx >= 0) {
                    this.removeFromQueue(toBeSigned);
                }
                return true;
            }
            case 0: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 1: 
            case 3: {
                if (prevIdx < 0) break;
                this.removeFromQueue(toBeSigned);
            }
        }
        if (this.pendingListModel.size() >= this.numTxnsToRetrieve) {
            return false;
        }
        if (this.pendingListModel.size() <= 0) {
            toBeSigned.savePreviousTransactionMarker();
        }
        HandleValue[] secureValues = null;
        boolean signed = false;
        try {
            secureValues = this.resolver.secureHandleValues(toBeSigned.txn.handle, toBeSigned.txn.values);
            signed = true;
        }
        catch (Throwable t) {
            System.err.println("Error verifying secure values: " + t);
            t.printStackTrace(System.err);
        }
        if (secureValues == null || !signed) {
            toBeSigned.run();
        }
        if (this.pendingListModel.size() <= 0) {
            toBeSigned.saveTransactionMarker();
        }
        return true;
    }

    private void getTransactions() {
        if (this.pendingListModel.size() >= this.numTxnsToRetrieve) {
            return;
        }
        this.authInfo = this.appUI.getAuthentication(false);
        if (this.authInfo == null) {
            return;
        }
        Runnable getter = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < ((TxnReviewWindow)TxnReviewWindow.this).replicationSite.servers.length; ++i) {
                        String serverTxnIDKey = "last_txn:" + ((TxnReviewWindow)TxnReviewWindow.this).replicationSite.servers[i].serverId;
                        String serverDateKey = "last_date:" + ((TxnReviewWindow)TxnReviewWindow.this).replicationSite.servers[i].serverId;
                        GetTxnCallback callback = new GetTxnCallback(TxnReviewWindow.this.replicationInfo, serverTxnIDKey, serverDateKey);
                        try {
                            TxnReviewWindow.this.appUI.getMain().retrieveHandlesSinceTime(TxnReviewWindow.this.authInfo, TxnReviewWindow.this.replicationSite, i, TxnReviewWindow.this.replicationInfo.getLong(serverTxnIDKey, 0L), TxnReviewWindow.this.replicationInfo.getLong(serverDateKey, System.currentTimeMillis()), callback);
                            continue;
                        }
                        catch (Throwable t) {
                            if (t instanceof HandleException && TxnReviewWindow.MARKER_MSG.equals(((HandleException)t).getMessage())) continue;
                            t.printStackTrace(System.err);
                            JOptionPane.showMessageDialog(TxnReviewWindow.this.thisObj, "Error: " + t.getMessage(), "Error", 0);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TxnReviewWindow.this.selectionUpdated();
                        }
                    });
                }
                finally {
                    TxnReviewWindow.this.progressBar.setIndeterminate(false);
                }
            }
        };
        this.progressBar.setIndeterminate(true);
        this.statusField.setText(this.appUI.getStr("retrieving_txns"));
        new Thread(getter).start();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.signerButton) {
            this.appUI.getSignatureInfo(this, true);
        } else if (evt.getSource() == this.authButton) {
            this.appUI.getAuthentication(true);
        } else {
            System.err.println("need to implement action: " + evt);
        }
    }

    public static final int getNextUnusedIndex(HandleValue[] values, int firstIdx) {
        int nextIdx = firstIdx - 1;
        boolean duplicate = true;
        block0: while (duplicate) {
            ++nextIdx;
            duplicate = false;
            for (int i = values.length - 1; i >= 0; --i) {
                HandleValue val = values[i];
                if (val == null || val.getIndex() != nextIdx) continue;
                duplicate = true;
                continue block0;
            }
        }
        return nextIdx;
    }

    private boolean signEntry(ToBeSigned entry, boolean recordMarker) {
        System.err.println("signing: " + entry);
        try {
            if (this.signerInfo.isRemoteSigner()) {
                this.showAsyncError("Cannot perform legacy signatures using remote signer");
                return false;
            }
            PublicKeyAuthenticationInfo localSigner = this.signerInfo.getLocalSignerInfo();
            HandleValue digestVal = HandleSignature.createDigestsValue(TxnReviewWindow.getNextUnusedIndex(entry.txn.values, 400), entry.handleStr, entry.txn.values);
            ValueReference signer = this.signerInfo.getUserValueReference();
            HandleValue sigValue = HandleSignature.createSignatureValue(TxnReviewWindow.getNextUnusedIndex(entry.txn.values, digestVal.getIndex() + 1), entry.handleStr, signer, null, localSigner.getPrivateKey(), digestVal);
            AddValueRequest req = new AddValueRequest(entry.txn.handle, new HandleValue[]{digestVal, sigValue}, this.authInfo);
            if (this.removeOldSignaturesBox.isSelected()) {
                int[] indexesToRemove = new int[entry.txn.values.length];
                int nextIdx = 0;
                for (int i = 0; i < indexesToRemove.length; ++i) {
                    if (!entry.txn.values[i].hasType(SecureResolver.METADATA_TYPE) && !entry.txn.values[i].hasType(SecureResolver.SIGNATURE_TYPE)) continue;
                    indexesToRemove[nextIdx++] = entry.txn.values[i].getIndex();
                }
                if (nextIdx > 0) {
                    int[] tmpIndexes = new int[nextIdx];
                    System.arraycopy(indexesToRemove, 0, tmpIndexes, 0, tmpIndexes.length);
                    RemoveValueRequest rvReq = new RemoveValueRequest(entry.txn.handle, tmpIndexes, this.authInfo);
                    AbstractResponse resp = this.appUI.getMain().getResolver().sendRequestToSite(rvReq, this.replicationSite);
                    if (resp.responseCode != 1 && resp.responseCode != 301) {
                        SwingUtilities.invokeLater(new ErrMsgRunner("Unable to remove old signatures"));
                        return false;
                    }
                }
            }
            AbstractResponse resp = this.appUI.getMain().getResolver().sendRequestToSite(req, this.replicationSite);
            if (resp.responseCode == 1 || resp.responseCode == 301) {
                this.pendingListModel.removeElement(entry);
                if (recordMarker) {
                    entry.saveTransactionMarker();
                }
            }
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new ErrMsgRunner(String.valueOf(t)));
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private void signSelectedHandle() {
        ToBeSigned tbs = (ToBeSigned)this.pendingList.getSelectedValue();
        if (tbs == null) {
            return;
        }
        this.signerInfo = this.appUI.getSignatureInfo(this, false);
        if (this.signerInfo == null) {
            return;
        }
        int selIdx = this.pendingList.getSelectedIndex();
        this.signEntry(tbs, selIdx == 0);
        selIdx = Math.min(selIdx, this.pendingListModel.getSize() - 1);
        if (selIdx >= 0) {
            this.pendingList.setSelectedIndex(selIdx);
        }
        this.selectionUpdated();
    }

    private void signAllHandles() {
        if (this.pendingListModel.size() <= 0) {
            return;
        }
        this.signerInfo = this.appUI.getSignatureInfo(this, false);
        if (this.signerInfo == null) {
            return;
        }
        this.signAction.setEnabled(false);
        this.signAllAction.setEnabled(false);
        Runnable signAllRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    while (TxnReviewWindow.this.pendingListModel.size() > 0) {
                        ToBeSigned tbs = (ToBeSigned)TxnReviewWindow.this.pendingListModel.get(0);
                        if (TxnReviewWindow.this.signEntry(tbs, true)) continue;
                        break;
                    }
                }
                finally {
                    TxnReviewWindow.this.selectionUpdated();
                }
            }
        };
        Thread t = new Thread(signAllRunner);
        t.setName("sign all handles thread");
        t.start();
    }

    public void signerChanged(SignerInfo newSigner) {
        this.signerInfo = newSigner;
        if (newSigner == null) {
            this.signerButton.setText(this.appUI.getStr("signer"));
        } else {
            try {
                String signerId = this.signerInfo.isLocalSigner() ? this.signerInfo.getUserValueReference().toString() : "Remote signer";
                this.signerButton.setText(this.appUI.getStr("signer") + ": " + signerId);
            }
            catch (Exception e) {
                this.signerButton.setText(String.valueOf(e));
            }
        }
    }

    public void authenticationChanged(AuthenticationInfo newAuth) {
        if (newAuth == null) {
            this.authButton.setText(this.appUI.getStr("authenticate"));
        } else {
            try {
                this.authButton.setText(this.appUI.getStr("authenticate") + ": " + newAuth.getUserIdIndex() + " : " + Util.decodeString(newAuth.getUserIdHandle()));
            }
            catch (Exception e) {
                this.authButton.setText(String.valueOf(e));
            }
        }
    }

    public void showAsyncError(String msg) {
        SwingUtilities.invokeLater(new ErrMsgRunner(msg));
    }

    private class ErrMsgRunner
    implements Runnable {
        private final String msg;

        ErrMsgRunner(String msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(TxnReviewWindow.this.thisObj, this.msg);
        }
    }

    private class GetTxnCallback
    implements TransactionCallback {
        private final StreamTable siteSettings;
        private final String serverTxnIDKey;
        private final String serverDateKey;

        GetTxnCallback(StreamTable siteSettings, String serverTxnKey, String serverDateKey) {
            this.siteSettings = siteSettings;
            this.serverTxnIDKey = serverTxnKey;
            this.serverDateKey = serverDateKey;
        }

        @Override
        public void processTransaction(Transaction txn) throws HandleException {
            if (!TxnReviewWindow.this.receiveTxn(txn, this)) {
                throw new HandleException(1, TxnReviewWindow.MARKER_MSG);
            }
        }

        public void saveTransactionMarker(ToBeSigned tbs) {
            this.siteSettings.put(this.serverTxnIDKey, tbs.txn.txnId);
            this.siteSettings.put(this.serverDateKey, tbs.txn.date);
            try {
                TxnReviewWindow.this.appUI.getMain().savePreferences();
            }
            catch (Throwable t) {
                System.err.println("Error saving preferences: " + t);
            }
        }

        public void savePreviousTransactionMarker(ToBeSigned tbs) {
            this.siteSettings.put(this.serverTxnIDKey, tbs.txn.txnId - 1L);
            this.siteSettings.put(this.serverDateKey, tbs.txn.date);
            try {
                TxnReviewWindow.this.appUI.getMain().savePreferences();
            }
            catch (Throwable t) {
                System.err.println("Error saving preferences: " + t);
            }
        }

        @Override
        public void processTransaction(String queueName, Transaction txn) throws HandleException {
        }

        @Override
        public void finishProcessing() {
        }

        @Override
        public void finishProcessing(long sourceDate) {
        }

        @Override
        public void setQueueLastTimestamp(String queueName, long sourceDate) {
        }
    }

    private class ToBeSigned
    implements Runnable {
        Transaction txn;
        String handleStr;
        GetTxnCallback siteCallback;

        ToBeSigned(Transaction origTxn, GetTxnCallback callback) {
            this.txn = origTxn;
            this.siteCallback = callback;
            this.handleStr = Util.decodeString(origTxn.handle);
        }

        @Override
        public void run() {
            TxnReviewWindow.this.pendingListModel.addElement(this);
        }

        public int hashCode() {
            return this.handleStr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ToBeSigned) {
                return ((ToBeSigned)obj).handleStr.equals(this.handleStr);
            }
            return false;
        }

        public void saveTransactionMarker() {
            this.siteCallback.saveTransactionMarker(this);
        }

        public void savePreviousTransactionMarker() {
            this.siteCallback.savePreviousTransactionMarker(this);
        }

        public String toString() {
            return this.handleStr;
        }
    }
}

