/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import net.handle.apps.admintool.view.AbstractConsolePanel;
import net.handle.awt.AwtUtil;

public class TextAreaBasedConsolePanel
extends AbstractConsolePanel {
    public boolean debug = false;
    private Font textFont;
    private final JTextArea textArea;
    private final JScrollPane scrollPane;
    private ConsoleStream outputStream = null;

    public TextAreaBasedConsolePanel() {
        super(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.textFont = new Font("Monospaced", 0, 10);
        }
        this.textArea = new JTextArea(5, 20);
        this.textArea.setEditable(false);
        if (this.textFont != null) {
            this.textArea.setFont(this.textFont);
        }
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, true));
    }

    @Override
    public void writeConsoleContents(Writer w) throws IOException {
        w.write(this.textArea.getText());
    }

    @Override
    public synchronized void addText(String text) {
        try {
            if (text == null) {
                return;
            }
            this.textArea.append(text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void clear() {
        this.textArea.setText("");
        this.repaint();
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ConsoleStream();
        }
        return this.outputStream;
    }

    private class ConsoleStream
    extends OutputStream {
        private ConsoleStream() {
        }

        @Override
        public void write(byte[] buf) throws IOException {
            TextAreaBasedConsolePanel.this.addText(new String(buf, "UTF-8"));
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            TextAreaBasedConsolePanel.this.addText(new String(buf, offset, length, "UTF-8"));
        }

        @Override
        public void write(int i) throws IOException {
            TextAreaBasedConsolePanel.this.addText(String.valueOf((char)i));
        }
    }
}

