/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import net.cnri.guiutil.GridC;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SiteTester
extends JDialog {
    private SiteInfo site;
    private DefaultTableModel statusModel;
    private AdminToolUI ui;
    private HandleResolver resolver;

    public SiteTester(Dialog owner, AdminToolUI ui, HandleValue siteValue) throws Exception {
        super(owner, "placeholder", false);
        this.setupWindow(ui, siteValue);
    }

    public SiteTester(Frame owner, AdminToolUI ui, HandleValue siteValue) throws Exception {
        super(owner, "placeholder", false);
        this.setupWindow(ui, siteValue);
    }

    public SiteTester(Dialog owner, AdminToolUI ui, SiteInfo siteInfo) {
        super(owner, "placeholder", false);
        this.setupWindow(ui, siteInfo);
    }

    public SiteTester(Frame owner, AdminToolUI ui, SiteInfo siteInfo) {
        super(owner, "placeholder", false);
        this.setupWindow(ui, siteInfo);
    }

    private void setupWindow(AdminToolUI ui, HandleValue siteValue) throws Exception {
        SiteInfo siteInfo = new SiteInfo();
        Encoder.decodeSiteInfoRecord(siteValue.getData(), 0, siteInfo);
        this.setupWindow(ui, siteInfo);
    }

    private void setupWindow(AdminToolUI ui, SiteInfo siteInfo) {
        this.setTitle(ui.getStr("testing_site:") + " " + siteInfo);
        this.ui = ui;
        this.site = siteInfo;
        this.resolver = ui.getMain().getResolver();
        JPanel p = new JPanel(new GridBagLayout());
        this.statusModel = new DefaultTableModel();
        this.statusModel.addColumn(ui.getStr("address_interface"));
        this.statusModel.addColumn(ui.getStr("status"));
        for (int serverIdx = 0; serverIdx < this.site.servers.length; ++serverIdx) {
            ServerInfo server = this.site.servers[serverIdx];
            this.statusModel.addRow(new Object[]{server.getAddressString(), ""});
            for (int ifcIdx = 0; ifcIdx < server.interfaces.length; ++ifcIdx) {
                int ifcRow = this.statusModel.getRowCount();
                this.statusModel.addRow(new Object[]{"  " + server.interfaces[ifcIdx], ui.getStr("checking...")});
                new InterfaceChecker(server, server.interfaces[ifcIdx], ifcRow).start();
            }
        }
        p.add((Component)new JScrollPane(new JTable(this.statusModel)), GridC.getc(0, 0).wxy(1.0f, 1.0f).fillboth().insets(10, 10, 10, 10));
        this.getContentPane().add((Component)p, "Center");
        this.pack();
        Dimension psize = this.getPreferredSize();
        psize.width = Math.max(psize.width, 200);
        this.setSize(psize);
    }

    class InterfaceChecker
    extends Thread {
        private final ServerInfo server;
        private final Interface ifc;
        private final int tableRow;

        InterfaceChecker(ServerInfo server, Interface ifc, int tableRow) {
            this.server = server;
            this.ifc = ifc;
            this.tableRow = tableRow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                GenericRequest req = new GenericRequest(Util.encodeString("0.SITE/status"), 2, null);
                long startTime = System.currentTimeMillis();
                try {
                    AbstractResponse resp = SiteTester.this.resolver.sendRequestToInterface(req, this.server, this.ifc);
                    long finishTime = System.currentTimeMillis();
                    if (resp.responseCode == 1) {
                        SiteTester.this.statusModel.setValueAt(SiteTester.this.ui.getStr("ifc_test_success") + " " + (finishTime - startTime) + " ms", this.tableRow, 1);
                        break block5;
                    }
                    SiteTester.this.statusModel.setValueAt(SiteTester.this.ui.getStr("error") + ": " + AbstractMessage.getResponseCodeMessage(resp.responseCode) + "; time: " + (finishTime - startTime) + " ms", this.tableRow, 1);
                }
                catch (Exception e) {
                    try {
                        long finishTime = System.currentTimeMillis();
                        SiteTester.this.statusModel.setValueAt(SiteTester.this.ui.getStr("error") + ": " + e + "; time: " + (finishTime - startTime) + " ms", this.tableRow, 1);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SiteTester.this.statusModel.fireTableRowsUpdated(InterfaceChecker.this.tableRow, InterfaceChecker.this.tableRow);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

