/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.cnri.guiutil.GridC;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.AttributeInfoEditor;
import net.handle.apps.admintool.view.HDLAction;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.apps.admintool.view.ServerInfoEditor;
import net.handle.apps.admintool.view.SiteTester;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SiteInfoEditor
extends JPanel
implements ActionListener,
HandleValueEditor {
    private final AdminToolUI ui;
    protected JButton loadButton;
    protected JButton saveButton;
    protected HDLAction testAction;
    protected JTextField dataVersionField;
    protected JTextField majorProtocolField;
    protected JTextField minorProtocolField;
    protected JTextField serialNumberField;
    protected JCheckBox isPrimaryCheckbox;
    protected JCheckBox multiplePrimaryCheckbox;
    protected JComboBox<String> hashOptionChoice;
    protected DefaultListModel<ServerInfo> serverListModel;
    protected JList<ServerInfo> serverList;
    protected JButton addServerButton;
    protected JButton removeServerButton;
    protected JButton editServerButton;
    protected DefaultListModel<Attribute> attributeListModel;
    protected JList<Attribute> attributeList;
    protected JButton addAttributeButton;
    protected JButton removeAttributeButton;
    protected JButton editAttributeButton;
    protected JButton loadFromNAButton;

    public SiteInfoEditor(AdminToolUI ui) {
        super(new GridBagLayout());
        this.ui = ui;
        this.loadButton = new JButton("Load From File");
        this.saveButton = new JButton("Save To File");
        this.testAction = new HDLAction(ui, "run_site_test", "run_site_test", this);
        this.dataVersionField = new JTextField("", 3);
        this.majorProtocolField = new JTextField("", 3);
        this.minorProtocolField = new JTextField("", 3);
        this.serialNumberField = new JTextField("", 3);
        this.isPrimaryCheckbox = new JCheckBox(ui.getStr("is_primary_site"));
        this.multiplePrimaryCheckbox = new JCheckBox(ui.getStr("is_multiple_primary_site"));
        this.hashOptionChoice = new JComboBox();
        this.hashOptionChoice.addItem(ui.getStr("hash_by_handle"));
        this.hashOptionChoice.addItem(ui.getStr("hash_by_prefix"));
        this.hashOptionChoice.addItem(ui.getStr("hash_by_localname"));
        this.serverListModel = new DefaultListModel();
        this.serverList = new JList<ServerInfo>(this.serverListModel);
        this.serverList.setSelectionMode(0);
        this.addServerButton = new JButton(ui.getStr("add"));
        this.removeServerButton = new JButton(ui.getStr("remove"));
        this.editServerButton = new JButton(ui.getStr("modify"));
        this.attributeListModel = new DefaultListModel();
        this.attributeList = new JList<Attribute>(this.attributeListModel);
        this.attributeList.setSelectionMode(0);
        this.addAttributeButton = new JButton(ui.getStr("add"));
        this.removeAttributeButton = new JButton(ui.getStr("remove"));
        this.editAttributeButton = new JButton(ui.getStr("modify"));
        this.loadFromNAButton = new JButton(ui.getStr("load_from_prefix"));
        int y = 0;
        JPanel fileP = new JPanel(new GridBagLayout());
        fileP.add((Component)new JButton(this.testAction), GridC.getc(0, 0).wx(1.0f).insets(5, 5, 5, 20).west());
        fileP.add((Component)this.loadButton, GridC.getc(1, 0).wx(0.0f).insets(5, 5, 5, 5));
        fileP.add((Component)this.saveButton, GridC.getc(2, 0).wx(0.0f).insets(5, 5, 5, 5));
        this.add((Component)fileP, GridC.getc(0, y++).colspan(4).wx(1.0f).fillboth());
        this.add((Component)new JLabel(ui.getStr("protocol_version") + ": ", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, true));
        this.add((Component)this.majorProtocolField, AwtUtil.getConstraints(1, y, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 1), true, true));
        this.add((Component)new JLabel("."), AwtUtil.getConstraints(2, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.minorProtocolField, AwtUtil.getConstraints(3, y++, 1.0, 0.0, 1, 1, new Insets(5, 1, 5, 5), true, true));
        this.add((Component)new JLabel(ui.getStr("site_serial_number") + ": ", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, true));
        this.add((Component)this.serialNumberField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 3, 1, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)new JLabel(ui.getStr("hash_alg") + ": ", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, true));
        this.add(this.hashOptionChoice, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 3, 1, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)this.isPrimaryCheckbox, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 3, 1, new Insets(5, 5, 5, 5), true, false));
        this.add((Component)this.multiplePrimaryCheckbox, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 3, 1, new Insets(5, 5, 5, 5), true, false));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(ui.getStr("servers") + ":"), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 2, 1, new Insets(5, 5, 5, 5), true, false));
        p.add((Component)new JScrollPane(this.serverList), AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 4, new Insets(0, 5, 5, 5), true, true));
        p.add((Component)this.addServerButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, new Insets(0, 5, 5, 5), true, true));
        p.add((Component)this.editServerButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p.add((Component)this.removeServerButton, AwtUtil.getConstraints(1, 3, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p.add(Box.createVerticalStrut(0), AwtUtil.getConstraints(1, 4, 0.0, 1.0, 1, 1, true, true));
        this.add((Component)p, AwtUtil.getConstraints(0, y++, 1.0, 1.0, 4, 1, true, false));
        p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(ui.getStr("attributes") + ":"), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 2, 1, new Insets(5, 5, 5, 5), true, false));
        p.add((Component)new JScrollPane(this.attributeList), AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 4, new Insets(0, 5, 5, 5), true, true));
        p.add((Component)this.addAttributeButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, new Insets(0, 5, 5, 5), true, true));
        p.add((Component)this.editAttributeButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p.add((Component)this.removeAttributeButton, AwtUtil.getConstraints(1, 3, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p.add(Box.createVerticalStrut(0), AwtUtil.getConstraints(1, 4, 0.0, 1.0, 1, 1, true, true));
        this.add((Component)p, AwtUtil.getConstraints(0, y++, 1.0, 1.0, 4, 1, true, false));
        this.serverList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SiteInfoEditor.this.editServer();
                }
            }
        });
        this.attributeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SiteInfoEditor.this.editAttributeButton.isEnabled()) {
                    SiteInfoEditor.this.editAttribute();
                }
            }
        });
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.addServerButton.addActionListener(this);
        this.removeServerButton.addActionListener(this);
        this.editServerButton.addActionListener(this);
        this.addAttributeButton.addActionListener(this);
        this.removeAttributeButton.addActionListener(this);
        this.editAttributeButton.addActionListener(this);
        this.loadFromNAButton.addActionListener(this);
    }

    private void editServer() {
        ServerInfo info = this.serverList.getSelectedValue();
        ServerInfoEditor sie = new ServerInfoEditor(this.ui);
        sie.loadServerInfo(info);
        if (!this.editServerButton.isEnabled()) {
            sie.setComponentEnabled(false);
        }
        while (JOptionPane.showConfirmDialog(this, sie, this.ui.getStr("server_information"), 2) != 2) {
            if (!sie.saveServerInfo(info)) continue;
            this.serverList.repaint();
            break;
        }
    }

    private void editAttribute() {
        Attribute info = this.attributeList.getSelectedValue();
        AttributeInfoEditor aie = new AttributeInfoEditor(this.ui);
        aie.loadAttribute(info);
        if (JOptionPane.showConfirmDialog(this, aie, this.ui.getStr("edit_attribute"), 2) == 2) {
            return;
        }
        aie.saveAttribute(info);
        this.attributeList.repaint();
    }

    @Override
    public boolean saveValueData(HandleValue value) {
        int i;
        SiteInfo siteinfo = new SiteInfo();
        siteinfo.dataFormatVersion = 1;
        try {
            siteinfo.serialNumber = Integer.parseInt(this.serialNumberField.getText().trim());
        }
        catch (Exception e) {
            this.showError(this.ui.getStr("invalid_serial_num") + ": " + this.serialNumberField.getText());
            return false;
        }
        try {
            siteinfo.majorProtocolVersion = Byte.parseByte(this.majorProtocolField.getText().trim());
        }
        catch (Exception e) {
            this.showError(this.ui.getStr("invalid_proto_version") + ": " + this.majorProtocolField.getText());
            return false;
        }
        try {
            siteinfo.minorProtocolVersion = Byte.parseByte(this.minorProtocolField.getText().trim());
        }
        catch (Exception e) {
            this.showError(this.ui.getStr("invalid_proto_version") + ": " + this.minorProtocolField.getText());
            return false;
        }
        siteinfo.isPrimary = this.isPrimaryCheckbox.isSelected();
        siteinfo.multiPrimary = this.multiplePrimaryCheckbox.isSelected();
        siteinfo.isRoot = false;
        switch (this.hashOptionChoice.getSelectedIndex()) {
            case 1: {
                siteinfo.hashOption = 0;
                break;
            }
            case 2: {
                siteinfo.hashOption = 1;
                break;
            }
            default: {
                siteinfo.hashOption = (byte)2;
            }
        }
        siteinfo.servers = new ServerInfo[this.serverListModel.getSize()];
        for (i = 0; i < siteinfo.servers.length; ++i) {
            siteinfo.servers[i] = this.serverListModel.getElementAt(i);
        }
        siteinfo.attributes = new Attribute[this.attributeListModel.getSize()];
        for (i = 0; i < siteinfo.attributes.length; ++i) {
            siteinfo.attributes[i] = this.attributeListModel.getElementAt(i);
        }
        value.setData(Encoder.encodeSiteInfoRecord(siteinfo));
        return true;
    }

    @Override
    public void loadValueData(HandleValue value) {
        int i;
        SiteInfo siteinfo = new SiteInfo();
        try {
            byte[] data = value.getData();
            if (Util.looksLikeBinary(data)) {
                Encoder.decodeSiteInfoRecord(data, 0, siteinfo);
            } else {
                SiteInfo converted = SiteInfoConverter.convertToSiteInfo(new String(data, "UTF-8"));
                if (converted != null) {
                    siteinfo = converted;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unable to extract value reference list from " + value);
        }
        this.dataVersionField.setText(String.valueOf(siteinfo.dataFormatVersion));
        this.serialNumberField.setText(String.valueOf(siteinfo.serialNumber));
        this.majorProtocolField.setText(String.valueOf(siteinfo.majorProtocolVersion));
        this.minorProtocolField.setText(String.valueOf(siteinfo.minorProtocolVersion));
        this.isPrimaryCheckbox.setSelected(siteinfo.isPrimary);
        this.multiplePrimaryCheckbox.setSelected(siteinfo.multiPrimary);
        switch (siteinfo.hashOption) {
            case 0: {
                this.hashOptionChoice.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.hashOptionChoice.setSelectedIndex(2);
                break;
            }
            default: {
                this.hashOptionChoice.setSelectedIndex(0);
            }
        }
        this.serverListModel.removeAllElements();
        for (i = 0; siteinfo.servers != null && i < siteinfo.servers.length; ++i) {
            this.serverListModel.addElement(siteinfo.servers[i].cloneServerInfo());
        }
        this.attributeListModel.removeAllElements();
        for (i = 0; siteinfo.attributes != null && i < siteinfo.attributes.length; ++i) {
            this.attributeListModel.addElement(siteinfo.attributes[i].cloneAttribute());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Load", 0);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try (FileInputStream fin = new FileInputStream(new File(dirName, fileName));){
                int r;
                while ((r = fin.read(buf)) >= 0) {
                    bout.write(buf, 0, r);
                }
            }
            buf = bout.toByteArray();
            HandleValue value = new HandleValue();
            value.setData(buf);
            this.loadValueData(value);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: loading file: " + e);
        }
    }

    private void saveToFile() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Save", 1);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        HandleValue value = new HandleValue();
        if (!this.saveValueData(value)) {
            return;
        }
        try {
            FileOutputStream fout = new FileOutputStream(new File(dirName, fileName));
            fout.write(value.getData());
            fout.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: saving file: " + e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (this.testAction.matchesCommand(evt)) {
            HandleValue siteValue = new HandleValue();
            if (!this.saveValueData(siteValue)) {
                return;
            }
            try {
                Window parent = SwingUtilities.getWindowAncestor(this);
                SiteTester tester = parent == null || parent instanceof Frame ? new SiteTester((Frame)parent, this.ui, siteValue) : new SiteTester((Dialog)parent, this.ui, siteValue);
                tester.setLocationRelativeTo(this);
                tester.setVisible(true);
            }
            catch (Exception e) {
                this.showError("Error parsing site information: " + e);
                e.printStackTrace(System.err);
                return;
            }
        } else if (src == this.addServerButton) {
            ServerInfo info;
            ServerInfoEditor sie = new ServerInfoEditor(this.ui);
            do {
                if (JOptionPane.showConfirmDialog(this, sie, this.ui.getStr("server_information"), 2) != 2) continue;
                return;
            } while (!sie.saveServerInfo(info = new ServerInfo()));
            this.serverListModel.addElement(info);
        } else if (src == this.removeServerButton) {
            int row = this.serverList.getSelectedIndex();
            if (row < 0) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, this.ui.getStr("confirm_rem_server"), this.ui.getStr("confirm"), 0) == 0) {
                this.serverListModel.remove(row);
            }
        } else if (src == this.editServerButton) {
            this.editServer();
        } else if (src == this.addAttributeButton) {
            AttributeInfoEditor aie = new AttributeInfoEditor(this.ui);
            Attribute info = new Attribute();
            if (JOptionPane.showConfirmDialog(this, aie, this.ui.getStr("edit_attribute"), 2) == 2) {
                return;
            }
            aie.saveAttribute(info);
            this.attributeListModel.addElement(info);
        } else if (src == this.removeAttributeButton) {
            int row = this.attributeList.getSelectedIndex();
            if (row < 0) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, this.ui.getStr("confirm_rem_attribute"), this.ui.getStr("confirm"), 0) == 0) {
                this.attributeListModel.remove(row);
            }
        } else if (src == this.editAttributeButton) {
            this.editAttribute();
        } else if (src != this.loadFromNAButton) {
            if (src == this.loadButton) {
                this.loadFromFile();
            } else if (src == this.saveButton) {
                this.saveToFile();
            }
        }
    }

    private void showError(String errorMessage) {
        JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
    }
}

