/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import net.handle.apps.admintool.view.RemoteSignerInfo;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleSigner;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.TrustException;

public class SignerInfo {
    private final RemoteSignerInfo remoteSignerInfo;
    private final PublicKeyAuthenticationInfo localSignerInfo;

    public SignerInfo(RemoteSignerInfo remoteSignerInfo) {
        this.remoteSignerInfo = remoteSignerInfo;
        this.localSignerInfo = null;
    }

    public SignerInfo(PublicKeyAuthenticationInfo localSignerInfo) {
        this.remoteSignerInfo = null;
        this.localSignerInfo = localSignerInfo;
    }

    public RemoteSignerInfo getRemoteSignerInfo() {
        return this.remoteSignerInfo;
    }

    public PublicKeyAuthenticationInfo getLocalSignerInfo() {
        return this.localSignerInfo;
    }

    public boolean isRemoteSigner() {
        return this.remoteSignerInfo != null;
    }

    public boolean isLocalSigner() {
        return this.localSignerInfo != null;
    }

    public ValueReference getUserValueReference() {
        if (this.isLocalSigner()) {
            return this.localSignerInfo.getUserValueReference();
        }
        return ValueReference.fromString(this.remoteSignerInfo.issuer);
    }

    public JsonWebSignature signClaimsSet(HandleClaimsSet claims) throws TrustException {
        JsonWebSignature jws;
        HandleSigner handleSigner = new HandleSigner();
        if (this.isLocalSigner()) {
            jws = handleSigner.signClaims(claims, this.getLocalSignerInfo().getPrivateKey());
        } else {
            RemoteSignerInfo remoteSignerInfo = this.getRemoteSignerInfo();
            String baseUri = remoteSignerInfo.baseUri;
            String username = remoteSignerInfo.username;
            String password = remoteSignerInfo.password;
            String privateKeyId = remoteSignerInfo.privateKeyId;
            String privateKeyPassphrase = remoteSignerInfo.privateKeyPassphrase;
            jws = handleSigner.signClaimsRemotely(claims, baseUri, username, password, privateKeyId, privateKeyPassphrase);
        }
        return jws;
    }
}

