/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import net.cnri.guiutil.GridC;
import net.cnri.util.StreamUtil;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.EditValueWindow;
import net.handle.apps.admintool.view.HDLAction;
import net.handle.apps.admintool.view.HandleValueRenderer;
import net.handle.apps.admintool.view.MainWindow;
import net.handle.apps.admintool.view.SignerInfo;
import net.handle.apps.admintool.view.SiteTester;
import net.handle.apps.admintool.view.ViewConstants;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleSignature;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleSigner;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.TrustException;

public class ShowValuesWindow
extends JFrame
implements ActionListener,
MouseListener,
ViewConstants {
    private int mode = 3;
    private String handle = null;
    private final DefaultListModel<HandleValue> valuesListModel;
    private final JList<HandleValue> valuesList;
    private final AdminToolUI ui;
    private final HDLAction saveValuesJsonAction;
    private final HDLAction saveValuesBinaryAction;
    private final HDLAction saveValueAction;
    private final HDLAction editHandleAction;
    private final HDLAction signHandleAction;
    private final HDLAction viewValueAction;
    private final HDLAction editValueAction;
    private final HDLAction testSiteAction;
    private final JPanel modValPanel;
    private final JButton copyButton;
    private final JButton doneButton;
    private final JButton cancelButton;
    private final JButton editValButton;
    private final JButton addValButton;
    private final JButton delValButton;
    private final JButton editHdlButton;
    private final JButton replaceButton;
    private final JPopupMenu addValPopup;
    private final JButton saveToFileButton;
    private final JButton loadFromFileButton;
    boolean overwriteWhenExists = false;

    public ShowValuesWindow(AdminToolUI appUI) {
        super("Show Handle Values");
        this.ui = appUI;
        this.setJMenuBar(appUI.getAppMenu());
        this.addValPopup = new JPopupMenu();
        this.addValPopup.add(new HDLAction(this.ui, "add_url_val", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addValueWithParams(1, Common.STD_TYPE_URL, Util.encodeString("http://example.com/"));
            }
        }));
        this.addValPopup.add(new HDLAction(this.ui, "add_email_val", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addValueWithParams(1, Common.STD_TYPE_EMAIL, Util.encodeString("you@example.com"));
            }
        }));
        this.addValPopup.add(new HDLAction(this.ui, "add_admin_val", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HandleValue adminValue = ShowValuesWindow.this.ui.getMainWindow().getDefaultAdminRecord(ShowValuesWindow.this.handle);
                adminValue.setIndex(ShowValuesWindow.this.getNextUnusedIndex(adminValue.getIndex()));
                ShowValuesWindow.this.addValue(adminValue);
            }
        }));
        this.addValPopup.add(new HDLAction(this.ui, "add_blank_val", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addValueWithParams(1, new byte[0], Util.encodeString(""));
            }
        }));
        this.addValPopup.addSeparator();
        this.addValPopup.add(new HDLAction(this.ui, "add_digest_and_sig_all", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addDigestAndSignatureForAllValues();
            }
        }));
        this.addValPopup.add(new HDLAction(this.ui, "add_jose_signature_selected", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addJoseSignatureOfSelectedValues();
            }
        }));
        this.addValPopup.add(new HDLAction(this.ui, "add_jose_signature_all", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addJoseSignatureOfAllValues();
            }
        }));
        this.addValPopup.add(new HDLAction(this.ui, "add_cert", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowValuesWindow.this.addCert();
            }
        }));
        this.addValPopup.pack();
        this.valuesListModel = new DefaultListModel();
        this.valuesList = new JList<HandleValue>(this.valuesListModel);
        this.valuesList.setSelectionMode(2);
        this.valuesList.setCellRenderer(new HandleValueRenderer());
        this.doneButton = new JButton(this.ui.getStr("ok"));
        this.cancelButton = new JButton(this.ui.getStr("cancel"));
        this.editValButton = new JButton(this.ui.getStr("edit_val_button"));
        this.addValButton = new JButton(this.ui.getStr("add_val_button"));
        this.delValButton = new JButton(this.ui.getStr("remove_val_button"));
        this.editHdlButton = new JButton(this.ui.getStr("edit_hdl_button"));
        this.replaceButton = new JButton("Replace Mode");
        this.copyButton = new JButton(this.ui.getStr("copy_hdl_button"));
        this.saveToFileButton = new JButton("Save to file");
        this.loadFromFileButton = new JButton("Load from file");
        this.saveValuesJsonAction = new HDLAction(this.ui, "save_values_json", "save_values_json", this);
        this.saveValuesBinaryAction = new HDLAction(this.ui, "save_values_binary", "save_values_binary", this);
        this.saveValueAction = new HDLAction(this.ui, "save_value", "save_value", this);
        this.editHandleAction = new HDLAction(this.ui, "edit_handle", "edit_handle", this);
        this.viewValueAction = new HDLAction(this.ui, "view_value", "view_value", this);
        this.editValueAction = new HDLAction(this.ui, "edit_value", "edit_value", this);
        this.testSiteAction = new HDLAction(this.ui, "run_site_test", "run_site_test", this);
        this.signHandleAction = new HDLAction(this.ui, "sign_handle", "sign_handle", this);
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JScrollPane(this.valuesList), GridC.getc(0, 0).wxy(1.0f, 1.0f).colspan(3).fillboth());
        this.modValPanel = new JPanel(new GridBagLayout());
        this.modValPanel.add((Component)this.addValButton, GridC.getc(0, 0).insets(0, 0, 0, 10));
        this.modValPanel.add((Component)this.editValButton, GridC.getc(1, 0).insets(0, 0, 0, 10));
        this.modValPanel.add((Component)this.delValButton, GridC.getc(2, 0).insets(0, 0, 0, 10));
        this.modValPanel.add((Component)new JButton(this.signHandleAction), GridC.getc(3, 0).insets(0, 0, 0, 10));
        p.add((Component)this.modValPanel, GridC.getc(0, 1).insets(10, 10, 2, 10).fillboth());
        p.add((Component)this.editHdlButton, GridC.getc(0, 1).insets(10, 10, 2, 10).west());
        p.add(Box.createHorizontalStrut(200), GridC.getc(1, 1).wx(1.0f).fillx().insets(5, 5, 0, 5));
        p.add((Component)this.copyButton, GridC.getc(2, 1).insets(10, 5, 2, 10).east());
        JPanel bottomLineLeft = new JPanel(new GridBagLayout());
        bottomLineLeft.add((Component)this.cancelButton, GridC.getc(1, 0).insets(0, 0, 0, 10));
        bottomLineLeft.add((Component)this.doneButton, GridC.getc(2, 0).insets(0, 0, 0, 10));
        JPanel bottomLineRight = new JPanel(new GridBagLayout());
        bottomLineRight.add((Component)this.replaceButton, GridC.getc(0, 0).insets(0, 0, 0, 10).west());
        bottomLineRight.add((Component)this.loadFromFileButton, GridC.getc(1, 0).insets(0, 0, 0, 10).west());
        bottomLineRight.add((Component)this.saveToFileButton, GridC.getc(2, 0).insets(0, 0, 0, 0).west());
        p.add((Component)bottomLineRight, GridC.getc(0, 2).insets(2, 10, 10, 0).west());
        p.add((Component)bottomLineLeft, GridC.getc(1, 2).insets(2, 10, 10, 0).colspan(2).east());
        this.getContentPane().add(p);
        this.cancelButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.editValButton.addActionListener(this);
        this.addValButton.addActionListener(this);
        this.delValButton.addActionListener(this);
        this.editHdlButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.saveToFileButton.addActionListener(this);
        this.loadFromFileButton.addActionListener(this);
        this.replaceButton.addActionListener(this);
        this.valuesList.addMouseListener(this);
        this.getRootPane().setDefaultButton(this.doneButton);
        this.setSize(700, 330);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt);
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt);
        } else if (evt.getClickCount() >= 2) {
            if (this.mode == 2 || this.mode == 1) {
                this.editValue();
            } else {
                this.viewSelectedValue();
            }
        }
    }

    private boolean performOperation(String opName, AbstractRequest req) {
        AuthenticationInfo auth = this.ui.getAuthentication(false);
        if (auth == null) {
            return false;
        }
        req.authInfo = auth;
        try {
            AbstractResponse resp;
            SiteInfo site = this.ui.getSpecificSite();
            if (this.ui.getSpecificSiteDoNotRefer()) {
                req.doNotRefer = true;
            }
            if ((resp = site == null ? this.ui.getMain().getResolver().processRequest(req) : this.ui.getMain().getResolver().sendRequestToSite(req, site)) == null || resp.responseCode != 1) {
                JOptionPane.showMessageDialog(this, "The '" + opName + "' operation was not successful.  Response was: " + resp);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "There was an error processing the '" + opName + "' operation.\n\nMessage: " + e);
            return false;
        }
    }

    private void deleteValue() {
        block4: {
            List<HandleValue> selObjs;
            block5: {
                int i;
                selObjs = this.valuesList.getSelectedValuesList();
                if (selObjs == null || selObjs.isEmpty()) {
                    return;
                }
                if (0 != JOptionPane.showConfirmDialog(this, "Are you sure you would like to delete the selected values?", "Delete Confirmation", 0, 3)) break block4;
                if (this.mode != 2) break block5;
                int[] idxList = new int[selObjs.size()];
                for (i = 0; i < idxList.length; ++i) {
                    idxList[i] = selObjs.get(i).getIndex();
                }
                if (!this.performOperation("remove value", new RemoveValueRequest(Util.encodeString(this.handle), idxList, null))) break block4;
                for (i = 0; i < selObjs.size(); ++i) {
                    this.valuesListModel.removeElement(selObjs.get(i));
                }
                break block4;
            }
            for (int i = 0; i < selObjs.size(); ++i) {
                this.valuesListModel.removeElement(selObjs.get(i));
            }
        }
    }

    private void viewSelectedValue() {
        int selIdx = this.valuesList.getSelectedIndex();
        if (selIdx < 0) {
            return;
        }
        HandleValue value = this.valuesListModel.getElementAt(selIdx);
        if (value == null) {
            return;
        }
        EditValueWindow editWin = new EditValueWindow(this.ui, this, this.handle, this.getValues());
        editWin.loadValueData(value.duplicate(), false);
        editWin.setMode(2);
        editWin.setVisible(true);
    }

    private void showPopupMenu(MouseEvent evt) {
        int index = this.valuesList.locationToIndex(evt.getPoint());
        HandleValue value = null;
        if (index >= 0) {
            this.valuesList.setSelectedIndex(index);
            value = this.valuesListModel.getElementAt(index);
        }
        JPopupMenu popup = new JPopupMenu();
        if (this.mode == 3) {
            if (index >= 0) {
                popup.add(this.viewValueAction);
            }
            popup.add(this.editHandleAction);
            popup.addSeparator();
        }
        if (this.mode == 2 && index >= 0) {
            popup.add(this.editValueAction);
            popup.addSeparator();
        }
        if (value != null && (value.hasType(Common.STD_TYPE_HSSITE) || value.hasType(Common.LEGACY_DERIVED_PREFIX_SITE_TYPE))) {
            popup.add(this.testSiteAction);
            popup.addSeparator();
        }
        if (index >= 0) {
            popup.add(this.saveValueAction);
        }
        popup.add(this.saveValuesJsonAction);
        popup.add(this.saveValuesBinaryAction);
        popup.pack();
        popup.show(this.valuesList, evt.getX(), evt.getY());
    }

    private void editValue() {
        final int selIdx = this.valuesList.getSelectedIndex();
        if (selIdx < 0 || this.valuesList.getSelectedIndices().length > 1) {
            return;
        }
        HandleValue originalValue = this.valuesListModel.getElementAt(selIdx);
        if (originalValue == null) {
            return;
        }
        final HandleValue valueToEdit = originalValue.duplicate();
        EditValueWindow editWin = new EditValueWindow(this.ui, this, this.handle, this.getValues());
        editWin.loadValueData(valueToEdit, false);
        AwtUtil.setWindowPosition((Window)editWin, this);
        final String handle = this.handle;
        editWin.setSaveCallback(new Runnable(){

            @Override
            public void run() {
                if (ShowValuesWindow.this.mode == 2) {
                    if (ShowValuesWindow.this.performOperation("edit value", new ModifyValueRequest(Util.encodeString(handle), valueToEdit, null))) {
                        ShowValuesWindow.this.valuesListModel.setElementAt(valueToEdit, selIdx);
                        ShowValuesWindow.this.valuesList.repaint();
                    }
                } else {
                    ShowValuesWindow.this.valuesListModel.setElementAt(valueToEdit, selIdx);
                    ShowValuesWindow.this.valuesList.repaint();
                }
            }
        });
        editWin.setVisible(true);
    }

    private void saveValuesBinary() {
        Object[] valueObjects = this.valuesListModel.toArray();
        if (valueObjects == null || valueObjects.length <= 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        FileDialog fwin = new FileDialog((Frame)this, this.ui.getStr("choose_values_file_to_save"), 1);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            HandleValue[] values = new HandleValue[valueObjects.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (HandleValue)valueObjects[i];
            }
            byte[] buffer = Encoder.encodeGlobalValues(values);
            try (FileOutputStream fout = new FileOutputStream(new File(dirName, fileName));){
                fout.write(buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this.ui.getStr("error_saving_values") + "\n\n" + e, this.ui.getStr("error_title"), 0);
        }
    }

    private void saveSelectedValue() {
        int selectedIdx = this.valuesList.getSelectedIndex();
        if (selectedIdx < 0 || this.valuesList.getSelectedIndices().length > 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        HandleValue val = this.valuesListModel.getElementAt(selectedIdx);
        if (val == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        FileDialog fwin = new FileDialog((Frame)this, this.ui.getStr("choose_value_file_to_save"), 1);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try (FileOutputStream fout = new FileOutputStream(new File(dirName, fileName));){
            fout.write(val.getData());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this.ui.getStr("error_saving_value") + "\n\n" + e, this.ui.getStr("error_title"), 0);
        }
    }

    public int getNextUnusedIndex(int firstIdx) {
        int nextIdx = firstIdx - 1;
        boolean duplicate = true;
        block0: while (duplicate) {
            ++nextIdx;
            duplicate = false;
            for (int i = this.valuesListModel.getSize() - 1; i >= 0; --i) {
                HandleValue val = this.valuesListModel.getElementAt(i);
                if (val == null || val.getIndex() != nextIdx) continue;
                duplicate = true;
                continue block0;
            }
        }
        return nextIdx;
    }

    private void addValue(final HandleValue newValue) {
        EditValueWindow editWin = new EditValueWindow(this.ui, this, this.handle, this.getValues());
        editWin.setTitle("Add Handle Value");
        editWin.setMode(3);
        editWin.loadValueData(newValue, true);
        AwtUtil.setWindowPosition((Window)editWin, this);
        final String handle = this.handle;
        editWin.setSaveCallback(new Runnable(){

            @Override
            public void run() {
                if (ShowValuesWindow.this.mode == 2) {
                    if (ShowValuesWindow.this.performOperation("add value", new AddValueRequest(Util.encodeString(handle), newValue, null))) {
                        ShowValuesWindow.this.valuesListModel.addElement(newValue);
                    }
                } else {
                    ShowValuesWindow.this.valuesListModel.addElement(newValue);
                }
            }
        });
        editWin.setVisible(true);
    }

    public HandleValue[] getValues() {
        HandleValue[] values = new HandleValue[this.valuesListModel.size()];
        for (int i = 0; i < this.valuesListModel.size(); ++i) {
            values[i] = this.valuesListModel.get(i);
        }
        return values;
    }

    private void replaceLegacyAdminValues() {
        if (this.valuesListModel == null) {
            return;
        }
        for (int i = 0; i < this.valuesListModel.getSize(); ++i) {
            HandleValue value = this.valuesListModel.get(i);
            if (!value.hasType(Common.ADMIN_TYPE)) continue;
            try {
                AdminRecord adminRecord = Encoder.decodeAdminRecord(value.getData(), 0);
                if (!adminRecord.legacyByteLength) continue;
                adminRecord.legacyByteLength = false;
                value.setData(Encoder.encodeAdminRecord(adminRecord));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setValues(String handle, HandleValue[] values, int mode) {
        if (values != null) {
            // empty if block
        }
        this.mode = mode;
        this.handle = handle;
        if (values != null) {
            this.valuesListModel.removeAllElements();
            for (int i = 0; i < values.length; ++i) {
                this.valuesListModel.addElement(values[i].duplicate());
            }
        }
        if (mode == 1) {
            if (this.overwriteWhenExists) {
                this.replaceLegacyAdminValues();
            }
            this.setTitle("Create Handle: " + handle);
            this.doneButton.setText(this.overwriteWhenExists ? "Replace Handle" : this.ui.getStr("create_hdl_button"));
            this.cancelButton.setVisible(true);
            this.editHdlButton.setVisible(false);
            this.replaceButton.setVisible(false);
            this.loadFromFileButton.setVisible(true);
            this.modValPanel.setVisible(true);
            this.modValPanel.setEnabled(true);
        } else if (mode == 2) {
            this.setTitle("Edit Handle: " + handle);
            this.doneButton.setText(this.ui.getStr("dismiss"));
            this.cancelButton.setVisible(false);
            this.editHdlButton.setVisible(false);
            this.replaceButton.setVisible(true);
            this.loadFromFileButton.setVisible(false);
            this.modValPanel.setVisible(true);
            this.modValPanel.setEnabled(true);
        } else if (mode == 3) {
            this.setTitle("View Handle: " + handle);
            this.doneButton.setText(this.ui.getStr("dismiss"));
            this.cancelButton.setVisible(false);
            this.editHdlButton.setVisible(true);
            this.replaceButton.setVisible(false);
            this.loadFromFileButton.setVisible(false);
            this.modValPanel.setVisible(false);
            this.modValPanel.setEnabled(false);
        } else {
            this.setTitle("????: " + handle);
            this.doneButton.setText("????");
            this.cancelButton.setVisible(true);
            this.editHdlButton.setVisible(false);
            this.modValPanel.setVisible(false);
            this.modValPanel.setEnabled(false);
        }
    }

    private void cancelButtonPressed() {
        this.setVisible(false);
    }

    private void doneButtonPressed() {
        if (this.mode == 1) {
            HandleValue[] values = new HandleValue[this.valuesListModel.getSize()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.valuesListModel.getElementAt(i);
            }
            CreateHandleRequest req = new CreateHandleRequest(Util.encodeString(this.handle), values, null);
            req.overwriteWhenExists = this.overwriteWhenExists;
            boolean success = this.performOperation(this.overwriteWhenExists ? "replace handle" : "create handle", req);
            if (success) {
                JOptionPane.showMessageDialog(this, "The handle '" + this.handle + "'  was " + (this.overwriteWhenExists ? "replaced!" : "created!"));
                this.setVisible(false);
            }
        } else if (this.mode == 2) {
            this.setVisible(false);
        } else if (this.mode == 3) {
            this.setVisible(false);
        }
    }

    private void saveToFile() {
        Object[] values = new HandleValue[this.valuesListModel.getSize()];
        this.valuesListModel.copyInto(values);
        HandleRecord record = new HandleRecord(this.handle, (HandleValue[])values);
        String json = GsonUtility.getPrettyGson().toJson((Object)record);
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Save", 1);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            FileOutputStream fout = new FileOutputStream(new File(dirName, fileName));
            fout.write(Util.encodeString(json));
            fout.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: saving file: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Load", 0);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            HandleValue[] values;
            byte[] buf;
            try (FileInputStream fin = new FileInputStream(new File(dirName, fileName));){
                buf = StreamUtil.readFully((InputStream)fin);
            }
            if (Util.looksLikeBinary(buf)) {
                values = Encoder.decodeHandleValues(buf);
            } else {
                String json = Util.decodeString(buf);
                HandleRecord record = (HandleRecord)GsonUtility.getGson().fromJson(json, HandleRecord.class);
                values = record.getValuesAsArray();
            }
            this.valuesListModel.clear();
            for (HandleValue value : values) {
                this.valuesListModel.addElement(value);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: loading file: " + e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.doneButton) {
            this.doneButtonPressed();
        } else if (src == this.cancelButton) {
            this.cancelButtonPressed();
        } else if (src == this.delValButton) {
            this.deleteValue();
        } else if (src == this.editValButton) {
            this.editValue();
        } else if (src == this.addValButton) {
            this.showAddValuePopup();
        } else if (src == this.editHdlButton || this.editHandleAction.matchesCommand(evt)) {
            String hdl = this.handle;
            if (this.ui.getMainWindow().editHandle(this, hdl)) {
                this.cancelButtonPressed();
            }
        } else if (src == this.replaceButton) {
            this.overwriteWhenExists = true;
            this.setValues(this.handle, null, 1);
        } else if (src == this.copyButton) {
            String newHdlStr = JOptionPane.showInputDialog(this, (Object)this.ui.getStr("copy_hdl_prompt"));
            if (newHdlStr == null) {
                return;
            }
            MainWindow mainWindow = this.ui.getMainWindow();
            Objects.requireNonNull(mainWindow);
            MainWindow.ActionHandler handler = mainWindow.new MainWindow.ActionHandler("create_action", newHdlStr);
            HandleValue[] newValues = new HandleValue[this.valuesListModel.getSize()];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = this.valuesListModel.getElementAt(i);
            }
            handler.setValues(newValues);
            handler.performAction();
        } else if (src == this.saveToFileButton) {
            this.saveToFile();
        } else if (src == this.loadFromFileButton) {
            this.loadFromFile();
        } else if (this.saveValuesJsonAction.matchesCommand(evt)) {
            this.saveToFile();
        } else if (this.saveValuesBinaryAction.matchesCommand(evt)) {
            this.saveValuesBinary();
        } else if (this.saveValueAction.matchesCommand(evt)) {
            this.saveSelectedValue();
        } else if (this.viewValueAction.matchesCommand(evt)) {
            this.viewSelectedValue();
        } else if (this.editValueAction.matchesCommand(evt)) {
            this.editValue();
        } else if (this.signHandleAction.matchesCommand(evt)) {
            this.addJoseSignatureOfAllValues();
        } else if (this.testSiteAction.matchesCommand(evt)) {
            List<HandleValue> selObjs = this.valuesList.getSelectedValuesList();
            for (int i = 0; selObjs != null && i < selObjs.size(); ++i) {
                try {
                    HandleValue siteValue = selObjs.get(i);
                    if (siteValue == null) continue;
                    SiteTester tester = new SiteTester((Frame)this, this.ui, siteValue);
                    tester.setLocationRelativeTo(this);
                    tester.setVisible(true);
                    continue;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error parsing site information: " + e, "Error", 0);
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private void showError(Throwable error) {
        JOptionPane.showMessageDialog(this, this.ui.getStr("error_message") + "\n\n" + error, this.ui.getStr("error_title"), 0);
        error.printStackTrace();
    }

    private void showError(String error) {
        JOptionPane.showMessageDialog(this, this.ui.getStr("error_message") + "\n\n" + error, this.ui.getStr("error_title"), 0);
    }

    private void addJoseSignatureOfSelectedValues() {
        List<HandleValue> selObjs = this.valuesList.getSelectedValuesList();
        if (selObjs == null || selObjs.isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        HandleValue[] values = selObjs.toArray(new HandleValue[0]);
        this.addJoseSignatureOfValues(values);
    }

    private void addJoseSignatureOfAllValues() {
        Object[] objVals = this.valuesListModel.toArray();
        HandleValue[] values = new HandleValue[objVals.length];
        System.arraycopy(objVals, 0, values, 0, values.length);
        this.addJoseSignatureOfValues(values);
    }

    private void addJoseSignatureOfValues(HandleValue[] values) {
        SignerInfo sigInfo = this.ui.getSignatureInfo(this, false);
        if (sigInfo == null) {
            return;
        }
        long now = System.currentTimeMillis() / 1000L - 600L;
        long oneYearInSeconds = 31622400L;
        long expiration = System.currentTimeMillis() / 1000L + oneYearInSeconds * 2L;
        HandleSigner handleSigner = new HandleSigner();
        HandleClaimsSet claims = handleSigner.createPayload(this.handle, Util.filterOnlyPublicValues(Arrays.asList(values)), sigInfo.getUserValueReference(), null, now, expiration);
        try {
            JsonWebSignature jws = sigInfo.signClaimsSet(claims);
            HandleValue signatureHandleValue = new HandleValue(this.getNextUnusedIndex(400), "HS_SIGNATURE", jws.serialize());
            this.addValue(signatureHandleValue);
        }
        catch (TrustException e) {
            this.showError(e);
        }
    }

    private void addCert() {
        SignerInfo sigInfo = this.ui.getSignatureInfo(this, false);
        if (sigInfo == null) {
            return;
        }
        ValueReference signer = sigInfo.getUserValueReference();
        long oneYearInSeconds = 31622400L;
        long expiration = System.currentTimeMillis() / 1000L + oneYearInSeconds * 2L;
        HandleClaimsSet claims = new HandleClaimsSet();
        claims.sub = "";
        claims.iss = signer != null ? signer.toString() : "";
        claims.iat = System.currentTimeMillis() / 1000L;
        claims.nbf = System.currentTimeMillis() / 1000L - 600L;
        claims.exp = expiration;
        claims.chain = null;
        claims.perms = Collections.emptyList();
        try {
            JsonWebSignature jws = sigInfo.signClaimsSet(claims);
            HandleValue signatureHandleValue = new HandleValue(this.getNextUnusedIndex(400), "HS_CERT", jws.serialize());
            this.addValue(signatureHandleValue);
        }
        catch (TrustException e) {
            this.showError(e);
        }
    }

    private void addDigestAndSignatureForAllValues() {
        try {
            SignerInfo sigInfo = this.ui.getSignatureInfo(this, false);
            if (sigInfo == null) {
                return;
            }
            if (sigInfo.isRemoteSigner()) {
                this.showError("Remote signer does not support legacy signatures.");
                return;
            }
            Object[] values = new HandleValue[this.valuesListModel.getSize()];
            this.valuesListModel.copyInto(values);
            HandleValue digestValue = HandleSignature.createDigestsValue(this.getNextUnusedIndex(400), this.handle, (HandleValue[])values);
            PublicKeyAuthenticationInfo localSigInfo = sigInfo.getLocalSignerInfo();
            ValueReference signer = new ValueReference(localSigInfo.getUserIdHandle(), localSigInfo.getUserIdIndex());
            HandleValue sigValue = HandleSignature.createSignatureValue(this.getNextUnusedIndex(digestValue.getIndex() + 1), this.handle, signer, null, localSigInfo.getPrivateKey(), digestValue);
            if (this.mode == 2) {
                if (this.performOperation("sign values", new AddValueRequest(Util.encodeString(this.handle), new HandleValue[]{digestValue, sigValue}, null))) {
                    this.valuesListModel.addElement(digestValue);
                    this.valuesListModel.addElement(sigValue);
                }
            } else {
                this.valuesListModel.addElement(digestValue);
                this.valuesListModel.addElement(sigValue);
            }
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    private void addValueWithParams(int idx, byte[] valType, byte[] valData) {
        HandleValue newValue = new HandleValue();
        newValue.setType(valType);
        newValue.setData(valData);
        newValue.setIndex(this.getNextUnusedIndex(idx));
        this.addValue(newValue);
    }

    private synchronized void showAddValuePopup() {
        this.addValPopup.show(this.addValButton, 0, 0 - this.addValPopup.getPreferredSize().height);
    }
}

