/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.Util;

public class ServerInfoEditor
extends JPanel
implements ActionListener {
    private final AdminToolUI ui;
    private final JTextField serverAddressField;
    private final JTextField serverIDField;
    private final JTextArea pubKeyField;
    private final JTable ifTable;
    private final InterfaceTableModel ifTableModel;
    private final JButton addIFButton;
    private final JButton removeIFButton;
    private final String capAdminStr;
    private final String capQueryStr;
    private final String capAdminQueryStr;
    private final String capOutOfServiceStr;
    private final String protoUDPStr;
    private final String protoTCPStr;
    private final String protoHTTPStr;
    private final String protoHTTPSStr;

    public ServerInfoEditor(AdminToolUI ui) {
        super(new GridBagLayout());
        this.ui = ui;
        this.serverAddressField = new JTextField("", 25);
        this.serverIDField = new JTextField("", 5);
        this.pubKeyField = new JTextArea(4, 25);
        this.ifTableModel = new InterfaceTableModel();
        this.ifTable = new JTable(this.ifTableModel);
        this.ifTable.setSelectionMode(0);
        this.ifTable.createDefaultColumnsFromModel();
        this.addIFButton = new JButton(ui.getStr("add"));
        this.removeIFButton = new JButton(ui.getStr("remove"));
        this.capAdminStr = ui.getStr("ifc_admin");
        this.capQueryStr = ui.getStr("ifc_query");
        this.capAdminQueryStr = ui.getStr("ifc_query_admin");
        this.capOutOfServiceStr = ui.getStr("ifc_none");
        this.protoUDPStr = ui.getStr("proto_udp");
        this.protoTCPStr = ui.getStr("proto_tcp");
        this.protoHTTPStr = ui.getStr("proto_http");
        this.protoHTTPSStr = ui.getStr("proto_https");
        this.ifTable.setDefaultEditor(String.class, new DefaultCellEditor(new JComboBox<String>(new String[]{this.protoUDPStr, this.protoTCPStr, this.protoHTTPStr, this.protoHTTPSStr})));
        int y = 0;
        this.add((Component)new JLabel(ui.getStr("server_address") + ":", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, false));
        this.add((Component)this.serverAddressField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        this.add((Component)new JLabel(ui.getStr("server_id"), 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, false));
        this.add((Component)this.serverIDField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        this.add((Component)new JLabel(ui.getStr("public_key"), 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, false));
        this.add((Component)new JScrollPane(this.pubKeyField), AwtUtil.getConstraints(1, y++, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)new JLabel(ui.getStr("server_interfaces"), 2), AwtUtil.getConstraints(0, y++, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 0), true, false));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JScrollPane(this.ifTable), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 4, true, true));
        p.add((Component)this.addIFButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(0, 5, 5, 0), true, false));
        p.add((Component)this.removeIFButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 1, 1, new Insets(0, 5, 5, 0), true, false));
        this.add((Component)p, AwtUtil.getConstraints(0, y++, 1.0, 1.0, 2, 1, new Insets(5, 5, 5, 5), true, true));
        this.addIFButton.addActionListener(this);
        this.removeIFButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.addIFButton) {
            this.ifTableModel.addInterface();
        } else if (src == this.removeIFButton) {
            int row = this.ifTable.getSelectedRow();
            this.ifTableModel.removeInterface(row);
        }
    }

    public void loadServerInfo(ServerInfo info) {
        if (info == null) {
            info = new ServerInfo();
        }
        this.ifTableModel.setInterfaces(info.interfaces);
        this.pubKeyField.setText(info.publicKey == null ? "" : Util.decodeHexString(info.publicKey, true));
        this.serverAddressField.setText(info.getAddressString());
        this.serverIDField.setText(String.valueOf(info.serverId));
    }

    public boolean saveServerInfo(ServerInfo info) {
        int serverID;
        TableCellEditor tc;
        if (info == null) {
            return false;
        }
        if (this.ifTable.isEditing() && (tc = this.ifTable.getCellEditor(this.ifTable.getEditingRow(), this.ifTable.getEditingColumn())) != null) {
            tc.stopCellEditing();
        }
        try {
            serverID = Integer.parseInt(this.serverIDField.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, this.ui.getStr("error") + ": " + e, this.ui.getStr("error"), 0);
            return false;
        }
        byte[] ipAddress = null;
        try {
            InetAddress addr = InetAddress.getByName(this.serverAddressField.getText());
            byte[] addr1 = addr.getAddress();
            ipAddress = new byte[16];
            for (int i = 0; i < 16; ++i) {
                ipAddress[i] = 0;
            }
            System.arraycopy(addr1, 0, ipAddress, ipAddress.length - addr1.length, addr1.length);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, this.ui.getStr("error") + ": " + e, this.ui.getStr("error"), 0);
            return false;
        }
        info.ipAddress = ipAddress;
        info.interfaces = this.ifTableModel.getInterfaces();
        info.publicKey = Util.encodeHexString(this.pubKeyField.getText());
        info.serverId = serverID;
        return true;
    }

    public void setComponentEnabled(boolean enabled) {
        this.setComponentEnabled(enabled, this);
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        if (component instanceof JTextField || component instanceof JComboBox || component instanceof JCheckBox || component instanceof JButton || component instanceof JTextArea || component instanceof JTable) {
            Color color;
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(enabled);
                color = component.getForeground();
                ((JTextComponent)component).setDisabledTextColor(color);
            } else if (component instanceof JComboBox && ((JComboBox)component).isEditable()) {
                component.setEnabled(enabled);
                color = component.getForeground();
                try {
                    ((JTextField)((JComboBox)component).getEditor().getEditorComponent()).setDisabledTextColor(color);
                }
                catch (Exception exception) {}
            } else {
                component.setEnabled(enabled);
            }
        }
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component heldComponent : components) {
                this.setComponentEnabled(enabled, heldComponent);
            }
        }
    }

    private class InterfaceTableModel
    extends AbstractTableModel {
        private final DefaultCellEditor capabilityEditor;
        private final DefaultCellEditor protocolEditor;
        private final DefaultCellEditor portEditor;
        private final ArrayList<Interface> ifcs = new ArrayList();

        InterfaceTableModel() {
            this.capabilityEditor = new DefaultCellEditor(new JComboBox<String>(new String[]{ServerInfoEditor.this.capAdminQueryStr, ServerInfoEditor.this.capQueryStr, ServerInfoEditor.this.capAdminStr, ServerInfoEditor.this.capOutOfServiceStr}));
            this.protocolEditor = new DefaultCellEditor(new JComboBox<String>(new String[]{ServerInfoEditor.this.protoUDPStr, ServerInfoEditor.this.protoTCPStr, ServerInfoEditor.this.protoHTTPStr, ServerInfoEditor.this.protoHTTPSStr}));
            this.portEditor = new DefaultCellEditor(new JTextField("", 5));
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ServerInfoEditor.this.ui.getStr("ifc_admin");
                }
                case 1: {
                    return ServerInfoEditor.this.ui.getStr("ifc_query");
                }
                case 2: {
                    return ServerInfoEditor.this.ui.getStr("protocol");
                }
                case 3: {
                    return ServerInfoEditor.this.ui.getStr("port");
                }
            }
            return "?";
        }

        public synchronized void addInterface() {
            this.ifcs.add(new Interface());
            this.fireTableRowsInserted(this.ifcs.size(), this.ifcs.size());
        }

        public synchronized void removeInterface(int row) {
            if (row < 0 || row >= this.ifcs.size()) {
                return;
            }
            this.ifcs.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public synchronized void setInterfaces(Interface[] newIfcs) {
            this.ifcs.clear();
            for (int i = 0; newIfcs != null && i < newIfcs.length; ++i) {
                if (newIfcs[i] == null) continue;
                this.ifcs.add(newIfcs[i].cloneInterface());
            }
        }

        public synchronized Interface[] getInterfaces() {
            Interface[] ifcA = new Interface[this.ifcs.size()];
            for (int i = 0; i < ifcA.length; ++i) {
                ifcA[i] = this.ifcs.get(i).cloneInterface();
            }
            return ifcA;
        }

        @Override
        public int getRowCount() {
            return this.ifcs.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.ifcs.size()) {
                return null;
            }
            Interface ifc = this.ifcs.get(row);
            switch (column) {
                case 0: {
                    return ifc.type == 1 || ifc.type == 3;
                }
                case 1: {
                    return ifc.type == 2 || ifc.type == 3;
                }
                case 2: {
                    switch (ifc.protocol) {
                        case 0: {
                            return ServerInfoEditor.this.protoUDPStr;
                        }
                        case 1: {
                            return ServerInfoEditor.this.protoTCPStr;
                        }
                        case 3: {
                            return ServerInfoEditor.this.protoHTTPSStr;
                        }
                    }
                    return ServerInfoEditor.this.protoHTTPStr;
                }
                case 3: {
                    return ifc.port;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < 0 || row >= this.ifcs.size()) {
                return;
            }
            Interface ifc = this.ifcs.get(row);
            switch (column) {
                case 0: {
                    boolean bval = (Boolean)value;
                    switch (ifc.type) {
                        case 0: 
                        case 1: {
                            ifc.type = bval ? (byte)1 : 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            ifc.type = (byte)(bval ? 3 : 2);
                        }
                    }
                    break;
                }
                case 1: {
                    boolean bval = (Boolean)value;
                    switch (ifc.type) {
                        case 0: 
                        case 2: {
                            ifc.type = (byte)(bval ? 2 : 0);
                            break;
                        }
                        case 1: 
                        case 3: {
                            ifc.type = (byte)(bval ? 3 : 1);
                        }
                    }
                    break;
                }
                case 2: {
                    String val = String.valueOf(value);
                    if (val.equalsIgnoreCase(ServerInfoEditor.this.protoUDPStr)) {
                        ifc.protocol = 0;
                        break;
                    }
                    if (val.equalsIgnoreCase(ServerInfoEditor.this.protoTCPStr)) {
                        ifc.protocol = 1;
                        break;
                    }
                    if (val.equalsIgnoreCase(ServerInfoEditor.this.protoHTTPStr)) {
                        ifc.protocol = (byte)2;
                        break;
                    }
                    if (!val.equalsIgnoreCase(ServerInfoEditor.this.protoHTTPSStr)) break;
                    ifc.protocol = (byte)3;
                    break;
                }
                case 3: {
                    try {
                        ifc.port = Integer.parseInt(String.valueOf(value));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return Boolean.class;
                }
                case 3: {
                    return Integer.class;
                }
            }
            return String.class;
        }
    }
}

