/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class SecretKeyValueEditor
extends JPanel
implements ActionListener,
HandleValueEditor {
    private JLabel inputLabel;
    private final JTextField inputField = new JTextField();
    private final JCheckBox hashedPasswordBox = new JCheckBox("Use SHA-1 hash of password");
    private final JButton editButton = new JButton("Change Password");

    public SecretKeyValueEditor() {
        super(new GridBagLayout());
        this.inputLabel = new JLabel("Password: ", 4);
        this.add((Component)this.inputLabel, AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        this.add((Component)this.inputField, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 2, 1, new Insets(4, 4, 4, 4), true, false));
        this.add((Component)this.hashedPasswordBox, AwtUtil.getConstraints(0, 1, 0.0, 0.0, 2, 1, new Insets(4, 4, 4, 4), 17, false, false));
        this.add((Component)this.editButton, AwtUtil.getConstraints(2, 1, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), false, false));
        this.add(Box.createHorizontalStrut(40), AwtUtil.getConstraints(1, 2, 1.0, 1.0, 1, 1, false, false));
        this.editButton.addActionListener(this);
    }

    @Override
    public boolean saveValueData(HandleValue value) {
        try {
            byte[] seckey = Encoder.encodeSecretKey(Util.encodeString(this.inputField.getText()), this.hashedPasswordBox.isSelected());
            value.setData(seckey);
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error encoding secret key: " + e);
            return false;
        }
    }

    @Override
    public void loadValueData(HandleValue value) {
        this.inputField.setText(Util.decodeString(value.getData()));
        this.inputField.setEditable(false);
        this.inputField.setEnabled(false);
        this.hashedPasswordBox.setVisible(false);
        this.hashedPasswordBox.setSelected(false);
        this.editButton.setVisible(true);
        this.inputLabel.setText("Password: ");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.editButton) {
            this.inputField.setEnabled(true);
            this.inputField.setEditable(true);
            this.hashedPasswordBox.setVisible(true);
            this.hashedPasswordBox.setSelected(false);
            this.editButton.setVisible(false);
            this.inputField.setText("");
            this.inputLabel.setText("New Password: ");
        }
    }
}

