/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.cnri.guiutil.GridC;
import net.cnri.util.StreamUtil;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.HDLAction;
import net.handle.apps.admintool.view.HDLImages;
import net.handle.apps.admintool.view.ShowValuesWindow;
import net.handle.apps.admintool.view.SignerInfo;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.FilesystemConfiguration;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class MainWindow
extends JFrame
implements ActionListener {
    private static final String HDL_HIST_PREF_KEY = "handle_history";
    private static final int HISTORY_LIMIT = 50;
    private final AdminToolUI appUI;
    private final MainWindow thisObj;
    private final JTextField handleField;
    private final JLabel statusField;
    private final JLabel siteField;
    private final JLabel configDirField;
    private final JButton historyButton;
    private final JButton lookupButton;
    private final JButton createButton;
    private final JButton editButton;
    private final JButton deleteButton;
    private final JButton authButton;
    private final JButton signerButton;
    JPopupMenu createHdlPopup = null;
    private final ActionListener popupAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            MainWindow.this.handleField.setText(evt.getActionCommand());
        }
    };

    public MainWindow(AdminToolUI ui) {
        super(ui.getStr("main_win_title") + " " + ui.getMain().getVersion());
        this.appUI = ui;
        this.thisObj = this;
        this.setJMenuBar(ui.getAppMenu());
        this.handleField = new JTextField("", 30);
        this.historyButton = new JButton(HDLImages.singleton().getIcon("/net/handle/apps/admintool/view/resources/down_triangle.png"));
        this.historyButton.setBorder(null);
        this.lookupButton = new JButton(ui.getStr("lookup"));
        this.createButton = new JButton(ui.getStr("create") + "...");
        this.editButton = new JButton(ui.getStr("modify"));
        this.deleteButton = new JButton(ui.getStr("delete"));
        this.authButton = new JButton(ui.getStr("authenticate"));
        this.signerButton = new JButton(ui.getStr("signer"));
        this.statusField = new JLabel(" ");
        this.statusField.setForeground(Color.gray);
        this.siteField = new JLabel(" ");
        this.siteField.setForeground(Color.gray);
        this.configDirField = new JLabel(" ");
        this.updateResolverConfigDirLabel(ui.getMain().getResolverConfigDir());
        this.configDirField.setForeground(Color.gray);
        JPanel p = new JPanel(new GridBagLayout());
        JPanel p2 = new JPanel(new GridBagLayout());
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.add((Component)new JLabel(ui.getStr("handle") + ":"), GridC.getc(0, 0).insets(0, 0, 0, 6));
        p.add((Component)this.handleField, GridC.getc(1, 0).field());
        p.add((Component)this.historyButton, GridC.getc(2, 0).center().filly().insets(0, 0, 0, 6));
        p.add((Component)this.lookupButton, GridC.getc(3, 0).fillx());
        p.add((Component)this.configDirField, GridC.getc(0, 1).colspan(4).fillx().insets(0, 15, 0, 6));
        p.add((Component)this.siteField, GridC.getc(0, 1).colspan(4).fillx().insets(0, 15, 0, 6));
        p.add((Component)p2, GridC.getc(0, 2).colspan(4).fillx().insets(16, 0, 0, 0));
        p2.add((Component)this.createButton, GridC.getc(0, 1).insets(5, 0, 0, 5));
        p2.add((Component)this.editButton, GridC.getc(1, 1).insets(5, 5, 0, 5));
        p2.add((Component)this.deleteButton, GridC.getc(2, 1).insets(5, 5, 0, 5));
        p2.add((Component)this.statusField, GridC.getc(3, 1).wx(1.0f).fillx().insets(5, 5, 0, 5));
        p2.add(Box.createHorizontalStrut(200), GridC.getc(3, 1).wx(1.0f).fillx().insets(5, 5, 0, 5));
        p2.add((Component)this.signerButton, GridC.getc(4, 1).fillx().insets(5, 0, 0, 0));
        p2.add((Component)this.authButton, GridC.getc(5, 1).fillx().insets(5, 0, 0, 0));
        p2.add(Box.createHorizontalStrut(200), GridC.getc(3, 1));
        this.getContentPane().add(p);
        this.getRootPane().setDefaultButton(this.lookupButton);
        this.createButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.lookupButton.addActionListener(this);
        this.handleField.addActionListener(this);
        this.authButton.addActionListener(this);
        this.signerButton.addActionListener(this);
        this.historyButton.addActionListener(this);
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, 4);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                MainWindow.this.appUI.shutdown();
            }
        });
    }

    @Override
    public void setVisible(boolean val) {
        super.setVisible(val);
        this.handleField.requestFocus();
    }

    public void setSiteFieldText(SiteInfo site, boolean doNotRefer) {
        if (site == null) {
            if (doNotRefer) {
                this.siteField.setText("(Sending doNotRefer)");
            } else {
                this.siteField.setText("");
            }
        } else {
            StringBuilder serverList = new StringBuilder();
            if (site.servers != null) {
                serverList.append(site.servers[0].getAddressString());
                for (int i = 1; i < site.servers.length; ++i) {
                    serverList.append(", ").append(site.servers[i].getAddressString());
                }
            }
            byte[] descAttr = site.getAttribute(Util.encodeString("desc"));
            String desc = "";
            if (descAttr != null) {
                desc = Util.decodeString(descAttr) + "; ";
            }
            String doNotReferText = "";
            if (doNotRefer) {
                doNotReferText = " (sending doNotRefer)";
            }
            String text = "Querying specific site" + doNotReferText + ": " + desc + "primary:" + (site.isPrimary ? "y; " : "n; ") + "servers=[" + serverList + "]";
            this.siteField.setText(text);
        }
    }

    public void signerChanged(SignerInfo newSigner) {
        if (newSigner == null) {
            this.signerButton.setText(this.appUI.getStr("signer"));
        } else {
            try {
                String signerId = newSigner.isLocalSigner() ? newSigner.getUserValueReference().toString() : "Remote signer";
                this.signerButton.setText(this.appUI.getStr("signer") + ": " + signerId);
            }
            catch (Exception e) {
                this.signerButton.setText(String.valueOf(e));
            }
        }
    }

    public void authenticationChanged(AuthenticationInfo newAuth) {
        if (newAuth == null) {
            this.authButton.setText(this.appUI.getStr("authenticate"));
        } else {
            try {
                this.authButton.setText(String.valueOf(newAuth.getUserIdIndex()) + " : " + Util.decodeString(newAuth.getUserIdHandle()));
            }
            catch (Exception e) {
                this.authButton.setText(String.valueOf(e));
            }
        }
    }

    public void showAsyncError(String msg) {
        SwingUtilities.invokeLater(new ErrMsgRunner(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHandleFromFile(String handleStr) {
        FileInputStream fin = null;
        try {
            FileDialog fwin = new FileDialog((Frame)this, this.appUI.getStr("choose_values_file_to_load"), 0);
            fwin.setVisible(true);
            String fileName = fwin.getFile();
            String dirName = fwin.getDirectory();
            if (fileName != null && dirName != null) {
                HandleValue[] values;
                fin = new FileInputStream(new File(dirName, fileName));
                byte[] buf = StreamUtil.readFully((InputStream)fin);
                if (Util.looksLikeBinary(buf)) {
                    values = Encoder.decodeHandleValues(buf);
                } else {
                    HandleValue[] json = Util.decodeString(buf);
                    HandleRecord record = (HandleRecord)GsonUtility.getGson().fromJson((String)json, HandleRecord.class);
                    values = record.getValuesAsArray();
                }
                System.err.println("parsed " + values.length + " values:");
                for (HandleValue val : values) {
                    System.err.println(" val: " + val);
                }
                ActionHandler creator = new ActionHandler("create_action", handleStr);
                creator.setValues(values);
                creator.performAction();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this.appUI.getStr("error_loading_values") + "\n\n" + e, this.appUI.getStr("error_title"), 0);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void createHandle(String hdl, HandleValue[] defaultValues) {
        AbstractResponse resp = null;
        try {
            ResolutionRequest req = new ResolutionRequest(Util.encodeString(hdl), null, null, null);
            req.authoritative = true;
            resp = this.appUI.getMain().sendMessage(req);
        }
        catch (Exception e) {
            this.showAsyncError("Warning: error checking '" + hdl + "'\n\nMessage: " + e);
            e.printStackTrace(System.err);
            return;
        }
        if (resp.responseCode == 1) {
            this.showAsyncError("The handle '" + hdl + "' already exists!");
            return;
        }
        AuthenticationInfo auth = this.appUI.getAuthentication(false);
        if (auth == null) {
            return;
        }
        this.showValues(hdl, defaultValues, 1);
    }

    private void showValues(String hdl, HandleValue[] values, int mode) {
        SwingUtilities.invokeLater(new ShowValuesRunner(hdl, values, mode));
    }

    private void showValues(ShowValuesWindow window, String hdl, HandleValue[] values, int mode) {
        SwingUtilities.invokeLater(new ShowValuesRunner(window, hdl, values, mode));
    }

    public boolean editHandle(String hdl) {
        return this.editHandle(null, hdl);
    }

    public boolean editHandle(ShowValuesWindow window, String hdl) {
        if (hdl == null || hdl.trim().length() <= 0) {
            return false;
        }
        AuthenticationInfo auth = this.appUI.getAuthentication(false);
        if (auth == null) {
            return false;
        }
        AbstractResponse resp = null;
        try {
            ResolutionRequest req = new ResolutionRequest(Util.encodeString(hdl), null, null, auth);
            req.authoritative = true;
            req.certify = true;
            req.ignoreRestrictedValues = false;
            resp = this.appUI.getMain().sendMessage(req);
        }
        catch (Exception e) {
            this.showAsyncError("Error resolving '" + hdl + "'\n\nMessage: " + e);
            e.printStackTrace();
            return false;
        }
        if (resp != null && resp instanceof ResolutionResponse) {
            try {
                ResolutionResponse rresp = (ResolutionResponse)resp;
                this.showValues(window, Util.decodeString(rresp.handle), rresp.getHandleValues(), 2);
            }
            catch (Exception e) {
                this.showAsyncError("Error parsing handle values for '" + hdl + "'\n\nMessage: " + e);
                return false;
            }
        } else {
            this.showAsyncError("Received unexpected response: " + resp);
            return false;
        }
        return true;
    }

    public void deleteHandle(String hdl) {
        if (hdl == null || hdl.trim().length() <= 0) {
            return;
        }
        AuthenticationInfo auth = this.appUI.getAuthentication(false);
        if (auth == null) {
            return;
        }
        DeleteHandleRequest dreq = new DeleteHandleRequest(Util.encodeString(hdl), auth);
        try {
            AbstractResponse resp = this.appUI.getMain().sendMessage(dreq);
            if (resp == null || resp.responseCode != 1) {
                JOptionPane.showMessageDialog(this, "The 'delete handle' operation was not successful.\nThe response was: " + resp);
                return;
            }
            JOptionPane.showMessageDialog(this, "The handle '" + hdl + "'  was deleted!");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "There was an error processing the 'delete handle' operation: " + e);
            return;
        }
    }

    public void lookupHandle(String hdl) {
        AbstractResponse resp = null;
        try {
            resp = this.appUI.getMain().sendMessage(new ResolutionRequest(Util.encodeString(hdl), null, null, null));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error resolving '" + hdl + "'\nMessage: " + e);
            e.printStackTrace();
            return;
        }
        if (resp instanceof ResolutionResponse) {
            try {
                ResolutionResponse rresp = (ResolutionResponse)resp;
                ShowValuesWindow showValsWindow = new ShowValuesWindow(this.appUI);
                showValsWindow.setValues(Util.decodeString(rresp.handle), rresp.getHandleValues(), 3);
                AwtUtil.setWindowPosition((Window)showValsWindow, this);
                showValsWindow.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error parsing handle values for '" + hdl + "'\n\nMessage: " + e);
                e.printStackTrace(System.err);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Received unexpected response: " + resp);
            return;
        }
    }

    HandleValue makeValueWithParams(int idx, byte[] valType, byte[] valData) {
        HandleValue newValue = new HandleValue();
        newValue.setType(valType);
        newValue.setData(valData);
        newValue.setIndex(idx);
        return newValue;
    }

    HandleValue getDefaultAdminRecord(String hdl) {
        AdminRecord adminInfo = new AdminRecord();
        if (hdl == null) {
            hdl = "0.NA/test";
        }
        String defaultPrefixAdmin = null;
        if (hdl.startsWith("0.NA/") && (defaultPrefixAdmin = this.appUI.getMain().prefs().getStr("default_prefix_admin")) == null) {
            String suffix = hdl.substring(5);
            if (suffix.length() > 2 && suffix.charAt(2) == '.') {
                defaultPrefixAdmin = "200:0.NA/" + suffix.substring(0, 2) + ".ADMIN";
            } else if (suffix.length() > 3 && suffix.charAt(3) == '.') {
                defaultPrefixAdmin = "200:0.NA/" + suffix.substring(0, 3) + ".ADMIN";
            }
        }
        if (defaultPrefixAdmin == null) {
            byte[] hdlBytes = Util.encodeString(hdl);
            adminInfo.adminId = Util.getZeroNAHandle(hdlBytes);
            adminInfo.adminIdIndex = 200;
        } else {
            ValueReference defaultPrefixAdminValRef = ValueReference.fromString(defaultPrefixAdmin);
            adminInfo.adminId = defaultPrefixAdminValRef.handle;
            adminInfo.adminIdIndex = defaultPrefixAdminValRef.index;
        }
        adminInfo.perms[1] = true;
        adminInfo.perms[6] = true;
        adminInfo.perms[5] = true;
        adminInfo.perms[4] = true;
        adminInfo.perms[10] = true;
        adminInfo.perms[9] = true;
        adminInfo.perms[8] = true;
        adminInfo.perms[7] = true;
        adminInfo.perms[0] = true;
        adminInfo.perms[11] = false;
        adminInfo.perms[2] = false;
        adminInfo.perms[3] = false;
        return this.makeValueWithParams(100, Common.STD_TYPE_HSADMIN, Encoder.encodeAdminRecord(adminInfo));
    }

    private synchronized void showCreateHandlePopup() {
        if (this.createHdlPopup == null) {
            this.createHdlPopup = new JPopupMenu();
            this.createHdlPopup.add(new HDLAction(this.appUI, "create_simple_url_hdl", "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String hdlStr = MainWindow.this.handleField.getText().trim();
                    if (hdlStr.length() <= 0) {
                        JOptionPane.showMessageDialog(MainWindow.this.thisObj, MainWindow.this.appUI.getStr("invalid_hdl_msg"));
                        return;
                    }
                    String urlStr = JOptionPane.showInputDialog(MainWindow.this.thisObj, (Object)(MainWindow.this.appUI.getStr("enter_url_prompt") + hdlStr));
                    if (urlStr == null) {
                        return;
                    }
                    ActionHandler handler = new ActionHandler("create_action", hdlStr);
                    handler.setValues(new HandleValue[]{MainWindow.this.makeValueWithParams(1, Common.STD_TYPE_URL, Util.encodeString(urlStr)), MainWindow.this.getDefaultAdminRecord(hdlStr)});
                    handler.performAction();
                }
            }));
            this.createHdlPopup.add(new HDLAction(this.appUI, "create_simple_email_hdl", "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String hdlStr = MainWindow.this.handleField.getText().trim();
                    String emailStr = JOptionPane.showInputDialog(MainWindow.this.thisObj, (Object)(MainWindow.this.appUI.getStr("enter_email_prompt") + hdlStr));
                    if (emailStr == null) {
                        return;
                    }
                    ActionHandler handler = new ActionHandler("create_action", hdlStr);
                    handler.setValues(new HandleValue[]{MainWindow.this.makeValueWithParams(1, Common.STD_TYPE_EMAIL, Util.encodeString(emailStr)), MainWindow.this.getDefaultAdminRecord(hdlStr)});
                    handler.performAction();
                }
            }));
            this.createHdlPopup.add(new HDLAction(this.appUI, "create_blank_hdl", "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String hdlStr = MainWindow.this.handleField.getText().trim();
                    ActionHandler handler = new ActionHandler("create_action", hdlStr);
                    handler.setValues(new HandleValue[]{MainWindow.this.getDefaultAdminRecord(hdlStr)});
                    handler.performAction();
                }
            }));
            this.createHdlPopup.addSeparator();
            this.createHdlPopup.add(new HDLAction(this.appUI, "create_handle_from_file", "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.createHandleFromFile(MainWindow.this.handleField.getText().trim());
                }
            }));
            this.createHdlPopup.pack();
        }
        this.createHdlPopup.show(this.createButton, 0, 0 - this.createHdlPopup.getPreferredSize().height);
    }

    private void showHistoryPopup() {
        JPopupMenu popup = new JPopupMenu();
        String[] hdlHist = this.appUI.getMain().prefs().getStr(HDL_HIST_PREF_KEY, "").split("\t");
        for (int i = 0; i < hdlHist.length; ++i) {
            if (hdlHist[i] == null || hdlHist[i].trim().length() <= 0) continue;
            popup.add(new HDLAction(null, hdlHist[i], hdlHist[i], this.popupAction));
        }
        popup.pack();
        popup.setSize(popup.getPreferredSize());
        popup.show(this.historyButton, this.historyButton.getWidth() - popup.getWidth(), this.historyButton.getHeight());
    }

    private void saveHandleToHistory() {
        String hdl = this.handleField.getText().trim();
        if (hdl.length() <= 0) {
            return;
        }
        String[] hdlHist = this.appUI.getMain().prefs().getStr(HDL_HIST_PREF_KEY, "").split("\t");
        if (hdlHist.length > 0 && hdlHist[0].equals(hdl)) {
            return;
        }
        ArrayList<String> history = new ArrayList<String>();
        history.addAll(Arrays.asList(hdlHist));
        if (history.contains(hdl)) {
            history.remove(hdl);
        }
        history.add(0, hdl);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < history.size() && i < 50; ++i) {
            if (i != 0) {
                sb.append('\t');
            }
            sb.append((String)history.get(i));
        }
        this.appUI.getMain().prefs().put(HDL_HIST_PREF_KEY, sb.toString());
        try {
            this.appUI.getMain().savePreferences();
        }
        catch (Exception e) {
            System.err.println("Error saving preferences");
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        ActionHandler handler = null;
        if (src == this.createButton) {
            this.saveHandleToHistory();
            this.showCreateHandlePopup();
        } else if (src == this.editButton) {
            this.saveHandleToHistory();
            handler = new ActionHandler("edit_action", this.handleField.getText());
        } else if (src == this.deleteButton) {
            this.saveHandleToHistory();
            handler = new ActionHandler("delete_action", this.handleField.getText());
        } else if (src == this.lookupButton || src == this.handleField) {
            this.saveHandleToHistory();
            handler = new ActionHandler("resolve_action", this.handleField.getText());
        } else if (src == this.authButton) {
            this.appUI.getAuthentication(true);
        } else if (src == this.signerButton) {
            this.appUI.getSignatureInfo(true);
        } else if (src == this.historyButton) {
            this.showHistoryPopup();
        }
        if (handler != null) {
            handler.performAction();
        }
    }

    public void updateResolverConfigDirLabel(String newConfigDir) {
        if (newConfigDir == null) {
            this.configDirField.setText("Current resolver configuration not usign a config directory");
            return;
        }
        boolean isDefaultDirectory = false;
        try {
            isDefaultDirectory = Files.isSameFile(Paths.get(newConfigDir, new String[0]), FilesystemConfiguration.getDefaultConfigDir().toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (isDefaultDirectory) {
            this.configDirField.setText(" ");
        } else {
            this.configDirField.setText("Current config directory: " + newConfigDir);
        }
    }

    private class ErrMsgRunner
    implements Runnable {
        private final String msg;

        ErrMsgRunner(String msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(MainWindow.this.thisObj, this.msg);
        }
    }

    private class ShowValuesRunner
    implements Runnable {
        private final ShowValuesWindow window;
        private final String hdl;
        private final HandleValue[] values;
        private final int mode;

        ShowValuesRunner(String hdl, HandleValue[] values, int mode) {
            this(null, hdl, values, mode);
        }

        ShowValuesRunner(ShowValuesWindow window, String hdl, HandleValue[] values, int mode) {
            this.window = window;
            this.hdl = hdl;
            this.values = values;
            this.mode = mode;
        }

        @Override
        public void run() {
            ShowValuesWindow showValsWindow = this.window;
            if (this.window == null) {
                showValsWindow = new ShowValuesWindow(MainWindow.this.appUI);
            }
            showValsWindow.setValues(this.hdl, this.values, this.mode);
            if (this.window == null) {
                AwtUtil.setWindowPosition((Window)showValsWindow, MainWindow.this.thisObj);
            }
            showValsWindow.setVisible(true);
        }
    }

    public class ActionHandler
    implements Runnable {
        public static final String CREATE_ACTION = "create_action";
        public static final String EDIT_ACTION = "edit_action";
        public static final String DELETE_ACTION = "delete_action";
        public static final String RESOLVE_ACTION = "resolve_action";
        private final String action;
        private final String hdl;
        private HandleValue[] values = null;

        public ActionHandler(String action, String hdl) {
            this.action = action;
            this.hdl = hdl;
        }

        public void setValues(HandleValue[] newValues) {
            this.values = newValues;
        }

        public void performAction() {
            int result;
            if (this.hdl == null || this.hdl.trim().length() <= 0) {
                return;
            }
            if (this.action.equals(DELETE_ACTION) && (result = JOptionPane.showConfirmDialog(MainWindow.this.thisObj, "Are you sure that you want to delete '" + this.hdl + "'?\n\nThis cannot be undone.", "Delete Handle Confirmation", 2)) != 0) {
                return;
            }
            MainWindow.this.statusField.setText(this.toString());
            Thread t = new Thread(this);
            t.start();
        }

        @Override
        public void run() {
            if (this.action.equals(CREATE_ACTION)) {
                MainWindow.this.createHandle(this.hdl, this.values);
            } else if (this.action.equals(EDIT_ACTION)) {
                MainWindow.this.editHandle(this.hdl);
            } else if (this.action.equals(DELETE_ACTION)) {
                MainWindow.this.deleteHandle(this.hdl);
            } else if (this.action.equals(RESOLVE_ACTION)) {
                MainWindow.this.lookupHandle(this.hdl);
            }
            MainWindow.this.statusField.setText("");
        }

        public String toString() {
            return MainWindow.this.appUI.getStr(this.action) + " " + this.hdl;
        }
    }
}

