/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.cnri.guiutil.GridC;
import net.handle.apps.admintool.view.AbstractConsolePanel;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.GetSiteInfoPanel;
import net.handle.apps.admintool.view.TextAreaBasedConsolePanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ListHandlesWindow
extends JFrame
implements ActionListener,
ItemListener {
    private final AdminToolUI ui;
    private final JTextField prefixField;
    private final GetSiteInfoPanel getSiteInfoPanel;
    private final JComboBox<String> outputChoice;
    private final JLabel outputFileLabel;
    private final JLabel consoleFillerLabel;
    private final JButton outputFileButton;
    private final JButton runButton;
    private final ListHandlesWindow thisObj;
    private final AbstractConsolePanel console;
    private AuthenticationInfo authInfo = null;
    private PrintWriter outputWriter = null;
    private int numActiveRunners = 0;

    public ListHandlesWindow(AdminToolUI ui) {
        super(ui.getStr("list_handles"));
        this.ui = ui;
        this.thisObj = this;
        this.setJMenuBar(ui.getAppMenu());
        this.runButton = new JButton(ui.getStr("list_handles"));
        this.outputChoice = new JComboBox<String>(new String[]{ui.getStr("to_window"), ui.getStr("to_file")});
        this.outputFileLabel = new JLabel("");
        this.consoleFillerLabel = new JLabel("");
        this.outputFileButton = new JButton(ui.getStr("choose_file"));
        this.console = new TextAreaBasedConsolePanel();
        this.prefixField = new JTextField("");
        this.getSiteInfoPanel = new GetSiteInfoPanel(ui, null);
        int y = 0;
        JPanel p = new JPanel(new GridBagLayout());
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.add((Component)new JLabel(ui.getStr("prefix") + ": "), GridC.getc(0, 0).label());
        p1.add((Component)this.prefixField, GridC.getc(1, 0).field());
        p.add((Component)p1, GridC.getc(0, y++).wx(1.0f).fillboth());
        p.add((Component)this.getSiteInfoPanel, GridC.getc(0, y++).wx(1.0f).fillboth().insets(10, 0, 15, 0));
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.add((Component)new JLabel(ui.getStr("send_output_to") + ":"), GridC.getc(0, 0).label());
        p2.add(this.outputChoice, GridC.getc(1, 0).label());
        p2.add((Component)this.outputFileLabel, GridC.getc(2, 0).field());
        p2.add((Component)this.consoleFillerLabel, GridC.getc(2, 0).field());
        p2.add((Component)this.outputFileButton, GridC.getc(3, 0).label());
        p.add((Component)p2, GridC.getc(0, y++).wx(1.0f).fillboth());
        p.add((Component)this.console, GridC.getc(0, y++).wxy(1.0f, 1.0f).insets(5, 5, 5, 5).fillboth());
        p.add((Component)this.runButton, GridC.getc(0, y++).east().insets(10, 0, 0, 0));
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(p);
        this.runButton.addActionListener(this);
        this.outputFileButton.addActionListener(this);
        this.outputChoice.addItemListener(this);
        this.pack();
        this.setSize(400, 800);
        AwtUtil.setWindowPosition((Window)this, 4);
        this.outputSelected();
    }

    private void runListHandles() {
        String prefixStr = this.prefixField.getText().trim();
        if (prefixStr.length() <= 0) {
            return;
        }
        byte[] prefix = Util.upperCaseInPlace(Util.encodeString(prefixStr));
        if (!Util.hasSlash(prefix)) {
            prefix = Util.convertSlashlessHandleToZeroNaHandle(prefix);
        }
        this.authInfo = this.ui.getAuthentication(false);
        if (this.authInfo == null) {
            return;
        }
        SiteInfo site = this.getSiteInfoPanel.getSiteInfo();
        if (site == null) {
            return;
        }
        try {
            if (this.outputChoice.getSelectedIndex() == 1) {
                FileOutputStream fout = null;
                while (fout == null) {
                    try {
                        fout = new FileOutputStream(this.outputFileLabel.getText());
                    }
                    catch (Exception e2) {
                        JOptionPane.showMessageDialog(this.thisObj, this.ui.getStr("output_file_err_reselect") + ":\n " + e2);
                        if (this.selectOutputFile()) continue;
                        if (fout != null) {
                            ((OutputStream)fout).close();
                        }
                        return;
                    }
                }
                this.outputWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fout, "UTF8"), true);
            } else {
                this.outputWriter = new PrintWriter(this.console.getOutputStream(), true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.thisObj, "Error creating log: " + e);
            try {
                this.outputWriter.close();
            }
            catch (Throwable e2) {
                // empty catch block
            }
            this.outputWriter = null;
            return;
        }
        this.outputChoice.setEnabled(false);
        this.outputFileButton.setEnabled(false);
        this.runButton.setEnabled(false);
        this.console.clear();
        this.numActiveRunners = site.servers.length;
        for (int i = 0; i < site.servers.length; ++i) {
            Thread batchRunner = new Thread(new ListHandlesRunner(site, site.servers[i], prefix, this.authInfo));
            batchRunner.setPriority(1);
            batchRunner.start();
        }
    }

    private void outputSelected() {
        boolean toFile = this.outputChoice.getSelectedIndex() == 1;
        Dimension oldSize = this.getSize();
        this.console.setVisible(!toFile);
        this.consoleFillerLabel.setVisible(!toFile);
        this.outputFileLabel.setVisible(toFile);
        this.outputFileButton.setVisible(toFile);
        this.pack();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(new Dimension(Math.max(oldSize.width, prefSize.width), prefSize.height));
    }

    public boolean selectOutputFile() {
        FileDialog fwin = new FileDialog((Frame)this, this.ui.getStr("send_output_to"), 1);
        String currentFile = this.outputFileLabel.getText().trim();
        if (currentFile.length() > 0) {
            try {
                File currentF = new File(currentFile);
                if (currentF.canWrite()) {
                    fwin.setDirectory(currentF.getParent());
                    fwin.setFile(currentF.getName());
                }
            }
            catch (Exception currentF) {
                // empty catch block
            }
        }
        fwin.setVisible(true);
        String fileStr = fwin.getFile();
        String dirStr = fwin.getDirectory();
        if (fileStr == null || dirStr == null) {
            return false;
        }
        File outputFile = new File(dirStr + fileStr);
        try {
            this.outputFileLabel.setText(outputFile.getPath());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.thisObj, "Error checking file: " + dirStr + fileStr + "\n\nError Message: " + e);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.runButton) {
            this.runListHandles();
        } else if (src == this.outputFileButton) {
            this.selectOutputFile();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.outputSelected();
    }

    private class ListHandlesRunner
    implements Runnable,
    ResponseMessageCallback {
        private String listErrorMsg = null;
        private final SiteInfo site;
        private final ServerInfo server;
        private final byte[] prefix;
        private final AuthenticationInfo auth;

        ListHandlesRunner(SiteInfo site, ServerInfo server, byte[] prefix, AuthenticationInfo auth) {
            this.site = site;
            this.server = server;
            this.prefix = prefix;
            this.auth = auth;
        }

        @Override
        public void run() {
            block13: {
                try {
                    ListHandlesRequest listReq = new ListHandlesRequest(this.prefix, this.auth);
                    HandleResolver resolver = ListHandlesWindow.this.ui.getMain().getResolver();
                    ListHandlesWindow.this.outputWriter.write("Sending list command " + listReq + "\n to server " + this.server + "\n");
                    ListHandlesWindow.this.outputWriter.flush();
                    resolver.sendRequestToServer((AbstractRequest)listReq, this.site, this.server, this);
                    ListHandlesWindow.this.outputChoice.setEnabled(true);
                }
                catch (Exception e) {
                    try {
                        this.listErrorMsg = "Error listing handles: " + e + "\n";
                        ListHandlesWindow.this.outputChoice.setEnabled(true);
                    }
                    catch (Throwable throwable) {
                        ListHandlesWindow.this.outputChoice.setEnabled(true);
                        ListHandlesWindow.this.outputFileButton.setEnabled(true);
                        ListHandlesWindow.this.numActiveRunners--;
                        if (ListHandlesWindow.this.numActiveRunners <= 0) {
                            ListHandlesWindow.this.runButton.setEnabled(true);
                            try {
                                ListHandlesWindow.this.outputWriter.close();
                                ListHandlesWindow.this.outputWriter = null;
                            }
                            catch (Throwable t) {
                                t.printStackTrace(System.err);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(ListHandlesWindow.this.thisObj, ListHandlesWindow.this.ui.getStr("list_handles_complete_msg"));
                                }
                            });
                        }
                        throw throwable;
                    }
                    ListHandlesWindow.this.outputFileButton.setEnabled(true);
                    ListHandlesWindow.this.numActiveRunners--;
                    if (ListHandlesWindow.this.numActiveRunners > 0) break block13;
                    ListHandlesWindow.this.runButton.setEnabled(true);
                    try {
                        ListHandlesWindow.this.outputWriter.close();
                        ListHandlesWindow.this.outputWriter = null;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                ListHandlesWindow.this.outputFileButton.setEnabled(true);
                ListHandlesWindow.this.numActiveRunners--;
                if (ListHandlesWindow.this.numActiveRunners <= 0) {
                    ListHandlesWindow.this.runButton.setEnabled(true);
                    try {
                        ListHandlesWindow.this.outputWriter.close();
                        ListHandlesWindow.this.outputWriter = null;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            if (this.listErrorMsg != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ListHandlesRunner.this.listErrorMsg != null) {
                            JOptionPane.showMessageDialog(ListHandlesWindow.this.thisObj, ListHandlesRunner.this.listErrorMsg);
                        }
                    }
                });
            }
        }

        @Override
        public void handleResponse(AbstractResponse message) throws HandleException {
            if (message instanceof ListHandlesResponse) {
                byte[][] handles = ((ListHandlesResponse)message).handles;
                for (int i = 0; handles != null && i < handles.length; ++i) {
                    if (handles[i] == null) continue;
                    ListHandlesWindow.this.outputWriter.write(Util.decodeString(handles[i]) + "\n");
                }
            } else if (!(message instanceof ChallengeResponse)) {
                ListHandlesWindow.this.outputWriter.write("Unrecognized response: " + message + ";\n from server: " + this.server + "\n");
            }
            ListHandlesWindow.this.outputWriter.flush();
        }
    }
}

