/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.GetSiteInfoPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class HomePrefixWindow
extends JFrame
implements ActionListener {
    private final AdminToolUI ui;
    private boolean home;
    private final JRadioButton homeChoice;
    private final JRadioButton unhomeChoice;
    private final JTextField prefixField;
    private final GetSiteInfoPanel getSiteInfoPanel;
    private final JButton goButton;

    public HomePrefixWindow(AdminToolUI ui) {
        super(ui.getStr("home_unhome_prefix"));
        this.ui = ui;
        this.setJMenuBar(ui.getAppMenu());
        this.homeChoice = new JRadioButton(ui.getStr("home_prefix"));
        this.unhomeChoice = new JRadioButton(ui.getStr("unhome_prefix"));
        ButtonGroup huGroup = new ButtonGroup();
        huGroup.add(this.homeChoice);
        huGroup.add(this.unhomeChoice);
        this.prefixField = new JTextField("");
        this.goButton = new JButton(ui.getStr("do_it"));
        JPanel p = new JPanel(new GridBagLayout());
        int y = 0;
        p.add((Component)new JLabel("<html>" + ui.getStr("home_unhome_desc") + "</html>"), AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(15, 15, 5, 15), true, true));
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.add((Component)new JLabel(ui.getStr("prefix") + ": "), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), false, false));
        p1.add((Component)this.prefixField, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        p.add((Component)p1, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(5, 5, 0, 5), true, true));
        p1 = new JPanel(new GridBagLayout());
        p1.add((Component)this.homeChoice, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), false, false));
        p1.add((Component)this.unhomeChoice, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), false, false));
        p.add((Component)p1, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(5, 5, 0, 5), true, true));
        this.getSiteInfoPanel = new GetSiteInfoPanel(ui, null);
        p.add((Component)this.getSiteInfoPanel, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(15, 15, 15, 15), true, true));
        p1 = new JPanel(new GridBagLayout());
        p1.add(Box.createHorizontalStrut(250), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, true));
        p1.add((Component)this.goButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, false, false));
        p.add((Component)p1, AwtUtil.getConstraints(0, y++, 1.0, 1.0, 1, 1, new Insets(0, 15, 15, 15), true, true));
        this.getContentPane().add(p);
        this.goButton.addActionListener(this);
        this.homeChoice.addActionListener(this);
        this.unhomeChoice.addActionListener(this);
        this.homeChoice.setSelected(true);
        this.home = true;
        this.getRootPane().setDefaultButton(this.goButton);
        this.pack();
        this.setSize(new Dimension(400, this.getPreferredSize().height + 100));
        AwtUtil.setWindowPosition((Window)this, 4);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.goButton) {
            this.doit();
        } else if (src == this.homeChoice) {
            this.home = true;
        } else if (src == this.unhomeChoice) {
            this.home = false;
        }
    }

    public void doit() {
        SiteInfo site;
        String prefix = this.prefixField.getText().trim();
        byte[] naHandle = Util.upperCaseInPlace(Util.encodeString(prefix));
        if (!Util.hasSlash(naHandle)) {
            naHandle = Util.convertSlashlessHandleToZeroNaHandle(naHandle);
        }
        if ((site = this.getSiteInfoPanel.getSiteInfo()) == null) {
            return;
        }
        try {
            if (!site.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            AuthenticationInfo authInfo = this.ui.getAuthentication(false);
            if (authInfo == null) {
                return;
            }
            GenericRequest homeNAReq = new GenericRequest(naHandle, this.home ? 300 : 301, authInfo);
            homeNAReq.majorProtocolVersion = (byte)2;
            homeNAReq.minorProtocolVersion = 0;
            homeNAReq.isAdminRequest = true;
            homeNAReq.certify = true;
            for (int i = 0; i < site.servers.length; ++i) {
                AbstractResponse response = this.ui.getMain().getResolver().sendRequestToServer((AbstractRequest)homeNAReq, site, site.servers[i]);
                if (response.responseCode == 1) continue;
                throw new Exception(String.valueOf(response));
            }
            JOptionPane.showMessageDialog(this, this.ui.getStr("success_home_unhome"), this.ui.getStr("success_title"), 1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this.ui.getStr("error_home_unhome") + "\n\n" + e, this.ui.getStr("error_title"), 0);
        }
    }
}

