/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.security.PublicKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Hashtable;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValueRenderer
extends Component
implements ListCellRenderer<HandleValue> {
    private static Color[] bgColors = new Color[]{new Color(-1), new Color(-1442307)};
    private final Hashtable<HandleValue, String> cache = new Hashtable();
    private HandleValue value = null;
    private boolean isSelected = false;
    private FontMetrics fm = null;
    private int maxDescent;
    private int w = 0;
    private int h = 0;
    private int index = 0;
    private final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss zzz").withZone(ZoneId.systemDefault());

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 40);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.w = w;
        this.h = h;
    }

    public String getTTLInWords(int ttl, byte ttlType) {
        switch (ttlType) {
            case 0: {
                int tmp2;
                int tmp;
                boolean isNegative;
                StringBuffer sb = new StringBuffer(20);
                boolean bl = isNegative = ttl < 0;
                if (isNegative) {
                    ttl = -ttl;
                }
                if (ttl >= 86400) {
                    tmp = ttl % 86400;
                    tmp2 = (ttl - tmp) / 86400;
                    sb.append(' ');
                    sb.append(tmp2);
                    sb.append(tmp2 > 1 ? " days" : " day");
                    ttl = tmp;
                }
                if (ttl >= 3600) {
                    tmp = ttl % 3600;
                    tmp2 = (ttl - tmp) / 3600;
                    sb.append(' ');
                    sb.append(tmp2);
                    sb.append(tmp2 > 1 ? " hours" : " hour");
                    ttl = tmp;
                }
                if (ttl >= 60) {
                    tmp = ttl % 60;
                    tmp2 = (ttl - tmp) / 60;
                    sb.append(' ');
                    sb.append(tmp2);
                    sb.append(tmp2 > 1 ? " minutes" : " minute");
                    ttl = tmp;
                }
                if (ttl > 0 || sb.length() <= 0) {
                    sb.append(' ');
                    sb.append(ttl);
                    sb.append(ttl == 1 ? " second" : " seconds");
                }
                if (isNegative) {
                    sb.append(" ago");
                    sb.insert(0, "Expires");
                } else {
                    sb.insert(0, "Expires in");
                }
                return sb.toString();
            }
            case 1: {
                return "Expires at " + this.dateTimeFormat.format(Instant.ofEpochMilli(1000L * (long)ttl));
            }
        }
        return "Unknown TTL type!";
    }

    public String getTextValue() {
        String cachedVal = this.cache.get(this.value);
        if (cachedVal != null) {
            return cachedVal;
        }
        StringBuffer val = new StringBuffer(30);
        byte[] type = this.value.getType();
        String typeStr = null;
        if (type != null) {
            typeStr = Util.decodeString(type);
            val.append(typeStr);
            val.append(": ");
        }
        byte[] data = this.value.getData();
        if (typeStr == null) {
            val.append(this.value.getDataAsString());
        } else if (typeStr.equalsIgnoreCase("URL") || typeStr.startsWith("URL.") || typeStr.equalsIgnoreCase("EMAIL") || typeStr.startsWith("EMAIL.") || typeStr.equalsIgnoreCase("HS_ALIAS") || typeStr.startsWith("HS_ALIAS.") || typeStr.equalsIgnoreCase("HS_SERV") || typeStr.startsWith("HS_SERV.") || typeStr.equalsIgnoreCase("DESC") || typeStr.startsWith("DESC.") || typeStr.equalsIgnoreCase("HS_SECKEY") || typeStr.startsWith("HS_SECKEY.")) {
            val.append(Util.decodeString(data));
        } else if (typeStr.equalsIgnoreCase("HS_SITE") || typeStr.startsWith("HS_SITE.") || typeStr.equalsIgnoreCase("HS_NA_DELEGATE")) {
            SiteInfo siteInfo = new SiteInfo();
            try {
                Encoder.decodeSiteInfoRecord(data, 0, siteInfo);
                val.append(siteInfo);
            }
            catch (Exception e) {
                val.append("*** BAD DATA ***");
            }
        } else if (typeStr.equalsIgnoreCase("HS_ADMIN") || typeStr.startsWith("HS_ADMIN.")) {
            AdminRecord adminInfo = new AdminRecord();
            try {
                Encoder.decodeAdminRecord(data, 0, adminInfo);
                val.append(adminInfo);
            }
            catch (Exception e) {
                val.append("*** BAD DATA ***");
            }
        } else if (typeStr.equalsIgnoreCase("HS_DSAPUBKEY") || typeStr.startsWith("HS_DSAPUBKEY.") || typeStr.equalsIgnoreCase("HS_PUBKEY") || typeStr.startsWith("HS_PUBKEY.")) {
            PublicKey key = null;
            try {
                key = Util.getPublicKeyFromBytes(data, 0);
                val.append("alg=");
                val.append(key.getAlgorithm());
                val.append("; format=");
                val.append(key.getFormat());
            }
            catch (Exception e) {
                val.append("*** BAD DATA: ***");
            }
        } else if (typeStr.equalsIgnoreCase("HS_VLIST") || typeStr.startsWith("HS_VLIST.")) {
            ValueReference[] refs = null;
            try {
                refs = Encoder.decodeValueReferenceList(data, 0);
                for (int i = 0; refs != null && i < refs.length; ++i) {
                    if (i != 0) {
                        val.append(", ");
                    }
                    val.append(String.valueOf(refs[i]));
                }
            }
            catch (Exception e) {
                val.append("*** BAD DATA ***");
            }
        } else {
            val.append(this.value.getDataAsString());
        }
        String returnStr = val.toString();
        this.cache.put(this.value, returnStr);
        return returnStr;
    }

    public String getAccessString() {
        StringBuffer sb = new StringBuffer("admin:-- public:--");
        if (this.value.getAdminCanRead()) {
            sb.setCharAt(6, 'r');
        }
        if (this.value.getAdminCanWrite()) {
            sb.setCharAt(7, 'w');
        }
        if (this.value.getAnyoneCanRead()) {
            sb.setCharAt(16, 'r');
        }
        if (this.value.getAnyoneCanWrite()) {
            sb.setCharAt(17, 'w');
        }
        return sb.toString();
    }

    @Override
    public void paint(Graphics g) {
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
            this.maxDescent = this.fm.getMaxDescent();
        }
        Color bg = Color.white;
        bg = this.isSelected ? Color.lightGray : bgColors[this.index % bgColors.length];
        g.setColor(bg);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(Color.lightGray);
        g.drawLine(0, this.h - 1, this.w, this.h - 1);
        int x = 5;
        String tmp = this.getTextValue();
        g.setColor(Color.black);
        g.drawString(tmp, x, this.h / 2 - this.maxDescent - 1);
        g.setColor(Color.gray);
        x = 15;
        int timeStamp = this.value.getTimestamp();
        tmp = timeStamp <= 0 ? "No timestamp" : "Last Modified: " + this.dateTimeFormat.format(Instant.ofEpochMilli(1000L * (long)timeStamp));
        g.drawString(tmp, x, this.h - this.maxDescent - 1);
        x += this.fm.stringWidth(tmp);
        tmp = this.getTTLInWords(this.value.getTTL(), this.value.getTTLType());
        g.drawString(tmp, x += 15, this.h - this.maxDescent - 1);
        x += this.fm.stringWidth(tmp);
        tmp = this.getAccessString();
        g.drawString(tmp, x += 15, this.h - this.maxDescent - 1);
        x += this.fm.stringWidth(tmp);
        tmp = "index: " + this.value.getIndex();
        g.drawString(tmp, x += 15, this.h - this.maxDescent - 1);
        x += this.fm.stringWidth(tmp);
        x += 15;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends HandleValue> list, HandleValue val, int index, boolean isSelected, boolean isFocused) {
        this.index = index;
        this.value = val;
        this.isSelected = isSelected;
        return this;
    }
}

