/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import com.google.gson.Gson;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.EditValueWindow;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.apps.admintool.view.SignerInfo;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.ChainBuilder;
import net.handle.hdllib.trust.ChainVerificationReport;
import net.handle.hdllib.trust.ChainVerifier;
import net.handle.hdllib.trust.DigestedHandleValues;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.IssuedSignature;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;
import net.handle.hdllib.trust.ValuesSignatureVerificationReport;

public class HandleClaimsSetJwsValueEditor
extends JPanel
implements HandleValueEditor,
ActionListener {
    private final AdminToolUI ui;
    private final JTextArea inputField;
    private final JTextArea signatureField;
    private final JButton signButton;
    private final JButton verifyButton;
    private final JLabel verifiedStatusLabel;
    private final JButton selectPublicKeyButton;
    private final boolean isHsCert;
    private final String handle;
    private final HandleValue[] values;
    private final EditValueWindow editValueWindow;

    public HandleClaimsSetJwsValueEditor(AdminToolUI ui, EditValueWindow window, boolean isHsCert, String handle, HandleValue[] values) {
        super.setLayout(new BoxLayout(this, 1));
        this.ui = ui;
        this.editValueWindow = window;
        this.isHsCert = isHsCert;
        this.handle = handle;
        this.values = values;
        this.inputField = new JTextArea(3, 3);
        this.signatureField = new JTextArea(1, 3);
        this.signatureField.setEditable(false);
        JScrollPane signatureScrollPane = new JScrollPane(this.signatureField);
        signatureScrollPane.setMaximumSize(new Dimension(1000, 45));
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                HandleClaimsSetJwsValueEditor.this.setDoneEnabled(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                HandleClaimsSetJwsValueEditor.this.setDoneEnabled(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HandleClaimsSetJwsValueEditor.this.setDoneEnabled(false);
            }
        });
        this.signButton = new JButton();
        this.signButton.setText("Sign");
        this.signButton.addActionListener(this);
        this.verifyButton = new JButton();
        this.verifyButton.setText("Verify");
        this.verifyButton.addActionListener(this);
        this.verifiedStatusLabel = new JLabel("");
        this.verifiedStatusLabel.setVisible(false);
        this.selectPublicKeyButton = new JButton();
        this.selectPublicKeyButton.setText("Select Public Key To Be Signed");
        this.selectPublicKeyButton.addActionListener(this);
        this.add(this.leftAlignBox(new JLabel("Claims:", 2)));
        this.add(new JScrollPane(this.inputField));
        if (isHsCert) {
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(this.leftAlignBox(this.selectPublicKeyButton));
        }
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.leftAlignBox(new JLabel("Signature:", 2)));
        this.add(signatureScrollPane);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        Box signVerifyButtonBox = Box.createHorizontalBox();
        signVerifyButtonBox.add(this.signButton);
        signVerifyButtonBox.add(this.verifyButton);
        signVerifyButtonBox.add(Box.createHorizontalGlue());
        signVerifyButtonBox.add(this.verifiedStatusLabel);
        this.add(signVerifyButtonBox);
    }

    private Box leftAlignBox(JComponent thing) {
        Box box = Box.createHorizontalBox();
        box.add(thing);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    @Override
    public boolean saveValueData(HandleValue value) {
        value.setData(Util.encodeString(this.signatureField.getText()));
        this.setDoneEnabled(true);
        return true;
    }

    private void resign() {
        try {
            this.verifiedStatusLabel.setText("");
            this.verifiedStatusLabel.setVisible(false);
            String prettyPayload = this.inputField.getText();
            Gson gson = GsonUtility.getPrettyGson();
            HandleClaimsSet claims = (HandleClaimsSet)gson.fromJson(prettyPayload, HandleClaimsSet.class);
            SignerInfo sigInfo = this.ui.getSignatureInfo((Frame)this.editValueWindow.getOwner(), false);
            if (sigInfo == null) {
                return;
            }
            JsonWebSignature jws = sigInfo.signClaimsSet(claims);
            String jwsString = jws.serialize();
            this.signatureField.setText(jwsString);
            prettyPayload = gson.toJson((Object)claims);
            this.inputField.setText(prettyPayload);
            this.setDoneEnabled(true);
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    @Override
    public void loadValueData(HandleValue value) {
        try {
            String signatureString = value.getDataAsString();
            HandleClaimsSet claims = null;
            Gson gson = GsonUtility.getPrettyGson();
            if (signatureString.isEmpty()) {
                long oneYearInSeconds = 31622400L;
                long expiration = System.currentTimeMillis() / 1000L + oneYearInSeconds * 2L;
                claims = new HandleClaimsSet();
                claims.sub = "";
                claims.iss = "";
                claims.iat = System.currentTimeMillis() / 1000L;
                claims.nbf = System.currentTimeMillis() / 1000L - 600L;
                claims.exp = expiration;
                claims.chain = null;
                if (this.isHsCert) {
                    claims.perms = Collections.emptyList();
                } else {
                    claims.digests = new DigestedHandleValues();
                    claims.digests.alg = "SHA-256";
                    claims.digests.digests = Collections.emptyList();
                }
            } else {
                JsonWebSignature jws = JsonWebSignatureFactory.getInstance().deserialize(signatureString);
                String payload = jws.getPayloadAsString();
                claims = (HandleClaimsSet)gson.fromJson(payload, HandleClaimsSet.class);
            }
            String prettyPayload = gson.toJson((Object)claims);
            this.inputField.setText(prettyPayload);
            this.setDoneEnabled(true);
        }
        catch (Exception e) {
            this.showError(e);
        }
        this.signatureField.setText(value == null ? "" : Util.decodeString(value.getData()));
    }

    private void showError(Throwable t) {
        this.showError(t.toString());
        t.printStackTrace();
    }

    private void showError(String errorMessage) {
        JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPublicKeyFromFile() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Load", 0);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try (FileInputStream fin = new FileInputStream(new File(dirName, fileName));){
                int r;
                while ((r = fin.read(buf)) >= 0) {
                    bout.write(buf, 0, r);
                }
            }
            buf = bout.toByteArray();
            PublicKey publicKey = Util.getPublicKeyFromBytes(buf);
            Gson gson = GsonUtility.getPrettyGson();
            String prettyPayload = this.inputField.getText();
            HandleClaimsSet claims = (HandleClaimsSet)gson.fromJson(prettyPayload, HandleClaimsSet.class);
            claims.publicKey = publicKey;
            prettyPayload = gson.toJson((Object)claims);
            this.inputField.setText(prettyPayload);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: loading file: " + e);
        }
    }

    private List<PublicKey> getRootKeys() throws Exception {
        return this.ui.getMain().getResolver().getConfiguration().getRootKeys();
    }

    public void verify() {
        String signatureString = this.signatureField.getText();
        try {
            List<IssuedSignature> issuedSignatures;
            JsonWebSignature jws = JsonWebSignatureFactory.getInstance().deserialize(signatureString);
            String message = "";
            ChainBuilder chainBuilder = new ChainBuilder(this.ui.getMain().getResolver());
            try {
                issuedSignatures = chainBuilder.buildChain(jws);
            }
            catch (TrustException e) {
                if (!this.isHsCert) {
                    try {
                        HandleClaimsSet claims = HandleVerifier.getInstance().getHandleClaimsSet(jws);
                        String issuer = claims.iss;
                        ValueReference issuerValRef = ValueReference.fromString(issuer);
                        HandleValue handleValue = this.ui.getMain().getResolver().resolveValueReference(issuerValRef);
                        if (handleValue != null) {
                            PublicKey issuerPublicKey = Util.getPublicKeyFromBytes(handleValue.getData());
                            ValuesSignatureVerificationReport valuesReport = HandleVerifier.getInstance().verifyValues(this.handle, Util.filterOnlyPublicValues(Arrays.asList(this.values)), jws, issuerPublicKey);
                            String valuesReportJson = GsonUtility.getPrettyGson().toJson((Object)valuesReport);
                            System.out.println(valuesReportJson);
                        }
                    }
                    catch (Exception claims) {
                        // empty catch block
                    }
                }
                message = "Signature NOT VERIFIED unable to build chain: " + e.getMessage();
                System.out.println(message);
                e.printStackTrace(System.out);
                this.verifiedStatusLabel.setText(message);
                this.verifiedStatusLabel.setVisible(true);
                return;
            }
            ChainVerifier chainVerifier = new ChainVerifier(this.getRootKeys());
            if (this.isHsCert) {
                ChainVerificationReport chainReport = chainVerifier.verifyChain(issuedSignatures);
                String chainReportJson = GsonUtility.getPrettyGson().toJson((Object)chainReport);
                System.out.println(chainReportJson);
                if (chainReport.canTrust()) {
                    message = "Signature VERIFIED";
                    String publicKeyIssue = this.checkPublicKeyIssue(jws);
                    if (publicKeyIssue != null) {
                        message = message + "; WARNING " + publicKeyIssue;
                    }
                } else {
                    message = "Signature NOT VERIFIED";
                }
            } else {
                boolean missingValues;
                ChainVerificationReport report = chainVerifier.verifyValues(this.handle, Arrays.asList(this.values), issuedSignatures);
                String reportJson = GsonUtility.getPrettyGson().toJson((Object)report);
                System.out.println(reportJson);
                boolean badDigests = report.valuesReport.badDigestValues.size() != 0;
                boolean bl = missingValues = report.valuesReport.missingValues.size() != 0;
                if (report.canTrustAndAuthorized() && !badDigests && !missingValues) {
                    message = "Signature VERIFIED";
                } else {
                    message = "Signature NOT VERIFIED";
                    if (badDigests) {
                        message = message + " bad digests";
                    }
                    if (missingValues) {
                        message = message + " missing values";
                    }
                }
            }
            System.out.println(message);
            this.verifiedStatusLabel.setText(message);
            this.verifiedStatusLabel.setVisible(true);
        }
        catch (Exception e) {
            this.showError(e);
            e.printStackTrace();
        }
    }

    private String checkPublicKeyIssue(JsonWebSignature jws) {
        try {
            HandleClaimsSet claims = HandleVerifier.getInstance().getHandleClaimsSet(jws);
            PublicKey pubKeyInCert = claims.publicKey;
            byte[] certPubKeyBytes = Util.getBytesFromPublicKey(pubKeyInCert);
            ValueReference valRef = ValueReference.fromString(claims.sub);
            HandleValue[] values = valRef.index == 0 ? this.ui.getMain().getResolver().resolveHandle(valRef.getHandleAsString(), new String[]{"HS_PUBKEY"}, null) : new HandleValue[]{this.ui.getMain().getResolver().resolveValueReference(valRef)};
            for (HandleValue value : values) {
                if (!Util.equals(certPubKeyBytes, value.getData())) continue;
                return null;
            }
            return "publicKey does not match subject";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "exception checking publicKey: " + e.getMessage();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.signButton) {
            this.resign();
        } else if (src == this.selectPublicKeyButton) {
            this.loadPublicKeyFromFile();
        } else if (src == this.verifyButton) {
            this.verify();
        }
    }

    private void setDoneEnabled(boolean enabled) {
        this.editValueWindow.setDoneEnabled(enabled);
        if (enabled) {
            this.verifiedStatusLabel.setText("");
            this.verifiedStatusLabel.setVisible(false);
        } else {
            this.verifiedStatusLabel.setText("Must sign before done");
            this.verifiedStatusLabel.setVisible(true);
        }
    }
}

