/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import net.cnri.guiutil.GridC;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class GetSiteInfoPanel
extends JPanel
implements ActionListener {
    private final AdminToolUI ui;
    private JRadioButton byPreviousChoice;
    private final JRadioButton byAddressChoice;
    private final JRadioButton bySiteChoice;
    private final JRadioButton byHandleChoice;
    private JRadioButton byNoneChoice;
    private final JTextField hostField;
    private final JTextField portField;
    private final JButton siteFileButton;
    private final JTextField siteFileField;
    private final JTextField handleField;
    private final JTextField indexField;
    private final JCheckBox usePrimaryCheckBox;
    private SiteInfo previousSite;
    private JLabel siteFileLabel;
    private JLabel hostLabel;
    private JLabel portLabel;
    private JLabel handleLabel;
    private JLabel indexLabel;
    private JLabel previousSiteLabel;
    private JCheckBox doNotReferCheckBox;

    public GetSiteInfoPanel(AdminToolUI ui, String description) {
        this(ui, description, false);
    }

    public GetSiteInfoPanel(AdminToolUI ui, String description, boolean forSpecificSite) {
        JPanel p1;
        this.ui = ui;
        if (forSpecificSite) {
            this.previousSite = ui.getSpecificSite();
            if (this.previousSite != null) {
                this.byPreviousChoice = new JRadioButton(ui.getStr("use_previous_siteinfo") + ": ");
                this.previousSiteLabel = new JLabel(this.displaySiteInfo(this.previousSite));
            }
            this.byNoneChoice = new JRadioButton(ui.getStr("no_specific_site"));
        }
        this.byAddressChoice = new JRadioButton(ui.getStr("by_address"));
        this.hostField = new JTextField("127.0.0.1");
        this.portField = new JTextField("2641");
        this.bySiteChoice = new JRadioButton(ui.getStr("by_siteinfo"));
        this.siteFileButton = new JButton(ui.getStr("choose_file"));
        this.siteFileField = new JTextField("");
        this.byHandleChoice = new JRadioButton(ui.getStr("by_handle"));
        this.handleField = new JTextField("");
        this.indexField = new JTextField("");
        this.usePrimaryCheckBox = new JCheckBox(ui.getStr("use_primary_from_handle"), true);
        ButtonGroup byGroup = new ButtonGroup();
        byGroup.add(this.byAddressChoice);
        byGroup.add(this.bySiteChoice);
        byGroup.add(this.byHandleChoice);
        if (this.byPreviousChoice != null) {
            byGroup.add(this.byPreviousChoice);
        }
        if (this.byNoneChoice != null) {
            byGroup.add(this.byNoneChoice);
        }
        if (forSpecificSite) {
            this.doNotReferCheckBox = new JCheckBox(ui.getStr("do_not_refer"), ui.getSpecificSiteDoNotRefer());
        }
        super.setLayout(new GridBagLayout());
        int y = 0;
        if (description != null) {
            this.add((Component)new JLabel("<html>" + description + "</html>"), GridC.getc(0, y++).wx(1.0f).fillboth().insets(15, 15, 5, 15));
        }
        if (this.byPreviousChoice != null) {
            p1 = new JPanel(new GridBagLayout());
            p1.setBorder(new EtchedBorder());
            p1.add((Component)this.byPreviousChoice, GridC.getc(0, 0).wx(1.0f).colspan(3).insets(5, 5, 5, 5).west());
            p1.add((Component)this.previousSiteLabel, GridC.getc(0, 1).insets(5, 5, 5, 15).fillboth());
            this.add((Component)p1, GridC.getc(0, y++).wx(1.0f).insets(15, 15, 15, 15).fillboth());
        }
        p1 = new JPanel(new GridBagLayout());
        p1.setBorder(new EtchedBorder());
        p1.add((Component)this.bySiteChoice, GridC.getc(0, 0).wx(1.0f).colspan(3).insets(5, 5, 5, 5).west());
        this.siteFileLabel = new JLabel(ui.getStr("siteinfo_file") + ":");
        p1.add((Component)this.siteFileLabel, GridC.getc(0, 1).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.siteFileField, GridC.getc(1, 1).wx(1.0f).insets(5, 5, 5, 5).fillboth());
        p1.add(Box.createHorizontalStrut(80), GridC.getc(1, 1).wx(1.0f).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.siteFileButton, GridC.getc(2, 1).insets(5, 5, 5, 5).fillboth());
        this.add((Component)p1, GridC.getc(0, y++).wx(1.0f).insets(15, 15, 15, 15).fillboth());
        p1 = new JPanel(new GridBagLayout());
        p1.setBorder(new EtchedBorder());
        p1.add((Component)this.byAddressChoice, GridC.getc(0, 0).wx(1.0f).colspan(3).insets(5, 5, 5, 5).west());
        this.hostLabel = new JLabel(ui.getStr("server_address") + ":");
        p1.add((Component)this.hostLabel, GridC.getc(0, 1).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.hostField, GridC.getc(1, 1).wx(1.0f).insets(5, 5, 5, 5).fillboth());
        this.portLabel = new JLabel(ui.getStr("server_port") + ":");
        p1.add((Component)this.portLabel, GridC.getc(0, 2).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.portField, GridC.getc(1, 2).wx(1.0f).insets(5, 5, 5, 5).fillboth());
        this.add((Component)p1, GridC.getc(0, y++).wx(1.0f).insets(15, 15, 15, 15).fillboth());
        p1 = new JPanel(new GridBagLayout());
        p1.setBorder(new EtchedBorder());
        p1.add((Component)this.byHandleChoice, GridC.getc(0, 0).wx(1.0f).colspan(3).insets(5, 5, 5, 5).west());
        this.handleLabel = new JLabel(ui.getStr("handle") + ":");
        p1.add((Component)this.handleLabel, GridC.getc(0, 1).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.handleField, GridC.getc(1, 1).wx(1.0f).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.usePrimaryCheckBox, GridC.getc(0, 2).wx(1.0f).colspan(3).insets(0, 0, 0, 0).fillboth());
        this.indexLabel = new JLabel(ui.getStr("index") + ":");
        p1.add((Component)this.indexLabel, GridC.getc(0, 3).insets(5, 5, 5, 5).fillboth());
        p1.add((Component)this.indexField, GridC.getc(1, 3).wx(1.0f).insets(5, 5, 5, 5).fillboth());
        this.add((Component)p1, GridC.getc(0, y++).wx(1.0f).insets(15, 15, 15, 15).fillboth());
        this.add(Box.createHorizontalStrut(12), GridC.getc(0, y++).wy(1.0f));
        if (this.byNoneChoice != null) {
            p1 = new JPanel(new GridBagLayout());
            p1.setBorder(new EtchedBorder());
            p1.add((Component)this.byNoneChoice, GridC.getc(0, 0).wx(1.0f).colspan(3).insets(5, 5, 5, 5).west());
            this.add((Component)p1, GridC.getc(0, y++).wx(1.0f).insets(15, 15, 15, 15).fillboth());
        }
        if (this.doNotReferCheckBox != null) {
            p1 = new JPanel(new GridBagLayout());
            p1.add((Component)this.doNotReferCheckBox, GridC.getc(0, 0).wx(1.0f).colspan(3).insets(5, 5, 5, 5).west());
            this.add((Component)p1, GridC.getc(0, y++).wx(1.0f).insets(0, 15, 0, 15).fillboth());
        }
        this.byAddressChoice.addActionListener(this);
        this.bySiteChoice.addActionListener(this);
        this.siteFileButton.addActionListener(this);
        this.byHandleChoice.addActionListener(this);
        this.usePrimaryCheckBox.addActionListener(this);
        if (this.byPreviousChoice != null) {
            this.byPreviousChoice.addActionListener(this);
        }
        if (this.byNoneChoice != null) {
            this.byNoneChoice.addActionListener(this);
        }
        if (this.byPreviousChoice != null) {
            this.byPreviousChoice.setSelected(true);
        } else {
            this.bySiteChoice.setSelected(true);
        }
        this.enableAppropriateFields();
    }

    private String displaySiteInfo(SiteInfo site) {
        String servList = "";
        if (site.servers != null) {
            servList = servList + site.servers[0];
            for (int i = 1; i < site.servers.length; ++i) {
                servList = servList + ",<br>" + site.servers[i];
            }
        }
        return "<html>version: " + site.majorProtocolVersion + '.' + site.minorProtocolVersion + "; serial:" + site.serialNumber + "; primary:" + (site.isPrimary ? "y; " : "n; ") + "servers=[" + servList + "]</html>";
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.byPreviousChoice || src == this.byNoneChoice || src == this.byAddressChoice || src == this.bySiteChoice || src == this.byHandleChoice || src == this.usePrimaryCheckBox) {
            this.enableAppropriateFields();
        } else if (src == this.siteFileButton) {
            FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), this.ui.getStr("choose_file"), 0);
            String currentFile = this.siteFileField.getText();
            if (currentFile != null && currentFile.trim().length() > 0) {
                try {
                    File f = new File(currentFile);
                    fwin.setDirectory(f.getParent());
                    fwin.setFile(f.getName());
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            fwin.setVisible(true);
            String fileStr = fwin.getFile();
            String dirStr = fwin.getDirectory();
            if (fileStr != null && dirStr != null) {
                this.siteFileField.setText(new File(dirStr, fileStr).getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiteInfo getSiteInfo() {
        if (this.byPreviousChoice != null && this.byPreviousChoice.isSelected()) {
            return this.previousSite;
        }
        if (this.byNoneChoice != null && this.byNoneChoice.isSelected()) {
            return null;
        }
        if (this.byAddressChoice.isSelected()) {
            return this.getManualSiteInfo();
        }
        if (this.byHandleChoice.isSelected()) {
            Exception error;
            block21: {
                error = null;
                try {
                    SiteInfo[] sites;
                    HandleResolver resolver = this.ui.getMain().getResolver();
                    boolean usePrimary = this.usePrimaryCheckBox.isSelected();
                    if (usePrimary) {
                        sites = resolver.findLocalSitesForNA(Util.encodeString(this.handleField.getText().trim()));
                    } else {
                        int[] nArray = new int[]{Integer.parseInt(this.indexField.getText().trim())};
                        HandleValue[] values = resolver.resolveHandle(this.handleField.getText().trim(), null, nArray);
                        sites = Util.getSitesAndAltSitesFromValues(values);
                    }
                    if (sites == null || sites.length <= 0) break block21;
                    if (usePrimary) {
                        for (SiteInfo site : sites) {
                            if (!site.isPrimary) continue;
                            return site;
                        }
                        break block21;
                    }
                    return sites[0];
                }
                catch (Exception e) {
                    error = e;
                }
            }
            if (error != null) {
                JOptionPane.showMessageDialog(this, this.ui.getStr("error_retrieve_siteinfo") + "\n\n" + error, this.ui.getStr("error_title"), 0);
            } else {
                JOptionPane.showMessageDialog(this, this.ui.getStr("error_retrieve_siteinfo"), this.ui.getStr("error_title"), 0);
            }
            return null;
        }
        if (this.bySiteChoice.isSelected()) {
            SiteInfo siteinfo = new SiteInfo();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[2048];
                try (FileInputStream fin = new FileInputStream(this.siteFileField.getText());){
                    int n;
                    while ((n = fin.read(buf)) >= 0) {
                        bout.write(buf, 0, n);
                    }
                }
                byte[] byArray = bout.toByteArray();
                if (Util.looksLikeBinary(byArray)) {
                    Encoder.decodeSiteInfoRecord(byArray, 0, siteinfo);
                } else {
                    siteinfo = SiteInfoConverter.convertToSiteInfo(new String(byArray, "UTF-8"));
                }
                return siteinfo;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, this.ui.getStr("error_load_siteinfo") + "\n\n" + e, this.ui.getStr("error_title"), 0);
                return null;
            }
        }
        return null;
    }

    public boolean getDoNotRefer() {
        if (this.doNotReferCheckBox == null) {
            return false;
        }
        return this.doNotReferCheckBox.isSelected();
    }

    public SiteInfo getManualSiteInfo() {
        return this.ui.getSiteInfoFromHost(this.hostField.getText().trim(), Integer.parseInt(this.portField.getText().trim()));
    }

    public void enableAppropriateFields() {
        boolean bySite = this.bySiteChoice.isSelected();
        boolean byAddress = this.byAddressChoice.isSelected();
        boolean byHandle = this.byHandleChoice.isSelected();
        boolean usePrimary = this.usePrimaryCheckBox.isSelected();
        this.hostLabel.setEnabled(byAddress);
        this.hostField.setEnabled(byAddress);
        this.portLabel.setEnabled(byAddress);
        this.portField.setEnabled(byAddress);
        this.siteFileLabel.setEnabled(bySite);
        this.siteFileButton.setEnabled(bySite);
        this.siteFileField.setEnabled(bySite);
        this.handleField.setEnabled(byHandle);
        this.handleLabel.setEnabled(byHandle);
        this.usePrimaryCheckBox.setEnabled(byHandle);
        this.indexField.setEnabled(byHandle && !usePrimary);
        this.indexLabel.setEnabled(byHandle && !usePrimary);
    }
}

