/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;
import net.cnri.guiutil.GridC;
import net.cnri.util.StreamTable;
import net.handle.apps.admintool.view.RemoteSignerInfo;
import net.handle.apps.admintool.view.SignerInfo;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.Util;

public class GetSignerInfoWindow
extends JDialog
implements ActionListener {
    private static final String SETTINGS_FILE = ".handle_siginfo";
    private final JPanel localPanel;
    private final JRadioButton localChoice;
    private final JTextField indexField;
    private final JTextField idField;
    private final JLabel privKeyLabel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JButton loadKeyButton;
    private String authRole = "handle";
    private File privKeyFile = null;
    private final JPanel remotePanel;
    private final JRadioButton remoteChoice;
    private final JTextField issuerField;
    private final JTextField baseUri;
    private final JTextField username;
    private final JPasswordField password;
    private final JTextField privateKeyId;
    private final JPasswordField privateKeyPassphrase;
    private SignerInfo sigInfo = null;
    private boolean wasCanceled = true;
    private StreamTable storedSettings = null;

    public GetSignerInfoWindow(Frame owner) throws HeadlessException {
        this(owner, "default");
    }

    public GetSignerInfoWindow(Frame owner, String roleID) throws HeadlessException {
        super(owner, "Signing Key", true);
        this.setResizable(false);
        if (roleID != null) {
            this.authRole = roleID;
        }
        this.storedSettings = new StreamTable();
        try {
            this.storedSettings.readFromFile(System.getProperty("user.home", "") + File.separator + SETTINGS_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String privKeyFileStr = this.storedSettings.getStr("keyfile_" + this.authRole, null);
        if (privKeyFileStr != null) {
            this.privKeyFile = new File(privKeyFileStr);
        }
        this.localChoice = new JRadioButton("Sign using local key");
        this.idField = new JTextField(this.storedSettings.getStr("id_" + this.authRole, ""), 30);
        this.indexField = new JTextField(this.storedSettings.getStr("idx_" + this.authRole, ""), 4);
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.loadKeyButton = new JButton("Select Key File...");
        this.privKeyLabel = new JLabel("no key loaded");
        this.privKeyLabel.setForeground(Color.gray);
        this.localPanel = new JPanel(new GridBagLayout());
        this.localPanel.setBorder(new CompoundBorder(new EmptyBorder(15, 15, 15, 15), new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10))));
        int y = 0;
        Box radioBox = new Box(0);
        radioBox.add(this.localChoice);
        this.localPanel.add((Component)radioBox, GridC.getc(0, y++).colspan(3).wx(1.0f).fillx().insets(0, 0, 0, 0));
        this.localPanel.add((Component)new JLabel("Your ID:"), GridC.getc(0, y).label());
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)this.idField, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 2, 1, new Insets(0, 10, 0, 0), true, false));
        tmp.add((Component)new JLabel("Key Index:", 4), AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(0, 10, 0, 0), false, false));
        tmp.add((Component)this.indexField, AwtUtil.getConstraints(2, 0, 0.0, 0.0, 1, 1, new Insets(0, 4, 0, 0), true, false));
        this.localPanel.add((Component)tmp, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 2, 1, new Insets(4, 4, 4, 0), true, false));
        this.localPanel.add((Component)new JLabel("Your Key:"), GridC.getc(0, y).label());
        this.localPanel.add((Component)this.privKeyLabel, GridC.getc(1, y).field());
        this.localPanel.add((Component)this.loadKeyButton, GridC.getc(2, y++).field().wx(0.0f));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.loadKeyButton.addActionListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.localPanel);
        this.remoteChoice = new JRadioButton("Sign using remote service");
        this.issuerField = new JTextField(this.storedSettings.getStr("issuer", ""), 30);
        this.baseUri = new JTextField(this.storedSettings.getStr("baseUri", ""), 30);
        this.username = new JTextField(this.storedSettings.getStr("username", ""), 30);
        this.password = new JPasswordField(30);
        this.privateKeyId = new JTextField(this.storedSettings.getStr("privateKeyId", ""), 30);
        this.privateKeyPassphrase = new JPasswordField(30);
        this.remotePanel = new JPanel();
        this.remotePanel.setBorder(new CompoundBorder(new EmptyBorder(0, 15, 15, 15), new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10))));
        this.remotePanel.setLayout(new BoxLayout(this.remotePanel, 1));
        this.addLeftJustifiedComponent(this.remoteChoice);
        this.addLeftLabeledComponent(this.baseUri, "Service URI");
        this.addLeftLabeledComponent(this.issuerField, "Issuer");
        this.addLeftLabeledComponent(this.username, "Username");
        this.addLeftLabeledComponent(this.password, "Password");
        this.addLeftLabeledComponent(this.privateKeyId, "Key ID");
        this.addLeftLabeledComponent(this.privateKeyPassphrase, "Key Passphrase");
        this.getContentPane().add(this.remotePanel);
        JPanel bp = new JPanel(new GridBagLayout());
        bp.add(Box.createHorizontalStrut(100), GridC.getc(0, 0).wx(1.0f));
        bp.add((Component)this.cancelButton, GridC.getc(1, 0));
        bp.add((Component)this.okButton, GridC.getc(2, 0));
        this.getContentPane().add(bp);
        this.getRootPane().setDefaultButton(this.okButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.localChoice);
        buttonGroup.add(this.remoteChoice);
        this.localChoice.addActionListener(this);
        this.remoteChoice.addActionListener(this);
        if (this.storedSettings.getBoolean("isLocalChoice", true)) {
            this.localChoice.setSelected(true);
            this.localChoice.requestFocusInWindow();
        } else {
            this.remoteChoice.setSelected(true);
            this.remoteChoice.requestFocusInWindow();
        }
        this.enableDisable();
        this.updateKeyLabel();
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, 4);
    }

    private void addLeftJustifiedComponent(Component component) {
        Box box = new Box(0);
        box.add(component);
        box.add(Box.createHorizontalGlue());
        this.remotePanel.add(box);
    }

    private void addLeftLabeledComponent(Component component, String label) {
        Box box = new Box(0);
        JLabel labelComponent = new JLabel(label);
        labelComponent.setPreferredSize(new Dimension(120, 1));
        box.add(labelComponent);
        box.add(component);
        this.remotePanel.add(box);
    }

    private void updateKeyLabel() {
        if (this.privKeyFile != null) {
            this.privKeyLabel.setText(this.privKeyFile.getName());
        } else {
            this.privKeyLabel.setText("no key loaded - press the \"Load\" button");
        }
    }

    private void chooseKey() {
        JFileChooser chooser = new JFileChooser();
        String filename = this.storedSettings.getStr("key_directory", null);
        if (filename != null) {
            chooser.setCurrentDirectory(new File(filename));
        }
        chooser.setDialogTitle("Select your private key file");
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            this.updateKeyLabel();
            return;
        }
        File f = chooser.getSelectedFile();
        this.storedSettings.put("key_directory", chooser.getCurrentDirectory().getPath());
        if (!(f == null || this.privKeyFile != null && f.equals(this.privKeyFile))) {
            this.privKeyFile = f;
        }
        this.updateKeyLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey loadPrivateKeyFromFile() {
        if (this.privKeyFile != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                try (FileInputStream fin = new FileInputStream(this.privKeyFile);){
                    int r = 0;
                    while ((r = fin.read(buf)) >= 0) {
                        bout.write(buf, 0, r);
                    }
                }
                buf = bout.toByteArray();
                byte[] passphrase = null;
                if (Util.requiresSecretKey(buf)) {
                    PassphrasePanel pp = new PassphrasePanel();
                    int result = JOptionPane.showConfirmDialog(this, pp, "Enter Passphrase", 2);
                    if (result == 0) {
                        passphrase = new String(pp.getPassphrase()).getBytes("UTF8");
                    } else {
                        return null;
                    }
                }
                buf = Util.decrypt(buf, passphrase);
                return Util.getPrivateKeyFromBytes(buf, 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error: " + e, "Error", 0);
                e.printStackTrace(System.err);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Error: Please specify a private key file", "Error", 64);
        }
        return null;
    }

    private boolean checkInputs() {
        this.sigInfo = null;
        if (this.localChoice.isSelected()) {
            int idIndex;
            try {
                idIndex = this.indexField.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.indexField.getText().trim());
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(this, "Invalid index for key: " + this.indexField.getText(), "Invalid index value", 0);
                return false;
            }
            String id = this.idField.getText().trim();
            if (id == null || id.trim().length() <= 0) {
                JOptionPane.showMessageDialog(this, "Please enter your identifier", "No identifier specified", 0);
                return false;
            }
            PrivateKey privKey = this.loadPrivateKeyFromFile();
            if (privKey == null) {
                return false;
            }
            this.sigInfo = new SignerInfo(new PublicKeyAuthenticationInfo(Util.encodeString(id), idIndex, privKey));
        } else {
            String baseUriString = this.baseUri.getText().trim();
            String issuerString = this.issuerField.getText().trim();
            String usernameString = this.username.getText().trim();
            String passwordString = new String(this.password.getPassword());
            String privateKeyIdString = this.privateKeyId.getText().trim();
            String privateKeyPassPhraseString = new String(this.privateKeyPassphrase.getPassword());
            if (issuerString.length() <= 0) {
                JOptionPane.showMessageDialog(this, "Please enter the issuer id", "No issuer specified", 0);
                return false;
            }
            if (baseUriString.length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter the URL of the signing server", "No server specified", 0);
                return false;
            }
            if (usernameString.length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter a username to access server", "No username specified", 0);
                return false;
            }
            if (passwordString.length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter a password to access server", "No password specified", 0);
                return false;
            }
            if (privateKeyIdString.length() == 0) {
                JOptionPane.showMessageDialog(this, "Please enter the id of the private key", "No private key id specified", 0);
                return false;
            }
            RemoteSignerInfo remoteSignerInfo = new RemoteSignerInfo(issuerString, baseUriString, usernameString, passwordString, privateKeyIdString, privateKeyPassPhraseString);
            this.sigInfo = new SignerInfo(remoteSignerInfo);
        }
        return true;
    }

    private void storeValues() {
        this.storedSettings.put("isLocalChoice", this.localChoice.isSelected());
        this.storedSettings.put("id_" + this.authRole, this.idField.getText());
        this.storedSettings.put("idx_" + this.authRole, this.indexField.getText());
        try {
            this.storedSettings.put("keyfile_" + this.authRole, this.privKeyFile.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.storedSettings.put("issuer", this.issuerField.getText());
        this.storedSettings.put("baseUri", this.baseUri.getText());
        this.storedSettings.put("username", this.username.getText());
        this.storedSettings.put("privateKeyId", this.privateKeyId.getText());
        try {
            this.storedSettings.writeToFile(System.getProperty("user.home", "") + File.separator + SETTINGS_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    public SignerInfo getSignatureInfo() {
        if (this.wasCanceled) {
            return null;
        }
        return this.sigInfo;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            if (this.checkInputs()) {
                this.wasCanceled = false;
                this.setVisible(false);
                this.storeValues();
            }
        } else if (src == this.cancelButton) {
            this.wasCanceled = true;
            this.setVisible(false);
        } else if (src == this.loadKeyButton) {
            this.chooseKey();
        } else if (src == this.localChoice || src == this.remoteChoice) {
            this.enableDisable();
        }
    }

    private void enableDisable() {
        if (this.localChoice.isSelected()) {
            this.setComponentEnabled(false, this.remotePanel);
            this.setComponentEnabled(true, this.localPanel);
        } else {
            this.setComponentEnabled(false, this.localPanel);
            this.setComponentEnabled(true, this.remotePanel);
        }
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JCheckBox || component instanceof JButton || component instanceof JLabel) {
            component.setEnabled(enabled);
        }
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component heldComponent : components) {
                this.setComponentEnabled(enabled, heldComponent);
            }
        }
    }

    private class PassphrasePanel
    extends JPanel {
        private final JPasswordField passField;

        PassphrasePanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.passField = new JPasswordField("", 30);
            this.add((Component)new JLabel("Enter the passphrase to decrypt your private key"), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, false, false));
            this.add((Component)this.passField, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, false, false));
        }

        char[] getPassphrase() {
            return this.passField.getPassword();
        }
    }
}

