/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.AdminValueEditor;
import net.handle.apps.admintool.view.DefaultValueEditor;
import net.handle.apps.admintool.view.HandleClaimsSetJwsValueEditor;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.apps.admintool.view.SecretKeyValueEditor;
import net.handle.apps.admintool.view.SiteInfoEditor;
import net.handle.apps.admintool.view.TextValueEditor;
import net.handle.apps.admintool.view.ValueReferenceListEditor;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class EditValueWindow
extends JDialog
implements ItemListener,
ActionListener {
    public static final int ADD_MODE = 3;
    public static final int VIEW_MODE = 2;
    public static final int EDIT_MODE = 1;
    private static final String[] KNOWN_TYPES = new String[]{Util.decodeString(Common.STD_TYPE_URL), Util.decodeString(Common.STD_TYPE_EMAIL), Util.decodeString(Common.STD_TYPE_HSALIAS), Util.decodeString(Common.STD_TYPE_HSADMIN), Util.decodeString(Common.STD_TYPE_HSSITE), Util.decodeString(Common.STD_TYPE_HSVALLIST), Util.decodeString(Common.STD_TYPE_HSSECKEY), Util.decodeString(Common.STD_TYPE_HSPUBKEY), Util.decodeString(Common.STD_TYPE_HSSERV)};
    private final AdminToolUI ui;
    private final JPanel valueEditorPanel;
    private final CardLayout valueEditorLayout;
    private final JComboBox<String> valueTypeChoice;
    private final Hashtable<String, HandleValueEditor> valueEditors;
    private final JPanel bp;
    private boolean detailsVisible = true;
    private final JButton detailsButton;
    private final JTextField indexField;
    private final JCheckBox adminRBox;
    private final JCheckBox adminWBox;
    private final JCheckBox publicRBox;
    private final JCheckBox publicWBox;
    private final JComboBox<String> ttlTypeChoice;
    private final JTextField ttlField;
    private JComponent[] detailComponents = null;
    private final JButton saveButton;
    private final JButton cancelButton;
    private boolean canceled = true;
    private int mode = 1;
    private boolean doneEnabled = true;
    private HandleValue handleValue;
    private Runnable saveCallback;
    private HandleValueEditor lastEditor = null;

    public EditValueWindow(AdminToolUI ui, Frame owner, String handle, HandleValue[] values) {
        super(owner, "Edit Handle Value", false);
        this.ui = ui;
        JLabel permLabel = new JLabel("Permissions:", 4);
        JLabel ttlTypeLabel = new JLabel("TTL Type:", 4);
        JLabel ttlLabel = new JLabel("TTL (seconds):", 4);
        this.detailsButton = new JButton("----------");
        this.saveButton = new JButton("Done");
        this.cancelButton = new JButton("Cancel");
        this.indexField = new JTextField("", 7);
        this.adminRBox = new JCheckBox("Readable by Admins");
        this.adminWBox = new JCheckBox("Writeable by Admins");
        this.publicRBox = new JCheckBox("Readable by Everyone");
        this.publicWBox = new JCheckBox("Writeable by Everyone");
        this.valueTypeChoice = new JComboBox<String>(KNOWN_TYPES);
        this.valueTypeChoice.setEditable(true);
        this.ttlTypeChoice = new JComboBox<String>(new String[]{"Relative", "Absolute"});
        this.ttlField = new JTextField("86400");
        this.valueEditorLayout = new CardLayout();
        this.valueEditorPanel = new JPanel(this.valueEditorLayout);
        this.valueEditors = new Hashtable();
        this.valueEditors.put("", new DefaultValueEditor());
        this.valueEditors.put("hs_alias", new TextValueEditor());
        this.valueEditors.put("hs_seckey", new SecretKeyValueEditor());
        this.valueEditors.put("hs_serv", new TextValueEditor());
        this.valueEditors.put("hs_serv.prefix", new TextValueEditor());
        this.valueEditors.put("hs_site", new SiteInfoEditor(ui));
        this.valueEditors.put("hs_site.6", new SiteInfoEditor(ui));
        this.valueEditors.put("hs_na_delegate", new SiteInfoEditor(ui));
        this.valueEditors.put("hs_site.prefix", new SiteInfoEditor(ui));
        this.valueEditors.put("email", new TextValueEditor());
        this.valueEditors.put("url", new TextValueEditor());
        this.valueEditors.put("hs_admin", new AdminValueEditor(ui));
        this.valueEditors.put("hs_vlist", new ValueReferenceListEditor(ui));
        this.valueEditors.put("hs_signature", new HandleClaimsSetJwsValueEditor(ui, this, false, handle, values));
        this.valueEditors.put("hs_cert", new HandleClaimsSetJwsValueEditor(ui, this, true, handle, values));
        Enumeration<String> enumeration = this.valueEditors.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            this.valueEditorPanel.add((Component)((Object)this.valueEditors.get(key)), key);
        }
        this.valueEditorLayout.show(this.valueEditorPanel, "");
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new EmptyBorder(8, 8, 8, 8));
        int y = 0;
        p.add((Component)new JLabel("Index:", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(0, 0, 4, 4), true, false));
        p.add((Component)this.indexField, AwtUtil.getConstraints(1, y, 1.0, 0.0, 1, 1, new Insets(0, 4, 4, 4), true, false));
        p.add((Component)this.detailsButton, AwtUtil.getConstraints(2, y++, 1.0, 0.0, 1, 1, new Insets(0, 4, 4, 0), true, false));
        p.add((Component)permLabel, AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(0, 0, 4, 4), true, false));
        p.add((Component)this.adminRBox, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(0, 4, 4, 0), 17, false, false));
        p.add((Component)this.adminWBox, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(0, 4, 4, 0), 17, false, false));
        y -= 2;
        p.add((Component)this.publicRBox, AwtUtil.getConstraints(2, y++, 1.0, 0.0, 1, 1, new Insets(0, 4, 4, 0), 17, false, false));
        p.add((Component)this.publicWBox, AwtUtil.getConstraints(2, y++, 1.0, 0.0, 1, 1, new Insets(0, 4, 4, 0), 17, false, false));
        p.add((Component)ttlTypeLabel, AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(0, 0, 4, 4), true, false));
        p.add(this.ttlTypeChoice, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 2, 1, new Insets(0, 4, 4, 0), true, false));
        p.add((Component)ttlLabel, AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(0, 0, 4, 4), true, false));
        p.add((Component)this.ttlField, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 2, 1, new Insets(0, 4, 4, 0), true, false));
        p.add((Component)new JLabel("Value Type:", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(0, 0, 4, 4), true, false));
        p.add(this.valueTypeChoice, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 2, 1, new Insets(0, 4, 4, 0), true, false));
        p.add((Component)this.valueEditorPanel, AwtUtil.getConstraints(0, y++, 1.0, 1.0, 3, 1, new Insets(0, 0, 0, 0), true, true));
        this.bp = new JPanel(new GridBagLayout());
        this.bp.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, true, true));
        this.bp.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(0, 20, 0, 0), false, false));
        this.bp.add((Component)this.saveButton, AwtUtil.getConstraints(2, 0, 0.0, 0.0, 1, 1, new Insets(0, 8, 0, 0), false, false));
        p.add((Component)this.bp, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 3, 1, new Insets(10, 0, 0, 0), true, false));
        this.getContentPane().add(p);
        this.detailsButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.valueTypeChoice.addItemListener(this);
        this.detailComponents = new JComponent[]{permLabel, this.adminRBox, this.adminWBox, this.publicRBox, this.publicWBox, ttlTypeLabel, this.ttlTypeChoice, ttlLabel, this.ttlField};
        this.toggleVisibleDetails();
    }

    public void setSaveCallback(Runnable saveCallback) {
        this.saveCallback = saveCallback;
    }

    public void toggleVisibleDetails() {
        this.detailsVisible = !this.detailsVisible;
        Dimension oldSize = this.getSize();
        for (int i = 0; i < this.detailComponents.length; ++i) {
            this.detailComponents[i].setVisible(this.detailsVisible);
        }
        this.detailsButton.setText(this.detailsVisible ? "Hide Details" : "Show Details");
        this.pack();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(new Dimension(Math.max(oldSize.width, prefSize.width), prefSize.height));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.cancelButton) {
            this.canceled = true;
            this.setVisible(false);
        } else if (src == this.saveButton) {
            this.canceled = false;
            if (this.mode == 2 || this.handleValue == null || this.saveCallback == null) {
                this.setVisible(false);
            } else if (this.saveValueData(this.handleValue)) {
                this.setVisible(false);
                this.saveCallback.run();
            }
        } else if (src == this.detailsButton) {
            this.toggleVisibleDetails();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object src = evt.getSource();
        if (src == this.valueTypeChoice) {
            this.updateValueType();
        }
    }

    private void updateValueType() {
        String selectedType = String.valueOf(this.valueTypeChoice.getSelectedItem()).toLowerCase();
        Dimension oldSize = this.getSize();
        if (!this.valueEditors.containsKey(selectedType)) {
            selectedType = "";
        }
        HandleValueEditor editor = this.valueEditors.get(selectedType);
        if (this.lastEditor != null && editor == this.lastEditor) {
            return;
        }
        HandleValue tmpVal = new HandleValue();
        if (this.lastEditor != null) {
            this.lastEditor.saveValueData(tmpVal);
        }
        editor.loadValueData(tmpVal);
        this.valueEditorLayout.show(this.valueEditorPanel, selectedType);
        this.pack();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(new Dimension(Math.max(oldSize.width, prefSize.width), prefSize.height));
        this.lastEditor = editor;
        if (selectedType.equals("hs_seckey")) {
            boolean pubread = this.publicRBox.isSelected();
            if (pubread && this.mode == 3) {
                this.publicRBox.setSelected(false);
            }
            if (!this.detailsVisible) {
                this.toggleVisibleDetails();
            }
        }
    }

    public synchronized void setMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 1: 
            case 3: {
                this.getContentPane().setEnabled(true);
                this.bp.setVisible(true);
                this.saveButton.setEnabled(this.doneEnabled);
                break;
            }
            case 2: {
                this.getContentPane().setEnabled(false);
                this.setComponentEnabled(false);
                this.bp.setVisible(false);
            }
        }
    }

    public void setComponentEnabled(boolean enabled) {
        this.setComponentEnabled(enabled, this.getContentPane());
    }

    private void setComponentEnabled(boolean enabled, Component component) {
        Component[] components;
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JCheckBox || component instanceof JButton && component != this.detailsButton && !this.buttonShouldRemainEnabled((JButton)component)) {
            Color color;
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(enabled);
                color = component.getForeground();
                ((JTextComponent)component).setDisabledTextColor(color);
            } else if (component instanceof JComboBox && ((JComboBox)component).isEditable()) {
                component.setEnabled(enabled);
                color = component.getForeground();
                try {
                    ((JTextField)((JComboBox)component).getEditor().getEditorComponent()).setDisabledTextColor(color);
                }
                catch (Exception exception) {}
            } else {
                component.setEnabled(enabled);
            }
        }
        if (component instanceof Container && (components = ((Container)component).getComponents()) != null && components.length > 0) {
            for (Component heldComponent : components) {
                this.setComponentEnabled(enabled, heldComponent);
            }
        }
    }

    private boolean buttonShouldRemainEnabled(JButton button) {
        if (button.getText().equals(this.ui.getStr("run_site_test"))) {
            return true;
        }
        return button.getText().equals("Verify");
    }

    public void loadValueData(HandleValue val, boolean isNewValue) {
        this.handleValue = val;
        this.indexField.setEditable(isNewValue);
        this.indexField.setEnabled(isNewValue);
        int index = val.getIndex();
        if (index < 0) {
            this.indexField.setText("");
        } else {
            this.indexField.setText(String.valueOf(index));
        }
        this.adminRBox.setSelected(val.getAdminCanRead());
        this.adminWBox.setSelected(val.getAdminCanWrite());
        this.publicRBox.setSelected(val.getAnyoneCanRead());
        this.publicWBox.setSelected(val.getAnyoneCanWrite());
        if (val.getTTLType() == 1) {
            this.ttlTypeChoice.setSelectedIndex(1);
        } else {
            this.ttlTypeChoice.setSelectedIndex(0);
        }
        this.ttlField.setText(String.valueOf(val.getTTL()));
        this.lastEditor = null;
        this.valueTypeChoice.setSelectedItem(val.getTypeAsString());
        this.updateValueType();
        this.lastEditor.loadValueData(val);
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public boolean saveValueData(HandleValue editVal) {
        int idx = -1;
        try {
            idx = Integer.parseInt(this.indexField.getText().trim());
            if (idx <= 0) {
                throw new Exception("Index must be positive");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: invalid index value: " + this.indexField.getText());
            return false;
        }
        int ttl = -1;
        try {
            ttl = Integer.parseInt(this.ttlField.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: invalid TTL value: " + this.ttlField.getText());
            return false;
        }
        if (this.lastEditor != null && !this.lastEditor.saveValueData(editVal)) {
            return false;
        }
        editVal.setIndex(idx);
        editVal.setType(Util.encodeString(String.valueOf(this.valueTypeChoice.getSelectedItem()).trim()));
        editVal.setTTL(ttl);
        editVal.setAdminCanRead(this.adminRBox.isSelected());
        editVal.setAdminCanWrite(this.adminWBox.isSelected());
        editVal.setAnyoneCanRead(this.publicRBox.isSelected());
        editVal.setAnyoneCanWrite(this.publicWBox.isSelected());
        if (this.ttlTypeChoice.getSelectedIndex() == 1) {
            editVal.setTTLType((byte)1);
        } else {
            editVal.setTTLType((byte)0);
        }
        return true;
    }

    public void setDoneEnabled(boolean enabled) {
        this.doneEnabled = enabled;
        if (this.mode != 2) {
            this.saveButton.setEnabled(enabled);
        }
    }

    static {
        UIManager.put("ComboBox.disabledForeground", Color.BLACK);
        UIManager.put("ComboBox.disabledText", Color.BLACK);
        UIManager.put("CheckBox.disabledText", Color.BLACK);
    }
}

