/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class DefaultValueEditor
extends JPanel
implements ActionListener,
HandleValueEditor {
    private final JComboBox<String> formatChoice;
    private final JTextArea inputField;
    private final JButton loadButton = new JButton("Load From File");
    private final JButton saveButton = new JButton("Save To File");
    int previousFormat = 0;

    public DefaultValueEditor() {
        super(new GridBagLayout());
        this.formatChoice = new JComboBox<String>(new String[]{"Hex", "UTF8 Text"});
        this.inputField = new JTextArea(5, 20);
        this.add(this.formatChoice, AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, new Insets(4, 20, 4, 4), true, true));
        this.add((Component)this.loadButton, AwtUtil.getConstraints(2, 0, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        this.add((Component)this.saveButton, AwtUtil.getConstraints(3, 0, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        this.add((Component)new JScrollPane(this.inputField), AwtUtil.getConstraints(0, 1, 1.0, 1.0, 4, 1, new Insets(4, 4, 4, 4), true, true));
        this.formatChoice.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
    }

    @Override
    public boolean saveValueData(HandleValue value) {
        if (this.formatChoice.getSelectedIndex() == 0) {
            value.setData(Util.encodeHexString(this.inputField.getText()));
        } else {
            value.setData(Util.encodeString(this.inputField.getText()));
        }
        return true;
    }

    @Override
    public void loadValueData(HandleValue value) {
        this.setData(value == null ? null : value.getData());
    }

    private void setData(byte[] data) {
        if (data == null) {
            this.previousFormat = 1;
            this.formatChoice.setSelectedIndex(1);
            this.inputField.setText("");
        } else if (Util.looksLikeBinary(data)) {
            this.previousFormat = 0;
            this.formatChoice.setSelectedIndex(0);
            this.inputField.setText(Util.decodeHexString(data, true));
        } else {
            this.previousFormat = 1;
            this.formatChoice.setSelectedIndex(1);
            this.inputField.setText(Util.decodeString(data));
        }
    }

    public void formatSelected() {
        int newFormat = this.formatChoice.getSelectedIndex();
        if (newFormat != this.previousFormat) {
            if (newFormat == 0) {
                byte[] data = Util.encodeString(this.inputField.getText());
                this.inputField.setText(Util.decodeHexString(data, true));
            } else {
                String dataStr;
                byte[] data = Util.encodeHexString(this.inputField.getText());
                if (!Util.equals(data, Util.encodeString(dataStr = Util.decodeString(data)))) {
                    this.getToolkit().beep();
                    this.formatChoice.setSelectedIndex(0);
                    return;
                }
                this.inputField.setText(dataStr);
            }
            this.previousFormat = newFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Load", 0);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try (FileInputStream fin = new FileInputStream(new File(dirName, fileName));){
                int r;
                while ((r = fin.read(buf)) >= 0) {
                    bout.write(buf, 0, r);
                }
            }
            buf = bout.toByteArray();
            if (Util.looksLikeBinary(buf)) {
                this.previousFormat = 0;
                this.formatChoice.setSelectedIndex(0);
                this.inputField.setText(Util.decodeHexString(buf, true));
            } else {
                this.previousFormat = 1;
                this.formatChoice.setSelectedIndex(1);
                this.inputField.setText(Util.decodeString(buf));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: loading file: " + e);
        }
    }

    private void saveToFile() {
        byte[] buf = null;
        buf = this.formatChoice.getSelectedIndex() == 0 ? Util.encodeHexString(this.inputField.getText()) : Util.encodeString(this.inputField.getText());
        FileDialog fwin = new FileDialog(AwtUtil.getFrame(this), "Choose File to Save", 1);
        fwin.setVisible(true);
        String fileName = fwin.getFile();
        String dirName = fwin.getDirectory();
        if (fileName == null || dirName == null) {
            return;
        }
        try {
            FileOutputStream fout = new FileOutputStream(new File(dirName, fileName));
            fout.write(buf);
            fout.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: loading file: " + e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.formatChoice) {
            this.formatSelected();
        } else if (src == this.loadButton) {
            this.loadFromFile();
        } else if (src == this.saveButton) {
            this.saveToFile();
        }
    }
}

