/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import net.handle.apps.admintool.view.AbstractConsolePanel;
import net.handle.awt.AwtUtil;

public class ConsolePanel
extends AbstractConsolePanel
implements AdjustmentListener,
Runnable {
    public boolean debug = false;
    private int rowHeight = 18;
    private final ArrayList<String> lines;
    private final JScrollBar scrollBar;
    private final ConsoleCanvas canvas;
    private int firstIdx = 0;
    private Font textFont;
    private ConsoleStream outputStream = null;

    public ConsolePanel() {
        super(new GridBagLayout());
        int lineHeight;
        this.setBorder(new EtchedBorder());
        FontMetrics fm = null;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.textFont = new Font("Monospaced", 0, 10);
            fm = graphics.getFontMetrics(this.textFont);
        }
        if (fm != null && (lineHeight = fm.getHeight()) > 0) {
            this.rowHeight = lineHeight;
        }
        this.canvas = new ConsoleCanvas();
        this.lines = new ArrayList();
        this.lines.add("");
        this.scrollBar = new JScrollBar(1, 0, 0, 0, 0);
        this.add((Component)this.canvas, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, true));
        this.add((Component)this.scrollBar, AwtUtil.getConstraints(1, 0, 0.0, 1.0, 1, 1, true, true));
        this.scrollBar.addAdjustmentListener(this);
    }

    @Override
    public void writeConsoleContents(Writer w) throws IOException {
        for (int i = 0; i < this.lines.size(); ++i) {
            w.write(String.valueOf(this.lines.get(i)));
            w.write(10);
        }
    }

    @Override
    public synchronized void addText(String text) {
        try {
            if (text == null) {
                return;
            }
            boolean isAtEnd = this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() >= this.scrollBar.getMaximum();
            boolean newline = false;
            do {
                int nlIdx = text.indexOf(10);
                int lastLineNum = this.lines.size() - 1;
                if (nlIdx < 0) {
                    this.lines.set(lastLineNum, this.lines.get(lastLineNum) + text);
                    text = "";
                    continue;
                }
                this.lines.add(text.substring(0, nlIdx));
                text = text.substring(nlIdx + 1);
                if (isAtEnd) {
                    this.firstIdx = Math.max(0, this.lines.size() - this.canvas.getNumRows());
                }
                newline = true;
            } while (text.length() > 0);
            if (newline) {
                if (isAtEnd) {
                    if (this.debug) {
                        System.err.println("set (end) values; first=" + Math.max(this.firstIdx, this.lines.size() - this.canvas.getNumRows()) + "; extent=" + Math.min(this.lines.size(), this.canvas.getNumRows()) + "; min=" + 0 + "; max=" + this.lines.size());
                    }
                    this.scrollBar.setValues(Math.max(this.firstIdx, this.lines.size() - this.canvas.getNumRows()), Math.min(this.lines.size(), this.canvas.getNumRows()), 0, this.lines.size());
                } else {
                    if (this.debug) {
                        System.err.println("set values; first=" + this.firstIdx + "; extent=" + Math.min(this.lines.size(), this.canvas.getNumRows()) + "; min=" + 0 + "; max=" + this.lines.size());
                    }
                    this.scrollBar.setValues(this.firstIdx, Math.min(this.lines.size(), this.canvas.getNumRows()), 0, this.lines.size());
                }
            }
            SwingUtilities.invokeLater(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void clear() {
        this.lines.clear();
        this.addText("\n");
        this.repaint();
    }

    @Override
    public void run() {
        this.canvas.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.firstIdx = evt.getValue();
        this.canvas.repaint();
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ConsoleStream();
        }
        return this.outputStream;
    }

    private class ConsoleCanvas
    extends JComponent {
        int w = 0;
        int h = 0;

        private ConsoleCanvas() {
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            this.w = w;
            this.h = h;
            super.setBounds(x, y, w, h);
        }

        int getNumRows() {
            return this.h / ConsolePanel.this.rowHeight;
        }

        @Override
        public void paint(Graphics g) {
            this.update(g);
        }

        @Override
        public void update(Graphics g) {
            g.setFont(ConsolePanel.this.textFont);
            g.clearRect(0, 0, this.w, this.h);
            int x = 4;
            int y = ConsolePanel.this.rowHeight;
            for (int i = ConsolePanel.this.firstIdx; y < this.h + ConsolePanel.this.rowHeight && i < ConsolePanel.this.lines.size(); y += ConsolePanel.this.rowHeight, ++i) {
                g.drawString((String)ConsolePanel.this.lines.get(i), x, y);
            }
        }
    }

    private class ConsoleStream
    extends OutputStream {
        private ConsoleStream() {
        }

        @Override
        public void write(byte[] buf) throws IOException {
            ConsolePanel.this.addText(new String(buf, "UTF-8"));
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            ConsolePanel.this.addText(new String(buf, offset, length, "UTF-8"));
        }

        @Override
        public void write(int i) throws IOException {
            ConsolePanel.this.addText(String.valueOf((char)i));
        }
    }
}

