/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.ConsolePanel;
import net.handle.awt.AwtUtil;

public class Console
extends JFrame
implements ActionListener {
    private final AdminToolUI ui;
    private final PrintStream oldErr;
    private final PrintStream oldOut;
    private final ConsolePanel console;
    private final JButton clearButton;
    private final JButton saveButton;
    private final JButton closeButton;

    public Console(AdminToolUI ui) {
        super(ui.getStr("console"));
        this.ui = ui;
        this.setJMenuBar(ui.getAppMenu());
        this.clearButton = new JButton(ui.getStr("clear_console"));
        this.saveButton = new JButton(ui.getStr("save_console"));
        this.closeButton = new JButton(ui.getStr("dismiss"));
        this.console = new ConsolePanel();
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.console, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 4, 1, true, true));
        p.add((Component)this.clearButton, AwtUtil.getConstraints(0, 1, 0.0, 0.0, 1, 1, new Insets(5, 10, 10, 5), true, true));
        p.add((Component)this.saveButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, new Insets(5, 5, 10, 10), true, true));
        p.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 1, 1.0, 0.0, 1, 1, new Insets(5, 10, 10, 10), true, true));
        p.add((Component)this.closeButton, AwtUtil.getConstraints(3, 1, 0.0, 0.0, 1, 1, new Insets(5, 10, 10, 10), true, true));
        this.getContentPane().add(p);
        this.setSize(new Dimension(700, 200));
        this.oldErr = System.err;
        this.oldOut = System.out;
        System.setErr(new PrintStream(this.console.getOutputStream(), true));
        System.setOut(new PrintStream(this.console.getOutputStream(), true));
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.saveButton.addActionListener(this);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (!vis) {
            System.setErr(this.oldErr);
            System.setOut(this.oldOut);
            this.ui.clearConsole();
        }
    }

    private void saveConsole() {
        FileDialog fwin = new FileDialog((Frame)this.ui.getMainWindow(), this.ui.getStr("choose_console_file"), 1);
        fwin.setVisible(true);
        String fileStr = fwin.getFile();
        String dirStr = fwin.getDirectory();
        if (fileStr == null || dirStr == null) {
            return;
        }
        File saveFile = new File(dirStr + fileStr);
        try {
            if (saveFile.exists() && !saveFile.canWrite()) {
                JOptionPane.showMessageDialog(this, "The selected file: \n  " + dirStr + fileStr + "\nis not writeable.");
                return;
            }
            OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(saveFile), "UTF-8");
            this.console.writeConsoleContents(fout);
            ((Writer)fout).close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving file:\n  " + dirStr + fileStr + "\n\nError Message: " + e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.clearButton) {
            this.console.clear();
        } else if (src == this.closeButton) {
            this.setVisible(false);
        } else if (src == this.saveButton) {
            this.saveConsole();
        }
    }
}

