/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.GetSiteInfoPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.SiteInfo;

public class CheckpointWindow
extends JFrame
implements ActionListener {
    private final AdminToolUI ui;
    private final GetSiteInfoPanel getSiteInfoPanel;
    private final JButton goButton;

    public CheckpointWindow(AdminToolUI ui) {
        super(ui.getStr("checkpoint_server"));
        this.ui = ui;
        this.setJMenuBar(ui.getAppMenu());
        this.goButton = new JButton(ui.getStr("do_it"));
        JPanel p = new JPanel(new GridBagLayout());
        int y = 0;
        this.getSiteInfoPanel = new GetSiteInfoPanel(ui, ui.getStr("checkpoint_desc"));
        p.add((Component)this.getSiteInfoPanel, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(15, 15, 15, 15), true, true));
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.add(Box.createHorizontalStrut(250), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, true));
        p1.add((Component)this.goButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, false, false));
        p.add((Component)p1, AwtUtil.getConstraints(0, y++, 1.0, 1.0, 1, 1, new Insets(0, 15, 15, 15), true, true));
        this.getContentPane().add(p);
        this.goButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.goButton);
        this.pack();
        this.setSize(new Dimension(400, this.getPreferredSize().height + 80));
        AwtUtil.setWindowPosition((Window)this, 4);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.goButton) {
            this.doit();
        }
    }

    public void doit() {
        SiteInfo site = this.getSiteInfoPanel.getSiteInfo();
        if (site == null) {
            return;
        }
        try {
            AuthenticationInfo authInfo;
            int i;
            int serverToBackup = -1;
            if (site.servers.length > 1) {
                Object[] choices = new String[site.servers.length + 1];
                choices[0] = this.ui.getStr("all_servers");
                for (int i2 = 0; i2 < site.servers.length; ++i2) {
                    choices[i2 + 1] = this.ui.getStr("server") + " " + (i2 + 1) + " (" + site.servers[i2] + ")";
                }
                Object selected = JOptionPane.showInputDialog(this, this.ui.getStr("select_server_to_checkpoint"), this.ui.getStr("select_server_title"), 3, null, choices, choices[0]);
                if (selected == null) {
                    return;
                }
                for (i = 0; i < choices.length; ++i) {
                    if (!selected.equals(choices[i])) continue;
                    serverToBackup = i - 1;
                    break;
                }
            }
            if ((authInfo = this.ui.getAuthentication(false)) == null) {
                return;
            }
            GenericRequest checkpointReq = new GenericRequest(Common.BLANK_HANDLE, 1003, authInfo);
            checkpointReq.isAdminRequest = true;
            checkpointReq.certify = true;
            for (i = 0; i < site.servers.length; ++i) {
                if (serverToBackup >= 0 && serverToBackup != i) continue;
                checkpointReq.clearBuffers();
                AbstractResponse response = this.ui.getMain().getResolver().sendRequestToServer((AbstractRequest)checkpointReq, site, site.servers[i]);
                if (response.responseCode == 1) continue;
                throw new Exception(String.valueOf(response));
            }
            JOptionPane.showMessageDialog(this, this.ui.getStr("success_checkpoint"), this.ui.getStr("success_title"), 1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this.ui.getStr("error_checkpoint") + "\n\n" + e, this.ui.getStr("error_title"), 0);
        }
    }
}

