/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.cnri.guiutil.GridC;
import net.handle.apps.admintool.view.AbstractConsolePanel;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.TextAreaBasedConsolePanel;
import net.handle.apps.batch.GenericBatch;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AuthenticationInfo;

public class BatchRunnerWindow
extends JFrame
implements ActionListener,
ItemListener {
    private final AdminToolUI ui;
    private final JList<String> batchList;
    private final DefaultListModel<String> batchListModel;
    private final JButton addButton;
    private final JButton delButton;
    private final JButton runButton;
    private final JComboBox<String> outputChoice;
    private final JLabel outputFileLabel;
    private final JLabel consoleFillerLabel;
    private final JButton outputFileButton;
    private final JButton consoleSaveButton;
    private boolean isRunning = false;
    private final BatchRunnerWindow thisObj;
    private final AbstractConsolePanel console;
    private AuthenticationInfo authInfo = null;
    private PrintWriter outputWriter = null;
    private String batchErrorMsg = null;

    public BatchRunnerWindow(AdminToolUI ui) {
        super(ui.getStr("batch_processor"));
        this.ui = ui;
        this.thisObj = this;
        this.setJMenuBar(ui.getAppMenu());
        this.batchListModel = new DefaultListModel();
        this.batchList = new JList<String>(this.batchListModel);
        this.batchList.setSelectionMode(0);
        this.addButton = new JButton(ui.getStr("add"));
        this.delButton = new JButton(ui.getStr("remove"));
        this.runButton = new JButton(ui.getStr("run_batch"));
        this.outputChoice = new JComboBox<String>(new String[]{ui.getStr("to_window"), ui.getStr("to_file")});
        this.outputFileLabel = new JLabel("");
        this.consoleFillerLabel = new JLabel("");
        this.outputFileButton = new JButton(ui.getStr("choose_file"));
        this.console = new TextAreaBasedConsolePanel();
        this.consoleSaveButton = new JButton(ui.getStr("save_console"));
        JPanel p = new JPanel(new GridBagLayout());
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.add((Component)new JScrollPane(this.batchList), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 4, new Insets(5, 5, 5, 5), true, true));
        p1.add((Component)this.addButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        p1.add((Component)this.delButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        p1.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, 2, 0.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        p1.add((Component)this.runButton, AwtUtil.getConstraints(1, 3, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, false));
        p.add((Component)p1, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, true, true));
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.add((Component)new JLabel(ui.getStr("send_output_to") + ":"), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p2.add(this.outputChoice, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p2.add((Component)this.outputFileLabel, AwtUtil.getConstraints(2, 0, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p2.add((Component)this.consoleFillerLabel, AwtUtil.getConstraints(2, 0, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p2.add((Component)this.outputFileButton, AwtUtil.getConstraints(3, 0, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p.add((Component)p2, AwtUtil.getConstraints(0, 1, 1.0, 0.0, 1, 1, true, true));
        p.add((Component)this.console, AwtUtil.getConstraints(0, 2, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        p.add((Component)this.consoleSaveButton, GridC.getc(0, 3).west().insets(5, 5, 5, 5));
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(p);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.outputFileButton.addActionListener(this);
        this.consoleSaveButton.addActionListener(this);
        this.outputChoice.addItemListener(this);
        this.pack();
        this.setSize(600, 400);
        AwtUtil.setWindowPosition((Window)this, 4);
        this.outputSelected();
    }

    private void runBatches() {
        this.isRunning = true;
        this.authInfo = this.ui.getAuthentication(false);
        if (this.authInfo == null) {
            this.isRunning = false;
            return;
        }
        try {
            if (this.outputChoice.getSelectedIndex() == 1) {
                FileOutputStream fout = null;
                while (fout == null) {
                    try {
                        fout = new FileOutputStream(this.outputFileLabel.getText());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.thisObj, this.ui.getStr("output_file_err_reselect") + ":\n " + e);
                        if (!this.selectOutputFile()) continue;
                        if (fout != null) {
                            ((OutputStream)fout).close();
                        }
                        return;
                    }
                }
                this.outputWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fout, "UTF8"), true);
            } else {
                this.outputWriter = new PrintWriter(this.console.getOutputStream(), true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.thisObj, "Error creating log: " + e);
            this.outputWriter = null;
            this.isRunning = false;
            return;
        }
        this.outputChoice.setEnabled(false);
        this.outputFileButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.batchList.setEnabled(false);
        this.runButton.setEnabled(false);
        this.console.clear();
        Thread batchRunner = new Thread(new Runnable(){

            @Override
            public void run() {
                BatchRunnerWindow.this.runBatchesAsync();
            }
        });
        batchRunner.setPriority(1);
        batchRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchesAsync() {
        String currentFile = null;
        try {
            int i;
            String[] batchFiles = new String[this.batchListModel.size()];
            for (i = 0; i < batchFiles.length; ++i) {
                batchFiles[i] = this.batchListModel.elementAt(i);
            }
            for (i = 0; i < batchFiles.length; ++i) {
                currentFile = batchFiles[i];
                System.err.println("processing: " + currentFile);
                try (BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(currentFile), "UTF8"));){
                    GenericBatch batch = new GenericBatch(rdr, this.authInfo, this.outputWriter, this.ui.getMain().getResolver());
                    batch.processBatch();
                    continue;
                }
            }
        }
        catch (Exception e) {
            this.batchErrorMsg = "Error processing batches:\n batch file: " + currentFile + "\n error: " + e + "\n";
        }
        finally {
            this.outputChoice.setEnabled(true);
            this.outputFileButton.setEnabled(true);
            this.addButton.setEnabled(true);
            this.delButton.setEnabled(true);
            this.batchList.setEnabled(true);
            this.runButton.setEnabled(true);
            this.isRunning = false;
        }
        if (this.batchErrorMsg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (BatchRunnerWindow.this.batchErrorMsg != null) {
                        JOptionPane.showMessageDialog(BatchRunnerWindow.this.thisObj, BatchRunnerWindow.this.batchErrorMsg);
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(BatchRunnerWindow.this.thisObj, BatchRunnerWindow.this.ui.getStr("batch_complete_msg"));
                }
            });
        }
    }

    private void outputSelected() {
        boolean toFile = this.outputChoice.getSelectedIndex() == 1;
        Dimension oldSize = this.getSize();
        this.console.setVisible(!toFile);
        this.consoleSaveButton.setVisible(!toFile);
        this.consoleFillerLabel.setVisible(!toFile);
        this.outputFileLabel.setVisible(toFile);
        this.outputFileButton.setVisible(toFile);
        this.pack();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(new Dimension(Math.max(oldSize.width, prefSize.width), toFile ? prefSize.height : 400));
    }

    public void addBatchFile() {
        FileDialog fwin = new FileDialog((Frame)this, this.ui.getStr("open_batch_file"), 0);
        fwin.setVisible(true);
        String fileStr = fwin.getFile();
        String dirStr = fwin.getDirectory();
        if (fileStr == null || dirStr == null) {
            return;
        }
        File batchFile = new File(dirStr + fileStr);
        try {
            if (!batchFile.exists() || !batchFile.canRead()) {
                JOptionPane.showMessageDialog(this.thisObj, "The selected file: \n  " + dirStr + fileStr + "\neither doesn't exist, or is not readable.");
                return;
            }
            this.addBatchFile(batchFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.thisObj, "Error accessing file: " + dirStr + fileStr + "\n\nError Message: " + e);
        }
    }

    public boolean selectOutputFile() {
        FileDialog fwin = new FileDialog((Frame)this, this.ui.getStr("send_output_to"), 1);
        String currentFile = this.outputFileLabel.getText().trim();
        if (currentFile.length() > 0) {
            try {
                File currentF = new File(currentFile);
                if (currentF.canWrite()) {
                    fwin.setDirectory(currentF.getParent());
                    fwin.setFile(currentF.getName());
                }
            }
            catch (Exception currentF) {
                // empty catch block
            }
        }
        fwin.setVisible(true);
        String fileStr = fwin.getFile();
        String dirStr = fwin.getDirectory();
        if (fileStr == null || dirStr == null) {
            return false;
        }
        File outputFile = new File(dirStr + fileStr);
        try {
            this.outputFileLabel.setText(outputFile.getPath());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.thisObj, "Error checking file: " + dirStr + fileStr + "\n\nError Message: " + e);
            return false;
        }
    }

    public synchronized void addBatchFile(File newBatchFile) {
        this.batchListModel.addElement(newBatchFile.getAbsolutePath());
    }

    private void removeBatchFile() {
        int selIdx = this.batchList.getSelectedIndex();
        if (selIdx < 0 || selIdx >= this.batchListModel.size()) {
            return;
        }
        this.batchListModel.removeElementAt(selIdx);
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.addButton) {
            this.addBatchFile();
        } else if (src == this.delButton) {
            this.removeBatchFile();
        } else if (src == this.runButton) {
            this.runBatches();
        } else if (src == this.outputFileButton) {
            this.selectOutputFile();
        } else if (src == this.consoleSaveButton) {
            this.saveConsole();
        }
    }

    private void saveConsole() {
        FileDialog fwin = new FileDialog((Frame)this.ui.getMainWindow(), this.ui.getStr("choose_console_file"), 1);
        fwin.setVisible(true);
        String fileStr = fwin.getFile();
        String dirStr = fwin.getDirectory();
        if (fileStr == null || dirStr == null) {
            return;
        }
        File saveFile = new File(dirStr + fileStr);
        try {
            if (saveFile.exists() && !saveFile.canWrite()) {
                JOptionPane.showMessageDialog(this, "The selected file: \n  " + dirStr + fileStr + "\nis not writeable.");
                return;
            }
            OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(saveFile), "UTF-8");
            this.console.writeConsoleContents(fout);
            ((Writer)fout).close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving file:\n  " + dirStr + fileStr + "\n\nError Message: " + e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.outputSelected();
    }
}

