/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.cnri.util.StreamTable;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.Util;

public class AuthWindow
extends JDialog
implements ActionListener {
    private static final String SETTINGS_FILE = ".handle_authentication";
    private final JComboBox<String> authTypeChoice;
    private final JTextField idField;
    private final JTextField indexField;
    private final JLabel privKeyLabel;
    private final JPasswordField secretKeyField;
    private final JCheckBox hashedPassBox;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JButton loadKeyButton;
    private String authRole = "handle";
    private File privKeyFile = null;
    private AuthenticationInfo auth = null;
    private boolean wasCanceled = true;
    private StreamTable storedSettings = null;

    public AuthWindow(Frame owner) throws HeadlessException {
        this(owner, "default");
    }

    public AuthWindow(Frame owner, String roleID) throws HeadlessException {
        super(owner, "Handle Authentication", true);
        if (roleID != null) {
            this.authRole = roleID;
        }
        this.storedSettings = new StreamTable();
        try {
            this.storedSettings.readFromFile(System.getProperty("user.home", "") + File.separator + SETTINGS_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String privKeyFileStr = this.storedSettings.getStr("keyfile_" + this.authRole, null);
        if (privKeyFileStr != null) {
            this.privKeyFile = new File(privKeyFileStr);
        }
        this.authTypeChoice = new JComboBox<String>(new String[]{"Public/Private Key", "Password"});
        this.idField = new JTextField(this.storedSettings.getStr("id_" + this.authRole, ""), 30);
        this.indexField = new JTextField(this.storedSettings.getStr("idx_" + this.authRole, "300"), 4);
        this.secretKeyField = new JPasswordField("", 15);
        this.hashedPassBox = new JCheckBox("Use SHA-1 hash of password", this.storedSettings.getBoolean("shadow_" + this.authRole, false));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.loadKeyButton = new JButton("Select Key File...");
        this.privKeyLabel = new JLabel("no key loaded");
        this.privKeyLabel.setForeground(Color.gray);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        int y = 0;
        p.add((Component)new JLabel("Your ID:", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 0), false, false));
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)this.idField, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 2, 1, new Insets(0, 10, 0, 0), true, false));
        tmp.add((Component)new JLabel("Key Index:", 4), AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(0, 10, 0, 0), false, false));
        tmp.add((Component)this.indexField, AwtUtil.getConstraints(2, 0, 0.0, 0.0, 1, 1, new Insets(0, 4, 0, 0), true, false));
        p.add((Component)tmp, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 2, 1, new Insets(4, 4, 4, 0), true, false));
        p.add((Component)new JLabel("Key Type:", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 0), true, false));
        p.add(this.authTypeChoice, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 2, 1, new Insets(4, 10, 4, 0), true, false));
        p.add((Component)new JLabel("Your Key:", 4), AwtUtil.getConstraints(0, y, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 0), false, false));
        p.add((Component)this.privKeyLabel, AwtUtil.getConstraints(1, y, 1.0, 0.0, 1, 1, new Insets(4, 10, 4, 4), true, false));
        p.add((Component)this.loadKeyButton, AwtUtil.getConstraints(2, y, 0.0, 0.0, 1, 1, new Insets(4, 0, 4, 4), true, false));
        p.add((Component)this.secretKeyField, AwtUtil.getConstraints(1, y, 1.0, 0.0, 1, 1, new Insets(4, 10, 4, 4), true, false));
        p.add((Component)this.hashedPassBox, AwtUtil.getConstraints(2, y++, 0.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, false));
        JPanel bp = new JPanel(new GridBagLayout());
        bp.setBorder(new EmptyBorder(10, 0, 0, 0));
        bp.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, new Insets(0, 0, 0, 20), true, false));
        bp.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 1, 1, new Insets(0, 0, 0, 20), false, false));
        bp.add((Component)this.okButton, AwtUtil.getConstraints(2, 0, 0.0, 0.0, 1, 1, false, false));
        p.add((Component)bp, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 3, 1, true, true));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.loadKeyButton.addActionListener(this);
        this.authTypeChoice.addActionListener(this);
        this.getContentPane().add(p);
        this.getRootPane().setDefaultButton(this.okButton);
        if (this.storedSettings.getStr("authtype_" + this.authRole, "priv").equals("priv")) {
            this.authTypeChoice.setSelectedIndex(0);
        } else {
            this.authTypeChoice.setSelectedIndex(1);
        }
        this.authTypeSelected();
        this.updateKeyLabel();
        AwtUtil.setWindowPosition((Window)this, 4);
    }

    private void authTypeSelected() {
        int authTypeIdx = this.authTypeChoice.getSelectedIndex();
        boolean privKeyMode = authTypeIdx == 0;
        this.privKeyLabel.setVisible(privKeyMode);
        this.loadKeyButton.setVisible(privKeyMode);
        this.secretKeyField.setVisible(!privKeyMode);
        this.hashedPassBox.setVisible(!privKeyMode);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void updateKeyLabel() {
        if (this.privKeyFile != null) {
            this.privKeyLabel.setText(this.privKeyFile.getName());
        } else {
            this.privKeyLabel.setText("no key loaded - press the \"Load\" button");
        }
    }

    private void chooseKey() {
        JFileChooser chooser = new JFileChooser();
        String filename = this.storedSettings.getStr("key_directory", null);
        if (filename != null) {
            chooser.setCurrentDirectory(new File(filename));
        }
        chooser.setDialogTitle("Select your private key file");
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            this.updateKeyLabel();
            return;
        }
        File f = chooser.getSelectedFile();
        this.storedSettings.put("key_directory", chooser.getCurrentDirectory().getPath());
        if (!(f == null || this.privKeyFile != null && f.equals(this.privKeyFile))) {
            this.privKeyFile = f;
        }
        this.updateKeyLabel();
    }

    private static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return AuthWindow.getWindowForComponent(parentComponent.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey loadPrivateKeyFromFile() {
        if (this.privKeyFile != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                try (FileInputStream fin = new FileInputStream(this.privKeyFile);){
                    int r = 0;
                    while ((r = fin.read(buf)) >= 0) {
                        bout.write(buf, 0, r);
                    }
                }
                buf = bout.toByteArray();
                byte[] passphrase = null;
                if (Util.requiresSecretKey(buf)) {
                    boolean supportsWindowDecorations;
                    final PassphrasePanel pp = new PassphrasePanel();
                    final JOptionPane pane = new JOptionPane(pp, 3, 2);
                    Window window = AuthWindow.getWindowForComponent(this);
                    final JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, "Enter Passphrase", true) : new JDialog((Dialog)window, "Enter Passphrase", true);
                    dialog.setComponentOrientation(this.getComponentOrientation());
                    Container contentPane = dialog.getContentPane();
                    contentPane.setLayout(new BorderLayout());
                    contentPane.add((Component)pane, "Center");
                    dialog.setResizable(false);
                    if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                        dialog.setUndecorated(true);
                        this.getRootPane().setWindowDecorationStyle(7);
                    }
                    dialog.pack();
                    dialog.setLocationRelativeTo(this);
                    WindowAdapter adapter = new WindowAdapter(){
                        private boolean gotFocus = false;

                        @Override
                        public void windowClosing(WindowEvent we) {
                            pane.setValue(null);
                        }

                        @Override
                        public void windowGainedFocus(WindowEvent we) {
                            if (!this.gotFocus) {
                                pp.focus();
                                this.gotFocus = true;
                            }
                        }
                    };
                    dialog.addWindowListener(adapter);
                    dialog.addWindowFocusListener(adapter);
                    dialog.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent ce) {
                            pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        }
                    });
                    pane.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent event) {
                            if (dialog.isVisible() && event.getSource() == pane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                                dialog.setVisible(false);
                            }
                        }
                    });
                    dialog.setVisible(true);
                    dialog.dispose();
                    Object selectedValue = pane.getValue();
                    int result = selectedValue instanceof Integer ? (Integer)selectedValue : -1;
                    if (result == 0) {
                        passphrase = new String(pp.getPassphrase()).getBytes("UTF8");
                    } else {
                        return null;
                    }
                }
                buf = Util.decrypt(buf, passphrase);
                return Util.getPrivateKeyFromBytes(buf, 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error: " + e, "Error", 0);
                e.printStackTrace(System.err);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Error: Please specify a private key file", "Error", 0);
        }
        return null;
    }

    private boolean checkInputs() {
        int idIndex;
        this.auth = null;
        try {
            idIndex = this.indexField.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.indexField.getText().trim());
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "Invalid index for key: " + this.indexField.getText(), "Invalid index value", 0);
            return false;
        }
        String id = this.idField.getText().trim();
        if (id == null || id.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please enter your identifier", "No identifier specified", 0);
            return false;
        }
        int authTypeIdx = this.authTypeChoice.getSelectedIndex();
        if (authTypeIdx == 0) {
            PrivateKey privKey = this.loadPrivateKeyFromFile();
            if (privKey == null) {
                return false;
            }
            this.auth = new PublicKeyAuthenticationInfo(Util.encodeString(id), idIndex, privKey);
        } else {
            byte[] secKey = Util.encodeString(new String(this.secretKeyField.getPassword()));
            try {
                this.auth = new SecretKeyAuthenticationInfo(Util.encodeString(id), idIndex, secKey, this.hashedPassBox.isSelected());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this, "Error calculating or encoding password", "Error encoding password", 0);
                return false;
            }
        }
        return true;
    }

    private void storeValues() {
        this.storedSettings.put("id_" + this.authRole, this.idField.getText());
        this.storedSettings.put("idx_" + this.authRole, this.indexField.getText());
        this.storedSettings.put("authtype_" + this.authRole, this.authTypeChoice.getSelectedIndex() == 0 ? "priv" : "sec");
        try {
            this.storedSettings.put("keyfile_" + this.authRole, this.privKeyFile.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.storedSettings.writeToFile(System.getProperty("user.home", "") + File.separator + SETTINGS_FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    public AuthenticationInfo getAuthentication() {
        if (this.wasCanceled) {
            return null;
        }
        return this.auth;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            if (this.checkInputs()) {
                this.wasCanceled = false;
                this.setVisible(false);
                this.storeValues();
            }
        } else if (src == this.cancelButton) {
            this.wasCanceled = true;
            this.setVisible(false);
        } else if (src == this.loadKeyButton) {
            this.chooseKey();
        } else if (src == this.authTypeChoice) {
            this.authTypeSelected();
        }
    }

    private class PassphrasePanel
    extends JPanel {
        private final JPasswordField passField;

        PassphrasePanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.passField = new JPasswordField("", 30);
            this.add((Component)new JLabel("Enter the passphrase to decrypt your private key"), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, false, false));
            this.add((Component)this.passField, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, false, false));
        }

        char[] getPassphrase() {
            return this.passField.getPassword();
        }

        void focus() {
            this.passField.requestFocusInWindow();
        }
    }
}

