/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.apps.admintool.view.HandleValueEditor;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class AdminValueEditor
extends JPanel
implements HandleValueEditor {
    private final AdminToolUI ui;
    private final JTextField handleField;
    private final JTextField indexField;
    private final JCheckBox deleteHandleCB;
    private final JCheckBox addValueCB;
    private final JCheckBox removeValueCB;
    private final JCheckBox modifyValueCB;
    private final JCheckBox readValueCB;
    private final JCheckBox addAdminCB;
    private final JCheckBox removeAdminCB;
    private final JCheckBox modifyAdminCB;
    private final JCheckBox addHandleCB;
    private final JCheckBox listHandlesCB;
    private final JCheckBox addDerivedPrefixCB;
    private final JCheckBox deleteDerivedPrefixCB;

    public AdminValueEditor(AdminToolUI ui) {
        super(new GridBagLayout());
        this.ui = ui;
        this.handleField = new JTextField("", 14);
        this.indexField = new JTextField("", 5);
        this.deleteHandleCB = new JCheckBox(ui.getStr("perm_del_hdl"), true);
        this.addValueCB = new JCheckBox(ui.getStr("perm_add_val"), true);
        this.removeValueCB = new JCheckBox(ui.getStr("perm_del_val"), true);
        this.modifyValueCB = new JCheckBox(ui.getStr("perm_mod_val"), true);
        this.readValueCB = new JCheckBox(ui.getStr("perm_read_val"), true);
        this.addAdminCB = new JCheckBox(ui.getStr("perm_add_adm"), true);
        this.removeAdminCB = new JCheckBox(ui.getStr("perm_rem_adm"), true);
        this.modifyAdminCB = new JCheckBox(ui.getStr("perm_mod_adm"), true);
        this.addHandleCB = new JCheckBox(ui.getStr("perm_add_hdl"), true);
        this.listHandlesCB = new JCheckBox(ui.getStr("perm_list_hdl"), true);
        this.addDerivedPrefixCB = new JCheckBox(ui.getStr("perm_add_na"), true);
        this.deleteDerivedPrefixCB = new JCheckBox(ui.getStr("perm_del_na"), true);
        JPanel idPanel = new JPanel(new GridBagLayout());
        idPanel.add((Component)new JLabel(ui.getStr("adm_handle") + ":", 4), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        idPanel.add((Component)this.handleField, AwtUtil.getConstraints(1, 0, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        idPanel.add((Component)new JLabel(ui.getStr("adm_validx") + ":", 4), AwtUtil.getConstraints(0, 1, 0.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        idPanel.add((Component)this.indexField, AwtUtil.getConstraints(1, 1, 1.0, 0.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)idPanel, AwtUtil.getConstraints(0, 0, 1.0, 0.0, 1, 1, true, true));
        JPanel permPanel = new JPanel(new GridBagLayout());
        int y = 0;
        permPanel.add((Component)this.addValueCB, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.removeValueCB, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.modifyValueCB, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.readValueCB, AwtUtil.getConstraints(0, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        y = 0;
        permPanel.add((Component)this.addAdminCB, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.removeAdminCB, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.modifyAdminCB, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.deleteHandleCB, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.addHandleCB, AwtUtil.getConstraints(0, ++y, 1.0, 0.0, 1, 1, new Insets(14, 4, 4, 4), true, true));
        permPanel.add((Component)this.addDerivedPrefixCB, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(14, 4, 4, 4), true, true));
        permPanel.add((Component)this.listHandlesCB, AwtUtil.getConstraints(0, y, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        permPanel.add((Component)this.deleteDerivedPrefixCB, AwtUtil.getConstraints(1, y++, 1.0, 0.0, 1, 1, new Insets(4, 4, 4, 4), true, true));
        this.add((Component)permPanel, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, true, true));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    @Override
    public boolean saveValueData(HandleValue value) {
        AdminRecord adminInfo = new AdminRecord();
        adminInfo.adminId = Util.encodeString(this.handleField.getText().trim());
        try {
            adminInfo.adminIdIndex = Integer.parseInt(this.indexField.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, this.ui.getStr("invalid_idx_msg") + "\n\nError: " + e);
            return false;
        }
        if (adminInfo.adminIdIndex < 0) {
            JOptionPane.showMessageDialog(this, this.ui.getStr("invalid_idx_msg"));
            return false;
        }
        adminInfo.perms[1] = this.deleteHandleCB.isSelected();
        adminInfo.perms[6] = this.addValueCB.isSelected();
        adminInfo.perms[5] = this.removeValueCB.isSelected();
        adminInfo.perms[4] = this.modifyValueCB.isSelected();
        adminInfo.perms[10] = this.readValueCB.isSelected();
        adminInfo.perms[9] = this.addAdminCB.isSelected();
        adminInfo.perms[8] = this.removeAdminCB.isSelected();
        adminInfo.perms[7] = this.modifyAdminCB.isSelected();
        adminInfo.perms[0] = this.addHandleCB.isSelected();
        adminInfo.perms[11] = this.listHandlesCB.isSelected();
        adminInfo.perms[2] = this.addDerivedPrefixCB.isSelected();
        adminInfo.perms[3] = this.deleteDerivedPrefixCB.isSelected();
        value.setData(Encoder.encodeAdminRecord(adminInfo));
        return true;
    }

    @Override
    public void loadValueData(HandleValue value) {
        AdminRecord adminInfo = new AdminRecord();
        adminInfo.perms[1] = true;
        adminInfo.perms[6] = true;
        adminInfo.perms[5] = true;
        adminInfo.perms[4] = true;
        adminInfo.perms[10] = true;
        adminInfo.perms[9] = true;
        adminInfo.perms[8] = true;
        adminInfo.perms[7] = true;
        adminInfo.perms[0] = true;
        adminInfo.perms[11] = false;
        adminInfo.perms[2] = false;
        adminInfo.perms[3] = false;
        try {
            Encoder.decodeAdminRecord(value.getData(), 0, adminInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (adminInfo.adminId != null) {
            this.handleField.setText(Util.decodeString(adminInfo.adminId));
        } else {
            this.handleField.setText("");
        }
        this.indexField.setText(String.valueOf(adminInfo.adminIdIndex));
        this.deleteHandleCB.setSelected(adminInfo.perms[1]);
        this.addValueCB.setSelected(adminInfo.perms[6]);
        this.removeValueCB.setSelected(adminInfo.perms[5]);
        this.modifyValueCB.setSelected(adminInfo.perms[4]);
        this.readValueCB.setSelected(adminInfo.perms[10]);
        this.addAdminCB.setSelected(adminInfo.perms[9]);
        this.removeAdminCB.setSelected(adminInfo.perms[8]);
        this.modifyAdminCB.setSelected(adminInfo.perms[7]);
        this.addHandleCB.setSelected(adminInfo.perms[0]);
        this.listHandlesCB.setSelected(adminInfo.perms[11]);
        this.addDerivedPrefixCB.setSelected(adminInfo.perms[2]);
        this.deleteDerivedPrefixCB.setSelected(adminInfo.perms[3]);
    }
}

