/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.view;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import net.handle.apps.admintool.controller.AuthenticationUtil;
import net.handle.apps.admintool.controller.Main;
import net.handle.apps.admintool.view.AuthWindow;
import net.handle.apps.admintool.view.BatchRunnerWindow;
import net.handle.apps.admintool.view.CheckpointWindow;
import net.handle.apps.admintool.view.Console;
import net.handle.apps.admintool.view.GetSignerInfoWindow;
import net.handle.apps.admintool.view.GetSiteInfoPanel;
import net.handle.apps.admintool.view.HDLAction;
import net.handle.apps.admintool.view.HomePrefixWindow;
import net.handle.apps.admintool.view.ListHandlesWindow;
import net.handle.apps.admintool.view.MainWindow;
import net.handle.apps.admintool.view.SignerInfo;
import net.handle.apps.admintool.view.TxnReviewWindow;
import net.handle.apps.admintool.view.resources.Resources;
import net.handle.awt.TaskIndicator;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.SiteInfo;

public class AdminToolUI {
    private Main main = null;
    private AdminToolUI ui = null;
    private Resources resources = null;
    private MainWindow mainWin = null;
    @Deprecated
    private TxnReviewWindow txnReviewWindow = null;
    private BatchRunnerWindow batchWin = null;
    private Console consoleWin = null;
    private AuthenticationInfo authInfo = null;
    private SignerInfo sigInfo = null;
    private SiteInfo specificSite = null;
    private boolean specificSiteDoNotRefer;
    private final Hashtable<String, ImageIcon> imageCache = new Hashtable();
    public static boolean isMacOSX = false;
    private final HDLAction openBatchFileAction;
    private final HDLAction changeConfigDirAction;
    private final HDLAction clearCacheAction;
    private final HDLAction authenticateAction;
    private final HDLAction shutdownAction;
    private final HDLAction showBatchAction;
    private final HDLAction showConsoleAction;
    private final HDLAction showHomingAction;
    private final HDLAction showCheckpointAction;
    private final HDLAction showListHandlesAction;
    private final HDLAction querySpecificSite;

    public AdminToolUI(Main main) {
        this.main = main;
        this.ui = this;
        String osName = System.getProperty("os.name", "");
        isMacOSX = osName.toUpperCase().indexOf("MAC OS X") >= 0;
        this.resources = (Resources)ResourceBundle.getBundle("net.handle.apps.admintool.view.resources.Resources", Locale.getDefault());
        this.openBatchFileAction = new HDLAction(this.ui, "open_batch_file", "Meta-B", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.openBatchFile();
            }
        });
        this.changeConfigDirAction = new HDLAction(this.ui, "change_config_dir", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.changeConfigDir();
            }
        });
        this.clearCacheAction = new HDLAction(this.ui, "clear_cache", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.getMain().clearHandleCache();
                JOptionPane.showMessageDialog(null, AdminToolUI.this.ui.getStr("cache_cleared_msg"), "Error", 1);
            }
        });
        this.authenticateAction = new HDLAction(this.ui, "authenticate", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.getAuthentication(true);
            }
        });
        this.shutdownAction = new HDLAction(this.ui, "quit", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.shutdown();
            }
        });
        this.showBatchAction = new HDLAction(this.ui, "batch_processor", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.showBatchProcessor();
            }
        });
        this.showConsoleAction = new HDLAction(this.ui, "console", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.showConsoleWindow();
            }
        });
        this.showHomingAction = new HDLAction(this.ui, "home_unhome_prefix", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.showHomeUnhomeWindow();
            }
        });
        this.showListHandlesAction = new HDLAction(this.ui, "list_handles", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.showListHandlesWindow();
            }
        });
        this.showCheckpointAction = new HDLAction(this.ui, "checkpoint_server", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.showCheckpointWindow();
            }
        });
        this.querySpecificSite = new HDLAction(this.ui, "query_specific_site", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminToolUI.this.querySpecificSiteTool(evt);
            }
        });
        this.querySpecificSite.putValue("Name", this.querySpecificSite.getValue("Name") + "...");
    }

    public SignerInfo getSignatureInfo(boolean changeInfo) {
        return this.getSignatureInfo(this.mainWin, changeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignerInfo getSignatureInfo(Frame owner, boolean changeInfo) {
        if (this.sigInfo != null && !changeInfo) {
            return this.sigInfo;
        }
        try {
            GetSignerInfoWindow sigWin = new GetSignerInfoWindow(owner);
            sigWin.setVisible(true);
            SignerInfo newSigInfo = sigWin.getSignatureInfo();
            if (newSigInfo == null) {
                SignerInfo signerInfo = changeInfo ? null : this.sigInfo;
                return signerInfo;
            }
            if (this.main.prefs().getBoolean("check_auth", true) && newSigInfo.isLocalSigner()) {
                CheckAuthentication checkAuth = new CheckAuthentication(newSigInfo.getLocalSignerInfo());
                TaskIndicator ti = new TaskIndicator(null);
                ti.invokeTask(checkAuth, "Checking Authentication ...");
                if (checkAuth.wasSuccessful()) {
                    PublicKeyAuthenticationInfo tmpAuth = newSigInfo.getLocalSignerInfo();
                    if (tmpAuth.getUserIdIndex() == 0 && checkAuth.getIndex() != null) {
                        tmpAuth = new PublicKeyAuthenticationInfo(tmpAuth.getUserIdHandle(), checkAuth.getIndex(), tmpAuth.getPrivateKey());
                        newSigInfo = new SignerInfo(tmpAuth);
                    }
                    SignerInfo signerInfo = this.sigInfo = newSigInfo;
                    return signerInfo;
                }
                String errorMsg = checkAuth.getErrorMessage();
                String msg = errorMsg == null ? "Authentication failed" : "Authentication failed: " + errorMsg;
                JOptionPane.showMessageDialog(null, msg, "Error", 0);
                SignerInfo signerInfo = null;
                return signerInfo;
            }
            SignerInfo checkAuth = this.sigInfo = newSigInfo;
            return checkAuth;
        }
        finally {
            if (this.mainWin != null) {
                this.mainWin.signerChanged(this.sigInfo);
            }
            this.txnReviewWindowSignerChanged();
        }
    }

    private void txnReviewWindowSignerChanged() {
        if (this.txnReviewWindow != null) {
            this.txnReviewWindow.signerChanged(this.sigInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AuthenticationInfo getAuthentication(boolean changeAuthentication) {
        if (this.authInfo != null && !changeAuthentication) {
            return this.authInfo;
        }
        try {
            AuthWindow authWin = new AuthWindow(null);
            authWin.setVisible(true);
            AuthenticationInfo tmpAuth = authWin.getAuthentication();
            if (tmpAuth == null) {
                AuthenticationInfo authenticationInfo = changeAuthentication ? null : this.authInfo;
                return authenticationInfo;
            }
            if (this.main.prefs().getBoolean("check_auth", true)) {
                CheckAuthentication checkAuth = new CheckAuthentication(tmpAuth);
                TaskIndicator ti = new TaskIndicator(null);
                ti.invokeTask(checkAuth, "Checking Authentication ...");
                if (checkAuth.wasSuccessful()) {
                    if (tmpAuth instanceof PublicKeyAuthenticationInfo && tmpAuth.getUserIdIndex() == 0 && checkAuth.getIndex() != null) {
                        tmpAuth = new PublicKeyAuthenticationInfo(tmpAuth.getUserIdHandle(), checkAuth.getIndex(), ((PublicKeyAuthenticationInfo)tmpAuth).getPrivateKey());
                    }
                    this.authInfo = tmpAuth;
                    ClientSessionTracker sessionTracker = new ClientSessionTracker();
                    sessionTracker.setSessionSetupInfo(new SessionSetupInfo());
                    this.main.getResolver().setSessionTracker(sessionTracker);
                    AuthenticationInfo authenticationInfo = this.authInfo;
                    return authenticationInfo;
                }
                String errorMsg = checkAuth.getErrorMessage();
                String msg = errorMsg == null ? "Authentication failed" : "Authentication failed: " + errorMsg;
                JOptionPane.showMessageDialog(null, msg, "Error", 0);
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            this.authInfo = tmpAuth;
            ClientSessionTracker sessionTracker = new ClientSessionTracker();
            sessionTracker.setSessionSetupInfo(new SessionSetupInfo());
            this.main.getResolver().setSessionTracker(sessionTracker);
            AuthenticationInfo authenticationInfo = this.authInfo;
            return authenticationInfo;
        }
        finally {
            if (this.mainWin != null) {
                this.mainWin.authenticationChanged(this.authInfo);
            }
            this.txnReviewWindowAuthenticationChanged();
        }
    }

    private void txnReviewWindowAuthenticationChanged() {
        if (this.txnReviewWindow != null) {
            this.txnReviewWindow.authenticationChanged(this.authInfo);
        }
    }

    public synchronized SiteInfo getSpecificSite() {
        return this.specificSite;
    }

    public synchronized boolean getSpecificSiteDoNotRefer() {
        return this.specificSiteDoNotRefer;
    }

    public MainWindow getMainWindow() {
        return this.mainWin;
    }

    @Deprecated
    public TxnReviewWindow getTxnReviewWindow() {
        return this.txnReviewWindow;
    }

    @Deprecated
    public void txnReviewWindowClosed(TxnReviewWindow win) {
        if (this.txnReviewWindow == win) {
            this.txnReviewWindow = null;
        }
    }

    public Main getMain() {
        return this.main;
    }

    public synchronized void go() {
        if (this.mainWin == null) {
            this.mainWin = new MainWindow(this);
        }
        this.mainWin.setVisible(true);
        this.mainWin.toFront();
    }

    public final String getStr(String key) {
        return this.resources.getString(key);
    }

    public ImageIcon getIcon(String iconPath) {
        if (this.imageCache.containsKey(iconPath)) {
            return this.imageCache.get(iconPath);
        }
        try {
            URL imgURL = this.getClass().getResource(iconPath);
            if (imgURL == null) {
                return null;
            }
            Image img = Toolkit.getDefaultToolkit().getImage(imgURL);
            if (img == null) {
                return null;
            }
            ImageIcon icon = new ImageIcon(img);
            this.imageCache.put(iconPath, icon);
            return icon;
        }
        catch (Exception imgURL) {
            if (this.imageCache.containsKey("BLANK")) {
                return this.imageCache.get("BLANK");
            }
            ImageIcon icon = new ImageIcon();
            this.imageCache.put("BLANK", icon);
            return icon;
        }
    }

    synchronized void clearConsole() {
        if (this.consoleWin != null) {
            this.consoleWin = null;
        }
    }

    public synchronized void showConsoleWindow() {
        if (this.consoleWin == null) {
            this.consoleWin = new Console(this);
        }
        this.consoleWin.setVisible(true);
        this.consoleWin.toFront();
    }

    public void shutdown() {
        System.exit(0);
    }

    public synchronized void showHomeUnhomeWindow() {
        HomePrefixWindow hpw = new HomePrefixWindow(this);
        hpw.setVisible(true);
        hpw.toFront();
    }

    public synchronized void showListHandlesWindow() {
        ListHandlesWindow lhw = new ListHandlesWindow(this);
        lhw.setVisible(true);
        lhw.toFront();
    }

    public synchronized void showCheckpointWindow() {
        CheckpointWindow cw = new CheckpointWindow(this);
        cw.setVisible(true);
        cw.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void querySpecificSiteTool(ActionEvent evt) {
        AbstractButton aButton = (AbstractButton)evt.getSource();
        ButtonModel model = aButton.getModel();
        model.isSelected();
        try {
            GetSiteInfoPanel siteInfoPanel = new GetSiteInfoPanel(this, this.getStr("query_specific_site_description"), true);
            int result = JOptionPane.showConfirmDialog(null, siteInfoPanel, this.getStr("query_specific_site"), 2);
            switch (result) {
                case 0: {
                    this.specificSite = siteInfoPanel.getSiteInfo();
                    this.specificSiteDoNotRefer = siteInfoPanel.getDoNotRefer();
                    this.mainWin.setSiteFieldText(this.specificSite, this.specificSiteDoNotRefer);
                    this.getMain().clearHandleCache();
                    break;
                }
            }
            model.setSelected(this.specificSite != null);
        }
        catch (Throwable throwable) {
            model.setSelected(this.specificSite != null);
            throw throwable;
        }
    }

    public synchronized void showBatchProcessor() {
        if (this.batchWin == null || this.batchWin.isRunning()) {
            this.batchWin = new BatchRunnerWindow(this);
        }
        this.batchWin.setVisible(true);
        this.batchWin.toFront();
    }

    public synchronized void openBatchFile() {
        this.showBatchProcessor();
        this.batchWin.addBatchFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeConfigDir() {
        String oldFileDialogProp = System.getProperty("apple.awt.fileDialogForDirectories");
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        try {
            FileDialog fwin = new FileDialog((Frame)this.mainWin, this.ui.getStr("change_config_dir"), 0);
            fwin.setVisible(true);
            String parentStr = fwin.getDirectory();
            String dirStr = fwin.getFile();
            if (parentStr == null || dirStr == null) {
                return;
            }
            String newConfigDir = Paths.get(parentStr, dirStr).toString();
            this.main.setResolverConfigDir(newConfigDir);
            this.mainWin.updateResolverConfigDirLabel(this.main.getResolverConfigDir());
        }
        finally {
            if (null != oldFileDialogProp) {
                System.setProperty("apple.awt.fileDialogForDirectories", oldFileDialogProp);
            } else {
                System.clearProperty("apple.awt.fileDialogForDirectories");
            }
        }
    }

    public JMenuBar getAppMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(new HDLAction(this.ui, "file", null, null));
        menuBar.add(fileMenu);
        JMenu toolsMenu = new JMenu(new HDLAction(this.ui, "tools", null, null));
        menuBar.add(toolsMenu);
        fileMenu.add(this.openBatchFileAction);
        fileMenu.add(this.clearCacheAction);
        fileMenu.add(this.authenticateAction);
        fileMenu.add(this.changeConfigDirAction);
        if (!isMacOSX) {
            fileMenu.addSeparator();
            fileMenu.add(this.shutdownAction);
        }
        toolsMenu.add(this.showBatchAction);
        toolsMenu.add(this.showConsoleAction);
        toolsMenu.add(this.showHomingAction);
        toolsMenu.add(this.showCheckpointAction);
        toolsMenu.add(this.showListHandlesAction);
        toolsMenu.add(new JCheckBoxMenuItem(this.querySpecificSite));
        return menuBar;
    }

    public SiteInfo getSiteInfoFromHost(String hostname, int svrPort) {
        InetAddress svrAddr;
        try {
            svrAddr = InetAddress.getByName(hostname);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, this.ui.getStr("error_retrieve_siteinfo") + "\n\n" + e, this.ui.getStr("error_title"), 0);
            return null;
        }
        GenericRequest siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
        siReq.majorProtocolVersion = (byte)2;
        siReq.minorProtocolVersion = 0;
        siReq.certify = false;
        AbstractResponse response = null;
        HandleResolver resolver = this.ui.getMain().getResolver();
        Throwable error = null;
        int[] preferredProtocols = new int[]{0, 1, 2};
        for (int i = 0; i < preferredProtocols.length; ++i) {
            try {
                switch (preferredProtocols[i]) {
                    case 1: {
                        response = resolver.sendHdlTcpRequest(siReq, svrAddr, svrPort);
                        break;
                    }
                    case 0: {
                        response = resolver.sendHdlUdpRequest(siReq, svrAddr, svrPort);
                        break;
                    }
                    default: {
                        response = resolver.sendHttpRequest(siReq, svrAddr, svrPort);
                    }
                }
                if (response.responseCode != 1) continue;
                return ((GetSiteInfoResponse)response).siteInfo;
            }
            catch (Exception e) {
                error = e;
                System.err.println("Error sending get-site-info request: " + e);
            }
        }
        if (error != null) {
            error.printStackTrace();
            JOptionPane.showMessageDialog(null, this.ui.getStr("error_retrieve_siteinfo") + "\n\n" + error, this.ui.getStr("error_title"), 0);
        } else {
            JOptionPane.showMessageDialog(null, this.ui.getStr("error_retrieve_siteinfo"), this.ui.getStr("error_title"), 0);
        }
        return null;
    }

    private class CheckAuthentication
    implements Runnable {
        private AuthenticationInfo authInfo = null;
        private boolean success = false;
        private String errorMessage = null;
        private Integer index;

        CheckAuthentication(AuthenticationInfo authInfo) {
            this.authInfo = authInfo;
        }

        public boolean wasSuccessful() {
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public Integer getIndex() {
            return this.index;
        }

        @Override
        public void run() {
            this.success = false;
            try {
                AuthenticationUtil authUtil = new AuthenticationUtil(AdminToolUI.this.getMain().getResolver());
                this.success = authUtil.checkAuthentication(this.authInfo);
                this.index = authUtil.getIndex();
            }
            catch (Exception e) {
                this.errorMessage = String.valueOf(e);
                e.printStackTrace(System.err);
            }
        }
    }
}

