/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.controller;

import java.io.File;
import java.security.PublicKey;
import net.cnri.util.StreamTable;
import net.handle.apps.admintool.view.AdminToolUI;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.FilesystemConfiguration;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.MemCache;
import net.handle.hdllib.Resolver;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.RetrieveTxnResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.TransactionCallback;

public class Main {
    private static final String VERSION_STRING = "2.0";
    private Resolver highLevelResolver = null;
    private HandleResolver resolver = null;
    private AdminToolUI ui = null;
    private final File configDir;
    private final File configFile;
    private final StreamTable preferences = new StreamTable();

    public Main() {
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.highLevelResolver = new Resolver();
        this.resolver = this.highLevelResolver.getResolver();
        this.resolver.traceMessages = true;
        this.resolver.setCache(new MemCache());
        this.configDir = this.highLevelResolver.getConfigFile().getParentFile();
        this.configFile = new File(this.configDir, "admin_tool.dict");
        try {
            if (this.configFile.exists()) {
                this.preferences.readFromFile(this.configFile);
            }
        }
        catch (Throwable t) {
            System.err.println("Error reading preferences file: " + t);
        }
    }

    public String getVersion() {
        return VERSION_STRING;
    }

    public HandleResolver getResolver() {
        return this.resolver;
    }

    public String getResolverConfigDir() {
        if (this.resolver.getConfiguration() instanceof FilesystemConfiguration) {
            return ((FilesystemConfiguration)this.resolver.getConfiguration()).getConfigDir().getAbsolutePath();
        }
        return null;
    }

    public void setResolverConfigDir(String newDir) {
        this.resolver.setConfiguration(new FilesystemConfiguration(new File(newDir)));
        this.clearHandleCache();
    }

    public AbstractResponse sendMessage(AbstractRequest req) throws HandleException {
        req.certify = true;
        long start = System.currentTimeMillis();
        SiteInfo site = this.ui.getSpecificSite();
        if (this.ui.getSpecificSiteDoNotRefer()) {
            req.doNotRefer = true;
        }
        AbstractResponse response = site == null ? this.resolver.processRequest(req) : this.resolver.sendRequestToSite(req, site);
        System.err.println("message processed in " + (System.currentTimeMillis() - start) + " ms");
        return response;
    }

    public void clearHandleCache() {
        this.resolver.setCache(new MemCache());
        this.resolver.setCertifiedCache(new MemCache());
    }

    public StreamTable prefs() {
        return this.preferences;
    }

    public void savePreferences() throws Exception {
        this.preferences.writeToFile(this.configFile);
    }

    final synchronized void go() {
        if (this.ui == null) {
            this.ui = new AdminToolUI(this);
        }
        this.ui.go();
    }

    public static void main(String[] argv) {
        Main m = new Main();
        m.go();
    }

    public boolean retrieveHandlesSinceTime(AuthenticationInfo auth, SiteInfo replicationSite, int serverNum, long lastTxnID, long lastDate, TransactionCallback callback) throws HandleException {
        RetrieveTxnRequest req = new RetrieveTxnRequest(lastTxnID, lastDate, 2, 1, 0, auth);
        req.encrypt = false;
        req.certify = true;
        AbstractResponse res = this.resolver.sendRequestToServer((AbstractRequest)req, replicationSite, replicationSite.servers[serverNum]);
        if (res.responseCode == 1) {
            PublicKey pubKey = null;
            try {
                pubKey = replicationSite.servers[serverNum].getPublicKey();
            }
            catch (Exception e) {
                throw new HandleException(8, "Unable to extract public key for replication source: " + e);
            }
            int status = ((RetrieveTxnResponse)res).processStreamedPart(callback, pubKey);
            if (status == 1) {
                return false;
            }
            if (status == 2) {
                return true;
            }
            throw new HandleException(15, "Unknown status code from server during replication: " + status);
        }
        throw new HandleException(15, "Unexpected response to replication request: " + res);
    }
}

