/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.admintool.controller;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;

public final class AuthenticationUtil {
    private final HandleResolver resolver;
    private Integer index;

    public AuthenticationUtil(HandleResolver resolver) {
        this.resolver = resolver;
    }

    public Integer getIndex() {
        return this.index;
    }

    public boolean checkAuthentication(AuthenticationInfo authInfo) throws Exception {
        ResolutionRequest request = new ResolutionRequest(Common.BLANK_HANDLE, null, null, null);
        ChallengeResponse challengeResp = new ChallengeResponse((AbstractRequest)request, true);
        byte[] authBytes = authInfo.authenticate(challengeResp, request);
        if (Util.equals(authInfo.getAuthType(), Common.SECRET_KEY_TYPE)) {
            return this.verifySecretKeyAuth(authInfo, challengeResp, authBytes);
        }
        if (Util.equals(authInfo.getAuthType(), Common.PUBLIC_KEY_TYPE)) {
            return this.verifyPubKeyAuth(authInfo, challengeResp, authBytes);
        }
        throw new HandleException(8, "Unknown authentication type: " + Util.decodeString(authInfo.getAuthType()));
    }

    public boolean verifySecretKeyAuth(AuthenticationInfo authInfo, ChallengeResponse challengeResp, byte[] authBytes) throws HandleException {
        VerifyAuthRequest verifyAuthReq = new VerifyAuthRequest(authInfo.getUserIdHandle(), challengeResp.nonce, challengeResp.requestDigest, challengeResp.rdHashType, authBytes, authInfo.getUserIdIndex(), null);
        verifyAuthReq.certify = true;
        AbstractResponse response = this.resolver.processRequest(verifyAuthReq);
        if (response instanceof VerifyAuthResponse) {
            return ((VerifyAuthResponse)response).isValid;
        }
        throw new HandleException(8, "Unable to verify authentication\n" + response);
    }

    public boolean verifyPubKeyAuth(AuthenticationInfo authInfo, ChallengeResponse challengeResp, byte[] authBytes) throws Exception {
        int[] nArray;
        int userIDIndex = authInfo.getUserIdIndex();
        byte[] byArray = authInfo.getUserIdHandle();
        byte[][] byArray2 = userIDIndex > 0 ? null : Common.PUBLIC_KEY_TYPES;
        if (userIDIndex > 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userIDIndex;
        } else {
            nArray = null;
        }
        ResolutionRequest request = new ResolutionRequest(byArray, byArray2, nArray, null);
        request.certify = true;
        AbstractResponse response = this.resolver.processRequest(request);
        if (!(response instanceof ResolutionResponse)) {
            throw new HandleException(8, "Unable to verify authentication\n" + response);
        }
        HashMap<Integer, PublicKey> pubKeys = new HashMap<Integer, PublicKey>();
        HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
        for (int i = 0; values != null && i < values.length; ++i) {
            HandleValue value = values[i];
            if (value == null || userIDIndex > 0 && userIDIndex != value.getIndex() || !value.hasType(Common.STD_TYPE_HSPUBKEY)) continue;
            pubKeys.put(value.getIndex(), Util.getPublicKeyFromBytes(value.getData(), 0));
        }
        if (pubKeys.size() <= 0) {
            throw new HandleException(8, "No public key found for the given authentication " + authInfo);
        }
        int offset = 0;
        byte[] hashAlgId = Encoder.readByteArray(authBytes, offset);
        byte[] sigBytes = Encoder.readByteArray(authBytes, offset += 4 + hashAlgId.length);
        offset += 4 + sigBytes.length;
        for (Map.Entry entry : pubKeys.entrySet()) {
            int index = (Integer)entry.getKey();
            PublicKey pubkey = (PublicKey)entry.getValue();
            if (pubkey instanceof DSAPublicKey) {
                if (!this.verifyDSAPublicKey(hashAlgId, pubkey, challengeResp, sigBytes)) continue;
                this.index = index;
                return true;
            }
            if (!(pubkey instanceof RSAPublicKey) || !this.verifyRSAPublicKeyImpl(hashAlgId, pubkey, challengeResp, sigBytes)) continue;
            this.index = index;
            return true;
        }
        return false;
    }

    public boolean verifyDSAPublicKey(byte[] hashAlgId, PublicKey pubKey, ChallengeResponse challengeResp, byte[] sigBytes) throws Exception {
        try {
            String sigId = Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm());
            Signature sig = Signature.getInstance(sigId);
            sig.initVerify(pubKey);
            sig.update(challengeResp.nonce);
            sig.update(challengeResp.requestDigest);
            return sig.verify(sigBytes);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public boolean verifyRSAPublicKeyImpl(byte[] hashAlgId, PublicKey pubKey, ChallengeResponse challengeResp, byte[] sigBytes) throws Exception {
        String sigId = Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm());
        Signature sig = Signature.getInstance(sigId);
        sig.initVerify(pubKey);
        sig.update(challengeResp.nonce);
        sig.update(challengeResp.requestDigest);
        return sig.verify(sigBytes);
    }
}

