/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.AttributeListJPanel;
import net.handle.apps.gui.jwidget.DataListJPanel;
import net.handle.apps.gui.jwidget.ServerInfoJPanel;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SiteInfoJPanel
extends JPanel
implements ActionListener {
    protected JTextField dataVersionField;
    protected JTextField majorProtocolField;
    protected JTextField minorProtocolField;
    protected JTextField serialNumberField;
    protected JCheckBox isPrimaryCheckbox;
    protected JCheckBox multiplePrimaryCheckbox;
    protected JComboBox hashOptionChoice;
    protected MyButton saveButton;
    protected MyButton loadButton;
    protected MyButton naButton;
    protected JPanel setPanel;
    protected JPanel savePanel;
    protected ServerList serverList;
    protected AttributeListJPanel attriList;
    protected SiteInfo siteInfo;
    protected boolean editFlag;

    public SiteInfoJPanel(boolean editFlag) {
        this.editFlag = editFlag;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        EtchedBorder etchBorder = new EtchedBorder();
        this.dataVersionField = new JTextField("1", 5);
        this.dataVersionField.setEditable(false);
        this.majorProtocolField = new JTextField("5", 3);
        this.majorProtocolField.setToolTipText("Major Protocol type, default value is 5");
        this.majorProtocolField.setEditable(editFlag);
        this.minorProtocolField = new JTextField("0", 3);
        this.minorProtocolField.setToolTipText("Minor Protocol type, default value is 0");
        this.minorProtocolField.setEditable(editFlag);
        this.serialNumberField = new JTextField("1", 5);
        this.serialNumberField.setToolTipText("increased by 1, whenever change the site information");
        this.serialNumberField.setEditable(editFlag);
        this.isPrimaryCheckbox = new JCheckBox("Primary Site", false);
        this.isPrimaryCheckbox.setToolTipText("Check to select the site as primary site, otherwise replication site");
        this.isPrimaryCheckbox.setEnabled(editFlag);
        this.multiplePrimaryCheckbox = new JCheckBox("Multiple Primary Sites", false);
        this.multiplePrimaryCheckbox.setToolTipText("Check to indicate that multiple sites may support administrative requests.");
        this.multiplePrimaryCheckbox.setEnabled(editFlag);
        this.hashOptionChoice = new JComboBox();
        this.hashOptionChoice.setToolTipText(" Choose the function to hash handles");
        this.hashOptionChoice.setEditable(false);
        this.hashOptionChoice.setEnabled(editFlag);
        this.hashOptionChoice.addItem("By Prefix");
        this.hashOptionChoice.addItem("By Local Name");
        this.hashOptionChoice.addItem("By Entire Handle");
        this.hashOptionChoice.setSelectedIndex(2);
        this.setPanel = new JPanel(gridbag);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(2, 2, 2, 2);
        this.setPanel.add((Component)new JLabel("Data Version: ", 2), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)this.dataVersionField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)insets, (int)17, (boolean)false, (boolean)true));
        this.setPanel.add((Component)new JLabel("Protocol: ", 2), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)this.majorProtocolField, AwtUtil.getConstraints((int)(x + 1), (int)y, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)this.minorProtocolField, AwtUtil.getConstraints((int)(x + 2), (int)y++, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)new JLabel("Serial #: ", 2), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)this.serialNumberField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (Insets)insets, (int)17, (boolean)false, (boolean)true));
        this.setPanel.add((Component)this.isPrimaryCheckbox, AwtUtil.getConstraints((int)(x + 1), (int)y, (double)0.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)this.multiplePrimaryCheckbox, AwtUtil.getConstraints((int)(x + 3), (int)y++, (double)0.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)new JLabel("Hash: ", 2), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.setPanel.add((Component)this.hashOptionChoice, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.serverList = new ServerList();
        this.serverList.setBorder(new TitledBorder(etchBorder, " Servers: "));
        this.attriList = new AttributeListJPanel(editFlag);
        this.attriList.setBorder(new TitledBorder(etchBorder, " Attributes: "));
        this.saveButton = new MyButton("Save To File", "Save current data");
        this.loadButton = new MyButton("Load From File", "Load data from file");
        this.naButton = new MyButton("Load From NA", "Load data from NA handle");
        this.saveButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.naButton.addActionListener(this);
        this.savePanel = new JPanel(gridbag);
        this.savePanel.add((Component)this.saveButton, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        this.savePanel.add((Component)this.naButton, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        this.savePanel.add((Component)this.loadButton, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        this.siteInfo = new SiteInfo();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Save To File")) {
            this.saveToFile();
        } else if (ae.getActionCommand().equals("Load From File")) {
            this.loadFromFile();
        } else if (ae.getActionCommand().equals("Load From NA")) {
            this.loadFromNA();
        }
    }

    public void setSiteInfo(SiteInfo site) {
        if (site == null) {
            System.err.println("error message: not siteinfo in the SiteInfoJPanel");
            return;
        }
        try {
            int i;
            this.dataVersionField.setText(String.valueOf(site.dataFormatVersion));
            this.majorProtocolField.setText(String.valueOf(site.majorProtocolVersion));
            this.minorProtocolField.setText(String.valueOf(site.minorProtocolVersion));
            this.serialNumberField.setText(String.valueOf(site.serialNumber));
            this.isPrimaryCheckbox.setSelected(site.isPrimary);
            this.multiplePrimaryCheckbox.setSelected(site.multiPrimary);
            this.hashOptionChoice.setSelectedIndex(site.hashOption);
            this.serverList.clearAll();
            if (site.servers != null) {
                for (i = 0; i < site.servers.length; ++i) {
                    this.serverList.appendItem(site.servers[i]);
                }
            }
            this.attriList.clearAll();
            if (site.attributes != null) {
                for (i = 0; i < site.attributes.length; ++i) {
                    this.attriList.appendItem(site.attributes[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public int getDataVersion() {
        try {
            return Integer.parseInt(this.dataVersionField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public byte getMajorProtocol() {
        try {
            return (byte)Integer.parseInt(this.majorProtocolField.getText().trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public byte getMinorProtocol() {
        try {
            return (byte)Integer.parseInt(this.minorProtocolField.getText().trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getSerialNumber() {
        try {
            return Integer.parseInt(this.serialNumberField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public SiteInfo getSiteInfo() {
        try {
            int i;
            this.siteInfo.dataFormatVersion = this.getDataVersion();
            this.siteInfo.majorProtocolVersion = this.getMajorProtocol();
            this.siteInfo.minorProtocolVersion = this.getMinorProtocol();
            this.siteInfo.serialNumber = this.getSerialNumber();
            this.siteInfo.isPrimary = this.isPrimaryCheckbox.isSelected();
            this.siteInfo.multiPrimary = this.multiplePrimaryCheckbox.isSelected();
            this.siteInfo.hashOption = (byte)this.hashOptionChoice.getSelectedIndex();
            Vector v = this.serverList.getItems();
            if (v != null) {
                this.siteInfo.servers = new ServerInfo[v.size()];
                for (i = 0; i < v.size(); ++i) {
                    this.siteInfo.servers[i] = (ServerInfo)v.elementAt(i);
                }
            }
            if ((v = this.attriList.getItems()) != null) {
                this.siteInfo.attributes = new Attribute[v.size()];
                for (i = 0; i < v.size(); ++i) {
                    this.siteInfo.attributes[i] = (Attribute)v.elementAt(i);
                }
            }
            return this.siteInfo;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    protected void saveToFile() {
        SiteInfo site = this.getSiteInfo();
        if (site == null) {
            System.err.println("No data to save");
            return;
        }
        BrowsePanel browser = new BrowsePanel("Save Path: ", (File)null, "", null, true);
        if (2 == JOptionPane.showConfirmDialog(null, browser, "Save Site info :", 2, -1)) {
            return;
        }
        File[] files = new File[1];
        FileOutputStream out = null;
        if (!browser.getWriteFile(files)) {
            System.err.println("warning message: Save path is not correct");
            return;
        }
        try {
            out = new FileOutputStream(files[0]);
            byte[] buffer = Encoder.encodeSiteInfoRecord((SiteInfo)site);
            out.write(buffer);
            out.close();
            out = null;
        }
        catch (Exception e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            e.printStackTrace(System.err);
        }
    }

    protected void loadFromNA() {
        String na = JOptionPane.showInputDialog(this, (Object)"Load NA Site Info");
        if (na == null) {
            return;
        }
        try {
            String[] s = new String[]{"HS_SITE"};
            HandleValue[] v = new HandleResolver().resolveHandle(na, s, null);
            if (v == null || v.length == 0) {
                throw new Exception("HS_SITE not found.");
            }
            SiteInfo site = new SiteInfo();
            Encoder.decodeSiteInfoRecord((byte[])v[0].getData(), (int)0, (SiteInfo)site);
            this.setSiteInfo(site);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Can't load NA " + na + ": " + e, "Error", 0);
        }
    }

    protected void loadFromFile() {
        BrowsePanel browser = new BrowsePanel("Open Path: ", (File)null, "", null, false);
        if (2 == JOptionPane.showConfirmDialog(null, browser, "Load Site info :", 2, -1)) {
            return;
        }
        File[] files = new File[1];
        if (!browser.getReadFile(files)) {
            System.err.println("warning message: Load path is not correct");
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(files[0]);
            byte[] buffer = new byte[(int)files[0].length()];
            int r = 0;
            for (int n = 0; n < buffer.length && (r = in.read(buffer, n, buffer.length - n)) >= 0; n += r) {
            }
            in.close();
            SiteInfo site = new SiteInfo();
            if (Util.looksLikeBinary((byte[])buffer)) {
                Encoder.decodeSiteInfoRecord((byte[])buffer, (int)0, (SiteInfo)site);
            } else {
                site = SiteInfoConverter.convertToSiteInfo((String)new String(buffer, "UTF-8"));
            }
            this.setSiteInfo(site);
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            e.printStackTrace(System.err);
        }
    }

    class ServerList
    extends DataListJPanel {
        ServerList() {
            int x = 0;
            int y = 0;
            GridBagLayout gridbag = new GridBagLayout();
            this.buttonPanel = new JPanel(gridbag);
            if (SiteInfoJPanel.this.editFlag) {
                this.buttonPanel.add((Component)this.addItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
                this.buttonPanel.add((Component)this.editItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
                this.buttonPanel.add((Component)this.remItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
                this.buttonPanel.add((Component)this.clearButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            }
            this.buttonPanel.add((Component)this.viewItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)SiteInfoJPanel.this.editFlag));
            this.add((Component)this.pane, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)2, (int)10, (boolean)true, (boolean)true));
            this.add((Component)this.buttonPanel, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)8, (boolean)true, (boolean)true));
        }

        @Override
        protected Object addData() {
            ServerInfoJPanel p = new ServerInfoJPanel(true);
            if (2 == JOptionPane.showConfirmDialog(null, p, " Add Server: ", 2, -1)) {
                return null;
            }
            return p.getServerInfo();
        }

        @Override
        protected Object modifyData(int ind) {
            ServerInfo server = (ServerInfo)this.items.elementAt(ind);
            ServerInfoJPanel p = new ServerInfoJPanel(true);
            p.setServerInfo(server);
            if (2 == JOptionPane.showConfirmDialog(null, p, " Modify Server: ", 2, -1)) {
                return null;
            }
            return p.getServerInfo();
        }

        @Override
        protected boolean removeData(int ind) {
            return true;
        }

        @Override
        protected void viewData(int ind) {
            ServerInfo server = (ServerInfo)this.items.elementAt(ind);
            ServerInfoJPanel p = new ServerInfoJPanel(false);
            p.setServerInfo(server);
            JOptionPane.showMessageDialog(this, p, "View Server: ", -1);
        }
    }
}

