/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.handle.apps.gui.jutil.HDLToolConfig;
import net.handle.awt.AwtUtil;

public class SecretKeyJPanel
extends JPanel {
    private final JTextField userIdHandleField;
    private final JTextField userIdIndexField;
    private final JPasswordField passwordField;
    private final JCheckBox hashedPassBox;

    public SecretKeyJPanel() {
        super(new GridBagLayout());
        String s = HDLToolConfig.table.getStr((Object)"SecIndex", "300");
        this.userIdIndexField = new JTextField("300", 5);
        this.userIdIndexField.setToolTipText("Input handle value index");
        s = HDLToolConfig.table.getStr((Object)"SecHandle", "");
        this.userIdHandleField = new JTextField(s, 25);
        this.userIdHandleField.setScrollOffset(0);
        this.userIdHandleField.setToolTipText("Input handle name");
        this.passwordField = new JPasswordField("", 30);
        this.passwordField.setScrollOffset(0);
        this.passwordField.setToolTipText("Input the secret key");
        this.hashedPassBox = new JCheckBox("Use SHA-1 hash of password", HDLToolConfig.table.getBoolean((Object)"ShadowPass", false));
        int x = 0;
        int y = 0;
        this.add((Component)new JLabel(" ID Handle: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.userIdHandleField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        this.add((Component)new JLabel(" ID Index: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.userIdIndexField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)0.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(1, 1, 1, 30), (int)17, (boolean)false, (boolean)false));
        this.add((Component)new JLabel(" Secret Key: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.passwordField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)0.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.hashedPassBox, AwtUtil.getConstraints((int)(x + 1), (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
    }

    public void setUserIdHandle(String newHandle) {
        this.userIdHandleField.setText(newHandle);
    }

    public void setUserIdIndex(int newIndex) {
        this.userIdIndexField.setText(String.valueOf(newIndex));
    }

    public String getUserIdHandle() {
        return this.userIdHandleField.getText().trim();
    }

    public int getUserIdIndex() {
        try {
            return Integer.parseInt(this.userIdIndexField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public char[] getSecretKey() {
        return this.passwordField.getPassword();
    }

    public String getSecretKeyStr() {
        return new String(this.passwordField.getPassword());
    }

    public boolean isHashedPasswordEnabled() {
        return this.hashedPassBox.isSelected();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Container c = f.getContentPane();
        c.add(new SecretKeyJPanel());
        f.setSize(500, 500);
        f.pack();
        f.setVisible(true);
    }
}

