/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.jutil.CommonDef;
import net.handle.apps.gui.jwidget.ValueRefListJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValueEntryJPanel
extends JPanel {
    protected JTextField indexField;
    protected JComboBox typeField;
    protected JComboBox ttlTypeChoice;
    protected JTextField ttlField;
    protected JTextField timestampField;
    protected JCheckBox adminReadCheckbox;
    protected JCheckBox adminWriteCheckbox;
    protected JCheckBox publicReadCheckbox;
    protected JCheckBox publicWriteCheckbox;
    protected ValueRefListJPanel referenceList;
    protected JPanel panel1;
    protected JPanel panel2;
    protected JPanel panel3;
    protected HandleValue handlevalue = null;

    public HandleValueEntryJPanel(boolean editFlag) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.indexField = new JTextField("", 5);
        this.indexField.setEditable(editFlag);
        this.ttlTypeChoice = new JComboBox();
        this.ttlTypeChoice.setToolTipText("Time_TO_Live of the have value");
        this.ttlTypeChoice.setEditable(false);
        this.ttlTypeChoice.setEnabled(editFlag);
        this.ttlTypeChoice.addItem("Relative");
        this.ttlTypeChoice.addItem("Absolute");
        this.ttlField = new JTextField("86400", 10);
        this.ttlField.setToolTipText("Input the Alive time");
        this.ttlField.setEditable(editFlag);
        this.timestampField = new JTextField("", 20);
        this.timestampField.setEditable(editFlag);
        this.adminReadCheckbox = new JCheckBox("Admin Read", true);
        this.adminReadCheckbox.setToolTipText("check to allow admin read");
        this.adminReadCheckbox.setEnabled(editFlag);
        this.adminWriteCheckbox = new JCheckBox("Admin Write", true);
        this.adminWriteCheckbox.setToolTipText("check to allow admin write");
        this.adminWriteCheckbox.setEnabled(editFlag);
        this.publicReadCheckbox = new JCheckBox("Public Read", true);
        this.publicReadCheckbox.setToolTipText("check to allow public read");
        this.publicReadCheckbox.setEnabled(editFlag);
        this.publicWriteCheckbox = new JCheckBox("Public Write", false);
        this.publicWriteCheckbox.setToolTipText("check to allow public write");
        this.publicWriteCheckbox.setEnabled(editFlag);
        this.referenceList = new ValueRefListJPanel(editFlag);
        this.typeField = new JComboBox();
        this.typeField.setToolTipText("Handle Value Type");
        this.typeField.setEditable(true);
        this.typeField.setEnabled(editFlag);
        for (int i = 0; i < CommonDef.DATA_TYPE_STR.length; ++i) {
            this.typeField.addItem(CommonDef.DATA_TYPE_STR[i]);
        }
        this.panel1 = new JPanel(gridbag);
        this.panel2 = new JPanel(gridbag);
        this.panel3 = new JPanel(gridbag);
        int x = 0;
        int y = 0;
        this.panel1.add((Component)new JLabel("Index:", 4), AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 10, 1, 5), (int)17, (boolean)true, (boolean)true));
        this.panel1.add((Component)this.indexField, AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)false, (boolean)true));
        this.panel1.add((Component)new JLabel(" Type:", 4), AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 20, 1, 0), (int)13, (boolean)false, (boolean)true));
        this.panel1.add((Component)this.typeField, AwtUtil.getConstraints((int)x++, (int)y, (double)1.0, (double)0.0, (int)1, (int)1, (boolean)false, (boolean)true));
        x = 0;
        y = 0;
        this.panel2.add((Component)new JLabel(" TTL:", 4), AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 10, 1, 5), (int)17, (boolean)true, (boolean)true));
        this.panel2.add((Component)this.ttlTypeChoice, AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.panel2.add((Component)this.ttlField, AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.panel2.add((Component)new JLabel(" Timestamp:", 4), AwtUtil.getConstraints((int)x++, (int)y, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 20, 1, 0), (int)13, (boolean)true, (boolean)true));
        this.panel2.add((Component)this.timestampField, AwtUtil.getConstraints((int)x++, (int)y, (double)1.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 5, 1, 10), (int)17, (boolean)true, (boolean)true));
        x = 0;
        y = 0;
        JPanel tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)new JLabel(" Permissions:", 0), AwtUtil.getConstraints((int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.adminReadCheckbox, AwtUtil.getConstraints((int)0, (int)1, (double)1.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 5), (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.adminWriteCheckbox, AwtUtil.getConstraints((int)1, (int)1, (double)1.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 5, 10, 10), (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.publicReadCheckbox, AwtUtil.getConstraints((int)0, (int)2, (double)1.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 5), (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.publicWriteCheckbox, AwtUtil.getConstraints((int)1, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 5, 10, 10), (boolean)true, (boolean)true));
        this.panel3.add((Component)tmpPanel, AwtUtil.getConstraints((int)x++, (int)y, (double)1.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        tmpPanel = new JPanel(gridbag);
        tmpPanel.add((Component)new JLabel(" References:", 0), AwtUtil.getConstraints((int)0, (int)0, (double)0.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        tmpPanel.add((Component)this.referenceList, AwtUtil.getConstraints((int)0, (int)1, (double)1.0, (double)0.0, (int)1, (int)5, (boolean)true, (boolean)true));
        int n = ++x;
        ++x;
        this.panel3.add((Component)tmpPanel, AwtUtil.getConstraints((int)n, (int)y, (double)1.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)17, (boolean)true, (boolean)true));
        this.add((Component)this.panel1, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)0.0, (int)3, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)17, (boolean)false, (boolean)true));
        this.add((Component)this.panel2, AwtUtil.getConstraints((int)0, (int)1, (double)1.0, (double)1.0, (int)4, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        this.add((Component)this.panel3, AwtUtil.getConstraints((int)0, (int)2, (double)1.0, (double)0.0, (int)4, (int)1, (Insets)new Insets(10, 10, 10, 10), (boolean)true, (boolean)true));
        this.handlevalue = new HandleValue();
        this.handlevalue.setIndex(-1);
        this.handlevalue.setData(Common.EMPTY_BYTE_ARRAY);
        this.handlevalue.setTimestamp((int)(System.currentTimeMillis() / 1000L));
        this.timestampField.setText(new Date((long)this.handlevalue.getTimestamp() * 1000L).toString());
    }

    public void setHandleValue(HandleValue value) {
        this.setIndex(value.getIndex());
        this.typeField.setSelectedItem(Util.decodeString((byte[])value.getType()));
        switch (value.getTTLType()) {
            case 1: {
                this.ttlTypeChoice.setSelectedIndex(1);
                break;
            }
            case 0: {
                this.ttlTypeChoice.setSelectedIndex(0);
            }
        }
        this.ttlField.setText(String.valueOf(value.getTTL()));
        this.timestampField.setText(new Date((long)value.getTimestamp() * 1000L).toString());
        this.adminReadCheckbox.setSelected(value.getAdminCanRead());
        this.adminWriteCheckbox.setSelected(value.getAdminCanWrite());
        this.publicReadCheckbox.setSelected(value.getAnyoneCanRead());
        this.publicWriteCheckbox.setSelected(value.getAnyoneCanWrite());
        ValueReference[] refs = value.getReferences();
        this.referenceList.clearAll();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                this.referenceList.appendItem(refs[i]);
            }
        }
        this.handlevalue.setTimestamp(value.getTimestamp());
        this.handlevalue.setType(value.getType());
        this.handlevalue.setData(value.getData());
    }

    public void setIndex(int index) {
        this.indexField.setText(String.valueOf(index));
    }

    public HandleValue getHandleValue() {
        this.handlevalue.setIndex(this.getIndex());
        try {
            this.handlevalue.setTTL(Integer.parseInt(this.ttlField.getText().trim()));
            if (this.ttlTypeChoice.getSelectedIndex() == 0) {
                this.handlevalue.setTTLType((byte)0);
            } else {
                this.handlevalue.setTTLType((byte)1);
            }
        }
        catch (Exception e) {
            this.handlevalue.setTTL(-1);
        }
        this.handlevalue.setAdminCanRead(this.adminReadCheckbox.isSelected());
        this.handlevalue.setAdminCanWrite(this.adminWriteCheckbox.isSelected());
        this.handlevalue.setAnyoneCanRead(this.publicReadCheckbox.isSelected());
        this.handlevalue.setAnyoneCanWrite(this.publicWriteCheckbox.isSelected());
        Vector v = this.referenceList.getItems();
        if (v != null) {
            ValueReference[] vr = new ValueReference[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                vr[i] = (ValueReference)v.elementAt(i);
            }
            this.handlevalue.setReferences(vr);
        }
        return this.handlevalue;
    }

    public int getIndex() {
        try {
            return Integer.parseInt(this.indexField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }
}

