/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jutil.MyRadioButton;
import net.handle.apps.gui.jutil.PasswordPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Util;

public class GenerateKeyJPanel
extends JPanel
implements ActionListener {
    protected BrowsePanel privkeyPanel;
    protected BrowsePanel pubkeyPanel;
    protected JComboBox algField;
    protected JTextField lenField;
    protected ButtonGroup bgroup;
    protected MyRadioButton encryptButton;
    protected MyRadioButton nocryptButton;
    protected KeyPair currentKeys;
    protected MyButton genButton;
    protected MyButton cancelButton;
    protected Thread genThread = null;

    public GenerateKeyJPanel() {
        this(new File(""));
    }

    public GenerateKeyJPanel(File dir) {
        this(dir, "pubkey.bin", "privkey.bin");
    }

    public GenerateKeyJPanel(File dir, String pubKeyFile, String privKeyFile) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setBorder(new EtchedBorder());
        this.privkeyPanel = new BrowsePanel("privkey file: ", dir, File.separator + privKeyFile, null, true);
        this.pubkeyPanel = new BrowsePanel("pubkey file: ", dir, File.separator + pubKeyFile, null, true);
        this.algField = new JComboBox();
        this.algField.setToolTipText("Choose Algorithm to generate key pair");
        this.algField.setEditable(false);
        this.algField.addItem("RSA");
        this.algField.addItem("DSA");
        this.algField.addActionListener(this);
        this.lenField = new JTextField("1024", 5);
        this.lenField.setToolTipText("Input the strength length of your key pair");
        JPanel p = new JPanel(gridbag);
        this.encryptButton = new MyRadioButton("Encrypt", "Encrypt the privkey file");
        this.nocryptButton = new MyRadioButton("Do not encrypt", "Do not encrypt privkey file");
        this.encryptButton.setSelected(true);
        this.bgroup = new ButtonGroup();
        this.bgroup.add(this.encryptButton);
        this.bgroup.add(this.nocryptButton);
        p.add((Component)this.encryptButton, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(2, 25, 1, 5), (boolean)true, (boolean)true));
        p.add((Component)this.nocryptButton, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(2, 5, 1, 25), (boolean)true, (boolean)true));
        JPanel p1 = new JPanel(gridbag);
        this.genButton = new MyButton("GenKeys", "click to begin the process");
        this.cancelButton = new MyButton("Cancel", "click to cancel the process");
        this.genButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(false);
        p1.add((Component)this.genButton, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(1, 15, 5, 15), (boolean)true, (boolean)true));
        p1.add((Component)this.cancelButton, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(1, 15, 5, 15), (boolean)true, (boolean)true));
        int x = 0;
        int y = 0;
        this.add((Component)this.privkeyPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)5, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.pubkeyPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)5, (int)1, (boolean)true, (boolean)true));
        this.add((Component)new JLabel("Algorithm: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.algField, AwtUtil.getConstraints((int)(x + 1), (int)y, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)new JLabel("Strength: ", 4), AwtUtil.getConstraints((int)(x + 3), (int)y, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)this.lenField, AwtUtil.getConstraints((int)(x + 4), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.add((Component)p, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)3, (int)1, (boolean)true, (boolean)true));
        this.add((Component)p1, AwtUtil.getConstraints((int)(x + 1), (int)y, (double)1.0, (double)1.0, (int)3, (int)1, (boolean)true, (boolean)true));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("GenKeys")) {
            this.genKeys();
        } else if (ae.getActionCommand().equals("Cancel")) {
            this.cancelProcess();
        } else if (ae.getSource() == this.algField) {
            this.algFieldSelected();
        }
    }

    public boolean isEncrypt() {
        return this.bgroup.getSelection().getActionCommand().equals("Encrypt");
    }

    public String getAlg() {
        return (String)this.algField.getSelectedItem();
    }

    public boolean getWritePubkeyFile(File[] files) {
        return this.pubkeyPanel.getWriteFile(files);
    }

    public boolean getWritePrivkeyFile(File[] files) {
        return this.privkeyPanel.getWriteFile(files);
    }

    public String getPubkeyFile() {
        return this.pubkeyPanel.getPath();
    }

    public String getPrivkeyFile() {
        return this.privkeyPanel.getPath();
    }

    public int getStrength() {
        try {
            return Integer.parseInt(this.lenField.getText().trim());
        }
        catch (Exception e) {
            return 1024;
        }
    }

    public boolean getPassPhrase(String[] passPhrase) {
        while (!PasswordPanel.show(passPhrase)) {
            if (passPhrase[0] != null) continue;
            return false;
        }
        return true;
    }

    public PublicKey getCurrentPublicKey() {
        if (this.currentKeys == null) {
            return null;
        }
        return this.currentKeys.getPublic();
    }

    public PrivateKey getCurrentPrivateKey() {
        if (this.currentKeys == null) {
            return null;
        }
        return this.currentKeys.getPrivate();
    }

    public void genKeys() {
        File[] files = new File[1];
        if (!this.getWritePubkeyFile(files)) {
            return;
        }
        File pubKeyFile = files[0];
        if (!this.getWritePrivkeyFile(files)) {
            return;
        }
        File privKeyFile = files[0];
        String[] password = new String[1];
        if (this.isEncrypt() && !this.getPassPhrase(password)) {
            return;
        }
        this.genButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        final String passPhrase = password[0];
        final boolean encrypt = this.isEncrypt();
        final File pubf = pubKeyFile;
        final File privf = privKeyFile;
        final String alg = this.getAlg();
        final int len = this.getStrength();
        Runnable r1 = new Runnable(){

            @Override
            public void run() {
                GenerateKeyJPanel.this.generateProcess(passPhrase, encrypt, pubf, privf, alg, len);
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        GenerateKeyJPanel.this.genButton.setEnabled(true);
                        GenerateKeyJPanel.this.cancelButton.setEnabled(false);
                    }
                };
                SwingUtilities.invokeLater(r2);
            }
        };
        this.genThread = new Thread(r1);
        this.genThread.start();
    }

    protected void generateProcess(String passPhrase, boolean encryptFlag, File pubKeyFile, File privKeyFile, String alg, int strength) {
        System.err.println("generate key message: Generating key pair now, wait please...");
        FileOutputStream out = null;
        try {
            KeyPair currentKeys = null;
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(alg);
            kpg.initialize(strength);
            currentKeys = kpg.generateKeyPair();
            if (currentKeys == null) {
                return;
            }
            System.err.println("generate key message: Save public key");
            PublicKey publicKey = currentKeys.getPublic();
            out = new FileOutputStream(pubKeyFile);
            out.write(Util.getBytesFromPublicKey((PublicKey)publicKey));
            out.close();
            PrivateKey privateKey = currentKeys.getPrivate();
            out = new FileOutputStream(privKeyFile);
            byte[] privKeyBytes = null;
            privKeyBytes = encryptFlag ? Util.encrypt((byte[])Util.getBytesFromPrivateKey((PrivateKey)privateKey), (byte[])Util.encodeString((String)passPhrase)) : Util.encrypt((byte[])Util.getBytesFromPrivateKey((PrivateKey)privateKey), null, (int)1);
            out.write(privKeyBytes);
            out.close();
            System.err.println("generate key message: Finished generating keys.");
            JOptionPane.showMessageDialog(this, "Finished generating keys", " Message ", 1);
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(this, "Generating keys failed.", " Message ", 2);
            return;
        }
    }

    public void algFieldSelected() {
        this.lenField.setText("1024");
    }

    protected void cancelProcess() {
        if (this.genThread == null) {
            return;
        }
        this.genThread.stop();
        JOptionPane.showMessageDialog(this, "Generating keys", " Cancel: ", 1);
        this.genButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
    }
}

