/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.HandleValueEntryJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ValueReference;

public abstract class GenDataJPanel
extends JPanel
implements ActionListener {
    protected JTextField indexField;
    protected MyButton moreButton;
    protected JPanel panel;
    protected HandleValue handlevalue;
    protected boolean moreFlag = true;
    protected boolean editFlag = true;

    public abstract void setValueData(byte[] var1);

    public abstract byte[] getValueData();

    public GenDataJPanel(boolean moreFlag, boolean editFlag, int index) {
        this(moreFlag, editFlag, String.valueOf(index));
    }

    public GenDataJPanel(boolean moreFlag, boolean editFlag, String indStr) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.moreFlag = moreFlag;
        this.editFlag = editFlag;
        if (moreFlag) {
            this.indexField = new JTextField(indStr, 5);
            this.indexField.setToolTipText("Input handle value index");
            this.indexField.setEditable(editFlag);
            this.moreButton = new MyButton("More", "Edit detail");
            this.moreButton.addActionListener(this);
            this.moreButton.setEnabled(moreFlag);
            JPanel p1 = new JPanel(gridbag);
            p1.add((Component)new JLabel(" Index: ", 4), AwtUtil.getConstraints((int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 1, 1, 1), (int)17, (boolean)true, (boolean)true));
            p1.add((Component)this.indexField, AwtUtil.getConstraints((int)1, (int)0, (double)0.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(1, 1, 1, 1), (int)17, (boolean)false, (boolean)false));
            p1.add((Component)this.moreButton, AwtUtil.getConstraints((int)2, (int)0, (double)0.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(1, 1, 10, 50), (boolean)false, (boolean)false));
            this.add((Component)p1, AwtUtil.getConstraints((int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (Insets)new Insets(1, 1, 1, 1), (int)17, (boolean)true, (boolean)true));
        }
        this.panel = new JPanel(gridbag);
        this.add((Component)this.panel, AwtUtil.getConstraints((int)0, (int)1, (double)0.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.handlevalue = new HandleValue();
        this.handlevalue.setIndex(-1);
        this.handlevalue.setTimestamp((int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("More")) {
            this.more();
        } else {
            System.err.println("Error Input");
        }
    }

    protected void more() {
        HandleValueEntryJPanel hvp = new HandleValueEntryJPanel(this.editFlag);
        this.handlevalue.setIndex(this.getIndex());
        hvp.setHandleValue(this.handlevalue);
        if (2 == JOptionPane.showConfirmDialog(null, hvp, "Handle Value: ", 2, -1)) {
            return;
        }
        this.handlevalue = hvp.getHandleValue();
        this.indexField.setText(Integer.toString(this.handlevalue.getIndex()));
    }

    public void setIndex(int newIndex) {
        this.indexField.setText(String.valueOf(newIndex));
    }

    public void setHandleValue(HandleValue value) {
        if (value == null) {
            return;
        }
        if (this.moreFlag) {
            this.setIndex(value.getIndex());
        }
        this.handlevalue.setTTL(value.getTTL());
        this.handlevalue.setTTLType(value.getTTLType());
        this.handlevalue.setTimestamp(value.getTimestamp());
        this.handlevalue.setAdminCanRead(value.getAdminCanRead());
        this.handlevalue.setAdminCanWrite(value.getAdminCanWrite());
        this.handlevalue.setAnyoneCanRead(value.getAnyoneCanRead());
        this.handlevalue.setAnyoneCanWrite(value.getAnyoneCanWrite());
        ValueReference[] refs = value.getReferences();
        if (refs != null) {
            ValueReference[] newRefs = new ValueReference[refs.length];
            System.arraycopy(refs, 0, newRefs, 0, refs.length);
            this.handlevalue.setReferences(newRefs);
        } else {
            this.handlevalue.setReferences(null);
        }
        this.handlevalue.setData(value.getData());
        this.setValueData(this.handlevalue.getData());
    }

    public int getIndex() {
        try {
            return Integer.parseInt(this.indexField.getText().trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public HandleValue getHandleValue() {
        if (this.moreFlag) {
            this.handlevalue.setIndex(this.getIndex());
        }
        this.handlevalue.setData(this.getValueData());
        return this.handlevalue;
    }
}

