/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.handle.apps.gui.jwidget.GenDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.Common;
import net.handle.hdllib.Util;

public class CustomDataJPanel
extends GenDataJPanel
implements ComponentListener {
    protected JTextArea textArea = new JTextArea();
    protected JScrollPane scroll = new JScrollPane(this.textArea, 20, 30);

    public CustomDataJPanel(byte[] type, boolean moreFlag, boolean editFlag) {
        this(type, moreFlag, editFlag, 0);
    }

    public CustomDataJPanel(byte[] type, boolean moreFlag, boolean editFlag, int index) {
        super(moreFlag, editFlag, index);
        String labelStr = " " + Util.decodeString((byte[])type) + ": ";
        this.textArea.setEditable(editFlag);
        this.scroll.setPreferredSize(new Dimension(800, 400));
        this.panel.addComponentListener(this);
        this.addComponentListener(this);
        this.scroll.setMinimumSize(new Dimension(600, 300));
        JLabel l = new JLabel(labelStr, 4);
        this.panel.add((Component)l, AwtUtil.getConstraints((int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (boolean)false, (boolean)false));
        this.panel.add((Component)this.scroll, AwtUtil.getConstraints((int)1, (int)1, (double)1.0, (double)0.0, (int)0, (int)1, (Insets)new Insets(1, 1, 1, 1), (boolean)true, (boolean)true));
        this.textArea.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        this.textArea.revalidate();
        this.handlevalue.setType(type);
        if (this.handlevalue.hasType(Common.STD_TYPE_HSSECKEY)) {
            this.handlevalue.setAnyoneCanRead(false);
        }
    }

    @Override
    public void setValueData(byte[] data) {
        if (data == Common.EMPTY_BYTE_ARRAY || data == null) {
            System.err.println("warning message: Handle value data is empty");
            return;
        }
        String str = Util.looksLikeBinary((byte[])data) ? Util.decodeHexString((byte[])data, (boolean)false) : Util.decodeString((byte[])data);
        this.textArea.setText(str);
        this.textArea.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        this.textArea.revalidate();
        this.textArea.invalidate();
    }

    @Override
    public byte[] getValueData() {
        try {
            String str = this.textArea.getText().trim();
            return Util.encodeString((String)str);
        }
        catch (Exception e) {
            System.err.println("warning message: Exception at getValueData");
            return Common.EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this) {
            this.panel.setPreferredSize(new Dimension(this.getSize().width / 100 * 100, this.getSize().height / 100 * 100));
        } else if (e.getComponent() == this.panel) {
            this.scroll.setPreferredSize(new Dimension(this.panel.getSize().width / 100 * 100, this.panel.getSize().height / 100 * 100));
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

