/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.gui.jwidget.GenDataJPanel;
import net.handle.apps.gui.jwidget.ValueRefJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public class AdminDataJPanel
extends GenDataJPanel {
    protected ValueRefJPanel adminIdPanel;
    protected JCheckBox addHandleChkbx;
    protected JCheckBox deleteHandleChkbx;
    protected JCheckBox addNAChkbx;
    protected JCheckBox deleteNAChkbx;
    protected JCheckBox modifyValueChkbx;
    protected JCheckBox removeValueChkbx;
    protected JCheckBox addValueChkbx;
    protected JCheckBox readValueChkbx;
    protected JCheckBox modifyAdminChkbx;
    protected JCheckBox removeAdminChkbx;
    protected JCheckBox addAdminChkbx;
    protected JCheckBox listHdlsChkbx;

    public AdminDataJPanel(boolean moreFlag, boolean editFlag) {
        this(moreFlag, editFlag, 0);
    }

    public AdminDataJPanel(boolean moreFlag, boolean editFlag, int index) {
        super(moreFlag, editFlag, String.valueOf(index));
        this.adminIdPanel = new ValueRefJPanel("Admin ID Handle:", "Input Admin ID Handle Name", "Admin ID Index:", "Input Admin ID Handle Index Value", editFlag);
        this.addHandleChkbx = new JCheckBox("Add Handle", false);
        this.addHandleChkbx.setEnabled(editFlag);
        this.deleteHandleChkbx = new JCheckBox("Delete Handle", true);
        this.deleteHandleChkbx.setEnabled(editFlag);
        this.addNAChkbx = new JCheckBox("Add Derived Prefix", false);
        this.addNAChkbx.setEnabled(editFlag);
        this.deleteNAChkbx = new JCheckBox("Delete Derived Prefix", false);
        this.deleteNAChkbx.setEnabled(editFlag);
        this.modifyValueChkbx = new JCheckBox("Modify Value", true);
        this.modifyValueChkbx.setEnabled(editFlag);
        this.removeValueChkbx = new JCheckBox("Remove Value", true);
        this.removeValueChkbx.setEnabled(editFlag);
        this.addValueChkbx = new JCheckBox("Add Value", true);
        this.addValueChkbx.setEnabled(editFlag);
        this.readValueChkbx = new JCheckBox("Read Value", true);
        this.readValueChkbx.setEnabled(editFlag);
        this.modifyAdminChkbx = new JCheckBox("Modify Admin", true);
        this.modifyAdminChkbx.setEnabled(editFlag);
        this.removeAdminChkbx = new JCheckBox("Remove Admin", true);
        this.removeAdminChkbx.setEnabled(editFlag);
        this.addAdminChkbx = new JCheckBox("Add Admin", true);
        this.addAdminChkbx.setEnabled(editFlag);
        this.listHdlsChkbx = new JCheckBox("List Handles", true);
        this.listHdlsChkbx.setEnabled(editFlag);
        JPanel p = new JPanel(new GridLayout(4, 2));
        int x = 0;
        int y = 0;
        JPanel naPerms = new JPanel(new GridLayout(2, 2));
        p.add(this.deleteHandleChkbx);
        p.add(this.modifyValueChkbx);
        p.add(this.removeValueChkbx);
        p.add(this.addValueChkbx);
        p.add(this.readValueChkbx);
        p.add(this.modifyAdminChkbx);
        p.add(this.removeAdminChkbx);
        p.add(this.addAdminChkbx);
        naPerms.add(this.addHandleChkbx);
        naPerms.add(this.addNAChkbx);
        naPerms.add(this.deleteNAChkbx);
        naPerms.add(this.listHdlsChkbx);
        y = 0;
        x = 0;
        naPerms.setBorder(new TitledBorder(new EtchedBorder(), "Prefix Permissions"));
        p.setBorder(new TitledBorder(new EtchedBorder(), "Handle Permissions"));
        this.panel.add((Component)this.adminIdPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)3, (int)1, (Insets)new Insets(1, 1, 1, 8), (boolean)true, (boolean)true));
        this.panel.add((Component)p, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)3, (int)1, (Insets)new Insets(5, 10, 5, 10), (boolean)true, (boolean)true));
        this.panel.add((Component)naPerms, AwtUtil.getConstraints((int)x, (int)y, (double)1.0, (double)0.0, (int)3, (int)1, (Insets)new Insets(5, 10, 5, 10), (boolean)true, (boolean)true));
        this.handlevalue.setType(Common.STD_TYPE_HSADMIN);
    }

    public void setAdmin(String handle, int index) {
        this.adminIdPanel.setHandleIdName(handle);
        this.adminIdPanel.setHandleIdIndex(index);
    }

    @Override
    public byte[] getValueData() {
        AdminRecord record = this.getAdminInfo();
        if (record != null) {
            return Encoder.encodeAdminRecord((AdminRecord)record);
        }
        System.err.println("warning message: Admini data is empty");
        return Common.EMPTY_BYTE_ARRAY;
    }

    @Override
    public void setValueData(byte[] data) {
        if (data == Common.EMPTY_BYTE_ARRAY) {
            System.err.println("warning message: Handle value data is empty");
            return;
        }
        AdminRecord admRec = new AdminRecord();
        try {
            Encoder.decodeAdminRecord((byte[])data, (int)0, (AdminRecord)admRec);
        }
        catch (HandleException handleException) {
            // empty catch block
        }
        this.setAdminInfo(admRec);
    }

    public AdminRecord getAdminInfo() {
        AdminRecord admin = new AdminRecord();
        try {
            admin.perms[0] = this.addHandleChkbx.isSelected();
            admin.perms[1] = this.deleteHandleChkbx.isSelected();
            admin.perms[2] = this.addNAChkbx.isSelected();
            admin.perms[3] = this.deleteNAChkbx.isSelected();
            admin.perms[4] = this.modifyValueChkbx.isSelected();
            admin.perms[5] = this.removeValueChkbx.isSelected();
            admin.perms[6] = this.addValueChkbx.isSelected();
            admin.perms[10] = this.readValueChkbx.isSelected();
            admin.perms[7] = this.modifyAdminChkbx.isSelected();
            admin.perms[8] = this.removeAdminChkbx.isSelected();
            admin.perms[9] = this.addAdminChkbx.isSelected();
            admin.perms[11] = this.listHdlsChkbx.isSelected();
            admin.adminId = Util.encodeString((String)this.adminIdPanel.getHandleIdName());
            admin.adminIdIndex = this.adminIdPanel.getHandleIdIndex();
            return admin;
        }
        catch (Exception e) {
            System.err.println("error message: Exception at getAdminInfo");
            e.printStackTrace(System.err);
            return null;
        }
    }

    public void setAdminInfo(AdminRecord admin) {
        if (admin == null) {
            return;
        }
        try {
            this.addHandleChkbx.setSelected(admin.perms[0]);
            this.deleteHandleChkbx.setSelected(admin.perms[1]);
            this.addNAChkbx.setSelected(admin.perms[2]);
            this.deleteNAChkbx.setSelected(admin.perms[3]);
            this.modifyValueChkbx.setSelected(admin.perms[4]);
            this.removeValueChkbx.setSelected(admin.perms[5]);
            this.addValueChkbx.setSelected(admin.perms[6]);
            this.readValueChkbx.setSelected(admin.perms[10]);
            this.modifyAdminChkbx.setSelected(admin.perms[7]);
            this.removeAdminChkbx.setSelected(admin.perms[8]);
            this.addAdminChkbx.setSelected(admin.perms[9]);
            this.listHdlsChkbx.setSelected(admin.perms[11]);
            this.adminIdPanel.setHandleIdName(Util.decodeString((byte[])admin.adminId));
            this.adminIdPanel.setHandleIdIndex(admin.adminIdIndex);
        }
        catch (Exception e) {
            System.err.println("error message:  Exception at setting admin info");
            e.printStackTrace(System.err);
        }
    }
}

