/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.HelpPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.Util;

public class UnhomeNAWindow
extends JDialog
implements ActionListener {
    private final JTextField naField;
    private final JTextField addressField;
    private final JTextField portField;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JComboBox protocolChoice;
    private final JButton changeAuthButton;
    private final JButton helpButton;
    private final HandleTool tool;

    public UnhomeNAWindow(HandleTool tool) {
        super(tool, "Unhome Prefix", false);
        this.tool = tool;
        this.naField = new JTextField("0.NA/YOUR_PREFIX", 20);
        this.naField.setScrollOffset(0);
        this.addressField = new JTextField("Your server address");
        this.addressField.setScrollOffset(0);
        this.portField = new JTextField("2641", 6);
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        this.changeAuthButton = new JButton("Authentication");
        this.helpButton = new JButton("Help");
        this.protocolChoice = new JComboBox();
        this.protocolChoice.addItem("TCP");
        this.protocolChoice.addItem("UDP");
        this.protocolChoice.addItem("HTTP");
        int x = 0;
        int y = 0;
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.helpButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)false, (boolean)false));
        p.add((Component)this.changeAuthButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)false, (boolean)false));
        p.add((Component)new JLabel("Primary server address: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.addressField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)new JLabel("Primary server port: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.portField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)new JLabel("Prefix Handle: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.naField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)new JLabel("Interface/Protocol: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.protocolChoice, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.okButton, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)false, (boolean)false));
        buttonPanel.add((Component)this.cancelButton, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)false, (boolean)false));
        p.add((Component)buttonPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.getContentPane().add(p);
        this.changeAuthButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, (Component)tool);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            if (this.unhomeNA()) {
                this.setVisible(false);
            }
        } else if (src == this.cancelButton) {
            this.setVisible(false);
        } else if (src == this.changeAuthButton) {
            this.tool.changeAuthentication();
        } else if (src == this.helpButton) {
            HelpPanel.show(this.tool, "/net/handle/apps/gui/help/en_en", "unhome_na.html");
        }
    }

    @Override
    public void setVisible(boolean val) {
        super.setVisible(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean unhomeNA() {
        try {
            svrAddr = InetAddress.getByName(this.addressField.getText().trim());
            svrPort = Integer.parseInt(this.portField.getText().trim());
            naHandle = Util.encodeString((String)this.naField.getText().trim());
            if (!Util.hasSlash((byte[])naHandle)) {
                naHandle = Util.convertSlashlessHandleToZeroNaHandle((byte[])naHandle);
            }
            siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
            response = null;
            try {
                switch (this.protocolChoice.getSelectedIndex()) {
                    case 0: {
                        response = this.tool.resolver.sendHdlTcpRequest((AbstractRequest)siReq, svrAddr, svrPort);
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        response = this.tool.resolver.sendHdlUdpRequest((AbstractRequest)siReq, svrAddr, svrPort);
                        ** break;
lbl18:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        response = this.tool.resolver.sendHttpRequest((AbstractRequest)siReq, svrAddr, svrPort);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new Exception("No protocol selected");
                    }
                }
            }
            finally {
                this.tool.resolver.setCheckSignatures(true);
            }
            siteInfo = null;
            if (response.responseCode != 1) {
                throw new Exception("Unable to retrieve site information from server");
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            authInfo = this.tool.getAuthentication();
            if (authInfo == null) {
                return false;
            }
            unhomeNAReq = new GenericRequest(naHandle, 301, authInfo);
            unhomeNAReq.isAdminRequest = true;
            unhomeNAReq.certify = true;
            for (i = 0; i < siteInfo.servers.length; ++i) {
                response = this.tool.resolver.sendRequestToServer((AbstractRequest)unhomeNAReq, siteInfo, siteInfo.servers[i]);
                if (response.responseCode == 1) continue;
                throw new Exception(String.valueOf(response));
            }
            GenericDialog.askQuestion((String)"Success", (String)"The prefix was unhomed on all servers\nwithin the given site.", (int)0, (Component)this);
            return true;
        }
        catch (Exception e) {
            sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            GenericDialog.askQuestion((String)"Error", (String)("Error: " + e + "\nPlease try again\n" + sw.toString()), (int)0, (Component)this);
            return false;
        }
    }
}

