/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.handle.apps.gui.hadmin.AdministMasterJPanel;
import net.handle.apps.gui.hadmin.HandleAdminJPanel;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jwidget.HandleValueListJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

public class ModifyHandleJPanel
extends HandleAdminJPanel
implements ActionListener {
    protected ModifyDataList dataList;
    protected Component this_panel = this;

    public ModifyHandleJPanel() {
        this(new HandleTool());
    }

    public ModifyHandleJPanel(HandleTool tool) {
        super(tool);
        this.submitButton.setVisible(false);
        this.dataList = new ModifyDataList();
        this.dataPanel.add((Component)this.dataList, AwtUtil.getConstraints((int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.upPanel.add((Component)this.handlePanel, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)2, (int)3, (Insets)new Insets(5, 5, 5, 5), (int)17, (boolean)false, (boolean)true));
        this.midPanel.add((Component)this.toolPanel, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)2, (int)8, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)false));
    }

    @Override
    public int getNextIndex(int start) {
        int i = 0;
        Vector v = this.dataList.getItems();
        while (i < v.size()) {
            HandleValue val = (HandleValue)v.elementAt(i);
            if (val.getIndex() == start) {
                ++start;
                i = 0;
                continue;
            }
            ++i;
        }
        return start;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String choice = ae.getActionCommand();
        if (ae.getSource() == this.nameField) {
            AuthenticationInfo authInfo = this.tool.getAuthentication();
            if (authInfo == null) {
                return;
            }
            this.fetchHandleValues(authInfo);
        } else if (choice.equals("Add Admin")) {
            this.addAdmin();
        } else if (choice.equals("Add URL")) {
            this.addURL();
        } else if (choice.equals("Add EMAIL")) {
            this.addEmail();
        } else if (choice.equals("Add Custom Data")) {
            this.addCustomData();
        }
    }

    @Override
    protected void createAdminRef(int index) {
        AdministMasterJPanel p;
        Vector v = this.dataList.getItems();
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (((HandleValue)v.elementAt(i)).getIndex() != index) continue;
                return;
            }
        }
        if (2 == JOptionPane.showConfirmDialog(null, p = new AdministMasterJPanel(index), "Add administrator: ", 2, -1)) {
            return;
        }
        HandleValue value = p.getAdmReferValue();
        this.addDataToList(value);
    }

    @Override
    protected void addDataToList(HandleValue value) {
        this.handleName = this.nameField.getText().trim();
        if (this.handleName == null || this.handleName.length() <= 0) {
            this.warn("Invalid handle name, re-enter please");
            return;
        }
        AuthenticationInfo authInfo = this.tool.getAuthentication();
        byte[] handle = Util.encodeString((String)this.handleName);
        AddValueRequest req = new AddValueRequest(handle, value, authInfo);
        try {
            AbstractResponse resp = this.tool.processRequest(this.this_panel, (AbstractRequest)req, "Adding handle value...");
            if (resp.responseCode == 1) {
                this.info("Response: Successfully added handle value\n" + resp);
                this.dataList.appendItem(value);
            } else {
                this.info("Response: There was an error adding the handle value\n" + resp);
                if (resp.responseCode == 403 || resp.responseCode == 402 || resp.responseCode == 400) {
                    this.tool.changeAuthentication();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.warn("There was an error adding the handle value: " + e.getMessage());
        }
    }

    public void reset() {
        this.dataList.clearAll();
        this.nameField.setText("");
    }

    public void fetchHandleValues(AuthenticationInfo authInfo) {
        this.dataList.clearAll();
        this.handleName = this.nameField.getText().trim();
        if (this.handleName == null || this.handleName.length() <= 0) {
            this.warn("Invalid handle name, re-enter please");
            this.nameField.requestFocus();
            return;
        }
        byte[] handlebytes = Util.encodeString((String)this.handleName);
        ResolutionRequest queryReq = null;
        AbstractResponse response = null;
        try {
            if (authInfo == null) {
                queryReq = new ResolutionRequest(handlebytes, null, null, authInfo);
                queryReq.authoritative = true;
                queryReq.ignoreRestrictedValues = true;
                queryReq.certify = true;
                this.warn("Retrieving only publicly readable handle values");
            } else {
                queryReq = new ResolutionRequest(handlebytes, null, null, authInfo);
                queryReq.authoritative = true;
                queryReq.ignoreRestrictedValues = false;
                queryReq.certify = true;
            }
            response = this.tool.processRequest(this.this_panel, (AbstractRequest)queryReq, "Fetching handle values ...");
            if (!(response instanceof ResolutionResponse) && authInfo != null) {
                this.warn("Unable to retrieve handle values: Authentication error.\nRetrieving only publicly readable handle values");
                queryReq = new ResolutionRequest(handlebytes, null, null, authInfo);
                queryReq.authoritative = true;
                queryReq.ignoreRestrictedValues = true;
                queryReq.certify = true;
                response = this.tool.processRequest(this.this_panel, (AbstractRequest)queryReq, "Fetching handle values ...");
                if (response == null) {
                    this.warn("There was an error processing your request");
                    return;
                }
            }
            if (!(response instanceof ResolutionResponse)) {
                this.warn("Unable to retrieve handle: \n" + response);
                return;
            }
            HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
            if (values == null) {
                return;
            }
            for (int i = 0; i < values.length; ++i) {
                this.dataList.appendItem(values[i]);
            }
        }
        catch (Exception e) {
            this.warn("Unable to retrieve handle: \n" + e.getMessage());
            return;
        }
    }

    protected class ModifyDataList
    extends HandleValueListJPanel {
        protected ModifyDataList() {
            int x = 0;
            int y = 0;
            GridBagLayout gridbag = new GridBagLayout();
            this.buttonPanel = new JPanel(gridbag);
            this.buttonPanel.add((Component)this.editItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            this.buttonPanel.add((Component)this.remItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            this.buttonPanel.add((Component)this.viewItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            y = 0;
            this.savePanel = new JPanel(gridbag);
            this.savePanel.add((Component)this.saveButton, AwtUtil.getConstraints((int)x++, (int)y, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)false, (boolean)true));
            this.add((Component)this.pane, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)2, (int)10, (boolean)true, (boolean)true));
            this.add((Component)this.buttonPanel, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)8, (boolean)true, (boolean)true));
            this.add((Component)this.savePanel, AwtUtil.getConstraints((int)0, (int)11, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        }

        @Override
        protected Object modifyData(int ind) {
            ModifyHandleJPanel.this.handleName = ModifyHandleJPanel.this.nameField.getText().trim();
            if (ModifyHandleJPanel.this.handleName == null || ModifyHandleJPanel.this.handleName.length() <= 0) {
                this.warn("Please enter a valid handle");
                return null;
            }
            HandleValue value = (HandleValue)super.modifyData(ind);
            if (value == null) {
                return null;
            }
            AuthenticationInfo authInfo = ModifyHandleJPanel.this.tool.getAuthentication();
            if (authInfo == null) {
                return null;
            }
            byte[] handle = Util.encodeString((String)ModifyHandleJPanel.this.handleName);
            ModifyValueRequest req = new ModifyValueRequest(handle, value, authInfo);
            try {
                AbstractResponse resp = ModifyHandleJPanel.this.tool.processRequest(ModifyHandleJPanel.this.this_panel, (AbstractRequest)req, "Updating handle value ...");
                if (resp == null) {
                    this.warn("Unable to process the request");
                    return null;
                }
                if (resp.responseCode == 1) {
                    this.info("Handle value successfully updated");
                    return value;
                }
                this.info("Error updating handle value: \n" + resp);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.warn("Error updating handle value: " + e.getMessage());
                return null;
            }
        }

        @Override
        protected boolean removeData(int ind) {
            ModifyHandleJPanel.this.handleName = ModifyHandleJPanel.this.nameField.getText().trim();
            if (ModifyHandleJPanel.this.handleName == null || ModifyHandleJPanel.this.handleName.length() <= 0) {
                this.warn("Please enter a valid handle");
                return false;
            }
            AuthenticationInfo authInfo = ModifyHandleJPanel.this.tool.getAuthentication();
            if (authInfo == null) {
                return false;
            }
            byte[] handle = Util.encodeString((String)ModifyHandleJPanel.this.handleName);
            int removeInd = ((HandleValue)this.items.elementAt(ind)).getIndex();
            RemoveValueRequest req = new RemoveValueRequest(handle, removeInd, authInfo);
            try {
                AbstractResponse resp = ModifyHandleJPanel.this.tool.processRequest(ModifyHandleJPanel.this.this_panel, (AbstractRequest)req, "Removing handle value ...");
                if (resp == null) {
                    this.warn("Unable to process the request");
                    return false;
                }
                if (resp.responseCode == 1) {
                    this.info("Handle value successfully removed");
                    return true;
                }
                this.info("Error removing handle value: \n" + resp);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.warn("Error removing handle value: " + e.getMessage());
                return false;
            }
        }

        @Override
        public void warn(String message) {
            JOptionPane.showMessageDialog(this, message, "Warning", 2);
        }

        @Override
        public void info(String message) {
            JOptionPane.showMessageDialog(this, message);
        }
    }
}

