/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.gui.hadmin.AdministMasterJPanel;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jwidget.AdminDataJPanel;
import net.handle.apps.gui.jwidget.HandleValueJPanel;
import net.handle.apps.gui.jwidget.SiteDataJPanel;
import net.handle.apps.gui.jwidget.TextDataJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class HandleAdminJPanel
extends JPanel
implements ActionListener {
    protected JPanel upPanel;
    protected JPanel midPanel;
    protected JPanel lowPanel;
    protected JPanel handlePanel;
    protected JPanel dataPanel;
    protected JPanel toolPanel;
    protected JTextField nameField;
    protected JScrollPane sp;
    protected JPanel workPanel;
    protected MyButton changeAuthButton;
    protected MyButton addAdmButton;
    protected MyButton addSiteButton;
    protected MyButton urlButton;
    protected MyButton emailButton;
    protected MyButton submitButton = new MyButton("");
    protected MyButton goButton;
    protected MyButton customDataButton;
    protected HandleValue[] handleValues;
    protected String handleName;
    protected HandleTool tool;

    public HandleAdminJPanel() {
        this(new HandleTool());
    }

    public HandleAdminJPanel(HandleTool tool) {
        this(tool, "Handle Data View");
    }

    public HandleAdminJPanel(HandleTool tool, String name) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        EtchedBorder etchBorder = new EtchedBorder();
        int x = 0;
        int y = 0;
        this.tool = tool;
        this.handlePanel = new JPanel(new FlowLayout());
        this.nameField = new JTextField("", 20);
        this.nameField.setScrollOffset(0);
        this.nameField.setToolTipText("Input the new handle name");
        this.nameField.addActionListener(this);
        this.handlePanel.add(new JLabel(" Handle: ", 4));
        this.handlePanel.add(this.nameField);
        this.handlePanel.add(this.submitButton);
        JPanel p2 = new JPanel(gridbag);
        this.addAdmButton = new MyButton("Add Admin", "click to add administrator");
        this.urlButton = new MyButton("Add URL", " click to add URL data");
        this.emailButton = new MyButton("Add EMAIL", "click to add Email data");
        this.urlButton.addActionListener(this);
        this.emailButton.addActionListener(this);
        this.addAdmButton.addActionListener(this);
        x = 0;
        y = 0;
        p2.add((Component)this.addAdmButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        p2.add((Component)this.urlButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        p2.add((Component)this.emailButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.customDataButton = new MyButton("Add Custom Data", "click to add custom data");
        this.customDataButton.addActionListener(this);
        p2.add((Component)this.customDataButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.toolPanel = new JPanel(gridbag);
        this.toolPanel.add((Component)p2, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)3, (Insets)new Insets(2, 1, 5, 1), (boolean)true, (boolean)false));
        this.toolPanel.setBorder(new TitledBorder(etchBorder, " Add Handle Data "));
        this.dataPanel = new JPanel(gridbag);
        this.dataPanel.setBorder(new TitledBorder(etchBorder, name));
        this.upPanel = new JPanel(gridbag);
        this.midPanel = new JPanel(gridbag);
        this.midPanel.add((Component)this.dataPanel, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)2, (int)10, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)true));
        this.lowPanel = new JPanel(gridbag);
        this.workPanel = new JPanel(gridbag);
        x = 0;
        y = 0;
        this.workPanel.add((Component)this.upPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)true));
        this.workPanel.add((Component)this.midPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)true));
        this.workPanel.add((Component)this.lowPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)true));
        x = 0;
        y = 0;
        this.add((Component)this.workPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(2, 5, 10, 5), (int)10, (boolean)true, (boolean)true));
    }

    public void warn(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning", 2);
    }

    public void info(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    public int getNextIndex(int start) {
        return 0;
    }

    protected void addAdmin() {
        this.handleName = this.nameField.getText().trim();
        int index = this.getNextIndex(100);
        AdminDataJPanel p = new AdminDataJPanel(true, true, index);
        AuthenticationInfo auth = this.tool.getCurrentAuthentication();
        if (auth != null) {
            p.setAdmin(new String(auth.getUserIdHandle()), auth.getUserIdIndex());
        }
        if (2 == JOptionPane.showConfirmDialog(this, p, "Input Administrators Info: ", 2, -1)) {
            return;
        }
        HandleValue value = p.getHandleValue();
        this.addDataToList(value);
        try {
            AdminRecord record = new AdminRecord();
            Encoder.decodeAdminRecord((byte[])value.getData(), (int)0, (AdminRecord)record);
            String admHandleName = Util.decodeString((byte[])record.adminId);
            if (this.handleName.equals(admHandleName)) {
                this.createAdminRef(record.adminIdIndex);
            }
        }
        catch (HandleException e) {
            this.getToolkit().beep();
        }
    }

    protected void createAdminRef(int index) {
        AdministMasterJPanel p = new AdministMasterJPanel(index);
        if (2 == JOptionPane.showConfirmDialog(null, p, " Add admininst Reference: ", 2, -1)) {
            return;
        }
        HandleValue value = p.getAdmReferValue();
        this.addDataToList(value);
    }

    protected void addSite() {
        SiteDataJPanel p = new SiteDataJPanel(true, true, this.getNextIndex(1));
        if (2 == JOptionPane.showConfirmDialog(this, p, "Add Site Info: ", 2, -1)) {
            return;
        }
        this.addDataToList(p.getHandleValue());
    }

    protected void addURL() {
        int i = this.getNextIndex(1);
        TextDataJPanel p = new TextDataJPanel(Common.STD_TYPE_URL, true, true, i);
        if (2 == JOptionPane.showConfirmDialog(this, p, "Input URL Info: ", 2, -1)) {
            return;
        }
        this.addDataToList(p.getHandleValue());
    }

    protected void addEmail() {
        int i = this.getNextIndex(1);
        TextDataJPanel p = new TextDataJPanel(Common.STD_TYPE_EMAIL, true, true, i);
        if (2 == JOptionPane.showConfirmDialog(this, p, "Input Email Info: ", 2, -1)) {
            return;
        }
        this.addDataToList(p.getHandleValue());
    }

    protected void addCustomData() {
        HandleValueJPanel p = new HandleValueJPanel(true, this.getNextIndex(1));
        if (2 == JOptionPane.showConfirmDialog(this, p, "Input Custom Info: ", 2, -1)) {
            return;
        }
        this.addDataToList(p.getHandleValue());
    }

    protected void addDataToList(HandleValue value) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Container c = f.getContentPane();
        c.add(new HandleAdminJPanel());
        f.setSize(500, 500);
        f.pack();
        f.setVisible(true);
    }
}

