/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.handle.apps.gui.hadmin.AdministMasterJPanel;
import net.handle.apps.gui.hadmin.HandleAdminJPanel;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jwidget.HandleValueListJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class CreateHandleJPanel
extends HandleAdminJPanel
implements ActionListener {
    protected CreateDataList dataList = new CreateDataList();

    public CreateHandleJPanel() {
        this(new HandleTool());
    }

    public CreateHandleJPanel(HandleTool tool) {
        super(tool);
        this.dataPanel.add((Component)this.dataList, AwtUtil.getConstraints((int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
        this.submitButton.setText("Create");
        this.submitButton.setActionCommand("Create");
        this.submitButton.addActionListener(this);
        this.upPanel.add((Component)this.handlePanel, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)2, (int)3, (Insets)new Insets(5, 5, 5, 5), (int)17, (boolean)false, (boolean)true));
        this.upPanel.add((Component)this.submitButton, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)false));
        this.midPanel.add((Component)this.toolPanel, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)2, (int)8, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)false));
    }

    public void reset() {
        this.nameField.setText("");
        this.dataList.clearAll();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String choice = ae.getActionCommand();
        if (ae.getSource() == this.nameField) {
            this.tool.getAuthentication();
        } else if (choice.equals("Create")) {
            this.submitCreate();
        } else if (choice.equals("Add Admin")) {
            this.addAdmin();
        } else if (choice.equals("Add URL")) {
            this.addURL();
        } else if (choice.equals("Add EMAIL")) {
            this.addEmail();
        } else if (choice.equals("Add Custom Data")) {
            this.addCustomData();
        }
    }

    @Override
    public int getNextIndex(int start) {
        int i = 0;
        Vector v = this.dataList.getItems();
        while (i < v.size()) {
            HandleValue val = (HandleValue)v.elementAt(i);
            if (val.getIndex() == start) {
                ++start;
                i = 0;
                continue;
            }
            ++i;
        }
        return start;
    }

    private void submitCreate() {
        this.handleName = this.nameField.getText().trim();
        this.nameField.requestFocus();
        if (this.handleName == null || this.handleName.length() <= 0) {
            this.warn("Did not input handle name");
            return;
        }
        Vector vt = this.dataList.getItems();
        if (vt == null) {
            this.warn("Did not input handle value");
            return;
        }
        if (vt.size() < 1) {
            this.warn("Did not input handle value");
            return;
        }
        this.handleValues = new HandleValue[vt.size()];
        boolean admflag = false;
        for (int i = 0; i < vt.size(); ++i) {
            this.handleValues[i] = (HandleValue)vt.elementAt(i);
            if (!this.handleValues[i].hasType(Common.ADMIN_TYPE)) continue;
            admflag = true;
        }
        if (!admflag) {
            this.warn("Did not input handle administrator");
            return;
        }
        AuthenticationInfo authInfo = this.tool.getAuthentication();
        if (authInfo == null) {
            return;
        }
        CreateHandleRequest req = new CreateHandleRequest(Util.encodeString((String)this.handleName), this.handleValues, authInfo);
        try {
            AbstractResponse resp = this.tool.processRequest(this, (AbstractRequest)req, "Creating Handle ...");
            if (resp == null) {
                this.warn("Can not process the request");
                return;
            }
            if (resp.responseCode == 1) {
                this.info("Response: Handle created successfully \n" + resp);
                this.dataList.clearAll();
                this.nameField.setText("");
            } else {
                this.info("Response: Handle creation failed \n" + resp);
                if (resp.responseCode == 403 || resp.responseCode == 402 || resp.responseCode == 400) {
                    this.tool.changeAuthentication();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.warn("Exception " + e.getMessage());
        }
    }

    @Override
    protected void addDataToList(HandleValue value) {
        if (value == null) {
            return;
        }
        this.dataList.appendItem(value);
    }

    @Override
    protected void createAdminRef(int index) {
        AdministMasterJPanel p;
        Vector v = this.dataList.getItems();
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (((HandleValue)v.elementAt(i)).getIndex() != index) continue;
                return;
            }
        }
        if (2 == JOptionPane.showConfirmDialog(null, p = new AdministMasterJPanel(index), " Add admininst Reference: ", 2, -1)) {
            return;
        }
        HandleValue value = p.getAdmReferValue();
        this.addDataToList(value);
    }

    protected class CreateDataList
    extends HandleValueListJPanel {
        CreateDataList() {
            int x = 0;
            int y = 0;
            GridBagLayout gridbag = new GridBagLayout();
            this.buttonPanel = new JPanel(gridbag);
            this.buttonPanel.add((Component)this.editItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            this.buttonPanel.add((Component)this.remItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            this.buttonPanel.add((Component)this.viewItemButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            this.buttonPanel.add((Component)this.clearButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)true));
            y = 0;
            this.savePanel = new JPanel(gridbag);
            this.savePanel.add((Component)this.saveButton, AwtUtil.getConstraints((int)x++, (int)y, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)true));
            this.savePanel.add((Component)this.loadButton, AwtUtil.getConstraints((int)x++, (int)y, (double)1.0, (double)1.0, (int)1, (int)1, (Insets)new Insets(5, 5, 5, 5), (boolean)true, (boolean)true));
            this.add((Component)this.pane, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)2, (int)10, (boolean)true, (boolean)true));
            this.add((Component)this.buttonPanel, AwtUtil.getConstraints((int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)10, (boolean)true, (boolean)true));
            this.add((Component)this.savePanel, AwtUtil.getConstraints((int)0, (int)11, (double)1.0, (double)1.0, (int)2, (int)1, (boolean)true, (boolean)true));
        }
    }
}

