/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.HelpPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.Interface;
import net.handle.hdllib.SiteInfo;

public class BackupServerWindow
extends JDialog
implements ActionListener {
    private final JTextField addressField;
    private final JTextField portField;
    private final JButton okButton;
    private final JButton cancelButton;
    private final JComboBox protocolChoice;
    private final JButton helpButton;
    private final HandleTool tool;

    public BackupServerWindow(HandleTool tool) {
        super(tool, "Backup Server Window", false);
        this.tool = tool;
        this.addressField = new JTextField("Your server address");
        this.addressField.setScrollOffset(0);
        this.portField = new JTextField("2641", 6);
        this.protocolChoice = new JComboBox();
        this.protocolChoice.addItem("UDP");
        this.protocolChoice.addItem("TCP");
        this.protocolChoice.addItem("HTTP");
        this.protocolChoice.setSelectedIndex(1);
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(this);
        int x = 0;
        int y = 0;
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.helpButton, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)false, (boolean)false));
        p.add((Component)new JLabel("Primary server address: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.addressField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)new JLabel("Primary server port: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.portField, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)new JLabel("Interface/Protocol: ", 4), AwtUtil.getConstraints((int)x, (int)y, (double)0.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        p.add((Component)this.protocolChoice, AwtUtil.getConstraints((int)(x + 1), (int)y++, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)true, (boolean)false));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.okButton, AwtUtil.getConstraints((int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)false, (boolean)false));
        buttonPanel.add((Component)this.cancelButton, AwtUtil.getConstraints((int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (boolean)false, (boolean)false));
        p.add((Component)buttonPanel, AwtUtil.getConstraints((int)x, (int)y++, (double)1.0, (double)0.0, (int)2, (int)1, (boolean)true, (boolean)true));
        this.getContentPane().add(p);
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, (Component)tool);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            if (this.backupServer()) {
                this.setVisible(false);
            }
        } else if (src == this.cancelButton) {
            this.setVisible(false);
        } else if (src == this.helpButton) {
            HelpPanel.show(this.tool, "/net/handle/apps/gui/help/en_en", "backup.html");
        }
    }

    @Override
    public void setVisible(boolean val) {
        super.setVisible(val);
    }

    private boolean backupServer() {
        try {
            InetAddress svrAddr = InetAddress.getByName(this.addressField.getText().trim());
            int svrPort = Integer.parseInt(this.portField.getText().trim());
            GenericRequest siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
            AbstractResponse response = null;
            switch (this.protocolChoice.getSelectedIndex()) {
                case 0: {
                    response = this.tool.resolver.sendHdlUdpRequest((AbstractRequest)siReq, svrAddr, svrPort);
                    break;
                }
                case 1: {
                    response = this.tool.resolver.sendHdlTcpRequest((AbstractRequest)siReq, svrAddr, svrPort);
                    break;
                }
                case 2: {
                    response = this.tool.resolver.sendHttpRequest((AbstractRequest)siReq, svrAddr, svrPort);
                    break;
                }
                default: {
                    throw new Exception("No protocol selected");
                }
            }
            SiteInfo siteInfo = null;
            if (response == null || response.responseCode != 1) {
                throw new Exception("Unable to retrieve site information from server.");
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            AuthenticationInfo authInfo = this.tool.getAuthentication();
            if (authInfo == null) {
                return false;
            }
            GenericRequest backupReq = new GenericRequest(Common.BLANK_HANDLE, 1003, authInfo);
            if (siteInfo.majorProtocolVersion == 5 && siteInfo.minorProtocolVersion == 0 || siteInfo.majorProtocolVersion < 2 || siteInfo.majorProtocolVersion == 2 && siteInfo.minorProtocolVersion < 11) {
                backupReq.majorProtocolVersion = siteInfo.majorProtocolVersion;
                backupReq.minorProtocolVersion = siteInfo.minorProtocolVersion;
            } else {
                backupReq.majorProtocolVersion = (byte)2;
                backupReq.minorProtocolVersion = (byte)11;
            }
            backupReq.certify = true;
            String respStr = null;
            response = null;
            for (int i = 0; i < siteInfo.servers.length; ++i) {
                if (!siteInfo.servers[i].getInetAddress().equals(svrAddr)) continue;
                for (int j = 0; j < siteInfo.servers[i].interfaces.length; ++j) {
                    Interface interf = siteInfo.servers[i].interfaces[j];
                    if (interf.port != svrPort || interf.protocol != (byte)this.protocolChoice.getSelectedIndex()) continue;
                    response = this.tool.processRequest(this, (AbstractRequest)backupReq, siteInfo.servers[i], "Sending server backup request...");
                    if (response == null) {
                        respStr = "There is no response for the server backup request";
                    } else {
                        if (response.responseCode == 1) {
                            JOptionPane.showMessageDialog(this, "Success, server is doing backup\n", "Info", 1);
                            return true;
                        }
                        respStr = response instanceof ErrorResponse ? String.valueOf(response) : response.getClass().getName() + "( " + String.valueOf(response.responseCode) + "): " + AbstractMessage.getResponseCodeMessage((int)response.responseCode);
                    }
                    JOptionPane.showMessageDialog(this, "Response: Server can not process the backup request\n" + respStr, "Error", 0);
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Catch exception at backup server:\n" + e.getMessage() + "\nTry again please", "Error", 0);
        }
        return false;
    }
}

