/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tree
implements Loggable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private static final String TRACE_DUP_ROOT_SPLIT = "DupRootSplit:";
    private static final String TRACE_MUTATE = "Mut:";
    private static final String TRACE_INSERT = "Ins:";
    private static final String TRACE_INSERT_DUPLICATE = "InsD:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxMainTreeEntriesPerNode;
    private int maxDupTreeEntriesPerNode;
    private StatGroup stats;
    private IntStat rootSplits;
    private LongStat relatchesRequired;
    private SharedLatch rootLatch;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL = new ThreadLocal();
    private static SplitRequiredException splitRequiredException = new SplitRequiredException();
    private TestHook waitHook;
    private TestHook searchHook;
    private TestHook ckptHook;

    public Tree(DatabaseImpl database) {
        this.init(database);
        this.setDatabase(database);
    }

    public Tree() {
        this.init(null);
        this.maxMainTreeEntriesPerNode = 0;
        this.maxDupTreeEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.rootLatch = new SharedLatch("RootLatch");
        this.root = null;
        this.database = database;
        this.stats = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");
        this.relatchesRequired = new LongStat(this.stats, BTreeStatDefinition.BTREE_RELATCHES_REQUIRED);
        this.rootSplits = new IntStat(this.stats, BTreeStatDefinition.BTREE_ROOT_SPLITS);
    }

    public void setDatabase(DatabaseImpl database) {
        this.database = database;
        this.maxMainTreeEntriesPerNode = database.getNodeMaxEntries();
        this.maxDupTreeEntriesPerNode = database.getNodeMaxDupTreeEntries();
        DbConfigManager configManager = database.getDbEnvironment().getConfigManager();
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot, boolean notLatched) {
        assert (notLatched || this.rootLatch.isWriteLockedByCurrentThread());
        this.root = newRoot;
    }

    public ChildReference makeRootChildReference(Node target, byte[] key, long lsn) {
        return new RootChildReference(target, key, lsn);
    }

    private ChildReference makeRootChildReference() {
        return new RootChildReference();
    }

    public boolean rootExists() {
        if (this.root == null) {
            return false;
        }
        return this.root.getTarget() != null || this.root.getLsn() != -1L;
    }

    public boolean isRootResident() {
        return this.root != null && this.root.getTarget() != null;
    }

    public long getRootLsn() {
        if (this.root == null) {
            return -1L;
        }
        return this.root.getLsn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLNs() {
        int topLevelSlots;
        int levels;
        if (this.database.getSortedDuplicates()) {
            return Long.MAX_VALUE;
        }
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            levels = rootIN.getLevel() & 0xFFFF;
            topLevelSlots = rootIN.getNEntries();
        }
        finally {
            this.rootLatch.release();
        }
        return (long)((double)topLevelSlots * Math.pow(this.database.getNodeMaxEntries(), levels - 1));
    }

    int getTreeStats() {
        return this.rootSplits.get();
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedExclusive(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireExclusive();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedShared(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireShared();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] idKey, LocalUtilizationTracker localTracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        INList inList = envImpl.getInMemoryINs();
        IN subtreeRootIN = null;
        ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
        IN rootIN = null;
        boolean rootNeedsUpdating = false;
        this.rootLatch.acquireExclusive();
        try {
            if (!this.rootExists()) {
                return;
            }
            rootIN = (IN)this.root.fetchTarget(this.database, null);
            rootIN.latch(CacheMode.UNCHANGED);
            this.searchDeletableSubTree(rootIN, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
            } else {
                SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                assert (deleteOk);
                subtreeRootIN = detachPoint.child;
                if (this.database.isDeferredWriteMode()) {
                    subtreeRootIN.accountForDeferredWriteSubtreeRemoval(inList, detachPoint.parent);
                }
                rootNeedsUpdating = this.cascadeUpdates(nodeLadder, null, -1);
                subtreeRootIN = detachPoint.child;
            }
        }
        finally {
            this.releaseNodeLadderLatches(nodeLadder);
            if (rootIN != null) {
                rootIN.releaseLatch();
            }
            this.rootLatch.release();
        }
        if (subtreeRootIN != null) {
            if (rootNeedsUpdating) {
                envImpl.getDbTree().optionalModifyDbRoot(this.database);
                RecoveryManager.traceRootDeletion(envImpl.getLogger(), this.database);
            }
            if (!this.database.isDeferredWriteMode()) {
                subtreeRootIN.accountForSubtreeRemoval(inList, localTracker);
            }
            LoggerUtils.envLogMsg(Level.FINE, envImpl, "SubtreeRemoval: subtreeRoot = " + subtreeRootIN.getNodeId());
        }
    }

    private void releaseNodeLadderLatches(ArrayList<SplitInfo> nodeLadder) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        while (iter.hasPrevious()) {
            SplitInfo info = iter.previous();
            info.child.releaseLatch();
        }
    }

    private boolean cascadeUpdates(ArrayList<SplitInfo> nodeLadder, BIN binRoot, int index) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        LogManager logManager = envImpl.getLogManager();
        long newLsn = -1L;
        SplitInfo info = null;
        while (iter.hasPrevious()) {
            info = iter.previous();
            if (newLsn != -1L) {
                info.parent.updateEntry(info.index, newLsn);
            }
            newLsn = info.parent.optionalLog(logManager);
        }
        boolean rootNeedsUpdating = false;
        if (info != null) {
            if (info.parent.isDbRoot()) {
                assert (this.rootLatch.isWriteLockedByCurrentThread());
                this.root.updateLsnAfterOptionalLog(this.database, newLsn);
                rootNeedsUpdating = true;
            } else if (binRoot != null && info.parent.isRoot()) {
                binRoot.updateEntry(index, newLsn);
            } else assert (false);
        }
        return rootNeedsUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDup(byte[] idKey, byte[] mainKey, LocalUtilizationTracker localTracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        IN in = this.search(mainKey, SearchType.NORMAL, -1L, null, CacheMode.UNCHANGED);
        IN deletedSubtreeRoot = null;
        try {
            assert (in.isLatchOwnerForWrite());
            assert (in instanceof BIN);
            assert (in.getNEntries() > 0);
            int index = in.findEntry(mainKey, false, true);
            if (index >= 0) {
                deletedSubtreeRoot = this.deleteDupSubtree(idKey, (BIN)in, index);
            }
        }
        finally {
            in.releaseLatch();
        }
        if (deletedSubtreeRoot != null && !this.database.isDeferredWriteMode()) {
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            deletedSubtreeRoot.accountForSubtreeRemoval(envImpl.getInMemoryINs(), localTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IN deleteDupSubtree(byte[] idKey, BIN bin, int index) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        INList inList = envImpl.getInMemoryINs();
        DupCountLN dcl = null;
        BasicLocker locker = BasicLocker.createBasicLocker(envImpl);
        locker.setPreemptable(false);
        DIN duplicateRoot = (DIN)bin.fetchTarget(index);
        duplicateRoot.latch(CacheMode.UNCHANGED);
        ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
        IN subtreeRootIN = null;
        try {
            ChildReference dclRef = duplicateRoot.getDupCountLNRef();
            dcl = (DupCountLN)dclRef.fetchTarget(this.database, duplicateRoot);
            LockResult lockResult = locker.nonBlockingLock(dcl.getNodeId(), LockType.READ, this.database);
            if (lockResult.getLockGrant() == LockGrantType.DENIED) {
                throw CursorsExistException.CURSORS_EXIST;
            }
            this.searchDeletableSubTree(duplicateRoot, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
                if (bin.nCursors() != 0) throw CursorsExistException.CURSORS_EXIST;
                boolean deleteOk = bin.deleteEntry(index, true);
                assert (deleteOk);
                INDupDeleteInfo info = new INDupDeleteInfo(duplicateRoot.getNodeId(), duplicateRoot.getMainTreeKey(), duplicateRoot.getDupTreeKey(), this.database.getId());
                info.optionalLog(envImpl.getLogManager(), this.database);
                subtreeRootIN = duplicateRoot;
                if (bin.getNEntries() != 0) return subtreeRootIN;
                this.database.getDbEnvironment().addToCompressorQueue(bin, null, false);
                return subtreeRootIN;
            } else {
                SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                assert (deleteOk);
                subtreeRootIN = detachPoint.child;
                if (this.database.isDeferredWriteMode()) {
                    subtreeRootIN.accountForDeferredWriteSubtreeRemoval(inList, detachPoint.parent);
                }
                this.cascadeUpdates(nodeLadder, bin, index);
            }
            return subtreeRootIN;
        }
        finally {
            this.releaseNodeLadderLatches(nodeLadder);
            locker.operationEnd(true);
            duplicateRoot.releaseLatch();
        }
    }

    public IN getFirstNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.LEFT, -1L, null, cacheMode);
    }

    public IN getLastNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.RIGHT, -1L, null, cacheMode);
    }

    public DBIN getFirstNode(DIN dupRoot, CacheMode cacheMode) throws DatabaseException {
        if (dupRoot == null) {
            throw EnvironmentFailureException.unexpectedState("getFirstNode passed null root");
        }
        assert (dupRoot.isLatchOwnerForWrite());
        IN ret = this.searchSubTree(dupRoot, null, SearchType.LEFT, -1L, null, cacheMode);
        return (DBIN)ret;
    }

    public DBIN getLastNode(DIN dupRoot, CacheMode cacheMode) throws DatabaseException {
        if (dupRoot == null) {
            throw EnvironmentFailureException.unexpectedState("getLastNode passed null root");
        }
        assert (dupRoot.isLatchOwnerForWrite());
        IN ret = this.searchSubTree(dupRoot, null, SearchType.RIGHT, -1L, null, cacheMode);
        return (DBIN)ret;
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, cacheMode, -1, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList) throws DatabaseException {
        if (child == null) {
            throw EnvironmentFailureException.unexpectedState("getParentNode passed null");
        }
        assert (child.isLatchOwnerForWrite());
        byte[] mainTreeKey = child.getMainTreeKey();
        byte[] dupTreeKey = child.getDupTreeKey();
        boolean isRoot = child.isRoot();
        child.releaseLatch();
        return this.getParentINForChildIN(child.getNodeId(), child.containsDuplicates(), isRoot, mainTreeKey, dupTreeKey, requireExactMatch, cacheMode, targetLevel, trackingList, true);
    }

    public SearchResult getParentINForChildIN(long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, byte[] targetMainTreeKey, byte[] targetDupTreeKey, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList, boolean doFetch) throws DatabaseException {
        IN rootIN = this.getRootINLatchedExclusive(cacheMode);
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId()));
            }
            IN potentialParent = rootIN;
            boolean success = false;
            try {
                while (result.keepSearching) {
                    assert (TestHookExecute.doHookIfSet(this.searchHook));
                    potentialParent.findParent(SearchType.NORMAL, targetNodeId, targetContainsDuplicates, targetIsRoot, targetMainTreeKey, targetDupTreeKey, result, requireExactMatch, cacheMode, targetLevel, trackingList, doFetch);
                    potentialParent = result.parent;
                }
                success = true;
            }
            catch (RelatchRequiredException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                if (!success) {
                    potentialParent.releaseLatch();
                }
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, byte[] mainKey, byte[] dupKey, LN ln, boolean splitsAllowed, boolean findDeletedEntries, boolean searchDupTree, CacheMode cacheMode) throws DatabaseException {
        IN searchResult = null;
        searchResult = splitsAllowed ? this.searchSplitsAllowed(mainKey, -1L, cacheMode) : this.search(mainKey, SearchType.NORMAL, -1L, null, cacheMode);
        location.bin = (BIN)searchResult;
        if (location.bin == null) {
            return false;
        }
        boolean exactSearch = false;
        boolean indicateIfExact = true;
        if (!findDeletedEntries) {
            exactSearch = true;
            indicateIfExact = false;
        }
        location.index = location.bin.findEntry(mainKey, indicateIfExact, exactSearch);
        boolean match = false;
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            if (!location.bin.isEntryKnownDeleted(location.index) && this.database.getSortedDuplicates()) {
                Node childNode = location.bin.fetchTarget(location.index);
                try {
                    if (childNode != null) {
                        if (ln.containsDuplicates()) {
                            return this.searchDupTreeForDupCountLNParent(location, mainKey, childNode);
                        }
                        if (childNode.containsDuplicates()) {
                            if (dupKey == null) {
                                return this.searchDupTreeByNodeId(location, childNode, ln, searchDupTree, cacheMode);
                            }
                            return this.searchDupTreeForDBIN(location, dupKey, (DIN)childNode, ln, findDeletedEntries, indicateIfExact, exactSearch, splitsAllowed, cacheMode);
                        }
                    }
                }
                catch (DatabaseException e) {
                    location.bin.releaseLatchIfOwner();
                    throw e;
                }
            }
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        location.lnKey = mainKey;
        return false;
    }

    private boolean searchDupTreeByNodeId(TreeLocation location, Node childNode, LN ln, boolean searchDupTree, CacheMode cacheMode) throws DatabaseException {
        if (searchDupTree) {
            BIN oldBIN = location.bin;
            if (childNode.matchLNByNodeId(location, ln.getNodeId(), cacheMode)) {
                location.index &= 0xFFFEFFFF;
                if (oldBIN != null) {
                    oldBIN.releaseLatch();
                }
                location.bin.latch(cacheMode);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean searchDupTreeForDupCountLNParent(TreeLocation location, byte[] mainKey, Node childNode) {
        location.lnKey = mainKey;
        if (childNode instanceof DIN) {
            DIN dupRoot = (DIN)childNode;
            location.childLsn = dupRoot.getDupCountLNRef().getLsn();
            return true;
        }
        return false;
    }

    private boolean searchDupTreeForDBIN(TreeLocation location, byte[] dupKey, DIN dupRoot, LN ln, boolean findDeletedEntries, boolean indicateIfExact, boolean exactSearch, boolean splitsAllowed, CacheMode cacheMode) throws DatabaseException {
        boolean match;
        assert (dupKey != null);
        dupRoot.latch(cacheMode);
        if (this.maybeSplitDuplicateRoot(location.bin, location.index, cacheMode)) {
            dupRoot = (DIN)location.bin.fetchTarget(location.index);
        }
        location.bin.releaseLatch();
        location.lnKey = dupKey;
        if (splitsAllowed) {
            try {
                location.bin = (BIN)this.searchSubTreeSplitsAllowed(dupRoot, location.lnKey, ln.getNodeId(), cacheMode);
            }
            catch (RelatchRequiredException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            catch (SplitRequiredException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
        } else {
            location.bin = (BIN)this.searchSubTree(dupRoot, location.lnKey, SearchType.NORMAL, ln.getNodeId(), null, cacheMode);
        }
        location.index = location.bin.findEntry(location.lnKey, indicateIfExact, exactSearch);
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        return false;
    }

    public BIN getNextBin(BIN bin, boolean traverseWithinDupTree, CacheMode cacheMode) throws DatabaseException {
        return this.getNextBinInternal(traverseWithinDupTree, bin, true, cacheMode);
    }

    public BIN getPrevBin(BIN bin, boolean traverseWithinDupTree, CacheMode cacheMode) throws DatabaseException {
        return this.getNextBinInternal(traverseWithinDupTree, bin, false, cacheMode);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BIN getNextBinInternal(boolean traverseWithinDupTree, BIN bin, boolean forward, CacheMode cacheMode) throws DatabaseException {
        byte[] idKey = null;
        idKey = bin.getNEntries() == 0 ? bin.getIdentifierKey() : (forward ? bin.getKey(bin.getNEntries() - 1) : bin.getKey(0));
        BIN bIN = bin;
        boolean nextIsLatched = false;
        assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
        IN parent = null;
        IN nextIN = null;
        boolean nextINIsLatched = false;
        try {
            while (true) {
                block24: {
                    void var6_7;
                    SearchResult result = null;
                    if (!traverseWithinDupTree) {
                        nextIsLatched = false;
                        result = this.getParentINForChildIN((IN)var6_7, true, cacheMode);
                        if (result.exactParentFound) {
                            parent = result.parent;
                            break block24;
                        } else {
                            assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
                            return null;
                        }
                    }
                    if (var6_7.isRoot()) {
                        var6_7.releaseLatch();
                        return null;
                    }
                    nextIsLatched = false;
                    result = this.getParentINForChildIN((IN)var6_7, true, cacheMode);
                    if (!result.exactParentFound) {
                        return null;
                    }
                    parent = result.parent;
                }
                assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                int index = parent.findEntry(idKey, false, false);
                boolean moreEntriesThisBin = false;
                if (forward) {
                    if (++index < parent.getNEntries()) {
                        moreEntriesThisBin = true;
                    }
                } else {
                    if (index > 0) {
                        moreEntriesThisBin = true;
                    }
                    --index;
                }
                if (moreEntriesThisBin) {
                    nextIN = (IN)parent.fetchTargetWithExclusiveLatch(index);
                    nextIN.latch(cacheMode);
                    nextINIsLatched = true;
                    assert (LatchSupport.countLatchesHeld() == 2) : LatchSupport.latchesHeldToString();
                    if (nextIN instanceof BIN) {
                        parent.releaseLatch();
                        parent = null;
                        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                        if (treeStatsAccumulator != null) {
                            nextIN.accumulateStats(treeStatsAccumulator);
                        }
                        return (BIN)nextIN;
                    }
                    IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, -1L, null, cacheMode);
                    nextINIsLatched = false;
                    parent.releaseLatch();
                    parent = null;
                    assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                    if (ret instanceof BIN) {
                        return (BIN)ret;
                    }
                    throw EnvironmentFailureException.unexpectedState("subtree did not have a BIN for leaf");
                }
                IN iN = parent;
                nextIsLatched = true;
                parent = null;
            }
        }
        catch (DatabaseException e) {
            if (bIN != null && nextIsLatched) {
                bIN.releaseLatch();
            }
            if (parent != null) {
                parent.releaseLatch();
            }
            if (nextIN != null && nextINIsLatched) {
                nextIN.releaseLatch();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(CacheMode cacheMode) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch(cacheMode);
        long curRootLsn = 0L;
        long logLsn = 0L;
        IN newRoot = null;
        try {
            byte[] rootIdKey = curRoot.getKey(0);
            newRoot = new IN(this.database, rootIdKey, this.maxMainTreeEntriesPerNode, curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            newRoot.setIsRoot(true);
            curRoot.setIsRoot(false);
            try {
                curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
                assert (insertOk);
                logLsn = newRoot.optionalLog(logManager);
            }
            catch (DatabaseException e) {
                curRoot.setIsRoot(true);
                throw e;
            }
            inMemoryINs.add(newRoot);
            this.root.setTarget(newRoot);
            this.root.updateLsnAfterOptionalLog(this.database, logLsn);
            curRoot.split(newRoot, 0, this.maxMainTreeEntriesPerNode, cacheMode);
            this.root.setLsn(newRoot.getLastFullVersion());
        }
        finally {
            newRoot.releaseLatch();
            curRoot.releaseLatch();
        }
        this.rootSplits.increment();
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public IN search(byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, CacheMode cacheMode) throws DatabaseException {
        IN rootIN = this.getRootIN(cacheMode);
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, nid, binBoundary, cacheMode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN searchSplitsAllowed(byte[] key, long nid, CacheMode cacheMode) throws DatabaseException {
        IN insertTarget = null;
        block7: while (insertTarget == null) {
            this.rootLatch.acquireShared();
            boolean rootLatched = true;
            boolean rootLatchedExclusive = false;
            boolean rootINLatched = false;
            boolean success = false;
            IN rootIN = null;
            try {
                while (this.rootExists()) {
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    if (rootIN.needsSplitting()) {
                        if (!rootLatchedExclusive) {
                            rootIN = null;
                            this.rootLatch.release();
                            this.rootLatch.acquireExclusive();
                            rootLatchedExclusive = true;
                            continue;
                        }
                        this.splitRoot(cacheMode);
                        this.rootLatch.release();
                        rootLatched = false;
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        env.getDbTree().optionalModifyDbRoot(this.database);
                        rootLatched = true;
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        rootIN.latch(cacheMode);
                    } else {
                        rootIN.latchShared(cacheMode);
                    }
                    rootINLatched = true;
                    break;
                }
                success = true;
            }
            finally {
                if (!success && rootINLatched) {
                    rootIN.releaseLatch();
                }
                if (rootLatched) {
                    this.rootLatch.release();
                }
            }
            if (rootIN == null) break;
            try {
                assert (rootINLatched);
                while (true) {
                    try {
                        insertTarget = this.searchSubTreeSplitsAllowed(rootIN, key, nid, cacheMode);
                        continue block7;
                    }
                    catch (RelatchRequiredException RRE) {
                        this.relatchesRequired.increment();
                        this.database.getDbEnvironment().incRelatchesRequired();
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        rootIN.latch(cacheMode);
                        this.rootLatch.release();
                        continue;
                    }
                    break;
                }
            }
            catch (SplitRequiredException e) {
            }
        }
        return insertTarget;
    }

    public void loadStats(StatsConfig config, BtreeStats btreeStats) {
        btreeStats.setTreeStats(this.stats.cloneGroup(false));
        if (config.getClear()) {
            this.relatchesRequired.clear();
        }
    }

    public IN searchSubTree(IN parent, byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, CacheMode cacheMode) throws DatabaseException {
        for (int i = 0; i < 2; ++i) {
            try {
                return this.searchSubTreeInternal(parent, key, searchType, nid, binBoundary, cacheMode);
            }
            catch (RelatchRequiredException RRE) {
                parent = this.getRootINLatchedExclusive(cacheMode);
                continue;
            }
        }
        throw EnvironmentFailureException.unexpectedState("searchSubTreeInternal should have completed in two tries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN searchSubTreeInternal(IN parent, byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, CacheMode cacheMode) throws RelatchRequiredException, DatabaseException {
        if (parent == null) {
            return null;
        }
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw EnvironmentFailureException.unexpectedState("searchSubTree passed key and left/right search");
        }
        assert (parent.isLatchOwnerForRead());
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        if (binBoundary != null) {
            binBoundary.isLastBin = true;
            binBoundary.isFirstBin = true;
        }
        IN child = null;
        IN grandParent = null;
        boolean childIsLatched = false;
        boolean grandParentIsLatched = false;
        boolean maintainGrandParentLatches = !parent.isLatchOwnerForWrite();
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        boolean success = false;
        try {
            do {
                int index;
                if (treeStatsAccumulator != null) {
                    parent.accumulateStats(treeStatsAccumulator);
                }
                if (parent.getNEntries() == 0) {
                    success = true;
                    IN iN = parent;
                    return iN;
                }
                if (searchType == SearchType.NORMAL) {
                    index = parent.findEntry(key, false, false);
                } else if (searchType == SearchType.LEFT) {
                    index = 0;
                } else if (searchType == SearchType.RIGHT) {
                    index = parent.getNEntries() - 1;
                } else {
                    throw EnvironmentFailureException.unexpectedState("Invalid value of searchType: " + searchType);
                }
                assert (index >= 0);
                if (binBoundary != null) {
                    if (index != parent.getNEntries() - 1) {
                        binBoundary.isLastBin = false;
                    }
                    if (index != 0) {
                        binBoundary.isFirstBin = false;
                    }
                }
                if (maintainGrandParentLatches && parent.getTarget(index) == null && !parent.isAlwaysLatchedExclusively()) {
                    if (grandParent == null) {
                        throw RelatchRequiredException.relatchRequiredException;
                    }
                    parent.releaseLatch();
                    parent.latch(cacheMode);
                    if (grandParent != null) {
                        grandParent.releaseLatch();
                        grandParentIsLatched = false;
                        grandParent = null;
                    }
                }
                child = (IN)parent.fetchTarget(index);
                if (grandParent != null) {
                    grandParent.releaseLatch();
                    grandParentIsLatched = false;
                }
                if (maintainGrandParentLatches) {
                    child.latchShared(cacheMode);
                } else {
                    child.latch(cacheMode);
                }
                childIsLatched = true;
                if (treeStatsAccumulator != null) {
                    child.accumulateStats(treeStatsAccumulator);
                }
                if (child.getNodeId() == nid) {
                    child.releaseLatch();
                    childIsLatched = false;
                    success = true;
                    IN iN = parent;
                    return iN;
                }
                if (maintainGrandParentLatches) {
                    grandParent = parent;
                    grandParentIsLatched = true;
                    continue;
                }
                parent.releaseLatch();
            } while (!((parent = child) instanceof BIN));
            success = true;
            IN iN = child;
            return iN;
        }
        finally {
            if (!success) {
                try {
                    if (child != null && childIsLatched) {
                        child.releaseLatch();
                    }
                    if (parent != child) {
                        parent.releaseLatch();
                    }
                }
                catch (Exception t2) {
                    t2.printStackTrace();
                }
            }
            if (grandParent != null && grandParentIsLatched) {
                grandParent.releaseLatch();
                grandParentIsLatched = false;
            }
        }
    }

    public void searchDeletableSubTree(IN parent, byte[] key, ArrayList<SplitInfo> nodeLadder) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        assert (parent != null);
        assert (key != null);
        assert (parent.isLatchOwnerForWrite());
        IN child = null;
        IN lowestMultipleEntryIN = null;
        while (parent.getNEntries() != 0) {
            if (parent.getNEntries() > 1) {
                lowestMultipleEntryIN = parent;
            }
            int index = parent.findEntry(key, false, false);
            assert (index >= 0);
            child = (IN)parent.fetchTargetWithExclusiveLatch(index);
            child.latch(CacheMode.UNCHANGED);
            nodeLadder.add(new SplitInfo(parent, child, index));
            parent = child;
            if (!(parent instanceof BIN)) continue;
        }
        if (child != null && child instanceof BIN) {
            if (child.getNEntries() != 0) {
                throw NodeNotEmptyException.NODE_NOT_EMPTY;
            }
            if (((BIN)child).nCursors() > 0) {
                throw CursorsExistException.CURSORS_EXIST;
            }
        }
        if (lowestMultipleEntryIN != null) {
            ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = iter.previous();
                if (info.parent != lowestMultipleEntryIN) {
                    info.child.releaseLatch();
                    iter.remove();
                    continue;
                }
                break;
            }
        } else {
            this.releaseNodeLadderLatches(nodeLadder);
            nodeLadder.clear();
        }
    }

    private IN searchSubTreeSplitsAllowed(IN parent, byte[] key, long nid, CacheMode cacheMode) throws RelatchRequiredException, DatabaseException, SplitRequiredException {
        if (parent != null) {
            while (true) {
                try {
                    return this.searchSubTreeUntilSplit(parent, key, nid, cacheMode);
                }
                catch (SplitRequiredException e) {
                    assert (TestHookExecute.doHookIfSet(this.waitHook));
                    parent = this.forceSplit(parent, key, cacheMode);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN searchSubTreeUntilSplit(IN parent, byte[] key, long nid, CacheMode cacheMode) throws RelatchRequiredException, DatabaseException, SplitRequiredException {
        boolean latchingIsExclusive = parent.isLatchOwnerForWrite();
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        IN child = null;
        boolean childIsLatched = false;
        boolean success = false;
        try {
            do {
                if (parent.getNEntries() == 0) {
                    success = true;
                    IN iN = parent;
                    return iN;
                }
                int index = parent.findEntry(key, false, false);
                assert (index >= 0);
                child = (IN)parent.fetchTarget(index);
                if (latchingIsExclusive || child.isAlwaysLatchedExclusively()) {
                    child.latch(cacheMode);
                } else {
                    child.latchShared(cacheMode);
                }
                childIsLatched = true;
                if (child.needsSplitting()) {
                    throw splitRequiredException;
                }
                if (child.getNodeId() == nid) {
                    child.releaseLatch();
                    childIsLatched = false;
                    success = true;
                    IN iN = parent;
                    return iN;
                }
                parent.releaseLatch();
            } while (!((parent = child) instanceof BIN));
            success = true;
            IN iN = parent;
            return iN;
        }
        finally {
            if (!success) {
                if (child != null && childIsLatched) {
                    child.releaseLatch();
                }
                if (parent != child) {
                    parent.releaseLatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN forceSplit(IN parent, byte[] key, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        boolean isRootLatched;
        IN originalParent;
        block24: {
            block25: {
                ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
                boolean allLeftSideDescent = true;
                boolean allRightSideDescent = true;
                IN child = null;
                originalParent = parent;
                ListIterator iter = null;
                isRootLatched = false;
                boolean success = false;
                try {
                    int index;
                    if (originalParent.isDbRoot()) {
                        this.rootLatch.acquireExclusive();
                        isRootLatched = true;
                        originalParent = parent = (IN)this.root.fetchTarget(this.database, null);
                    }
                    originalParent.latch(cacheMode);
                    if (originalParent.needsSplitting() || !originalParent.isRoot()) {
                        throw splitRequiredException;
                    }
                    while (parent.getNEntries() != 0) {
                        index = parent.findEntry(key, false, false);
                        if (index != 0) {
                            allLeftSideDescent = false;
                        }
                        if (index != parent.getNEntries() - 1) {
                            allRightSideDescent = false;
                        }
                        assert (index >= 0);
                        child = (IN)parent.getTarget(index);
                        if (child == null) break;
                        child.latch(cacheMode);
                        nodeLadder.add(new SplitInfo(parent, child, index));
                        parent = child;
                        if (!(parent instanceof BIN)) continue;
                    }
                    boolean startedSplits = false;
                    LogManager logManager = this.database.getDbEnvironment().getLogManager();
                    iter = nodeLadder.listIterator(nodeLadder.size());
                    long lastParentForSplit = -1L;
                    while (iter.hasPrevious()) {
                        SplitInfo info = (SplitInfo)iter.previous();
                        iter.remove();
                        child = info.child;
                        parent = info.parent;
                        index = info.index;
                        if (child.needsSplitting()) {
                            int maxEntriesPerNode;
                            int n = maxEntriesPerNode = child.containsDuplicates() ? this.maxDupTreeEntriesPerNode : this.maxMainTreeEntriesPerNode;
                            if (allLeftSideDescent || allRightSideDescent) {
                                child.splitSpecial(parent, index, maxEntriesPerNode, key, allLeftSideDescent, cacheMode);
                            } else {
                                child.split(parent, index, maxEntriesPerNode, cacheMode);
                            }
                            lastParentForSplit = parent.getNodeId();
                            startedSplits = true;
                            if (parent.isDbRoot()) {
                                assert (isRootLatched);
                                this.root.setLsn(parent.getLastFullVersion());
                                parent.setDirty(true);
                            }
                        } else if (startedSplits) {
                            long newLsn = 0L;
                            newLsn = lastParentForSplit == child.getNodeId() ? child.getLastFullVersion() : child.optionalLog(logManager);
                            parent.updateEntry(index, newLsn);
                        }
                        child.releaseLatch();
                        child = null;
                    }
                    success = true;
                    if (success) break block24;
                    if (child != null) {
                        child.releaseLatch();
                    }
                    if (nodeLadder.size() <= 0) break block25;
                    iter = nodeLadder.listIterator(nodeLadder.size());
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (child != null) {
                            child.releaseLatch();
                        }
                        if (nodeLadder.size() > 0) {
                            iter = nodeLadder.listIterator(nodeLadder.size());
                            while (iter.hasPrevious()) {
                                SplitInfo info = (SplitInfo)iter.previous();
                                info.child.releaseLatch();
                            }
                        }
                        originalParent.releaseLatch();
                    }
                    if (isRootLatched) {
                        this.rootLatch.release();
                    }
                    throw throwable;
                }
                while (iter.hasPrevious()) {
                    SplitInfo info = (SplitInfo)iter.previous();
                    info.child.releaseLatch();
                }
            }
            originalParent.releaseLatch();
        }
        if (isRootLatched) {
            this.rootLatch.release();
        }
        return originalParent;
    }

    public IN getRootIN(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, false);
    }

    public IN getRootINLatchedExclusive(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootINInternal(CacheMode cacheMode, boolean exclusive) throws DatabaseException {
        this.rootLatch.acquireShared();
        IN rootIN = null;
        try {
            if (this.rootExists()) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                if (exclusive) {
                    rootIN.latch(cacheMode);
                } else {
                    rootIN.latchShared(cacheMode);
                }
            }
            IN iN = rootIN;
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public IN getResidentRootIN(boolean latched) throws DatabaseException {
        IN rootIN = null;
        if (this.rootExists() && (rootIN = (IN)this.root.getTarget()) != null && latched) {
            rootIN.latchShared(CacheMode.UNCHANGED);
        }
        return rootIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(LN ln, byte[] key, boolean allowDuplicates, CursorImpl cursor, LockResult lnLock, ReplicationContext repContext) {
        try {
            this.findBinForInsert(key, cursor);
            assert (cursor.getBIN().isLatchOwnerForWrite());
            if (this.insertNewSlot(ln, key, cursor, lnLock, repContext)) {
                boolean bl = true;
                return bl;
            }
            SlotReuseInfo slotInfo = this.getSlotReuseInfo(ln, key, cursor);
            if (slotInfo.slotReuseAllowed) {
                this.reuseExistingSlot(ln, key, cursor, lnLock, repContext, slotInfo);
                boolean bl = true;
                return bl;
            }
            boolean bl = this.insertDuplicate(ln, key, allowDuplicates, cursor, lnLock, repContext, slotInfo.originalLNData);
            return bl;
        }
        finally {
            cursor.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertNewSlot(LN ln, byte[] key, CursorImpl cursor, LockResult lnLock, ReplicationContext repContext) {
        EnvironmentImpl env = this.database.getDbEnvironment();
        ChildReference newLNRef = new ChildReference(ln, key, -1L);
        BIN bin = cursor.getBIN();
        int index = bin.insertEntry1(newLNRef);
        if ((index & 0x20000) == 0) {
            cursor.updateBin(bin, index & 0xFFFEFFFF);
            return false;
        }
        cursor.updateBin(bin, index &= 0xFFFDFFFF);
        long newLsn = -1L;
        try {
            newLsn = ln.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
        }
        finally {
            if (newLsn == -1L && !this.database.isDeferredWriteMode()) {
                bin.setKnownDeleted(index);
            }
        }
        lnLock.setAbortLsn(-1L, true, true);
        bin.updateEntry(index, newLsn);
        this.traceInsert(Level.FINER, env, bin, ln, newLsn, index);
        return true;
    }

    private void reuseExistingSlot(LN ln, byte[] key, CursorImpl cursor, LockResult lnLock, ReplicationContext repContext, SlotReuseInfo slotInfo) {
        EnvironmentImpl env = this.database.getDbEnvironment();
        if (slotInfo.isExistingLock) {
            lnLock.copyAbortInfo(slotInfo.existingLockInfo);
        }
        lnLock.setAbortLsn(slotInfo.abortLsn, slotInfo.abortKnownDeleted);
        long newLsn = ln.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        bin.updateEntry(index, ln, newLsn, key);
        bin.clearKnownDeleted(index);
        bin.clearPendingDeleted(index);
        this.traceInsert(Level.FINER, env, bin, ln, newLsn, index);
    }

    private SlotReuseInfo getSlotReuseInfo(LN ln, byte[] key, CursorImpl cursor) {
        EnvironmentImpl env = this.database.getDbEnvironment();
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        if (this.database.getSortedDuplicates() && this.database.getBtreeComparator() != null && !Arrays.equals(key, bin.getKey(index))) {
            throw new IllegalArgumentException("Custom Btree comparator matches two non-identical keys in a Database with duplicates configured");
        }
        LN currentLN = null;
        boolean isDup = false;
        Node node = bin.fetchTarget(index);
        if (node == null || node instanceof LN) {
            currentLN = (LN)node;
        } else {
            isDup = true;
        }
        boolean isDeleted = false;
        LockResult currentLock = null;
        if (!isDup) {
            if (currentLN == null) {
                isDeleted = true;
            } else {
                currentLock = cursor.lockLNDeletedAllowed(currentLN, LockType.WRITE);
                currentLN = currentLock.getLN();
                bin = cursor.getBIN();
                index = cursor.getIndex();
                if (cursor.getDupBIN() != null) {
                    cursor.clearDupBIN(true);
                    isDup = true;
                } else if (bin.isEntryKnownDeleted(index) || currentLN == null || currentLN.isDeleted()) {
                    isDeleted = true;
                }
            }
        }
        SlotReuseInfo slotInfo = new SlotReuseInfo();
        slotInfo.slotReuseAllowed = false;
        slotInfo.isExistingLock = false;
        slotInfo.existingLockInfo = null;
        slotInfo.abortLsn = -1L;
        slotInfo.abortKnownDeleted = false;
        byte[] byArray = slotInfo.originalLNData = currentLN != null ? currentLN.getData() : null;
        if (!isDeleted) {
            return slotInfo;
        }
        slotInfo.slotReuseAllowed = true;
        slotInfo.isExistingLock = currentLN != null && currentLock.getLockGrant() == LockGrantType.EXISTING;
        slotInfo.abortLsn = bin.getLsn(index);
        slotInfo.abortKnownDeleted = true;
        if (slotInfo.isExistingLock) {
            long nodeId = currentLN.getNodeId();
            Locker locker = cursor.getLocker();
            slotInfo.existingLockInfo = locker.getWriteLockInfo(nodeId);
            slotInfo.abortLsn = slotInfo.existingLockInfo.getAbortLsn();
            slotInfo.abortKnownDeleted = slotInfo.existingLockInfo.getAbortKnownDeleted();
        }
        if (this.database.getSortedDuplicates() && !slotInfo.abortKnownDeleted && slotInfo.abortLsn != -1L) {
            LN originalLN;
            try {
                originalLN = (LN)env.getLogManager().getEntry(slotInfo.abortLsn);
            }
            catch (FileNotFoundException e) {
                throw EnvironmentFailureException.unexpectedException("Prior non-deleted version was cleaned", (Exception)e);
            }
            if (originalLN.isDeleted()) {
                throw EnvironmentFailureException.unexpectedState("Prior version is deleted, abortLsn=" + DbLsn.getNoFormatString(slotInfo.abortLsn));
            }
            slotInfo.originalLNData = originalLN.getData();
            if (Key.compareKeys(ln.getData(), slotInfo.originalLNData, this.database.getDuplicateComparator()) != 0) {
                slotInfo.slotReuseAllowed = false;
            }
        }
        return slotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean insertDuplicate(LN newLN, byte[] key, boolean allowDuplicates, CursorImpl cursor, LockResult lnLock, ReplicationContext repContext, byte[] originalLNData) {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        boolean successfulInsert = false;
        DIN dupRoot = null;
        Node n = bin.fetchTarget(index);
        long binNid = bin.getNodeId();
        if (n instanceof DIN) {
            IN dupBin = null;
            try {
                CacheMode cacheMode = cursor.getCacheMode();
                dupRoot = (DIN)n;
                dupRoot.latch(cacheMode);
                LockResult dclLockResult = cursor.lockDupCountLN(dupRoot, LockType.WRITE);
                bin = cursor.getBIN();
                index = cursor.getIndex();
                if (!allowDuplicates) {
                    dupRoot = (DIN)bin.fetchTarget(index);
                    DupCountLN dcl = (DupCountLN)dclLockResult.getLN();
                    if (dcl.getDupCount() > 0) {
                        boolean bl = false;
                        return bl;
                    }
                }
                this.maybeSplitDuplicateRoot(bin, index, cacheMode);
                dupRoot = (DIN)bin.fetchTarget(index);
                byte[] newLNKey = newLN.getData();
                long previousLsn = dupRoot.getLastFullVersion();
                try {
                    dupBin = (DBIN)this.searchSubTreeSplitsAllowed(dupRoot, newLNKey, -1L, cacheMode);
                }
                catch (RelatchRequiredException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                catch (SplitRequiredException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                long currentLsn = dupRoot.getLastFullVersion();
                if (currentLsn != previousLsn) {
                    bin.updateEntry(index, currentLsn);
                }
                cursor.releaseBIN();
                bin = null;
                dupRoot = null;
                ChildReference newLNRef = new ChildReference(newLN, newLNKey, -1L);
                int dupIndex = dupBin.insertEntry1(newLNRef);
                if ((dupIndex & 0x20000) != 0) {
                    cursor.updateDBin((DBIN)dupBin, dupIndex &= 0xFFFDFFFF);
                    long newLsn = -1L;
                    try {
                        newLsn = newLN.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
                    }
                    finally {
                        if (newLsn == -1L && !this.database.isDeferredWriteMode()) {
                            ((BIN)dupBin).setKnownDeleted(dupIndex);
                        }
                    }
                    lnLock.setAbortLsn(-1L, true, true);
                    dupBin.updateEntry(dupIndex, newLsn);
                    this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)dupBin, newLN, newLsn, binNid);
                    successfulInsert = true;
                } else {
                    cursor.updateDBin((DBIN)dupBin, dupIndex &= 0xFFFEFFFF);
                    LN currentLN = (LN)((BIN)dupBin).fetchTarget(dupIndex);
                    boolean isDeleted = false;
                    LockResult currentLock = null;
                    if (currentLN == null) {
                        isDeleted = true;
                    } else {
                        currentLock = cursor.lockLNDeletedAllowed(currentLN, LockType.WRITE);
                        currentLN = currentLock.getLN();
                        cursor.releaseBIN();
                        dupBin = cursor.getDupBIN();
                        dupIndex = cursor.getDupIndex();
                        if (dupBin.isEntryKnownDeleted(dupIndex) || currentLN == null || currentLN.isDeleted()) {
                            isDeleted = true;
                        }
                    }
                    if (isDeleted) {
                        long abortLsn = dupBin.getLsn(dupIndex);
                        boolean abortKnownDeleted = true;
                        if (currentLN != null && currentLock.getLockGrant() == LockGrantType.EXISTING) {
                            long nodeId = currentLN.getNodeId();
                            Locker locker = cursor.getLocker();
                            WriteLockInfo info = locker.getWriteLockInfo(nodeId);
                            abortLsn = info.getAbortLsn();
                            abortKnownDeleted = info.getAbortKnownDeleted();
                            lnLock.copyAbortInfo(info);
                        }
                        lnLock.setAbortLsn(abortLsn, abortKnownDeleted);
                        long newLsn = newLN.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
                        dupBin.updateEntry(dupIndex, newLN, newLsn, newLNKey);
                        ((BIN)dupBin).clearKnownDeleted(dupIndex);
                        dupBin.clearPendingDeleted(dupIndex);
                        this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)dupBin, newLN, newLsn, binNid);
                        successfulInsert = true;
                    } else {
                        successfulInsert = false;
                    }
                }
                dupBin.releaseLatch();
                dupBin = null;
                if (!successfulInsert) return successfulInsert;
                cursor.latchBIN();
                dupRoot = cursor.getLatchedDupRoot(false);
                cursor.releaseBIN();
                dupRoot.incrementDuplicateCount(dclLockResult, key, cursor.getLocker(), true);
                return successfulInsert;
            }
            finally {
                if (dupBin != null) {
                    dupBin.releaseLatch();
                }
                if (dupRoot != null) {
                    dupRoot.releaseLatch();
                }
            }
        }
        if (!(n instanceof LN)) throw EnvironmentFailureException.unexpectedState("neither LN or DIN found in BIN");
        if (!allowDuplicates && !((LN)n).isDeleted()) {
            return false;
        }
        try {
            lnLock.setAbortLsn(-1L, true, true);
            dupRoot = this.createDuplicateTree(newLN, key, cursor, repContext, originalLNData);
            return successfulInsert;
        }
        finally {
            if (dupRoot != null) {
                dupRoot.releaseLatch();
                successfulInsert = true;
            } else {
                successfulInsert = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeSplitDuplicateRoot(BIN bin, int index, CacheMode cacheMode) throws DatabaseException {
        DIN curRoot = (DIN)bin.fetchTarget(index);
        if (curRoot.needsSplitting()) {
            EnvironmentImpl env = this.database.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            byte[] rootIdKey = curRoot.getKey(0);
            DIN newRoot = new DIN(this.database, rootIdKey, this.maxDupTreeEntriesPerNode, curRoot.getDupKey(), curRoot.getDupCountLNRef(), curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            long curRootLsn = 0L;
            long logLsn = 0L;
            try {
                newRoot.setIsRoot(true);
                curRoot.setDupCountLN(null);
                curRoot.setIsRoot(false);
                try {
                    curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                    boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, bin.getLsn(index)));
                    assert (insertOk);
                    logLsn = newRoot.optionalLog(logManager);
                }
                catch (DatabaseException e) {
                    curRoot.setIsRoot(true);
                    throw e;
                }
                inMemoryINs.add(newRoot);
                bin.updateNode(index, newRoot, logLsn, null);
                curRoot.split(newRoot, 0, this.maxDupTreeEntriesPerNode, cacheMode);
            }
            finally {
                curRoot.releaseLatch();
            }
            this.traceSplitRoot(Level.FINE, TRACE_DUP_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
            return true;
        }
        return false;
    }

    private DIN createDuplicateTree(LN newLN, byte[] key, CursorImpl cursor, ReplicationContext repContext, byte[] originalLNData) throws DatabaseException {
        long nodeId;
        boolean keysEqual;
        boolean existingLNIsDeleted;
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        DIN dupRoot = null;
        DBIN dupBin = null;
        boolean dupBinIsLatched = false;
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        LN existingLN = (LN)bin.fetchTarget(index);
        boolean bl = existingLNIsDeleted = bin.isEntryKnownDeleted(index) || existingLN.isDeleted();
        assert (existingLN != null);
        byte[] existingKey = originalLNData;
        byte[] newLNKey = newLN.getData();
        boolean bl2 = keysEqual = Key.compareKeys(newLNKey, existingKey, this.database.getDuplicateComparator()) == 0;
        if (keysEqual) {
            return null;
        }
        Locker locker = cursor.getLocker();
        int startingCount = locker.createdNode(nodeId = existingLN.getNodeId()) || locker.getWriteLockInfo(nodeId).getAbortKnownDeleted() ? 0 : 1;
        DupCountLN dupCountLN = new DupCountLN(this.database.getDbEnvironment(), startingCount);
        long firstDupCountLNLsn = dupCountLN.optionalLogProvisional(env, this.database, key, -1L, ReplicationContext.NO_REPLICATE);
        dupRoot = new DIN(this.database, existingKey, this.maxDupTreeEntriesPerNode, key, new ChildReference(dupCountLN, key, firstDupCountLNLsn), 2);
        CacheMode cacheMode = cursor.getCacheMode();
        dupRoot.latch(cacheMode);
        dupRoot.setIsRoot(true);
        dupBin = new DBIN(this.database, existingKey, this.maxDupTreeEntriesPerNode, key, 1);
        dupBin.latch(cacheMode);
        dupBinIsLatched = true;
        ChildReference newExistingLNRef = new ChildReference(existingLN, existingKey, bin.getLsn(index), bin.getState(index));
        boolean insertOk = dupBin.insertEntry(newExistingLNRef);
        assert (insertOk);
        try {
            long dbinLsn = dupBin.optionalLogProvisional(logManager, dupRoot);
            inMemoryINs.add(dupBin);
            dupRoot.setEntry(0, dupBin, dupBin.getKey(0), dbinLsn, dupBin.getState(0));
            bin.setMigrate(index, false);
            dupRoot.clearKnownDeleted(0);
            dupRoot.clearPendingDeleted(0);
            long dinLsn = dupRoot.optionalLog(logManager);
            inMemoryINs.add(dupRoot);
            LockResult lockResult = locker.lock(dupCountLN.getNodeId(), LockType.WRITE, false, this.database);
            lockResult.setAbortLsn(firstDupCountLNLsn, false);
            dupCountLN.setDupCount(existingLNIsDeleted ? 1 : 2);
            long dupCountLsn = dupCountLN.optionalLog(env, this.database, key, firstDupCountLNLsn, locker, ReplicationContext.NO_REPLICATE);
            dupRoot.updateDupCountLNRef(dupCountLsn);
            long newLsn = newLN.optionalLog(env, this.database, key, -1L, locker, repContext);
            int dupIndex = dupBin.insertEntry1(new ChildReference(newLN, newLNKey, newLsn));
            cursor.updateDBin(dupBin, dupIndex &= 0xFFFDFFFF);
            bin.adjustCursorsForMutation(index, dupBin, dupIndex ^ 1, cursor);
            dupBin.releaseLatch();
            dupBinIsLatched = false;
            bin.updateNode(index, dupRoot, dinLsn, null);
            bin.setMigrate(index, false);
            bin.clearKnownDeleted(index);
            bin.clearPendingDeleted(index);
            this.traceMutate(Level.FINE, bin, existingLN, newLN, newLsn, dupCountLN, dupCountLsn, dupRoot, dinLsn, dupBin, dbinLsn);
        }
        catch (DatabaseException e) {
            if (dupBinIsLatched) {
                dupBin.releaseLatch();
            }
            dupRoot.releaseLatch();
            throw e;
        }
        return dupRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findBinForInsert(byte[] key, CursorImpl cursor) {
        BIN bin;
        block11: {
            bin = cursor.latchBIN();
            if (bin != null) {
                if (!bin.needsSplitting() && bin.isKeyInBounds(key)) {
                    return;
                }
                bin.releaseLatch();
            }
            boolean rootLatchIsHeld = false;
            try {
                IN in;
                while (true) {
                    rootLatchIsHeld = true;
                    this.rootLatch.acquireShared();
                    if (!this.rootExists()) {
                        this.rootLatch.release();
                        this.rootLatch.acquireExclusive();
                        if (this.rootExists()) {
                            this.rootLatch.release();
                            rootLatchIsHeld = false;
                            continue;
                        }
                        CacheMode cacheMode = cursor.getCacheMode();
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        LogManager logManager = env.getLogManager();
                        INList inMemoryINs = env.getInMemoryINs();
                        bin = new BIN(this.database, key, this.maxMainTreeEntriesPerNode, 1);
                        bin.latch(cacheMode);
                        long logLsn = bin.optionalLogProvisional(logManager, null);
                        IN rootIN = new IN(this.database, key, this.maxMainTreeEntriesPerNode, 2);
                        rootIN.latch(cacheMode);
                        rootIN.setIsRoot(true);
                        boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                        assert (insertOk);
                        logLsn = rootIN.optionalLog(logManager);
                        rootIN.setDirty(true);
                        this.root = this.makeRootChildReference(rootIN, new byte[0], logLsn);
                        rootIN.releaseLatch();
                        inMemoryINs.add(bin);
                        inMemoryINs.add(rootIN);
                        this.rootLatch.release();
                        rootLatchIsHeld = false;
                        break block11;
                    }
                    this.rootLatch.release();
                    rootLatchIsHeld = false;
                    in = this.searchSplitsAllowed(key, -1L, cursor.getCacheMode());
                    if (in != null) break;
                }
                bin = (BIN)in;
            }
            finally {
                if (rootLatchIsHeld) {
                    this.rootLatch.release();
                }
            }
        }
        assert (TestHookExecute.doHookIfSet(this.ckptHook));
        cursor.setBIN(bin);
    }

    @Override
    public int getLogSize() {
        int size = 1;
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        byte booleans = (byte)(this.root != null ? 1 : 0);
        logBuffer.put(booleans);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean rootExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = rootExists = (booleans & 1) != 0;
        if (rootExists) {
            this.root = this.makeRootChildReference();
            this.root.readFromLog(itemBuffer, entryVersion);
        }
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquireShared();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
            }
            finally {
                this.rootLatch.release();
            }
        }
    }

    public void dump() {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            boolean bl = rootIN.validateSubtreeBeforeDelete(index);
            return bl;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getDbEnvironment().getInMemoryINs();
            if (!inList.contains(parent)) {
                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTarget(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray node " + node.getNodeId() + " at index " + i);
                            }
                            byte[] key = parent.getKey(i);
                            if (key != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void setWaitHook(TestHook hook) {
        this.waitHook = hook;
    }

    public void setSearchHook(TestHook hook) {
        this.searchHook = hook;
    }

    public void setCkptHook(TestHook hook) {
        this.ckptHook = hook;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            LoggerUtils.logMsg(logger, this.database.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceMutate(Level level, BIN theBin, LN existingLn, LN newLn, long newLsn, DupCountLN dupCountLN, long dupRootLsn, DIN dupRoot, long ddinLsn, DBIN dupBin, long dbinLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_MUTATE);
            sb.append(" existingLn=");
            sb.append(existingLn.getNodeId());
            sb.append(" newLn=");
            sb.append(newLn.getNodeId());
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            sb.append(" dupCountLN=");
            sb.append(dupCountLN.getNodeId());
            sb.append(" dupRootLsn=");
            sb.append(DbLsn.getNoFormatString(dupRootLsn));
            sb.append(" rootdin=");
            sb.append(dupRoot.getNodeId());
            sb.append(" ddinLsn=");
            sb.append(DbLsn.getNoFormatString(ddinLsn));
            sb.append(" dbin=");
            sb.append(dupBin.getNodeId());
            sb.append(" dbinLsn=");
            sb.append(DbLsn.getNoFormatString(dbinLsn));
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            LoggerUtils.logMsg(logger, this.database.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceInsert(Level level, EnvironmentImpl env, BIN insertingBin, LN ln, long lnLsn, int index) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(logger, env, level, sb.toString());
        }
    }

    private void traceInsertDuplicate(Level level, EnvironmentImpl env, BIN insertingDBin, LN ln, long lnLsn, long binNid) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT_DUPLICATE);
            sb.append(" dbin=");
            sb.append(insertingDBin.getNodeId());
            sb.append(" bin=");
            sb.append(binNid);
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            LoggerUtils.logMsg(logger, env, level, sb.toString());
        }
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    private class SlotReuseInfo {
        boolean slotReuseAllowed;
        boolean isExistingLock;
        WriteLockInfo existingLockInfo;
        long abortLsn;
        boolean abortKnownDeleted;
        byte[] originalLNData;

        private SlotReuseInfo() {
        }
    }

    private class RootChildReference
    extends ChildReference {
        private RootChildReference() {
        }

        private RootChildReference(Node target, byte[] key, long lsn) {
            super(target, key, lsn);
        }

        public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
            if (this.getTarget() == null && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                Tree.this.rootLatch.release();
                Tree.this.rootLatch.acquireExclusive();
                if (this != Tree.this.root) {
                    throw EnvironmentFailureException.unexpectedState(database.getDbEnvironment(), "Root changed while unlatched, dbId=" + database.getId());
                }
            }
            return super.fetchTarget(database, in);
        }

        public void setTarget(Node target) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.setTarget(target);
        }

        public void clearTarget() {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.clearTarget();
        }

        public void setLsn(long lsn) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.setLsn(lsn);
        }

        void updateLsnAfterOptionalLog(DatabaseImpl dbImpl, long lsn) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.updateLsnAfterOptionalLog(dbImpl, lsn);
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();

        private SearchType() {
        }
    }
}

