/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public abstract class Node
implements Loggable {
    private static final String BEGIN_TAG = "<node>";
    private static final String END_TAG = "</node>";
    public static final long NULL_NODE_ID = -1L;
    private long nodeId;

    protected Node() {
    }

    protected Node(EnvironmentImpl envImpl, boolean replicated) {
        this.nodeId = replicated ? envImpl.getNodeSequence().getNextReplicatedNodeId() : envImpl.getNodeSequence().getNextLocalNodeId();
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
    }

    public long getNodeId() {
        return this.nodeId;
    }

    void setNodeId(long nid) {
        this.nodeId = nid;
    }

    public void latchShared() throws DatabaseException {
    }

    public void latchShared(CacheMode ignore) throws DatabaseException {
    }

    public void releaseLatch() {
    }

    public void verify(byte[] maxKey) throws DatabaseException {
    }

    public boolean containsDuplicates() {
        return false;
    }

    public int getLevel() {
        return 0;
    }

    boolean matchLNByNodeId(TreeLocation location, long nodeId, CacheMode cachemode) throws DatabaseException {
        assert (false) : "matchLNByNodeId called on non DIN/DBIN";
        return false;
    }

    abstract void rebuildINList(INList var1) throws DatabaseException;

    abstract void accountForSubtreeRemoval(INList var1, LocalUtilizationTracker var2) throws DatabaseException;

    abstract void accountForDeferredWriteSubtreeRemoval(INList var1, IN var2) throws DatabaseException;

    abstract boolean isValidForDelete() throws DatabaseException;

    protected abstract boolean isSoughtNode(long var1, CacheMode var3, boolean var4) throws DatabaseException;

    protected abstract boolean canBeAncestor(boolean var1);

    protected long getMemorySizeIncludedByParent() {
        return 0L;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    private String beginTag() {
        return BEGIN_TAG;
    }

    private String endTag() {
        return END_TAG;
    }

    public void dump(int nSpaces) {
        System.out.print(this.dumpString(nSpaces, true));
    }

    String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        if (dumpTags) {
            self.append(this.beginTag());
        }
        self.append(this.nodeId);
        if (dumpTags) {
            self.append(this.endTag());
        }
        return self.toString();
    }

    public String shortDescription() {
        return "<" + this.getType() + "/" + this.getNodeId();
    }

    public String getType() {
        return this.getClass().getName();
    }

    public abstract void incFetchStats(EnvironmentImpl var1, boolean var2);

    public abstract LogEntryType getLogType();

    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.nodeId);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.nodeId);
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.nodeId = LogUtils.readLong(itemBuffer, entryVersion < 6);
    }

    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append(BEGIN_TAG);
        sb.append(this.nodeId);
        sb.append(END_TAG);
    }

    public long getTransactionId() {
        return 0L;
    }
}

