/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.utilint.VLSN;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepGroupImpl {
    private final String groupName;
    private UUID uuid;
    private final int version;
    private int changeVersion = 0;
    private int nodeIdSequence;
    private static final int NODE_SEQUENCE_START = 0;
    private Map<Integer, RepNodeImpl> nodesById;
    private Map<String, RepNodeImpl> nodesByName;
    private static final int VERSION = 2;
    private static final int CHANGE_VERSION_START = 0;
    private static final UUID UNKNOWN_UUID = new UUID(0L, 0L);

    public RepGroupImpl(String groupName) {
        this(groupName, false);
    }

    public RepGroupImpl(String groupName, boolean unknownUUID) {
        this(groupName, unknownUUID ? UNKNOWN_UUID : UUID.randomUUID(), 2, 0, 0, new HashMap<Integer, RepNodeImpl>());
    }

    public RepGroupImpl(String groupName, UUID uuid, int version, int changeVersion, int nodeIdSequence, Map<Integer, RepNodeImpl> nodes) {
        this.groupName = groupName;
        this.uuid = uuid;
        this.version = version;
        this.changeVersion = changeVersion;
        this.nodeIdSequence = nodeIdSequence;
        if (2 != version) {
            throw new IllegalStateException("Expected membership database version: 2 Encountered unsupported version: " + version);
        }
        this.setNodes(nodes);
    }

    public boolean hasUnknownUUID() {
        return UNKNOWN_UUID.equals(this.uuid);
    }

    public static boolean isUnknownUUID(UUID uuid) {
        return UNKNOWN_UUID.equals(uuid);
    }

    public void setUUID(UUID uuid) {
        if (!this.hasUnknownUUID()) {
            throw EnvironmentFailureException.unexpectedState("Expected placeholder UUID, not " + uuid);
        }
        this.uuid = uuid;
    }

    public RepNodeImpl removeMember(String nodeName) {
        RepNodeImpl node = this.getMember(nodeName);
        if (node == null) {
            throw EnvironmentFailureException.unexpectedState("Node:" + nodeName + " is not a member of the group.");
        }
        node.setRemoved(true);
        return node;
    }

    public void checkForConflicts(RepNodeImpl node) throws DatabaseException, NodeConflictException {
        for (RepNodeImpl n : this.getAllMembers(null)) {
            if (!n.getSocketAddress().equals(node.getSocketAddress())) continue;
            throw new NodeConflictException("New node:" + node.getName() + ", is configured with the socket address: " + n.getSocketAddress() + ". It conflicts with the socket already " + "used by the member: " + n.getName());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.changeVersion;
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + (this.nodesById == null ? 0 : this.nodesById.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepGroupImpl)) {
            return false;
        }
        RepGroupImpl other = (RepGroupImpl)obj;
        if (this.changeVersion != other.changeVersion) {
            return false;
        }
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        if (this.nodesById == null ? other.nodesById != null : !this.nodesById.equals(other.nodesById)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        return this.version == other.version;
    }

    public void setNodes(Map<Integer, RepNodeImpl> nodes) {
        this.nodesById = nodes;
        if (nodes == null) {
            this.nodesByName = null;
            return;
        }
        this.nodesByName = new HashMap<String, RepNodeImpl>();
        for (RepNodeImpl node : nodes.values()) {
            this.nodesByName.put(node.getName(), node);
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getVersion() {
        return this.version;
    }

    public int getChangeVersion() {
        return this.changeVersion;
    }

    public int incrementChangeVersion() {
        return ++this.changeVersion;
    }

    public int getNodeIdSequence() {
        return this.nodeIdSequence;
    }

    public void setNodeIdSequence(int nodeIdSequence) {
        this.nodeIdSequence = nodeIdSequence;
    }

    public int getNextNodeId() {
        return ++this.nodeIdSequence;
    }

    public static int getFirstNodeId() {
        return 1;
    }

    public void makeConsistent() {
        if (this.nodesById.size() == 0) {
            return;
        }
        int computedNodeId = -1;
        int computedChangeVersion = -1;
        for (RepNodeImpl mi : this.nodesById.values()) {
            if (computedNodeId < mi.getNodeId()) {
                computedNodeId = mi.getNodeId();
            }
            if (computedChangeVersion >= mi.getChangeVersion()) continue;
            computedChangeVersion = mi.getChangeVersion();
        }
        this.nodeIdSequence = computedNodeId;
        this.changeVersion = computedChangeVersion;
    }

    static <T> String objectToHex(TupleBinding<T> binding, T object) {
        StringBuffer buffer = new StringBuffer();
        TupleOutput tuple = new TupleOutput(new byte[100]);
        binding.objectToEntry(object, tuple);
        byte[] bytes = tuple.getBufferBytes();
        int size = tuple.getBufferLength();
        for (int i = 0; i < size; ++i) {
            int lowNibble = bytes[i] & 0xF;
            int highNibble = bytes[i] >> 4 & 0xF;
            buffer.append(Character.forDigit(lowNibble, 16));
            buffer.append(Character.forDigit(highNibble, 16));
        }
        return buffer.toString();
    }

    public String serializeHex() {
        RepGroupDB.GroupBinding groupBinding = new RepGroupDB.GroupBinding();
        StringBuffer buffer = new StringBuffer();
        buffer.append(RepGroupImpl.objectToHex(groupBinding, this));
        for (RepNodeImpl mi : this.nodesById.values()) {
            buffer.append("|");
            buffer.append(RepGroupImpl.serializeHex(mi));
        }
        return buffer.toString();
    }

    public static String serializeHex(RepNodeImpl node) {
        RepGroupDB.NodeBinding nodeBinding = new RepGroupDB.NodeBinding();
        return RepGroupImpl.objectToHex(nodeBinding, node);
    }

    public static byte[] serializeBytes(RepNodeImpl node) {
        RepGroupDB.NodeBinding binding = new RepGroupDB.NodeBinding();
        TupleOutput tuple = new TupleOutput(new byte[100]);
        binding.objectToEntry(node, tuple);
        return tuple.getBufferBytes();
    }

    public static RepNodeImpl hexDeserializeNode(String hex) {
        RepGroupDB.NodeBinding nodeBinding = new RepGroupDB.NodeBinding();
        return RepGroupImpl.hexToObject(nodeBinding, hex);
    }

    public static RepNodeImpl deserializeNode(byte[] bytes) {
        RepGroupDB.NodeBinding binding = new RepGroupDB.NodeBinding();
        TupleInput tuple = new TupleInput(bytes);
        return binding.entryToObject(tuple);
    }

    private static <T> T hexToObject(TupleBinding<T> binding, String hex) {
        byte[] buffer = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            int value = Character.digit(hex.charAt(i), 16);
            buffer[i >> 1] = (byte)(value |= Character.digit(hex.charAt(i + 1), 16) << 4);
        }
        TupleInput tuple = new TupleInput(buffer);
        return binding.entryToObject(tuple);
    }

    public static RepGroupImpl deserializeHex(String[] tokens, int start) {
        RepGroupDB.GroupBinding groupBinding = new RepGroupDB.GroupBinding();
        RepGroupImpl group = RepGroupImpl.hexToObject(groupBinding, tokens[start++]);
        HashMap<Integer, RepNodeImpl> nodeMap = new HashMap<Integer, RepNodeImpl>();
        while (start < tokens.length) {
            RepNodeImpl n = RepGroupImpl.hexDeserializeNode(tokens[start++]);
            RepNodeImpl old = nodeMap.put(n.getNameIdPair().getId(), n);
            assert (old == null);
        }
        group.setNodes(nodeMap);
        return group;
    }

    public Set<Integer> getAllMemberIds() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (RepNodeImpl mi : this.nodesById.values()) {
            if (mi.isRemoved()) continue;
            ret.add(mi.getNodeId());
        }
        return ret;
    }

    public Set<RepNodeImpl> getAllMembers(Predicate p) {
        HashSet<RepNodeImpl> ret = new HashSet<RepNodeImpl>();
        for (RepNodeImpl mi : this.nodesById.values()) {
            if (mi.isRemoved() || p != null && !p.include(mi)) continue;
            ret.add(mi);
        }
        return ret;
    }

    public Set<RepNodeImpl> getAllElectableMembers() {
        return this.getAllMembers(new Predicate(){

            boolean include(RepNodeImpl n) {
                return n.getType() == NodeType.ELECTABLE;
            }
        });
    }

    public Set<RepNodeImpl> getElectableNodes() {
        return this.getAllMembers(new Predicate(){

            boolean include(RepNodeImpl n) {
                return n.getType() == NodeType.ELECTABLE && n.isQuorumAck();
            }
        });
    }

    public Set<RepNodeImpl> getMonitorNodes() {
        return this.getAllMembers(new Predicate(){

            boolean include(RepNodeImpl n) {
                return n.getType() == NodeType.MONITOR;
            }
        });
    }

    private Set<InetSocketAddress> getAllMemberSockets(Predicate p) {
        HashSet<InetSocketAddress> sockets = new HashSet<InetSocketAddress>();
        for (RepNodeImpl mi : this.nodesById.values()) {
            if (mi.isRemoved() || p != null && !p.include(mi)) continue;
            sockets.add(mi.getSocketAddress());
        }
        return sockets;
    }

    public Set<InetSocketAddress> getLearnerSockets() {
        return this.getAllMemberSockets(null);
    }

    public Set<InetSocketAddress> getMonitorSockets() {
        return this.getAllMemberSockets(new Predicate(){

            boolean include(RepNodeImpl n) {
                return n.getType() == NodeType.MONITOR;
            }
        });
    }

    public Set<InetSocketAddress> getAcceptorSockets() {
        return this.getAllMemberSockets(new Predicate(){

            boolean include(RepNodeImpl n) {
                return n.getType() == NodeType.ELECTABLE;
            }
        });
    }

    public RepNodeImpl getMember(int nodeId) {
        RepNodeImpl node = this.getNode(nodeId);
        if (node == null) {
            return null;
        }
        if (node.isRemoved()) {
            throw EnvironmentFailureException.unexpectedState("No longer a member:" + nodeId);
        }
        return node;
    }

    public RepNodeImpl getMember(String name) throws MemberNotFoundException {
        RepNodeImpl node = this.getNode(name);
        if (node == null) {
            return null;
        }
        if (node.isRemoved()) {
            throw new MemberNotFoundException("Node no longer a member:" + name);
        }
        return node;
    }

    public RepNodeImpl getNode(int nodeId) {
        RepNodeImpl node = this.nodesById.get(nodeId);
        return node;
    }

    public RepNodeImpl getNode(String name) {
        RepNodeImpl node = this.nodesByName.get(name);
        return node;
    }

    public int getElectableGroupSize() {
        return this.getAllElectableMembers().size();
    }

    public String getName() {
        return this.groupName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Group info [").append(this.groupName).append("] ");
        sb.append(this.getUUID()).append("\n Representation version: ").append(this.getVersion()).append("\n Change version: ").append(this.getChangeVersion()).append("\n Max rep node id: ").append(this.getNodeIdSequence()).append("\n");
        if (this.nodesByName != null) {
            for (Map.Entry<String, RepNodeImpl> entry : this.nodesByName.entrySet()) {
                sb.append(" ").append(entry.getValue());
            }
        }
        return sb.toString();
    }

    public static class NodeConflictException
    extends DatabaseException {
        public NodeConflictException(String message) {
            super(message);
        }
    }

    public static class BarrierState {
        private final VLSN lastLocalCBVLSN;
        private final long barrierTime;

        public BarrierState(VLSN lastLocalCBVLSN, long barrierTime) {
            this.lastLocalCBVLSN = lastLocalCBVLSN;
            this.barrierTime = barrierTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lastLocalCBVLSN == null ? 0 : this.lastLocalCBVLSN.hashCode());
            result = 31 * result + (int)(this.barrierTime ^ this.barrierTime >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BarrierState other = (BarrierState)obj;
            if (this.lastLocalCBVLSN == null ? other.lastLocalCBVLSN != null : !this.lastLocalCBVLSN.equals(other.lastLocalCBVLSN)) {
                return false;
            }
            return this.barrierTime == other.barrierTime;
        }

        public VLSN getLastCBVLSN() {
            return this.lastLocalCBVLSN;
        }

        public long getBarrierTime() {
            return this.barrierTime;
        }

        public String toString() {
            return String.format("LocalCBVLSN:%,d at:%tc", this.lastLocalCBVLSN.getSequence(), this.barrierTime);
        }
    }

    abstract class Predicate {
        Predicate() {
        }

        abstract boolean include(RepNodeImpl var1);
    }
}

